/*
 * Decompiled with CFR 0.152.
 */
package cz.seznam.euphoria.core.client.triggers;

import cz.seznam.euphoria.core.client.dataset.windowing.Window;
import cz.seznam.euphoria.core.client.operator.state.ValueStorage;
import cz.seznam.euphoria.core.client.operator.state.ValueStorageDescriptor;
import cz.seznam.euphoria.core.client.triggers.Trigger;
import cz.seznam.euphoria.core.client.triggers.TriggerContext;

public class CountTrigger<W extends Window>
implements Trigger<W> {
    private static final ValueStorageDescriptor<Long> COUNT_DESCR = ValueStorageDescriptor.of("count", Long.class, 0L, (x, y) -> x + y);
    private final long maxCount;

    public CountTrigger(long maxCount) {
        this.maxCount = maxCount;
    }

    @Override
    public Trigger.TriggerResult onElement(long time, W window, TriggerContext ctx) {
        ValueStorage<Long> count = ctx.getValueStorage(COUNT_DESCR);
        count.set(count.get() + 1L);
        if (count.get() >= this.maxCount) {
            return Trigger.TriggerResult.FLUSH_AND_PURGE;
        }
        return Trigger.TriggerResult.NOOP;
    }

    @Override
    public Trigger.TriggerResult onTimer(long time, W window, TriggerContext ctx) {
        return Trigger.TriggerResult.NOOP;
    }

    @Override
    public void onClear(W window, TriggerContext ctx) {
        ctx.getValueStorage(COUNT_DESCR).clear();
    }

    @Override
    public void onMerge(W window, TriggerContext.TriggerMergeContext ctx) {
        ctx.mergeStoredState(COUNT_DESCR);
    }
}

