/*
 * Decompiled with CFR 0.152.
 */
package cz.seznam.euphoria.core.client.triggers;

import cz.seznam.euphoria.core.client.dataset.windowing.TimeInterval;
import cz.seznam.euphoria.core.client.operator.state.ValueStorage;
import cz.seznam.euphoria.core.client.operator.state.ValueStorageDescriptor;
import cz.seznam.euphoria.core.client.triggers.Trigger;
import cz.seznam.euphoria.core.client.triggers.TriggerContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PeriodicTimeTrigger
implements Trigger<TimeInterval> {
    private static final Logger LOG = LoggerFactory.getLogger(PeriodicTimeTrigger.class);
    private static final ValueStorageDescriptor<Long> FIRE_TIME_DESCR = ValueStorageDescriptor.of("fire-time", Long.class, Long.MAX_VALUE, Math::min);
    private final long interval;

    public PeriodicTimeTrigger(long interval) {
        this.interval = interval;
    }

    @Override
    public Trigger.TriggerResult onElement(long time, TimeInterval window, TriggerContext ctx) {
        ValueStorage<Long> fireStamp = ctx.getValueStorage(FIRE_TIME_DESCR);
        if (fireStamp.get() == Long.MAX_VALUE) {
            long start = window.getStartMillis() - window.getStartMillis() % this.interval;
            long nextFireTimestamp = start + this.interval;
            LOG.trace("Registering PeriodicTimeTrigger for time {}", (Object)nextFireTimestamp);
            ctx.registerTimer(nextFireTimestamp, window);
            fireStamp.set(nextFireTimestamp);
        }
        return Trigger.TriggerResult.NOOP;
    }

    @Override
    public Trigger.TriggerResult onTimer(long time, TimeInterval window, TriggerContext ctx) {
        ValueStorage<Long> fireStamp = ctx.getValueStorage(FIRE_TIME_DESCR);
        if (fireStamp.get() == time) {
            long nextTimestamp = time + this.interval;
            if (nextTimestamp < window.getEndMillis()) {
                ctx.registerTimer(time + this.interval, window);
                fireStamp.set(time + this.interval);
            }
            return Trigger.TriggerResult.FLUSH;
        }
        return Trigger.TriggerResult.NOOP;
    }

    @Override
    public void onClear(TimeInterval window, TriggerContext ctx) {
        ValueStorage<Long> fireStamp = ctx.getValueStorage(FIRE_TIME_DESCR);
        ctx.deleteTimer(fireStamp.get(), window);
        fireStamp.clear();
    }

    @Override
    public void onMerge(TimeInterval window, TriggerContext.TriggerMergeContext ctx) {
        ctx.mergeStoredState(FIRE_TIME_DESCR);
        ValueStorage<Long> fireStamp = ctx.getValueStorage(FIRE_TIME_DESCR);
        ctx.registerTimer(fireStamp.get(), window);
    }
}

