/*
 * Decompiled with CFR 0.152.
 */
package cz.seznam.euphoria.core.client.triggers;

import cz.seznam.euphoria.core.client.dataset.windowing.TimeInterval;
import cz.seznam.euphoria.core.client.triggers.Trigger;
import cz.seznam.euphoria.core.client.triggers.TriggerContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TimeTrigger
implements Trigger<TimeInterval> {
    private static final Logger LOG = LoggerFactory.getLogger(TimeTrigger.class);

    @Override
    public boolean isStateful() {
        return false;
    }

    @Override
    public Trigger.TriggerResult onElement(long time, TimeInterval window, TriggerContext ctx) {
        return this.registerTimer(window, ctx);
    }

    @Override
    public Trigger.TriggerResult onTimer(long time, TimeInterval window, TriggerContext ctx) {
        if (time == window.maxTimestamp()) {
            LOG.debug("Firing TimeTrigger, time {}, window: {}", (Object)time, (Object)window);
            return Trigger.TriggerResult.FLUSH_AND_PURGE;
        }
        return Trigger.TriggerResult.NOOP;
    }

    @Override
    public void onClear(TimeInterval window, TriggerContext ctx) {
        ctx.deleteTimer(window.maxTimestamp(), window);
    }

    @Override
    public void onMerge(TimeInterval window, TriggerContext.TriggerMergeContext ctx) {
        this.registerTimer(window, ctx);
    }

    private Trigger.TriggerResult registerTimer(TimeInterval window, TriggerContext ctx) {
        if (ctx.registerTimer(window.maxTimestamp(), window)) {
            return Trigger.TriggerResult.NOOP;
        }
        return Trigger.TriggerResult.PURGE;
    }
}

