/*
 * Decompiled with CFR 0.152.
 */
package cz.seznam.euphoria.core.client.util;

import java.util.Comparator;
import java.util.Objects;

public final class Pair<K, V> {
    private static final Comparator<Pair> CMP_BY_FIRST = (o1, o2) -> Pair.doCompare(o1.getFirst(), o2.getFirst());
    private static final Comparator<Pair> CMP_BY_SECOND = (o1, o2) -> Pair.doCompare(o1.getSecond(), o2.getSecond());
    final K first;
    final V second;

    private static int doCompare(Object a, Object b) {
        Comparable ca = (Comparable)a;
        Comparable cb = (Comparable)b;
        if (ca == cb) {
            return 0;
        }
        if (ca == null) {
            return 1;
        }
        if (cb == null) {
            return -1;
        }
        return ca.compareTo(cb);
    }

    public static <K extends Comparable<K>, V> Comparator<Pair<K, V>> compareByFirst() {
        return CMP_BY_FIRST;
    }

    public static <K, V extends Comparable<V>> Comparator<Pair<K, V>> compareBySecond() {
        return CMP_BY_SECOND;
    }

    private Pair(K first, V second) {
        this.first = first;
        this.second = second;
    }

    public static <K, V> Pair<K, V> of(K first, V second) {
        return new Pair<K, V>(first, second);
    }

    public K getFirst() {
        return this.first;
    }

    public V getSecond() {
        return this.second;
    }

    public String toString() {
        return "Pair{first='" + this.first + "', second='" + this.second + "'}";
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj instanceof Pair) {
            Pair other = (Pair)obj;
            return Objects.equals(this.first, other.first) && Objects.equals(this.second, other.second);
        }
        return false;
    }

    public int hashCode() {
        if (this.getFirst() != null && this.getSecond() != null) {
            int h = this.getFirst().hashCode();
            int shift = 16;
            return (h >> shift | h << shift) ^ this.getSecond().hashCode();
        }
        if (this.getFirst() != null) {
            return this.getFirst().hashCode();
        }
        if (this.getSecond() != null) {
            return this.getSecond().hashCode();
        }
        return 0;
    }
}

