/*
 * Decompiled with CFR 0.152.
 */
package cz.seznam.euphoria.core.executor;

import cz.seznam.euphoria.core.client.dataset.Dataset;
import cz.seznam.euphoria.core.client.dataset.windowing.GlobalWindowing;
import cz.seznam.euphoria.core.client.dataset.windowing.Windowing;
import cz.seznam.euphoria.core.client.operator.Join;
import cz.seznam.euphoria.core.client.operator.Operator;
import cz.seznam.euphoria.core.client.operator.WindowWiseOperator;
import cz.seznam.euphoria.core.client.operator.WindowingRequiredException;
import cz.seznam.euphoria.core.client.util.Pair;
import cz.seznam.euphoria.core.executor.FlowUnfolder;
import cz.seznam.euphoria.core.executor.graph.DAG;
import cz.seznam.euphoria.core.executor.graph.Node;
import cz.seznam.euphoria.shadow.com.google.common.base.Preconditions;
import java.util.HashMap;
import java.util.List;
import java.util.stream.Collectors;

class FlowValidator {
    FlowValidator() {
    }

    static DAG<Operator<?, ?>> preTranslate(DAG<Operator<?, ?>> dag) {
        FlowValidator.checkJoinWindowing(dag);
        return dag;
    }

    static DAG<Operator<?, ?>> postTranslate(DAG<Operator<?, ?>> dag) {
        FlowValidator.checkSinks(dag);
        return dag;
    }

    private static void checkJoinWindowing(DAG<Operator<?, ?>> dag) {
        List joins = dag.traverse().filter(node -> node.get() instanceof Join).collect(Collectors.toList());
        for (Node join : joins) {
            FlowValidator.checkJoinWindowing(join);
        }
    }

    private static void checkJoinWindowing(Node<Operator<?, ?>> node) {
        Preconditions.checkState(node.get() instanceof Join);
        if (((Join)node.get()).getWindowing() != null) {
            return;
        }
        for (Node<Operator<?, ?>> parent : node.getParents()) {
            if (FlowValidator.isBatched(parent)) continue;
            throw new WindowingRequiredException("Join operator requires either an explicit windowing strategy or needs to be supplied with batched inputs.");
        }
    }

    private static boolean isBatched(Node<Operator<?, ?>> node) {
        Windowing windowing;
        Operator<?, ?> operator = node.get();
        if (operator instanceof FlowUnfolder.InputOperator) {
            return true;
        }
        if (operator instanceof WindowWiseOperator && (windowing = ((WindowWiseOperator)operator).getWindowing()) != null) {
            return windowing instanceof GlobalWindowing;
        }
        List<Node<Operator<?, ?>>> parents = node.getParents();
        Preconditions.checkState(!parents.isEmpty(), "Non-input operator without parents?!");
        for (Node<Operator<?, ?>> parent : parents) {
            if (FlowValidator.isBatched(parent)) continue;
            return false;
        }
        return true;
    }

    private static void checkSinks(DAG<Operator<?, ?>> dag) {
        List<Pair> outputs = dag.nodes().filter(n -> n.output().getOutputSink() != null).map(o -> Pair.of(o.output(), o.output().getOutputSink())).collect(Collectors.toList());
        HashMap sinkDatasets = new HashMap();
        outputs.forEach(p -> {
            Dataset current = (Dataset)sinkDatasets.get(p.getSecond());
            if (current != null) {
                throw new IllegalArgumentException("Operator " + current.getProducer().getName() + " and  operator " + ((Dataset)p.getFirst()).getProducer().getName() + " use the same sink " + p.getSecond());
            }
            sinkDatasets.put(p.getSecond(), p.getFirst());
        });
    }
}

