/*
 * Decompiled with CFR 0.152.
 */
package cz.seznam.euphoria.core.executor.graph;

import cz.seznam.euphoria.core.client.util.Pair;
import cz.seznam.euphoria.core.executor.graph.Node;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public class DAG<T> {
    final List<Node<T>> roots = new ArrayList<Node<T>>();
    final Map<T, Node<T>> nodeMap = new HashMap<T, Node<T>>();

    private DAG() {
    }

    public static <T> DAG<T> empty() {
        return DAG.of(Collections.emptyList());
    }

    public static <T> DAG<T> of(T ... rootElements) {
        return DAG.of(Arrays.asList(rootElements));
    }

    public static <T> DAG<T> of(Iterable<T> rootElements) {
        DAG<Object> ret = new DAG<Object>();
        for (T elem : rootElements) {
            ret.add(elem, new Object[0]);
        }
        return ret;
    }

    @SafeVarargs
    public final DAG<T> add(T elem, T ... parents) {
        this.add(elem, Arrays.asList(parents));
        return this;
    }

    public DAG<T> add(T elem, List<T> parents) {
        Node node;
        if (parents.isEmpty()) {
            node = new Node(elem);
            this.roots.add(node);
        } else {
            List<Node<Node>> parentNodes = parents.stream().map(this::getNode).collect(Collectors.toList());
            node = new Node<T>(elem, parentNodes);
            parentNodes.forEach(p -> p.children.add(node));
        }
        if (this.nodeMap.containsKey(elem)) {
            throw new IllegalArgumentException("Element " + elem + " is already added to the graph.");
        }
        this.nodeMap.put(elem, node);
        return this;
    }

    public boolean contains(T elem) {
        return this.nodeMap.get(elem) != null;
    }

    public Node<T> getNode(T elem) {
        Node<T> ret = this.nodeMap.get(elem);
        if (ret == null) {
            throw new IllegalStateException("No node with value " + elem + " found");
        }
        return ret;
    }

    public Collection<Node<T>> getRoots() {
        return this.roots;
    }

    public Collection<Node<T>> getLeafs() {
        return this.nodeMap.values().stream().filter(n -> n.children.isEmpty()).collect(Collectors.toList());
    }

    public DAG<T> parentSubGraph(T elem) {
        DAG ret = new DAG();
        LinkedHashSet<Node> nodeList = new LinkedHashSet<Node>();
        LinkedList notYetAdded = new LinkedList();
        notYetAdded.add(this.getNode(elem));
        while (!notYetAdded.isEmpty()) {
            Node node = (Node)notYetAdded.pollLast();
            nodeList.remove(node);
            nodeList.add(node);
            notYetAdded.addAll(node.parents);
        }
        LinkedList<Node> reversedNodes = new LinkedList<Node>();
        for (Node n2 : nodeList) {
            reversedNodes.addFirst(n2);
        }
        for (Node node : reversedNodes) {
            List parents = node.parents.stream().map(n -> n.value).collect(Collectors.toList());
            ret.add(node.value, parents);
        }
        return ret;
    }

    public int size() {
        return this.nodeMap.size();
    }

    public Stream<T> nodes() {
        return this.nodeMap.values().stream().map(n -> n.value);
    }

    public Stream<Node<T>> traverse() {
        LinkedList<Node> ret = new LinkedList<Node>();
        HashSet<Node> closed = new HashSet<Node>();
        LinkedList<Node> open = new LinkedList<Node>();
        open.addAll(this.roots);
        while (!open.isEmpty()) {
            Node next = (Node)open.poll();
            if (closed.contains(next)) continue;
            if (closed.containsAll(next.parents)) {
                open.addAll(next.children);
                ret.add(next);
                closed.add(next);
                continue;
            }
            open.add(next);
        }
        return ret.stream();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        LinkedList open = new LinkedList();
        this.roots.forEach(r -> open.add(Pair.of(0, r)));
        while (!open.isEmpty()) {
            Pair poll = (Pair)open.removeFirst();
            for (int i = 0; i < (Integer)poll.getFirst(); ++i) {
                sb.append(" ");
            }
            sb.append(((Node)poll.getSecond()).get());
            sb.append("\n");
            ((Node)poll.getSecond()).children.forEach(n -> open.addFirst(Pair.of((Integer)poll.getFirst() + 1, n)));
        }
        return sb.toString();
    }
}

