/*
 * Decompiled with CFR 0.152.
 */
package cz.seznam.euphoria.core.executor.graph;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nullable;

public final class Node<T> {
    final List<Node<T>> children = new ArrayList<Node<T>>();
    @Nullable
    final T value;
    final List<Node<T>> parents = new ArrayList<Node<T>>();
    private static final Node NULL_NODE = new Node<Object>(null);

    Node(@Nullable T value) {
        this.value = value;
    }

    Node(@Nullable T value, List<Node<T>> parents) {
        this(value);
        this.parents.addAll(parents);
    }

    public boolean isRoot() {
        return this.parents.isEmpty();
    }

    public List<Node<T>> getParents() {
        return Collections.unmodifiableList(this.parents);
    }

    public Node<T> getSingleParent() {
        if (this.parents.size() == 1) {
            return this.parents.get(0);
        }
        throw new IllegalStateException("Asked for single parent while node has parents " + this.parents);
    }

    public Node<T> getSingleParentOrNull() {
        if (this.parents.size() > 1) {
            throw new IllegalStateException("Node has too many parents: " + this.parents.size());
        }
        if (this.parents.isEmpty()) {
            return Node.nullNode();
        }
        return this.parents.iterator().next();
    }

    public List<Node<T>> getChildren() {
        return Collections.unmodifiableList(this.children);
    }

    public T get() {
        return this.value;
    }

    Node<T> copy() {
        Node<T> clone = new Node<T>(this.value, this.parents);
        clone.children.addAll(this.children);
        return clone;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj instanceof Node) {
            return Objects.equals(((Node)obj).value, this.value);
        }
        return false;
    }

    public int hashCode() {
        if (this.value != null) {
            return this.value.hashCode();
        }
        return 0;
    }

    public String toString() {
        return "Node(" + String.valueOf(this.value) + ")";
    }

    public static <T> Node<T> nullNode() {
        return NULL_NODE;
    }
}

