/*
 * Decompiled with CFR 0.152.
 */
package cz.seznam.euphoria.core.executor.greduce;

import cz.seznam.euphoria.core.client.dataset.windowing.Window;
import java.util.HashSet;
import java.util.PriorityQueue;
import javax.annotation.Nullable;

class TimerSupport<W extends Window> {
    final HashSet<Timer<W>> timers = new HashSet();
    final PriorityQueue<Timer<W>> queue = new PriorityQueue(100);
    long stamp = Long.MIN_VALUE;

    TimerSupport() {
    }

    long getStamp() {
        return this.stamp;
    }

    void updateStamp(long stamp, TimerHandler<W> handler) {
        Timer<W> t;
        while ((t = this.queue.peek()) != null && (t.getTime() < stamp || stamp == Long.MAX_VALUE)) {
            t = this.queue.poll();
            this.timers.remove(t);
            handler.handle(t.getTime(), t.getWindow());
        }
        this.stamp = stamp;
    }

    boolean registerTimer(long stamp, W window) {
        Timer<W> t = new Timer<W>(window, stamp);
        if (this.timers.add(t)) {
            this.queue.add(t);
        }
        return true;
    }

    void deleteTimer(long stamp, W window) {
        Timer<W> t = new Timer<W>(window, stamp);
        if (this.timers.remove(t)) {
            this.queue.remove(t);
        }
    }

    static interface TimerHandler<W> {
        public void handle(long var1, W var3);
    }

    static final class Timer<W>
    implements Comparable<Timer<W>> {
        @Nullable
        final W window;
        final long time;

        Timer(@Nullable W window, long time) {
            this.window = window;
            this.time = time;
        }

        @Nullable
        public W getWindow() {
            return this.window;
        }

        public long getTime() {
            return this.time;
        }

        public boolean equals(Object o) {
            if (o instanceof Timer) {
                Timer that = (Timer)o;
                return this.time == that.time && (this.window != null ? this.window.equals(that.window) : that.window == null);
            }
            return false;
        }

        public int hashCode() {
            int result = this.window != null ? this.window.hashCode() : 0;
            result = 31 * result + (int)(this.time ^ this.time >>> 32);
            return result;
        }

        @Override
        public int compareTo(Timer<W> other) {
            return Long.compare(this.time, other.time);
        }
    }
}

