/*
 * Decompiled with CFR 0.152.
 */
package cz.seznam.euphoria.core.executor.greduce;

import cz.seznam.euphoria.core.client.dataset.windowing.Window;
import cz.seznam.euphoria.core.client.operator.state.ListStorage;
import cz.seznam.euphoria.core.client.operator.state.ListStorageDescriptor;
import cz.seznam.euphoria.core.client.operator.state.Storage;
import cz.seznam.euphoria.core.client.operator.state.StorageDescriptor;
import cz.seznam.euphoria.core.client.operator.state.StorageProvider;
import cz.seznam.euphoria.core.client.operator.state.ValueStorage;
import cz.seznam.euphoria.core.client.operator.state.ValueStorageDescriptor;
import java.util.HashMap;
import java.util.Objects;

class TriggerStorage {
    private final StorageProvider storageProvider;
    private final HashMap<Key, Storage> store = new HashMap();

    TriggerStorage(StorageProvider storageProvider) {
        this.storageProvider = Objects.requireNonNull(storageProvider);
    }

    Storage<?> getStorage(Window window, StorageDescriptor desc) {
        return this.store.get(new Key(window, desc));
    }

    <T> ValueStorage<T> getValueStorage(Window window, ValueStorageDescriptor<T> desc) {
        Key key = new Key(window, desc);
        ValueStorage<T> s = this.store.get(key);
        if (s == null) {
            s = this.storageProvider.getValueStorage(desc);
            this.store.put(key, s);
        }
        return new ClearingValueStorage(s, key);
    }

    <T> ListStorage<T> getListStorage(Window window, ListStorageDescriptor<T> desc) {
        Key key = new Key(window, desc);
        ListStorage<T> s = this.store.get(key);
        if (s == null) {
            s = this.storageProvider.getListStorage(desc);
            this.store.put(key, s);
        }
        return new ClearingListStorage(s, key);
    }

    int size() {
        return this.store.size();
    }

    class ClearingListStorage<T>
    implements ListStorage<T> {
        private final ListStorage<T> wrap;
        private final Key key;

        ClearingListStorage(ListStorage<T> wrap, Key key) {
            this.wrap = wrap;
            this.key = key;
        }

        @Override
        public void clear() {
            this.wrap.clear();
            TriggerStorage.this.store.remove(this.key);
        }

        @Override
        public void add(T element) {
            this.wrap.add(element);
        }

        @Override
        public Iterable<T> get() {
            return this.wrap.get();
        }
    }

    class ClearingValueStorage<T>
    implements ValueStorage<T> {
        private final ValueStorage<T> wrap;
        private final Key key;

        ClearingValueStorage(ValueStorage<T> wrap, Key key) {
            this.wrap = wrap;
            this.key = key;
        }

        @Override
        public void clear() {
            this.wrap.clear();
            TriggerStorage.this.store.remove(this.key);
        }

        @Override
        public void set(T value) {
            this.wrap.set(value);
        }

        @Override
        public T get() {
            return this.wrap.get();
        }
    }

    static class Key {
        private final Window window;
        private final String storeId;

        Key(Window window, StorageDescriptor desc) {
            this.window = window;
            this.storeId = desc.getName();
        }

        public boolean equals(Object o) {
            if (o instanceof Key) {
                Key that = (Key)o;
                return Objects.equals(this.window, that.window) && Objects.equals(this.storeId, that.storeId);
            }
            return false;
        }

        public int hashCode() {
            return Objects.hash(this.window, this.storeId);
        }

        public String toString() {
            return "Key{window=" + this.window + ", storeId='" + this.storeId + '\'' + '}';
        }
    }
}

