/*
 * Decompiled with CFR 0.152.
 */
package cz.seznam.euphoria.core.executor.io;

import cz.seznam.euphoria.core.client.io.ExternalIterable;
import cz.seznam.euphoria.core.client.operator.state.ListStorage;
import cz.seznam.euphoria.core.executor.io.SerializerFactory;
import cz.seznam.euphoria.core.executor.io.SpillFileFactory;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.Objects;

public class FsSpillingListStorage<T>
implements ListStorage<T>,
ExternalIterable<T> {
    private final SerializerFactory serializerFactory;
    private final SpillFileFactory spillFileFactory;
    private final int maxElemsInMemory;
    private final List<T> elems = new ArrayList<T>();
    private File storageFile;
    private SerializerFactory.Serializer serializerInstance;
    private SerializerFactory.Serializer.Output serializerStream;
    private boolean needsFlush;

    public FsSpillingListStorage(SerializerFactory serializerFactory, SpillFileFactory spillFileFactory, int maxElemsInMemory) {
        this.serializerFactory = Objects.requireNonNull(serializerFactory);
        this.spillFileFactory = Objects.requireNonNull(spillFileFactory);
        this.maxElemsInMemory = maxElemsInMemory;
    }

    @Override
    public void add(T element) {
        this.elems.add(element);
        if (this.elems.size() > this.maxElemsInMemory) {
            this.spillElems();
        }
    }

    private void spillElems() {
        if (this.serializerStream == null) {
            this.initDiskStorage();
        }
        for (T elem : this.elems) {
            this.serializerStream.writeObject(elem);
        }
        this.elems.clear();
        this.needsFlush = true;
    }

    @Override
    public Iterable<T> get() {
        return () -> {
            SerializerFactory.Serializer.Input is;
            if (this.serializerStream == null && this.elems.isEmpty() && (this.storageFile == null || !this.storageFile.exists())) {
                return Collections.emptyIterator();
            }
            if (this.serializerStream != null && this.needsFlush) {
                this.serializerStream.flush();
                this.needsFlush = false;
            }
            try {
                is = this.storageFile != null && this.storageFile.exists() ? this.serializerInstance.newInput(new FileInputStream(this.storageFile)) : null;
            }
            catch (FileNotFoundException e) {
                throw new IllegalStateException("Failed to open spilling storage: " + this.storageFile, e);
            }
            final Iterator<T> elemsIter = this.elems.iterator();
            return new Iterator<T>(){

                @Override
                public boolean hasNext() {
                    boolean n;
                    boolean bl = n = is != null && !is.eof() || elemsIter.hasNext();
                    if (!n && is != null) {
                        is.close();
                    }
                    return n;
                }

                @Override
                public T next() {
                    if (is != null && !is.eof()) {
                        return is.readObject();
                    }
                    if (elemsIter.hasNext()) {
                        return elemsIter.next();
                    }
                    if (is != null) {
                        is.close();
                    }
                    throw new NoSuchElementException();
                }
            };
        };
    }

    void closeOutput() {
        this.flush();
        if (this.serializerStream != null) {
            this.serializerStream.close();
            this.serializerStream = null;
        }
    }

    @Override
    public void clear() {
        if (this.serializerStream != null) {
            this.serializerStream.close();
            this.serializerStream = null;
        }
        if (this.storageFile != null && this.storageFile.exists() && !this.storageFile.delete()) {
            throw new IllegalStateException("Failed to clean up storage file: " + this.storageFile);
        }
    }

    void flush() {
        this.spillElems();
        this.serializerStream.flush();
        this.needsFlush = false;
    }

    private void initDiskStorage() {
        assert (this.storageFile == null);
        assert (this.serializerInstance == null);
        assert (this.serializerStream == null);
        this.storageFile = this.spillFileFactory.newSpillFile();
        this.serializerInstance = this.serializerFactory.newSerializer();
        try {
            this.serializerStream = this.serializerInstance.newOutput(new FileOutputStream(this.storageFile));
        }
        catch (FileNotFoundException e) {
            throw new IllegalStateException(e);
        }
    }

    @Override
    public Iterator<T> iterator() {
        return this.get().iterator();
    }

    @Override
    public void close() {
        this.clear();
    }
}

