/*
 * Decompiled with CFR 0.152.
 */
package cz.seznam.euphoria.core.executor.io;

import cz.seznam.euphoria.core.client.io.ExternalIterable;
import cz.seznam.euphoria.core.client.io.SpillTools;
import cz.seznam.euphoria.core.executor.io.FsSpillingListStorage;
import cz.seznam.euphoria.core.executor.io.SerializerFactory;
import cz.seznam.euphoria.core.executor.io.SpillFileFactory;
import cz.seznam.euphoria.core.util.Settings;
import cz.seznam.euphoria.shadow.com.google.common.annotations.VisibleForTesting;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.UUID;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GenericSpillTools
implements SpillTools {
    private static final Logger LOG = LoggerFactory.getLogger(GenericSpillTools.class);
    private final int numSpillRecords;
    private final SpillFileFactory spillFactory;
    private final SerializerFactory serializer;

    public GenericSpillTools(SerializerFactory serializer, SpillFileFactory spillFactory, Settings settings) {
        this(serializer, spillFactory, settings.getInt("euphoria.spill.buffer.items", 10000));
    }

    public GenericSpillTools(SerializerFactory serializer, Settings settings) {
        this(serializer, GenericSpillTools.spillFactory(settings), settings.getInt("euphoria.spill.buffer.items", 10000));
    }

    @VisibleForTesting
    GenericSpillTools(SerializerFactory serializer, SpillFileFactory spillFactory, int spillRecords) {
        this.serializer = serializer;
        this.spillFactory = spillFactory;
        this.numSpillRecords = spillRecords;
    }

    private static SpillFileFactory spillFactory(Settings settings) {
        File tmpDir = new File(settings.getString("euphoria.spill.tmp.dir", "./"));
        if (tmpDir.exists()) {
            if (!tmpDir.isDirectory()) {
                throw new IllegalArgumentException("Path " + tmpDir + " exists and is not directory! Tune your " + "euphoria.spill.tmp.dir" + " settings");
            }
        } else {
            tmpDir.mkdirs();
        }
        return () -> new File(tmpDir, String.format("euphoria-spill-%s.bin", UUID.randomUUID().toString()));
    }

    @Override
    public <T> ExternalIterable<T> externalize(Iterable<T> what) {
        return this.externalize(StreamSupport.stream(what.spliterator(), false));
    }

    private <T> ExternalIterable<T> externalize(Stream<T> what) {
        FsSpillingListStorage ret = new FsSpillingListStorage(this.serializer, this.spillFactory, this.numSpillRecords);
        what.forEach(ret::add);
        ret.closeOutput();
        return ret;
    }

    @Override
    public <T> Collection<ExternalIterable<T>> spillAndSortParts(Iterable<T> what, Comparator<T> comparator) throws InterruptedException {
        ArrayList<ExternalIterable<T>> ret = new ArrayList<ExternalIterable<T>>();
        ArrayList<T> sortList = new ArrayList<T>(this.numSpillRecords);
        for (T e : what) {
            if (sortList.size() == this.numSpillRecords) {
                ret.add(this.externalize(sortList.stream().sorted(comparator)));
                LOG.debug("Successfully externalized {} records", (Object)sortList.size());
                sortList.clear();
            }
            sortList.add(e);
            if (!Thread.currentThread().isInterrupted()) continue;
            throw new InterruptedException();
        }
        if (!sortList.isEmpty()) {
            ret.add(this.externalize(sortList.stream().sorted(comparator)));
        }
        return ret;
    }
}

