/*
 * Decompiled with CFR 0.152.
 */
package cz.seznam.euphoria.core.time;

import cz.seznam.euphoria.core.time.TimeProvider;
import java.time.Duration;
import java.util.Calendar;
import java.util.Date;
import java.util.Objects;
import java.util.TimeZone;

public class TimeProviders {
    private TimeProviders() {
        throw new AssertionError();
    }

    public static TimeProvider getInstance() {
        return new DefaultTimeProvider();
    }

    public static TimeProvider getInstance(TimeZone tz) {
        return new TimezoneTimeProvider(tz);
    }

    public static FixedTimeProvider getFixedTimeInstance(Date d) {
        return new FixedTimeProvider(d);
    }

    static class TimezoneTimeProvider
    extends AbstractTimeProvider {
        private final TimeZone timezone;

        public TimezoneTimeProvider(TimeZone timezone) {
            this.timezone = timezone;
        }

        @Override
        public Calendar nowAsCalendar() {
            return Calendar.getInstance(this.timezone);
        }
    }

    public static class FixedTimeProvider
    extends AbstractTimeProvider {
        private volatile Date date;

        FixedTimeProvider(Date date) {
            this.date = Objects.requireNonNull(date);
        }

        public Date getFixedPoint() {
            return this.date;
        }

        public void setFixedPoint(Date d) {
            this.date = Objects.requireNonNull(d);
        }

        @Override
        public Calendar nowAsCalendar() {
            Calendar c = Calendar.getInstance(TimeZone.getTimeZone("UTC"));
            c.setTime(this.date);
            return c;
        }
    }

    static class DefaultTimeProvider
    extends AbstractTimeProvider {
        DefaultTimeProvider() {
        }

        @Override
        public Calendar nowAsCalendar() {
            return Calendar.getInstance();
        }
    }

    public static abstract class AbstractTimeProvider
    implements TimeProvider {
        @Override
        public Date now() {
            return this.nowAsCalendar().getTime();
        }

        @Override
        public Date nowOffset(Duration offset) {
            return new Date(this.now().getTime() + offset.toMillis());
        }

        @Override
        public Date today() {
            Calendar now = this.nowAsCalendar();
            now.set(11, 0);
            now.set(12, 0);
            now.set(13, 0);
            now.set(14, 0);
            return now.getTime();
        }

        public abstract Calendar nowAsCalendar();
    }
}

