/*
 * Decompiled with CFR 0.152.
 */
package cz.seznam.euphoria.core.util;

import java.io.IOException;
import java.util.stream.Stream;

public class IOUtils {
    public static <T> void forEach(Iterable<T> iterable, IOConsumer<T> consumer) throws IOException {
        IOException firstException = null;
        for (T element : iterable) {
            try {
                consumer.accept(element);
            }
            catch (IOException e) {
                if (firstException != null) {
                    firstException.addSuppressed(e);
                    continue;
                }
                firstException = e;
            }
        }
        if (firstException != null) {
            throw firstException;
        }
    }

    public static <T> void forEach(Stream<T> stream, IOConsumer<T> consumer) throws IOException {
        IOUtils.forEach(stream::iterator, consumer);
    }

    @FunctionalInterface
    public static interface IOConsumer<T> {
        public void accept(T var1) throws IOException;
    }
}

