/*
 * Decompiled with CFR 0.152.
 */
package cz.seznam.euphoria.core.util;

import cz.seznam.euphoria.core.client.util.Pair;
import cz.seznam.euphoria.core.util.InstanceUtils;
import java.io.Serializable;
import java.net.URI;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Collectors;
import javax.annotation.Nullable;

public class Settings
implements Serializable {
    @Nullable
    private final String prefix;
    private final Map<String, String> map;

    public Settings() {
        this(null, new ConcurrentHashMap<String, String>());
    }

    public Settings(Settings other) {
        this();
        other.getAll().entrySet().stream().forEach(p -> this.setString((String)p.getKey(), (String)p.getValue()));
    }

    private Settings(@Nullable String prefix, Map<String, String> map) {
        this.prefix = prefix;
        this.map = map;
    }

    private String skey(String key) {
        return this.prefix == null ? key : this.prefix + key;
    }

    public Settings nested(String prefix) {
        if (prefix == null || prefix.isEmpty()) {
            return this;
        }
        if (!prefix.endsWith(".")) {
            prefix = prefix + ".";
        }
        return new Settings(prefix, this.map);
    }

    public Map<String, String> getAll() {
        if (this.prefix == null) {
            return this.map;
        }
        return this.map.entrySet().stream().filter(e -> ((String)e.getKey()).startsWith(this.prefix)).map(e -> Pair.of(((String)e.getKey()).substring(this.prefix.length()), e.getValue())).collect(Collectors.toMap(Pair::getFirst, Pair::getSecond));
    }

    public boolean contains(String key) {
        return this.containsSkey(this.skey(Objects.requireNonNull(key)));
    }

    private boolean containsSkey(String skey) {
        return this.map.containsKey(skey);
    }

    public void setString(String key, String value) {
        this.map.put(this.skey(Objects.requireNonNull(key)), Objects.requireNonNull(value));
    }

    public String getString(String key, String def) {
        String skey = this.skey(Objects.requireNonNull(key));
        return this.map.getOrDefault(skey, def);
    }

    public String getString(String key) {
        String skey = this.skey(Objects.requireNonNull(key));
        if (!this.containsSkey(skey)) {
            throw new IllegalArgumentException("No value for: " + key + " (settings prefix: " + this.prefix + ")");
        }
        return this.map.get(skey);
    }

    public void setBoolean(String key, boolean value) {
        this.setString(key, Boolean.toString(value));
    }

    public boolean getBoolean(String key, boolean def) {
        String stringVal = this.getString(key, null);
        return stringVal == null ? def : Boolean.parseBoolean(stringVal);
    }

    public boolean getBoolean(String key) {
        String stringVal = this.getString(key);
        return Boolean.parseBoolean(stringVal);
    }

    public void setInt(String key, int value) {
        this.setString(key, String.valueOf(value));
    }

    public int getInt(String key, int def) {
        String stringVal = this.getString(key, null);
        return stringVal == null ? def : Integer.parseInt(stringVal);
    }

    public int getInt(String key) {
        String stringVal = this.getString(key);
        return Integer.parseInt(stringVal);
    }

    public void setLong(String key, long value) {
        this.setString(key, String.valueOf(value));
    }

    public long getLong(String key, long def) {
        String stringVal = this.getString(key, null);
        return stringVal == null ? def : Long.parseLong(stringVal);
    }

    public long getLong(String key) {
        String stringVal = this.getString(key);
        return Long.parseLong(stringVal);
    }

    public void setURI(String key, URI uri) {
        this.setString(key, uri.toString());
    }

    public URI getURI(String key, URI def) {
        String stringVal = this.getString(key, null);
        return stringVal == null ? def : URI.create(stringVal);
    }

    public URI getURI(String key) {
        String stringVal = this.getString(key);
        return URI.create(stringVal);
    }

    public void setClass(String key, Class<?> cls) {
        this.setString(key, cls.getName());
    }

    public <E> Class<? extends E> getClass(String key, Class<E> superType) {
        String className = this.getString(key);
        return InstanceUtils.forName(className, superType);
    }
}

