/*
 * Decompiled with CFR 0.152.
 */
package freemarker.core;

import freemarker.core.FMParser;
import freemarker.core.FMParserConstants;
import freemarker.core.MessageUtil;
import freemarker.core.SimpleCharStream;
import freemarker.core.Token;
import freemarker.core.TokenMgrError;
import freemarker.core._CoreAPI;
import freemarker.core._CoreStringUtils;
import freemarker.template.Configuration;
import freemarker.template.Template;
import freemarker.template._TemplateAPI;
import freemarker.template.utility.StringUtil;
import java.io.IOException;
import java.io.PrintStream;
import java.util.StringTokenizer;

class FMParserTokenManager
implements FMParserConstants {
    private static final String PLANNED_DIRECTIVE_HINT = "(If you have seen this directive in use elsewhere, this was a planned directive, so maybe you need to upgrade FreeMarker.)";
    String noparseTag;
    private FMParser parser;
    private int hashLiteralNesting;
    private int parenthesisNesting;
    private int bracketNesting;
    private boolean inFTLHeader;
    boolean strictEscapeSyntax;
    boolean onlyTextOutput;
    boolean squBracTagSyntax;
    boolean autodetectTagSyntax;
    boolean directiveSyntaxEstablished;
    boolean inInvocation;
    int initialNamingConvention;
    int namingConvention;
    Token namingConventionEstabilisher;
    int incompatibleImprovements;
    public PrintStream debugStream = System.out;
    static final long[] jjbitVec0 = new long[]{-2L, -1L, -1L, -1L};
    static final long[] jjbitVec2 = new long[]{0L, 0L, -1L, -1L};
    static final long[] jjbitVec3 = new long[]{-4503595332403202L, -8193L, -17386027614209L, 1585267068842803199L};
    static final long[] jjbitVec4 = new long[]{0L, 0L, 0x420040000000000L, -36028797027352577L};
    static final long[] jjbitVec5 = new long[]{0L, -9222809086901354496L, 0x1FFF0000L, 0L};
    static final long[] jjbitVec6 = new long[]{-864764451093480316L, 17376L, 24L, 0L};
    static final long[] jjbitVec7 = new long[]{-140737488355329L, -2147483649L, -1L, 3509778554814463L};
    static final long[] jjbitVec8 = new long[]{-245465970900993L, 0x80FFFFFFFFFFL, 0x7F7F7F7F007FFFFFL, 0x7F7F7F7FL};
    static final long[] jjbitVec9 = new long[]{0x800000000000L, 0L, 0L, 0L};
    static final long[] jjbitVec10 = new long[]{1746833705466331232L, -1L, -1L, -1L};
    static final long[] jjbitVec11 = new long[]{-1L, -1L, 0x7FFFFFF0000FFFFL, -281474976710656L};
    static final long[] jjbitVec12 = new long[]{-1L, -1L, 0L, 0L};
    static final long[] jjbitVec13 = new long[]{-1L, -1L, 0x3FFFFFFFFFFFFFL, 0L};
    static final long[] jjbitVec14 = new long[]{-1L, -1L, 8191L, 0x3FFFFFFFFFFF0000L};
    static final long[] jjbitVec15 = new long[]{0xFFFFFFF1FFFL, -9223231299366420481L, -4278190081L, 0x3FFFFFFFFFL};
    static final long[] jjbitVec16 = new long[]{-12893290496L, -1L, 8791799069183L, -72057594037927936L};
    static final long[] jjbitVec17 = new long[]{0x7FFFFF7BBL, 0xFFFFFFFFFFFFFL, 0xFFFFFFFFFFFFCL, 647392446501552128L};
    static final long[] jjbitVec18 = new long[]{-281200098803713L, 2305843004918726783L, 0x7FFFFFFFFFFF0L, 67076096L};
    static final long[] jjbitVec19 = new long[]{0x1FFFFFFFFFFL, 324259168942755831L, 4495436853045886975L, 7890092085477381L};
    static final long[] jjbitVec20 = new long[]{140183445864062L, 0L, 0L, 287948935534739455L};
    static final long[] jjbitVec21 = new long[]{-1L, -1L, -281406257233921L, 0xFFFFFFFFFFFF87FL};
    static final long[] jjbitVec22 = new long[]{6881498030004502655L, -37L, 0x3FFFFFFFFFFFFL, -524288L};
    static final long[] jjbitVec23 = new long[]{0x3FFFFFFFFFFFFFFFL, -65536L, -196609L, 0xFFF0000000000FFL};
    static final long[] jjbitVec24 = new long[]{0L, -9288674231451648L, -1L, 0x1FFFFFFFFFFFFFFFL};
    static final long[] jjbitVec25 = new long[]{576460743780532224L, -274743689218L, Long.MAX_VALUE, 0x1CFCFCFCL};
    static final int[] jjnextStates = new int[]{10, 12, 4, 5, 3, 4, 5, 593, 608, 320, 321, 322, 323, 324, 325, 326, 327, 328, 329, 330, 331, 332, 333, 334, 335, 336, 337, 338, 339, 340, 341, 342, 343, 344, 345, 346, 352, 353, 361, 362, 371, 372, 379, 380, 391, 392, 403, 404, 415, 416, 425, 426, 436, 437, 447, 448, 460, 461, 470, 471, 483, 484, 497, 498, 508, 509, 510, 511, 512, 513, 514, 515, 516, 517, 518, 519, 520, 521, 522, 523, 524, 525, 535, 536, 537, 549, 550, 555, 561, 562, 564, 12, 21, 24, 31, 36, 45, 50, 58, 65, 70, 77, 84, 90, 98, 105, 114, 120, 130, 136, 141, 148, 153, 161, 171, 180, 189, 196, 204, 213, 220, 228, 229, 237, 242, 247, 256, 265, 272, 282, 290, 301, 308, 318, 5, 6, 14, 15, 38, 41, 47, 48, 163, 164, 173, 174, 184, 185, 191, 192, 193, 198, 199, 200, 206, 207, 208, 215, 216, 217, 222, 223, 224, 230, 231, 232, 234, 235, 236, 239, 240, 241, 244, 245, 246, 249, 250, 258, 259, 260, 274, 275, 276, 292, 293, 294, 312, 313, 348, 349, 355, 356, 364, 365, 374, 375, 382, 383, 394, 395, 408, 409, 418, 419, 428, 429, 439, 440, 450, 451, 463, 464, 473, 474, 486, 487, 500, 501, 527, 528, 541, 542, 596, 597, 599, 604, 605, 600, 606, 599, 601, 602, 604, 605, 320, 321, 322, 323, 324, 325, 326, 327, 328, 329, 330, 331, 332, 333, 334, 335, 336, 337, 338, 339, 340, 341, 342, 343, 344, 345, 566, 567, 568, 569, 570, 571, 572, 573, 574, 575, 576, 577, 578, 579, 580, 509, 510, 511, 512, 513, 514, 515, 516, 517, 518, 519, 520, 521, 522, 523, 524, 581, 536, 582, 550, 585, 588, 562, 589, 557, 558, 595, 607, 604, 605, 50, 51, 52, 70, 73, 76, 80, 81, 46, 48, 42, 43, 13, 14, 17, 6, 7, 10, 59, 61, 63, 66, 20, 23, 8, 11, 15, 18, 21, 22, 24, 25, 47, 48, 49, 67, 70, 73, 77, 78, 43, 45, 56, 58, 60, 63, 3, 5, 46, 47, 48, 66, 69, 72, 76, 77, 42, 44, 38, 39, 8, 9, 12, 1, 2, 5, 55, 57, 59, 62, 3, 6, 10, 13, 16, 17, 19, 20, 52, 53, 54, 72, 75, 78, 82, 83, 48, 50, 44, 45, 61, 63, 65, 68};
    public static final String[] jjstrLiteralImages = new String[]{"", null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, "${", "#{", null, null, null, null, null, null, null, null, null, null, "false", "true", null, null, ".", "..", null, "..*", "?", "??", "=", "==", "!=", "+=", "-=", "*=", "/=", "%=", "++", "--", null, null, null, null, "+", "-", "*", "**", "...", "/", "%", null, null, "!", ",", ";", ":", "[", "]", "(", ")", "{", "}", "in", "as", "using", null, null, null, null, null, null, ">", null, ">", ">=", null, null, null, null, null, null};
    public static final String[] lexStateNames = new String[]{"DEFAULT", "NODIRECTIVE", "FM_EXPRESSION", "IN_PAREN", "NAMED_PARAMETER_EXPRESSION", "EXPRESSION_COMMENT", "NO_SPACE_EXPRESSION", "NO_PARSE"};
    public static final int[] jjnewLexState = new int[]{-1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 2, 2, -1, 5, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 2, 2, -1, -1, -1, -1};
    static final long[] jjtoToken = new long[]{-63L, -2088961L, 2095231L};
    static final long[] jjtoSkip = new long[]{0L, 1040384L, 0L};
    protected SimpleCharStream input_stream;
    private final int[] jjrounds = new int[609];
    private final int[] jjstateSet = new int[1218];
    StringBuffer image;
    int jjimageLen;
    int lengthOfMatch;
    protected char curChar;
    int curLexState = 0;
    int defaultLexState = 0;
    int jjnewStateCnt;
    int jjround;
    int jjmatchedPos;
    int jjmatchedKind;

    void setParser(FMParser parser) {
        this.parser = parser;
    }

    Template getTemplate() {
        return this.parser != null ? this.parser.getTemplate() : null;
    }

    private void strictSyntaxCheck(Token tok, int tokenNamingConvention, int newLexState) {
        if (this.onlyTextOutput) {
            tok.kind = 73;
            return;
        }
        String image = tok.image;
        if (!this.strictEscapeSyntax && tokenNamingConvention == 12 && !this.isStrictTag(image)) {
            tok.kind = 73;
            return;
        }
        char firstChar = image.charAt(0);
        if (this.autodetectTagSyntax && !this.directiveSyntaxEstablished) {
            boolean bl = this.squBracTagSyntax = firstChar == '[';
        }
        if (firstChar == '[' && !this.squBracTagSyntax || firstChar == '<' && this.squBracTagSyntax) {
            tok.kind = 73;
            return;
        }
        if (!this.strictEscapeSyntax) {
            this.checkNamingConvention(tok, tokenNamingConvention);
            this.SwitchTo(newLexState);
            return;
        }
        if (!this.squBracTagSyntax && !this.isStrictTag(image)) {
            tok.kind = 73;
            return;
        }
        this.directiveSyntaxEstablished = true;
        this.checkNamingConvention(tok, tokenNamingConvention);
        this.SwitchTo(newLexState);
    }

    void checkNamingConvention(Token tok) {
        this.checkNamingConvention(tok, _CoreStringUtils.getIdentifierNamingConvention(tok.image));
    }

    void checkNamingConvention(Token tok, int tokenNamingConvention) {
        if (tokenNamingConvention != 10) {
            if (this.namingConvention == 10) {
                this.namingConvention = tokenNamingConvention;
                this.namingConventionEstabilisher = tok;
            } else if (this.namingConvention != tokenNamingConvention) {
                throw this.newNameConventionMismatchException(tok);
            }
        }
    }

    private TokenMgrError newNameConventionMismatchException(Token tok) {
        return new TokenMgrError("Naming convention mismatch. Identifiers that are part of the template language (not the user specified ones) " + (this.initialNamingConvention == 10 ? "must consistently use the same naming convention within the same template. This template uses " : "must use the configured naming convention, which is the ") + (this.namingConvention == 12 ? "camel case naming convention (like: exampleName) " : (this.namingConvention == 11 ? "legacy naming convention (directive (tag) names are like examplename, everything else is like example_name) " : "??? (internal error)")) + (this.namingConventionEstabilisher != null ? "estabilished by auto-detection at " + MessageUtil.formatPosition(this.namingConventionEstabilisher.beginLine, this.namingConventionEstabilisher.beginColumn) + " by token " + StringUtil.jQuote(this.namingConventionEstabilisher.image.trim()) : "") + ", but the problematic token, " + StringUtil.jQuote(tok.image.trim()) + ", uses a different convention.", 0, tok.beginLine, tok.beginColumn, tok.endLine, tok.endColumn);
    }

    private void strictSyntaxCheck(Token tok, int newLexState) {
        this.strictSyntaxCheck(tok, 10, newLexState);
    }

    private boolean isStrictTag(String image) {
        return image.length() > 2 && (image.charAt(1) == '#' || image.charAt(2) == '#');
    }

    private static int getTagNamingConvention(Token tok, int charIdxInName) {
        return _CoreStringUtils.isUpperUSASCII(FMParserTokenManager.getTagNameCharAt(tok, charIdxInName)) ? 12 : 11;
    }

    static char getTagNameCharAt(Token tok, int charIdxInName) {
        char c;
        String image = tok.image;
        int idx = 0;
        while ((c = image.charAt(idx)) == '<' || c == '[' || c == '/' || c == '#') {
            ++idx;
        }
        return image.charAt(idx + charIdxInName);
    }

    private void unifiedCall(Token tok) {
        char firstChar = tok.image.charAt(0);
        if (this.autodetectTagSyntax && !this.directiveSyntaxEstablished) {
            boolean bl = this.squBracTagSyntax = firstChar == '[';
        }
        if (this.squBracTagSyntax && firstChar == '<') {
            tok.kind = 73;
            return;
        }
        if (!this.squBracTagSyntax && firstChar == '[') {
            tok.kind = 73;
            return;
        }
        this.directiveSyntaxEstablished = true;
        this.SwitchTo(6);
    }

    private void unifiedCallEnd(Token tok) {
        char firstChar = tok.image.charAt(0);
        if (this.squBracTagSyntax && firstChar == '<') {
            tok.kind = 73;
            return;
        }
        if (!this.squBracTagSyntax && firstChar == '[') {
            tok.kind = 73;
            return;
        }
    }

    private void closeBracket(Token tok) {
        if (this.bracketNesting > 0) {
            --this.bracketNesting;
        } else {
            tok.kind = 139;
            if (this.inFTLHeader) {
                this.eatNewline();
                this.inFTLHeader = false;
            }
            this.SwitchTo(0);
        }
    }

    private void eatNewline() {
        int charsRead = 0;
        try {
            char c;
            do {
                c = this.input_stream.readChar();
                ++charsRead;
                if (!Character.isWhitespace(c)) {
                    this.input_stream.backup(charsRead);
                    return;
                }
                if (c != '\r') continue;
                char next = this.input_stream.readChar();
                ++charsRead;
                if (next != '\n') {
                    this.input_stream.backup(1);
                }
                return;
            } while (c != '\n');
            return;
        }
        catch (IOException ioe) {
            this.input_stream.backup(charsRead);
            return;
        }
    }

    private void ftlHeader(Token matchedToken) {
        if (!this.directiveSyntaxEstablished) {
            this.squBracTagSyntax = matchedToken.image.charAt(0) == '[';
            this.directiveSyntaxEstablished = true;
            this.autodetectTagSyntax = false;
        }
        String img = matchedToken.image;
        char firstChar = img.charAt(0);
        char lastChar = img.charAt(img.length() - 1);
        if (firstChar == '[' && !this.squBracTagSyntax || firstChar == '<' && this.squBracTagSyntax) {
            matchedToken.kind = 73;
        }
        if (matchedToken.kind != 73) {
            if (lastChar != '>' && lastChar != ']') {
                this.SwitchTo(2);
                this.inFTLHeader = true;
            } else {
                this.eatNewline();
            }
        }
    }

    public void setDebugStream(PrintStream ds) {
        this.debugStream = ds;
    }

    private final int jjMoveStringLiteralDfa0_7() {
        return this.jjMoveNfa_7(0, 0);
    }

    private final void jjCheckNAdd(int state) {
        if (this.jjrounds[state] != this.jjround) {
            this.jjstateSet[this.jjnewStateCnt++] = state;
            this.jjrounds[state] = this.jjround;
        }
    }

    private final void jjAddStates(int start, int end) {
        do {
            this.jjstateSet[this.jjnewStateCnt++] = jjnextStates[start];
        } while (start++ != end);
    }

    private final void jjCheckNAddTwoStates(int state1, int state2) {
        this.jjCheckNAdd(state1);
        this.jjCheckNAdd(state2);
    }

    private final void jjCheckNAddStates(int start, int end) {
        do {
            this.jjCheckNAdd(jjnextStates[start]);
        } while (start++ != end);
    }

    private final void jjCheckNAddStates(int start) {
        this.jjCheckNAdd(jjnextStates[start]);
        this.jjCheckNAdd(jjnextStates[start + 1]);
    }

    private final int jjMoveNfa_7(int startState, int curPos) {
        int startsAt = 0;
        this.jjnewStateCnt = 13;
        int i = 1;
        this.jjstateSet[0] = startState;
        int kind = Integer.MAX_VALUE;
        while (true) {
            long l;
            if (++this.jjround == Integer.MAX_VALUE) {
                this.ReInitRounds();
            }
            if (this.curChar < '@') {
                l = 1L << this.curChar;
                block27: do {
                    switch (this.jjstateSet[--i]) {
                        case 0: {
                            if ((0xEFFFDFFFFFFFFFFFL & l) != 0L) {
                                if (kind > 147) {
                                    kind = 147;
                                }
                                this.jjCheckNAdd(6);
                            } else if ((0x1000200000000000L & l) != 0L && kind > 148) {
                                kind = 148;
                            }
                            if (this.curChar == '-') {
                                this.jjAddStates(0, 1);
                                break;
                            }
                            if (this.curChar != '<') break;
                            this.jjstateSet[this.jjnewStateCnt++] = 1;
                            break;
                        }
                        case 1: {
                            if (this.curChar != '/') break;
                            this.jjCheckNAddTwoStates(2, 3);
                            break;
                        }
                        case 2: {
                            if (this.curChar != '#') break;
                            this.jjCheckNAdd(3);
                            break;
                        }
                        case 4: {
                            if ((0x100002600L & l) == 0L) break;
                            this.jjAddStates(2, 3);
                            break;
                        }
                        case 5: {
                            if (this.curChar != '>' || kind <= 146) continue block27;
                            kind = 146;
                            break;
                        }
                        case 6: {
                            if ((0xEFFFDFFFFFFFFFFFL & l) == 0L) continue block27;
                            if (kind > 147) {
                                kind = 147;
                            }
                            this.jjCheckNAdd(6);
                            break;
                        }
                        case 7: {
                            if ((0x1000200000000000L & l) == 0L || kind <= 148) continue block27;
                            kind = 148;
                            break;
                        }
                        case 8: {
                            if (this.curChar != '-') break;
                            this.jjAddStates(0, 1);
                            break;
                        }
                        case 9: {
                            if (this.curChar != '>' || kind <= 145) continue block27;
                            kind = 145;
                            break;
                        }
                        case 10: {
                            if (this.curChar != '-') break;
                            this.jjstateSet[this.jjnewStateCnt++] = 9;
                            break;
                        }
                        case 12: {
                            if (this.curChar != '-') break;
                            this.jjstateSet[this.jjnewStateCnt++] = 11;
                            break;
                        }
                    }
                } while (i != startsAt);
            } else if (this.curChar < '\u0080') {
                l = 1L << (this.curChar & 0x3F);
                block28: do {
                    switch (this.jjstateSet[--i]) {
                        case 0: {
                            if ((0xFFFFFFFFF7FFFFFFL & l) != 0L) {
                                if (kind > 147) {
                                    kind = 147;
                                }
                                this.jjCheckNAdd(6);
                            } else if (this.curChar == '[' && kind > 148) {
                                kind = 148;
                            }
                            if (this.curChar != '[') break;
                            this.jjstateSet[this.jjnewStateCnt++] = 1;
                            break;
                        }
                        case 3: {
                            if ((0x7FFFFFE07FFFFFEL & l) == 0L) break;
                            this.jjAddStates(4, 6);
                            break;
                        }
                        case 5: {
                            if (this.curChar != ']' || kind <= 146) continue block28;
                            kind = 146;
                            break;
                        }
                        case 6: {
                            if ((0xFFFFFFFFF7FFFFFFL & l) == 0L) continue block28;
                            if (kind > 147) {
                                kind = 147;
                            }
                            this.jjCheckNAdd(6);
                            break;
                        }
                        case 7: {
                            if (this.curChar != '[' || kind <= 148) continue block28;
                            kind = 148;
                            break;
                        }
                        case 11: {
                            if (this.curChar != ']' || kind <= 145) continue block28;
                            kind = 145;
                            break;
                        }
                    }
                } while (i != startsAt);
            } else {
                int hiByte = this.curChar >> 8;
                int i1 = hiByte >> 6;
                long l1 = 1L << (hiByte & 0x3F);
                int i2 = (this.curChar & 0xFF) >> 6;
                long l2 = 1L << (this.curChar & 0x3F);
                block29: do {
                    switch (this.jjstateSet[--i]) {
                        case 0: 
                        case 6: {
                            if (!FMParserTokenManager.jjCanMove_0(hiByte, i1, i2, l1, l2)) continue block29;
                            if (kind > 147) {
                                kind = 147;
                            }
                            this.jjCheckNAdd(6);
                            break;
                        }
                    }
                } while (i != startsAt);
            }
            if (kind != Integer.MAX_VALUE) {
                this.jjmatchedKind = kind;
                this.jjmatchedPos = curPos;
                kind = Integer.MAX_VALUE;
            }
            ++curPos;
            i = this.jjnewStateCnt;
            this.jjnewStateCnt = startsAt;
            if (i == (startsAt = 13 - this.jjnewStateCnt)) {
                return curPos;
            }
            try {
                this.curChar = this.input_stream.readChar();
            }
            catch (IOException e) {
                return curPos;
            }
        }
    }

    private final int jjStopStringLiteralDfa_1(int pos, long active0, long active1) {
        switch (pos) {
            case 0: {
                if ((active1 & 0x1800L) != 0L) {
                    this.jjmatchedKind = 74;
                    return -1;
                }
                return -1;
            }
        }
        return -1;
    }

    private final int jjStartNfa_1(int pos, long active0, long active1) {
        return this.jjMoveNfa_1(this.jjStopStringLiteralDfa_1(pos, active0, active1), pos + 1);
    }

    private final int jjStopAtPos(int pos, int kind) {
        this.jjmatchedKind = kind;
        this.jjmatchedPos = pos;
        return pos + 1;
    }

    private final int jjStartNfaWithStates_1(int pos, int kind, int state) {
        this.jjmatchedKind = kind;
        this.jjmatchedPos = pos;
        try {
            this.curChar = this.input_stream.readChar();
        }
        catch (IOException e) {
            return pos + 1;
        }
        return this.jjMoveNfa_1(state, pos + 1);
    }

    private final int jjMoveStringLiteralDfa0_1() {
        switch (this.curChar) {
            case '#': {
                return this.jjMoveStringLiteralDfa1_1(4096L);
            }
            case '$': {
                return this.jjMoveStringLiteralDfa1_1(2048L);
            }
        }
        return this.jjMoveNfa_1(2, 0);
    }

    private final int jjMoveStringLiteralDfa1_1(long active1) {
        try {
            this.curChar = this.input_stream.readChar();
        }
        catch (IOException e) {
            this.jjStopStringLiteralDfa_1(0, 0L, active1);
            return 1;
        }
        switch (this.curChar) {
            case '{': {
                if ((active1 & 0x800L) != 0L) {
                    return this.jjStopAtPos(1, 75);
                }
                if ((active1 & 0x1000L) == 0L) break;
                return this.jjStopAtPos(1, 76);
            }
        }
        return this.jjStartNfa_1(0, 0L, active1);
    }

    private final int jjMoveNfa_1(int startState, int curPos) {
        int startsAt = 0;
        this.jjnewStateCnt = 3;
        int i = 1;
        this.jjstateSet[0] = startState;
        int kind = Integer.MAX_VALUE;
        while (true) {
            long l;
            if (++this.jjround == Integer.MAX_VALUE) {
                this.ReInitRounds();
            }
            if (this.curChar < '@') {
                l = 1L << this.curChar;
                block15: do {
                    switch (this.jjstateSet[--i]) {
                        case 2: {
                            if ((0xEFFFFFE6FFFFD9FFL & l) != 0L) {
                                if (kind > 73) {
                                    kind = 73;
                                }
                                this.jjCheckNAdd(1);
                                break;
                            }
                            if ((0x100002600L & l) != 0L) {
                                if (kind > 72) {
                                    kind = 72;
                                }
                                this.jjCheckNAdd(0);
                                break;
                            }
                            if ((0x1000001800000000L & l) == 0L || kind <= 74) continue block15;
                            kind = 74;
                            break;
                        }
                        case 0: {
                            if ((0x100002600L & l) == 0L) continue block15;
                            kind = 72;
                            this.jjCheckNAdd(0);
                            break;
                        }
                        case 1: {
                            if ((0xEFFFFFE6FFFFD9FFL & l) == 0L) continue block15;
                            kind = 73;
                            this.jjCheckNAdd(1);
                            break;
                        }
                    }
                } while (i != startsAt);
            } else if (this.curChar < '\u0080') {
                l = 1L << (this.curChar & 0x3F);
                block16: do {
                    switch (this.jjstateSet[--i]) {
                        case 2: {
                            if ((0xF7FFFFFFF7FFFFFFL & l) != 0L) {
                                if (kind > 73) {
                                    kind = 73;
                                }
                                this.jjCheckNAdd(1);
                                break;
                            }
                            if ((0x800000008000000L & l) == 0L || kind <= 74) continue block16;
                            kind = 74;
                            break;
                        }
                        case 1: {
                            if ((0xF7FFFFFFF7FFFFFFL & l) == 0L) continue block16;
                            kind = 73;
                            this.jjCheckNAdd(1);
                            break;
                        }
                    }
                } while (i != startsAt);
            } else {
                int hiByte = this.curChar >> 8;
                int i1 = hiByte >> 6;
                long l1 = 1L << (hiByte & 0x3F);
                int i2 = (this.curChar & 0xFF) >> 6;
                long l2 = 1L << (this.curChar & 0x3F);
                block17: do {
                    switch (this.jjstateSet[--i]) {
                        case 1: 
                        case 2: {
                            if (!FMParserTokenManager.jjCanMove_0(hiByte, i1, i2, l1, l2)) continue block17;
                            if (kind > 73) {
                                kind = 73;
                            }
                            this.jjCheckNAdd(1);
                            break;
                        }
                    }
                } while (i != startsAt);
            }
            if (kind != Integer.MAX_VALUE) {
                this.jjmatchedKind = kind;
                this.jjmatchedPos = curPos;
                kind = Integer.MAX_VALUE;
            }
            ++curPos;
            i = this.jjnewStateCnt;
            this.jjnewStateCnt = startsAt;
            if (i == (startsAt = 3 - this.jjnewStateCnt)) {
                return curPos;
            }
            try {
                this.curChar = this.input_stream.readChar();
            }
            catch (IOException e) {
                return curPos;
            }
        }
    }

    private final int jjStopStringLiteralDfa_0(int pos, long active0, long active1) {
        switch (pos) {
            case 0: {
                if ((active1 & 0x1800L) != 0L) {
                    this.jjmatchedKind = 74;
                    return -1;
                }
                return -1;
            }
        }
        return -1;
    }

    private final int jjStartNfa_0(int pos, long active0, long active1) {
        return this.jjMoveNfa_0(this.jjStopStringLiteralDfa_0(pos, active0, active1), pos + 1);
    }

    private final int jjStartNfaWithStates_0(int pos, int kind, int state) {
        this.jjmatchedKind = kind;
        this.jjmatchedPos = pos;
        try {
            this.curChar = this.input_stream.readChar();
        }
        catch (IOException e) {
            return pos + 1;
        }
        return this.jjMoveNfa_0(state, pos + 1);
    }

    private final int jjMoveStringLiteralDfa0_0() {
        switch (this.curChar) {
            case '#': {
                return this.jjMoveStringLiteralDfa1_0(4096L);
            }
            case '$': {
                return this.jjMoveStringLiteralDfa1_0(2048L);
            }
        }
        return this.jjMoveNfa_0(2, 0);
    }

    private final int jjMoveStringLiteralDfa1_0(long active1) {
        try {
            this.curChar = this.input_stream.readChar();
        }
        catch (IOException e) {
            this.jjStopStringLiteralDfa_0(0, 0L, active1);
            return 1;
        }
        switch (this.curChar) {
            case '{': {
                if ((active1 & 0x800L) != 0L) {
                    return this.jjStopAtPos(1, 75);
                }
                if ((active1 & 0x1000L) == 0L) break;
                return this.jjStopAtPos(1, 76);
            }
        }
        return this.jjStartNfa_0(0, 0L, active1);
    }

    private final int jjMoveNfa_0(int startState, int curPos) {
        int startsAt = 0;
        this.jjnewStateCnt = 609;
        int i = 1;
        this.jjstateSet[0] = startState;
        int kind = Integer.MAX_VALUE;
        while (true) {
            long l;
            if (++this.jjround == Integer.MAX_VALUE) {
                this.ReInitRounds();
            }
            if (this.curChar < '@') {
                l = 1L << this.curChar;
                block643: do {
                    switch (this.jjstateSet[--i]) {
                        case 2: {
                            if ((0xEFFFFFE6FFFFD9FFL & l) != 0L) {
                                if (kind > 73) {
                                    kind = 73;
                                }
                                this.jjCheckNAdd(1);
                            } else if ((0x100002600L & l) != 0L) {
                                if (kind > 72) {
                                    kind = 72;
                                }
                                this.jjCheckNAdd(0);
                            } else if ((0x1000001800000000L & l) != 0L && kind > 74) {
                                kind = 74;
                            }
                            if (this.curChar == '<') {
                                this.jjAddStates(7, 8);
                            }
                            if (this.curChar == '<') {
                                this.jjCheckNAddStates(9, 90);
                            }
                            if (this.curChar != '<') break;
                            this.jjCheckNAddStates(91, 133);
                            break;
                        }
                        case 0: {
                            if ((0x100002600L & l) == 0L) continue block643;
                            if (kind > 72) {
                                kind = 72;
                            }
                            this.jjCheckNAdd(0);
                            break;
                        }
                        case 1: {
                            if ((0xEFFFFFE6FFFFD9FFL & l) == 0L) continue block643;
                            if (kind > 73) {
                                kind = 73;
                            }
                            this.jjCheckNAdd(1);
                            break;
                        }
                        case 3: {
                            if (this.curChar != '<') break;
                            this.jjCheckNAddStates(91, 133);
                            break;
                        }
                        case 5: {
                            if ((0x100002600L & l) == 0L) break;
                            this.jjAddStates(134, 135);
                            break;
                        }
                        case 6: {
                            if (this.curChar != '>' || kind <= 6) continue block643;
                            kind = 6;
                            break;
                        }
                        case 14: {
                            if ((0x100002600L & l) == 0L) break;
                            this.jjAddStates(136, 137);
                            break;
                        }
                        case 15: {
                            if (this.curChar != '>' || kind <= 7) continue block643;
                            kind = 7;
                            break;
                        }
                        case 23: {
                            if ((0x100002600L & l) == 0L || kind <= 8) continue block643;
                            kind = 8;
                            break;
                        }
                        case 28: {
                            if ((0x100002600L & l) == 0L || kind <= 9) continue block643;
                            kind = 9;
                            break;
                        }
                        case 33: {
                            if ((0x100002600L & l) == 0L || kind <= 10) continue block643;
                            kind = 10;
                            break;
                        }
                        case 38: {
                            if ((0x100002600L & l) == 0L) break;
                            this.jjAddStates(138, 139);
                            break;
                        }
                        case 40: {
                            if ((0x100002600L & l) == 0L || kind <= 11) continue block643;
                            kind = 11;
                            break;
                        }
                        case 47: {
                            if ((0x100002600L & l) == 0L) break;
                            this.jjAddStates(140, 141);
                            break;
                        }
                        case 48: {
                            if (this.curChar != '>' || kind <= 12) continue block643;
                            kind = 12;
                            break;
                        }
                        case 54: {
                            if ((0x100002600L & l) == 0L || kind <= 13) continue block643;
                            kind = 13;
                            break;
                        }
                        case 60: {
                            if ((0x100002600L & l) == 0L || kind <= 14) continue block643;
                            kind = 14;
                            break;
                        }
                        case 67: {
                            if ((0x100002600L & l) == 0L || kind <= 15) continue block643;
                            kind = 15;
                            break;
                        }
                        case 72: {
                            if ((0x100002600L & l) == 0L || kind <= 16) continue block643;
                            kind = 16;
                            break;
                        }
                        case 79: {
                            if ((0x100002600L & l) == 0L || kind <= 17) continue block643;
                            kind = 17;
                            break;
                        }
                        case 86: {
                            if ((0x100002600L & l) == 0L || kind <= 18) continue block643;
                            kind = 18;
                            break;
                        }
                        case 92: {
                            if ((0x100002600L & l) == 0L || kind <= 19) continue block643;
                            kind = 19;
                            break;
                        }
                        case 100: {
                            if ((0x100002600L & l) == 0L || kind <= 20) continue block643;
                            kind = 20;
                            break;
                        }
                        case 107: {
                            if ((0x100002600L & l) == 0L || kind <= 21) continue block643;
                            kind = 21;
                            break;
                        }
                        case 116: {
                            if ((0x100002600L & l) == 0L || kind <= 22) continue block643;
                            kind = 22;
                            break;
                        }
                        case 122: {
                            if ((0x100002600L & l) == 0L || kind <= 23) continue block643;
                            kind = 23;
                            break;
                        }
                        case 132: {
                            if ((0x100002600L & l) == 0L || kind <= 24) continue block643;
                            kind = 24;
                            break;
                        }
                        case 138: {
                            if ((0x100002600L & l) == 0L || kind <= 25) continue block643;
                            kind = 25;
                            break;
                        }
                        case 143: {
                            if ((0x100002600L & l) == 0L || kind <= 26) continue block643;
                            kind = 26;
                            break;
                        }
                        case 150: {
                            if ((0x100002600L & l) == 0L || kind <= 27) continue block643;
                            kind = 27;
                            break;
                        }
                        case 155: {
                            if ((0x100002600L & l) == 0L || kind <= 28) continue block643;
                            kind = 28;
                            break;
                        }
                        case 163: {
                            if ((0x100002600L & l) == 0L) break;
                            this.jjAddStates(142, 143);
                            break;
                        }
                        case 164: {
                            if (this.curChar != '>' || kind <= 29) continue block643;
                            kind = 29;
                            break;
                        }
                        case 173: {
                            if ((0x100002600L & l) == 0L) break;
                            this.jjAddStates(144, 145);
                            break;
                        }
                        case 174: {
                            if (this.curChar != '>' || kind <= 30) continue block643;
                            kind = 30;
                            break;
                        }
                        case 184: {
                            if ((0x100002600L & l) == 0L) break;
                            this.jjAddStates(146, 147);
                            break;
                        }
                        case 185: {
                            if (this.curChar != '>' || kind <= 32) continue block643;
                            kind = 32;
                            break;
                        }
                        case 191: {
                            if ((0x100002600L & l) == 0L) break;
                            this.jjCheckNAddStates(148, 150);
                            break;
                        }
                        case 192: {
                            if (this.curChar != '/') break;
                            this.jjCheckNAdd(193);
                            break;
                        }
                        case 193: {
                            if (this.curChar != '>' || kind <= 48) continue block643;
                            kind = 48;
                            break;
                        }
                        case 198: {
                            if ((0x100002600L & l) == 0L) break;
                            this.jjCheckNAddStates(151, 153);
                            break;
                        }
                        case 199: {
                            if (this.curChar != '/') break;
                            this.jjCheckNAdd(200);
                            break;
                        }
                        case 200: {
                            if (this.curChar != '>' || kind <= 49) continue block643;
                            kind = 49;
                            break;
                        }
                        case 206: {
                            if ((0x100002600L & l) == 0L) break;
                            this.jjCheckNAddStates(154, 156);
                            break;
                        }
                        case 207: {
                            if (this.curChar != '/') break;
                            this.jjCheckNAdd(208);
                            break;
                        }
                        case 208: {
                            if (this.curChar != '>' || kind <= 50) continue block643;
                            kind = 50;
                            break;
                        }
                        case 215: {
                            if ((0x100002600L & l) == 0L) break;
                            this.jjCheckNAddStates(157, 159);
                            break;
                        }
                        case 216: {
                            if (this.curChar != '/') break;
                            this.jjCheckNAdd(217);
                            break;
                        }
                        case 217: {
                            if (this.curChar != '>' || kind <= 51) continue block643;
                            kind = 51;
                            break;
                        }
                        case 222: {
                            if ((0x100002600L & l) == 0L) break;
                            this.jjCheckNAddStates(160, 162);
                            break;
                        }
                        case 223: {
                            if (this.curChar != '/') break;
                            this.jjCheckNAdd(224);
                            break;
                        }
                        case 224: {
                            if (this.curChar != '>' || kind <= 52) continue block643;
                            kind = 52;
                            break;
                        }
                        case 230: {
                            if ((0x100002600L & l) == 0L) break;
                            this.jjCheckNAddStates(163, 165);
                            break;
                        }
                        case 231: {
                            if (this.curChar != '/') break;
                            this.jjCheckNAdd(232);
                            break;
                        }
                        case 232: {
                            if (this.curChar != '>' || kind <= 53) continue block643;
                            kind = 53;
                            break;
                        }
                        case 234: {
                            if ((0x100002600L & l) == 0L) break;
                            this.jjCheckNAddStates(166, 168);
                            break;
                        }
                        case 235: {
                            if (this.curChar != '/') break;
                            this.jjCheckNAdd(236);
                            break;
                        }
                        case 236: {
                            if (this.curChar != '>' || kind <= 54) continue block643;
                            kind = 54;
                            break;
                        }
                        case 239: {
                            if ((0x100002600L & l) == 0L) break;
                            this.jjCheckNAddStates(169, 171);
                            break;
                        }
                        case 240: {
                            if (this.curChar != '/') break;
                            this.jjCheckNAdd(241);
                            break;
                        }
                        case 241: {
                            if (this.curChar != '>' || kind <= 55) continue block643;
                            kind = 55;
                            break;
                        }
                        case 244: {
                            if ((0x100002600L & l) == 0L) break;
                            this.jjCheckNAddStates(172, 174);
                            break;
                        }
                        case 245: {
                            if (this.curChar != '/') break;
                            this.jjCheckNAdd(246);
                            break;
                        }
                        case 246: {
                            if (this.curChar != '>' || kind <= 56) continue block643;
                            kind = 56;
                            break;
                        }
                        case 249: {
                            if ((0x100002600L & l) == 0L) break;
                            this.jjAddStates(175, 176);
                            break;
                        }
                        case 250: {
                            if (this.curChar != '>' || kind <= 57) continue block643;
                            kind = 57;
                            break;
                        }
                        case 258: {
                            if ((0x100002600L & l) == 0L) break;
                            this.jjCheckNAddStates(177, 179);
                            break;
                        }
                        case 259: {
                            if (this.curChar != '/') break;
                            this.jjCheckNAdd(260);
                            break;
                        }
                        case 260: {
                            if (this.curChar != '>' || kind <= 58) continue block643;
                            kind = 58;
                            break;
                        }
                        case 267: {
                            if ((0x100002600L & l) == 0L || kind <= 59) continue block643;
                            kind = 59;
                            break;
                        }
                        case 274: {
                            if ((0x100002600L & l) == 0L) break;
                            this.jjCheckNAddStates(180, 182);
                            break;
                        }
                        case 275: {
                            if (this.curChar != '/') break;
                            this.jjCheckNAdd(276);
                            break;
                        }
                        case 276: {
                            if (this.curChar != '>' || kind <= 60) continue block643;
                            kind = 60;
                            break;
                        }
                        case 284: {
                            if ((0x100002600L & l) == 0L || kind <= 61) continue block643;
                            kind = 61;
                            break;
                        }
                        case 292: {
                            if ((0x100002600L & l) == 0L) break;
                            this.jjCheckNAddStates(183, 185);
                            break;
                        }
                        case 293: {
                            if (this.curChar != '/') break;
                            this.jjCheckNAdd(294);
                            break;
                        }
                        case 294: {
                            if (this.curChar != '>' || kind <= 62) continue block643;
                            kind = 62;
                            break;
                        }
                        case 303: {
                            if ((0x100002600L & l) == 0L || kind <= 63) continue block643;
                            kind = 63;
                            break;
                        }
                        case 312: {
                            if ((0x100002600L & l) == 0L) break;
                            this.jjAddStates(186, 187);
                            break;
                        }
                        case 313: {
                            if (this.curChar != '>' || kind <= 65) continue block643;
                            kind = 65;
                            break;
                        }
                        case 319: {
                            if (this.curChar != '<') break;
                            this.jjCheckNAddStates(9, 90);
                            break;
                        }
                        case 320: {
                            if (this.curChar != '#') break;
                            this.jjCheckNAdd(12);
                            break;
                        }
                        case 321: {
                            if (this.curChar != '#') break;
                            this.jjCheckNAdd(21);
                            break;
                        }
                        case 322: {
                            if (this.curChar != '#') break;
                            this.jjCheckNAdd(24);
                            break;
                        }
                        case 323: {
                            if (this.curChar != '#') break;
                            this.jjCheckNAdd(31);
                            break;
                        }
                        case 324: {
                            if (this.curChar != '#') break;
                            this.jjCheckNAdd(36);
                            break;
                        }
                        case 325: {
                            if (this.curChar != '#') break;
                            this.jjCheckNAdd(45);
                            break;
                        }
                        case 326: {
                            if (this.curChar != '#') break;
                            this.jjCheckNAdd(50);
                            break;
                        }
                        case 327: {
                            if (this.curChar != '#') break;
                            this.jjCheckNAdd(58);
                            break;
                        }
                        case 328: {
                            if (this.curChar != '#') break;
                            this.jjCheckNAdd(65);
                            break;
                        }
                        case 329: {
                            if (this.curChar != '#') break;
                            this.jjCheckNAdd(70);
                            break;
                        }
                        case 330: {
                            if (this.curChar != '#') break;
                            this.jjCheckNAdd(77);
                            break;
                        }
                        case 331: {
                            if (this.curChar != '#') break;
                            this.jjCheckNAdd(84);
                            break;
                        }
                        case 332: {
                            if (this.curChar != '#') break;
                            this.jjCheckNAdd(90);
                            break;
                        }
                        case 333: {
                            if (this.curChar != '#') break;
                            this.jjCheckNAdd(98);
                            break;
                        }
                        case 334: {
                            if (this.curChar != '#') break;
                            this.jjCheckNAdd(105);
                            break;
                        }
                        case 335: {
                            if (this.curChar != '#') break;
                            this.jjCheckNAdd(114);
                            break;
                        }
                        case 336: {
                            if (this.curChar != '#') break;
                            this.jjCheckNAdd(120);
                            break;
                        }
                        case 337: {
                            if (this.curChar != '#') break;
                            this.jjCheckNAdd(130);
                            break;
                        }
                        case 338: {
                            if (this.curChar != '#') break;
                            this.jjCheckNAdd(136);
                            break;
                        }
                        case 339: {
                            if (this.curChar != '#') break;
                            this.jjCheckNAdd(141);
                            break;
                        }
                        case 340: {
                            if (this.curChar != '#') break;
                            this.jjCheckNAdd(148);
                            break;
                        }
                        case 341: {
                            if (this.curChar != '#') break;
                            this.jjCheckNAdd(153);
                            break;
                        }
                        case 342: {
                            if (this.curChar != '#') break;
                            this.jjCheckNAdd(161);
                            break;
                        }
                        case 343: {
                            if (this.curChar != '#') break;
                            this.jjCheckNAdd(171);
                            break;
                        }
                        case 344: {
                            if (this.curChar != '#') break;
                            this.jjCheckNAdd(180);
                            break;
                        }
                        case 345: {
                            if (this.curChar != '#') break;
                            this.jjCheckNAdd(189);
                            break;
                        }
                        case 346: {
                            if (this.curChar != '/') break;
                            this.jjCheckNAdd(350);
                            break;
                        }
                        case 348: {
                            if ((0x100002600L & l) == 0L) break;
                            this.jjAddStates(188, 189);
                            break;
                        }
                        case 349: {
                            if (this.curChar != '>' || kind <= 33) continue block643;
                            kind = 33;
                            break;
                        }
                        case 351: {
                            if (this.curChar != '#') break;
                            this.jjCheckNAdd(350);
                            break;
                        }
                        case 352: 
                        case 566: {
                            if (this.curChar != '/') break;
                            this.jjCheckNAdd(351);
                            break;
                        }
                        case 353: {
                            if (this.curChar != '/') break;
                            this.jjCheckNAdd(359);
                            break;
                        }
                        case 355: {
                            if ((0x100002600L & l) == 0L) break;
                            this.jjAddStates(190, 191);
                            break;
                        }
                        case 356: {
                            if (this.curChar != '>' || kind <= 34) continue block643;
                            kind = 34;
                            break;
                        }
                        case 360: {
                            if (this.curChar != '#') break;
                            this.jjCheckNAdd(359);
                            break;
                        }
                        case 361: 
                        case 567: {
                            if (this.curChar != '/') break;
                            this.jjCheckNAdd(360);
                            break;
                        }
                        case 362: {
                            if (this.curChar != '/') break;
                            this.jjCheckNAdd(369);
                            break;
                        }
                        case 364: {
                            if ((0x100002600L & l) == 0L) break;
                            this.jjAddStates(192, 193);
                            break;
                        }
                        case 365: {
                            if (this.curChar != '>' || kind <= 35) continue block643;
                            kind = 35;
                            break;
                        }
                        case 370: {
                            if (this.curChar != '#') break;
                            this.jjCheckNAdd(369);
                            break;
                        }
                        case 371: 
                        case 568: {
                            if (this.curChar != '/') break;
                            this.jjCheckNAdd(370);
                            break;
                        }
                        case 372: {
                            if (this.curChar != '/') break;
                            this.jjCheckNAdd(377);
                            break;
                        }
                        case 374: {
                            if ((0x100002600L & l) == 0L) break;
                            this.jjAddStates(194, 195);
                            break;
                        }
                        case 375: {
                            if (this.curChar != '>' || kind <= 36) continue block643;
                            kind = 36;
                            break;
                        }
                        case 378: {
                            if (this.curChar != '#') break;
                            this.jjCheckNAdd(377);
                            break;
                        }
                        case 379: 
                        case 569: {
                            if (this.curChar != '/') break;
                            this.jjCheckNAdd(378);
                            break;
                        }
                        case 380: {
                            if (this.curChar != '/') break;
                            this.jjCheckNAdd(389);
                            break;
                        }
                        case 382: {
                            if ((0x100002600L & l) == 0L) break;
                            this.jjAddStates(196, 197);
                            break;
                        }
                        case 383: {
                            if (this.curChar != '>' || kind <= 37) continue block643;
                            kind = 37;
                            break;
                        }
                        case 390: {
                            if (this.curChar != '#') break;
                            this.jjCheckNAdd(389);
                            break;
                        }
                        case 391: 
                        case 570: {
                            if (this.curChar != '/') break;
                            this.jjCheckNAdd(390);
                            break;
                        }
                        case 392: {
                            if (this.curChar != '/') break;
                            this.jjCheckNAdd(401);
                            break;
                        }
                        case 394: {
                            if ((0x100002600L & l) == 0L) break;
                            this.jjAddStates(198, 199);
                            break;
                        }
                        case 395: {
                            if (this.curChar != '>' || kind <= 38) continue block643;
                            kind = 38;
                            break;
                        }
                        case 402: {
                            if (this.curChar != '#') break;
                            this.jjCheckNAdd(401);
                            break;
                        }
                        case 403: 
                        case 571: {
                            if (this.curChar != '/') break;
                            this.jjCheckNAdd(402);
                            break;
                        }
                        case 404: {
                            if (this.curChar != '/') break;
                            this.jjCheckNAdd(413);
                            break;
                        }
                        case 408: {
                            if ((0x100002600L & l) == 0L) break;
                            this.jjAddStates(200, 201);
                            break;
                        }
                        case 409: {
                            if (this.curChar != '>' || kind <= 39) continue block643;
                            kind = 39;
                            break;
                        }
                        case 414: {
                            if (this.curChar != '#') break;
                            this.jjCheckNAdd(413);
                            break;
                        }
                        case 415: 
                        case 572: {
                            if (this.curChar != '/') break;
                            this.jjCheckNAdd(414);
                            break;
                        }
                        case 416: {
                            if (this.curChar != '/') break;
                            this.jjCheckNAdd(423);
                            break;
                        }
                        case 418: {
                            if ((0x100002600L & l) == 0L) break;
                            this.jjAddStates(202, 203);
                            break;
                        }
                        case 419: {
                            if (this.curChar != '>' || kind <= 40) continue block643;
                            kind = 40;
                            break;
                        }
                        case 424: {
                            if (this.curChar != '#') break;
                            this.jjCheckNAdd(423);
                            break;
                        }
                        case 425: 
                        case 573: {
                            if (this.curChar != '/') break;
                            this.jjCheckNAdd(424);
                            break;
                        }
                        case 426: {
                            if (this.curChar != '/') break;
                            this.jjCheckNAdd(434);
                            break;
                        }
                        case 428: {
                            if ((0x100002600L & l) == 0L) break;
                            this.jjAddStates(204, 205);
                            break;
                        }
                        case 429: {
                            if (this.curChar != '>' || kind <= 41) continue block643;
                            kind = 41;
                            break;
                        }
                        case 435: {
                            if (this.curChar != '#') break;
                            this.jjCheckNAdd(434);
                            break;
                        }
                        case 436: 
                        case 574: {
                            if (this.curChar != '/') break;
                            this.jjCheckNAdd(435);
                            break;
                        }
                        case 437: {
                            if (this.curChar != '/') break;
                            this.jjCheckNAdd(445);
                            break;
                        }
                        case 439: {
                            if ((0x100002600L & l) == 0L) break;
                            this.jjAddStates(206, 207);
                            break;
                        }
                        case 440: {
                            if (this.curChar != '>' || kind <= 42) continue block643;
                            kind = 42;
                            break;
                        }
                        case 446: {
                            if (this.curChar != '#') break;
                            this.jjCheckNAdd(445);
                            break;
                        }
                        case 447: 
                        case 575: {
                            if (this.curChar != '/') break;
                            this.jjCheckNAdd(446);
                            break;
                        }
                        case 448: {
                            if (this.curChar != '/') break;
                            this.jjCheckNAdd(458);
                            break;
                        }
                        case 450: {
                            if ((0x100002600L & l) == 0L) break;
                            this.jjAddStates(208, 209);
                            break;
                        }
                        case 451: {
                            if (this.curChar != '>' || kind <= 43) continue block643;
                            kind = 43;
                            break;
                        }
                        case 459: {
                            if (this.curChar != '#') break;
                            this.jjCheckNAdd(458);
                            break;
                        }
                        case 460: 
                        case 576: {
                            if (this.curChar != '/') break;
                            this.jjCheckNAdd(459);
                            break;
                        }
                        case 461: {
                            if (this.curChar != '/') break;
                            this.jjCheckNAdd(468);
                            break;
                        }
                        case 463: {
                            if ((0x100002600L & l) == 0L) break;
                            this.jjAddStates(210, 211);
                            break;
                        }
                        case 464: {
                            if (this.curChar != '>' || kind <= 44) continue block643;
                            kind = 44;
                            break;
                        }
                        case 469: {
                            if (this.curChar != '#') break;
                            this.jjCheckNAdd(468);
                            break;
                        }
                        case 470: 
                        case 577: {
                            if (this.curChar != '/') break;
                            this.jjCheckNAdd(469);
                            break;
                        }
                        case 471: {
                            if (this.curChar != '/') break;
                            this.jjCheckNAdd(481);
                            break;
                        }
                        case 473: {
                            if ((0x100002600L & l) == 0L) break;
                            this.jjAddStates(212, 213);
                            break;
                        }
                        case 474: {
                            if (this.curChar != '>' || kind <= 45) continue block643;
                            kind = 45;
                            break;
                        }
                        case 482: {
                            if (this.curChar != '#') break;
                            this.jjCheckNAdd(481);
                            break;
                        }
                        case 483: 
                        case 578: {
                            if (this.curChar != '/') break;
                            this.jjCheckNAdd(482);
                            break;
                        }
                        case 484: {
                            if (this.curChar != '/') break;
                            this.jjCheckNAdd(495);
                            break;
                        }
                        case 486: {
                            if ((0x100002600L & l) == 0L) break;
                            this.jjAddStates(214, 215);
                            break;
                        }
                        case 487: {
                            if (this.curChar != '>' || kind <= 46) continue block643;
                            kind = 46;
                            break;
                        }
                        case 496: {
                            if (this.curChar != '#') break;
                            this.jjCheckNAdd(495);
                            break;
                        }
                        case 497: 
                        case 579: {
                            if (this.curChar != '/') break;
                            this.jjCheckNAdd(496);
                            break;
                        }
                        case 498: {
                            if (this.curChar != '/') break;
                            this.jjCheckNAdd(506);
                            break;
                        }
                        case 500: {
                            if ((0x100002600L & l) == 0L) break;
                            this.jjAddStates(216, 217);
                            break;
                        }
                        case 501: {
                            if (this.curChar != '>' || kind <= 47) continue block643;
                            kind = 47;
                            break;
                        }
                        case 507: {
                            if (this.curChar != '#') break;
                            this.jjCheckNAdd(506);
                            break;
                        }
                        case 508: 
                        case 580: {
                            if (this.curChar != '/') break;
                            this.jjCheckNAdd(507);
                            break;
                        }
                        case 509: {
                            if (this.curChar != '#') break;
                            this.jjCheckNAdd(196);
                            break;
                        }
                        case 510: {
                            if (this.curChar != '#') break;
                            this.jjCheckNAdd(204);
                            break;
                        }
                        case 511: {
                            if (this.curChar != '#') break;
                            this.jjCheckNAdd(213);
                            break;
                        }
                        case 512: {
                            if (this.curChar != '#') break;
                            this.jjCheckNAdd(220);
                            break;
                        }
                        case 513: {
                            if (this.curChar != '#') break;
                            this.jjCheckNAdd(228);
                            break;
                        }
                        case 514: {
                            if (this.curChar != '#') break;
                            this.jjCheckNAdd(229);
                            break;
                        }
                        case 515: {
                            if (this.curChar != '#') break;
                            this.jjCheckNAdd(237);
                            break;
                        }
                        case 516: {
                            if (this.curChar != '#') break;
                            this.jjCheckNAdd(242);
                            break;
                        }
                        case 517: {
                            if (this.curChar != '#') break;
                            this.jjCheckNAdd(247);
                            break;
                        }
                        case 518: {
                            if (this.curChar != '#') break;
                            this.jjCheckNAdd(256);
                            break;
                        }
                        case 519: {
                            if (this.curChar != '#') break;
                            this.jjCheckNAdd(265);
                            break;
                        }
                        case 520: {
                            if (this.curChar != '#') break;
                            this.jjCheckNAdd(272);
                            break;
                        }
                        case 521: {
                            if (this.curChar != '#') break;
                            this.jjCheckNAdd(282);
                            break;
                        }
                        case 522: {
                            if (this.curChar != '#') break;
                            this.jjCheckNAdd(290);
                            break;
                        }
                        case 523: {
                            if (this.curChar != '#') break;
                            this.jjCheckNAdd(301);
                            break;
                        }
                        case 524: {
                            if (this.curChar != '#') break;
                            this.jjCheckNAdd(308);
                            break;
                        }
                        case 525: {
                            if (this.curChar != '/') break;
                            this.jjCheckNAdd(533);
                            break;
                        }
                        case 527: {
                            if ((0x100002600L & l) == 0L) break;
                            this.jjAddStates(218, 219);
                            break;
                        }
                        case 528: {
                            if (this.curChar != '>' || kind <= 64) continue block643;
                            kind = 64;
                            break;
                        }
                        case 534: {
                            if (this.curChar != '#') break;
                            this.jjCheckNAdd(533);
                            break;
                        }
                        case 535: 
                        case 581: {
                            if (this.curChar != '/') break;
                            this.jjCheckNAdd(534);
                            break;
                        }
                        case 536: {
                            if (this.curChar != '#') break;
                            this.jjCheckNAdd(318);
                            break;
                        }
                        case 537: {
                            if (this.curChar != '/') break;
                            this.jjCheckNAdd(547);
                            break;
                        }
                        case 541: {
                            if ((0x100002600L & l) == 0L) break;
                            this.jjAddStates(220, 221);
                            break;
                        }
                        case 542: {
                            if (this.curChar != '>' || kind <= 66) continue block643;
                            kind = 66;
                            break;
                        }
                        case 548: {
                            if (this.curChar != '#') break;
                            this.jjCheckNAdd(547);
                            break;
                        }
                        case 549: 
                        case 582: {
                            if (this.curChar != '/') break;
                            this.jjCheckNAdd(548);
                            break;
                        }
                        case 552: {
                            if ((0x100002600L & l) == 0L || kind <= 69) continue block643;
                            kind = 69;
                            break;
                        }
                        case 555: {
                            if (this.curChar != '#') break;
                            this.jjstateSet[this.jjnewStateCnt++] = 554;
                            break;
                        }
                        case 557: {
                            if (this.curChar != '/') break;
                            this.jjstateSet[this.jjnewStateCnt++] = 558;
                            break;
                        }
                        case 558: {
                            if (this.curChar != '>' || kind <= 70) continue block643;
                            kind = 70;
                            break;
                        }
                        case 561: {
                            if (this.curChar != '#') break;
                            this.jjstateSet[this.jjnewStateCnt++] = 560;
                            break;
                        }
                        case 562: {
                            if (this.curChar != '#') break;
                            this.jjstateSet[this.jjnewStateCnt++] = 563;
                            break;
                        }
                        case 564: 
                        case 589: {
                            if (this.curChar != '/') break;
                            this.jjCheckNAdd(562);
                            break;
                        }
                        case 585: {
                            if (this.curChar != '#') break;
                            this.jjstateSet[this.jjnewStateCnt++] = 584;
                            break;
                        }
                        case 588: {
                            if (this.curChar != '#') break;
                            this.jjstateSet[this.jjnewStateCnt++] = 587;
                            break;
                        }
                        case 590: {
                            if (this.curChar != '<') break;
                            this.jjAddStates(7, 8);
                            break;
                        }
                        case 591: {
                            if (this.curChar != '-' || kind <= 31) continue block643;
                            kind = 31;
                            break;
                        }
                        case 592: {
                            if (this.curChar != '-') break;
                            this.jjstateSet[this.jjnewStateCnt++] = 591;
                            break;
                        }
                        case 593: {
                            if (this.curChar != '#') break;
                            this.jjstateSet[this.jjnewStateCnt++] = 592;
                            break;
                        }
                        case 595: {
                            if (this.curChar != '$') break;
                            this.jjCheckNAddStates(222, 226);
                            break;
                        }
                        case 596: {
                            if ((0x3FF001000000000L & l) == 0L) break;
                            this.jjCheckNAddStates(222, 226);
                            break;
                        }
                        case 598: {
                            if ((0x400600000000000L & l) == 0L) break;
                            this.jjCheckNAddStates(222, 226);
                            break;
                        }
                        case 599: {
                            if (this.curChar != '.') break;
                            this.jjAddStates(227, 228);
                            break;
                        }
                        case 600: {
                            if (this.curChar != '$') break;
                            this.jjCheckNAddStates(229, 233);
                            break;
                        }
                        case 601: {
                            if ((0x3FF001000000000L & l) == 0L) break;
                            this.jjCheckNAddStates(229, 233);
                            break;
                        }
                        case 603: {
                            if ((0x400600000000000L & l) == 0L) break;
                            this.jjCheckNAddStates(229, 233);
                            break;
                        }
                        case 604: {
                            if ((0x100002600L & l) == 0L) break;
                            this.jjCheckNAddTwoStates(604, 605);
                            break;
                        }
                        case 605: {
                            if (this.curChar != '>' || kind <= 68) continue block643;
                            kind = 68;
                            break;
                        }
                        case 608: {
                            if (this.curChar != '/') break;
                            this.jjstateSet[this.jjnewStateCnt++] = 594;
                            break;
                        }
                    }
                } while (i != startsAt);
            } else if (this.curChar < '\u0080') {
                l = 1L << (this.curChar & 0x3F);
                block644: do {
                    switch (this.jjstateSet[--i]) {
                        case 2: {
                            if ((0xF7FFFFFFF7FFFFFFL & l) != 0L) {
                                if (kind > 73) {
                                    kind = 73;
                                }
                                this.jjCheckNAdd(1);
                            } else if ((0x800000008000000L & l) != 0L && kind > 74) {
                                kind = 74;
                            }
                            if (this.curChar == '[') {
                                this.jjAddStates(7, 8);
                            }
                            if (this.curChar != '[') break;
                            this.jjAddStates(234, 298);
                            break;
                        }
                        case 1: {
                            if ((0xF7FFFFFFF7FFFFFFL & l) == 0L) continue block644;
                            if (kind > 73) {
                                kind = 73;
                            }
                            this.jjCheckNAdd(1);
                            break;
                        }
                        case 4: {
                            if (this.curChar != 't') break;
                            this.jjAddStates(134, 135);
                            break;
                        }
                        case 6: {
                            if (this.curChar != ']' || kind <= 6) continue block644;
                            kind = 6;
                            break;
                        }
                        case 7: {
                            if (this.curChar != 'p') break;
                            this.jjstateSet[this.jjnewStateCnt++] = 4;
                            break;
                        }
                        case 8: {
                            if (this.curChar != 'm') break;
                            this.jjstateSet[this.jjnewStateCnt++] = 7;
                            break;
                        }
                        case 9: {
                            if (this.curChar != 'e') break;
                            this.jjstateSet[this.jjnewStateCnt++] = 8;
                            break;
                        }
                        case 10: {
                            if (this.curChar != 't') break;
                            this.jjstateSet[this.jjnewStateCnt++] = 9;
                            break;
                        }
                        case 11: {
                            if (this.curChar != 't') break;
                            this.jjstateSet[this.jjnewStateCnt++] = 10;
                            break;
                        }
                        case 12: {
                            if (this.curChar != 'a') break;
                            this.jjstateSet[this.jjnewStateCnt++] = 11;
                            break;
                        }
                        case 13: {
                            if (this.curChar != 'r') break;
                            this.jjAddStates(136, 137);
                            break;
                        }
                        case 15: {
                            if (this.curChar != ']' || kind <= 7) continue block644;
                            kind = 7;
                            break;
                        }
                        case 16: {
                            if (this.curChar != 'e') break;
                            this.jjstateSet[this.jjnewStateCnt++] = 13;
                            break;
                        }
                        case 17: {
                            if (this.curChar != 'v') break;
                            this.jjstateSet[this.jjnewStateCnt++] = 16;
                            break;
                        }
                        case 18: {
                            if (this.curChar != 'o') break;
                            this.jjstateSet[this.jjnewStateCnt++] = 17;
                            break;
                        }
                        case 19: {
                            if (this.curChar != 'c') break;
                            this.jjstateSet[this.jjnewStateCnt++] = 18;
                            break;
                        }
                        case 20: {
                            if (this.curChar != 'e') break;
                            this.jjstateSet[this.jjnewStateCnt++] = 19;
                            break;
                        }
                        case 21: {
                            if (this.curChar != 'r') break;
                            this.jjstateSet[this.jjnewStateCnt++] = 20;
                            break;
                        }
                        case 22: {
                            if (this.curChar != 'f') break;
                            this.jjstateSet[this.jjnewStateCnt++] = 23;
                            break;
                        }
                        case 24: {
                            if (this.curChar != 'i') break;
                            this.jjstateSet[this.jjnewStateCnt++] = 22;
                            break;
                        }
                        case 25: {
                            if (this.curChar != 'e') break;
                            this.jjstateSet[this.jjnewStateCnt++] = 26;
                            break;
                        }
                        case 26: {
                            if ((0x20000000200L & l) == 0L) break;
                            this.jjstateSet[this.jjnewStateCnt++] = 27;
                            break;
                        }
                        case 27: {
                            if (this.curChar != 'f') break;
                            this.jjstateSet[this.jjnewStateCnt++] = 28;
                            break;
                        }
                        case 29: {
                            if (this.curChar != 's') break;
                            this.jjstateSet[this.jjnewStateCnt++] = 25;
                            break;
                        }
                        case 30: {
                            if (this.curChar != 'l') break;
                            this.jjstateSet[this.jjnewStateCnt++] = 29;
                            break;
                        }
                        case 31: {
                            if (this.curChar != 'e') break;
                            this.jjstateSet[this.jjnewStateCnt++] = 30;
                            break;
                        }
                        case 32: {
                            if (this.curChar != 't') break;
                            this.jjstateSet[this.jjnewStateCnt++] = 33;
                            break;
                        }
                        case 34: {
                            if (this.curChar != 's') break;
                            this.jjstateSet[this.jjnewStateCnt++] = 32;
                            break;
                        }
                        case 35: {
                            if (this.curChar != 'i') break;
                            this.jjstateSet[this.jjnewStateCnt++] = 34;
                            break;
                        }
                        case 36: {
                            if (this.curChar != 'l') break;
                            this.jjstateSet[this.jjnewStateCnt++] = 35;
                            break;
                        }
                        case 37: {
                            if (this.curChar != 's') break;
                            this.jjstateSet[this.jjnewStateCnt++] = 38;
                            break;
                        }
                        case 39: {
                            if (this.curChar != 's') break;
                            this.jjstateSet[this.jjnewStateCnt++] = 40;
                            break;
                        }
                        case 41: {
                            if (this.curChar != 'a') break;
                            this.jjstateSet[this.jjnewStateCnt++] = 39;
                            break;
                        }
                        case 42: {
                            if (this.curChar != 'm') break;
                            this.jjstateSet[this.jjnewStateCnt++] = 37;
                            break;
                        }
                        case 43: {
                            if (this.curChar != 'e') break;
                            this.jjstateSet[this.jjnewStateCnt++] = 42;
                            break;
                        }
                        case 44: {
                            if (this.curChar != 't') break;
                            this.jjstateSet[this.jjnewStateCnt++] = 43;
                            break;
                        }
                        case 45: {
                            if (this.curChar != 'i') break;
                            this.jjstateSet[this.jjnewStateCnt++] = 44;
                            break;
                        }
                        case 46: {
                            if (this.curChar != 'p') break;
                            this.jjAddStates(140, 141);
                            break;
                        }
                        case 48: {
                            if (this.curChar != ']' || kind <= 12) continue block644;
                            kind = 12;
                            break;
                        }
                        case 49: {
                            if (this.curChar != 'e') break;
                            this.jjstateSet[this.jjnewStateCnt++] = 46;
                            break;
                        }
                        case 50: {
                            if (this.curChar != 's') break;
                            this.jjstateSet[this.jjnewStateCnt++] = 49;
                            break;
                        }
                        case 51: {
                            if (this.curChar != 'r') break;
                            this.jjstateSet[this.jjnewStateCnt++] = 52;
                            break;
                        }
                        case 52: {
                            if ((0x2000000020L & l) == 0L) break;
                            this.jjstateSet[this.jjnewStateCnt++] = 56;
                            break;
                        }
                        case 53: {
                            if (this.curChar != 'h') break;
                            this.jjstateSet[this.jjnewStateCnt++] = 54;
                            break;
                        }
                        case 55: {
                            if (this.curChar != 'c') break;
                            this.jjstateSet[this.jjnewStateCnt++] = 53;
                            break;
                        }
                        case 56: {
                            if (this.curChar != 'a') break;
                            this.jjstateSet[this.jjnewStateCnt++] = 55;
                            break;
                        }
                        case 57: {
                            if (this.curChar != 'o') break;
                            this.jjstateSet[this.jjnewStateCnt++] = 51;
                            break;
                        }
                        case 58: {
                            if (this.curChar != 'f') break;
                            this.jjstateSet[this.jjnewStateCnt++] = 57;
                            break;
                        }
                        case 59: {
                            if (this.curChar != 'h') break;
                            this.jjstateSet[this.jjnewStateCnt++] = 60;
                            break;
                        }
                        case 61: {
                            if (this.curChar != 'c') break;
                            this.jjstateSet[this.jjnewStateCnt++] = 59;
                            break;
                        }
                        case 62: {
                            if (this.curChar != 't') break;
                            this.jjstateSet[this.jjnewStateCnt++] = 61;
                            break;
                        }
                        case 63: {
                            if (this.curChar != 'i') break;
                            this.jjstateSet[this.jjnewStateCnt++] = 62;
                            break;
                        }
                        case 64: {
                            if (this.curChar != 'w') break;
                            this.jjstateSet[this.jjnewStateCnt++] = 63;
                            break;
                        }
                        case 65: {
                            if (this.curChar != 's') break;
                            this.jjstateSet[this.jjnewStateCnt++] = 64;
                            break;
                        }
                        case 66: {
                            if (this.curChar != 'e') break;
                            this.jjstateSet[this.jjnewStateCnt++] = 67;
                            break;
                        }
                        case 68: {
                            if (this.curChar != 's') break;
                            this.jjstateSet[this.jjnewStateCnt++] = 66;
                            break;
                        }
                        case 69: {
                            if (this.curChar != 'a') break;
                            this.jjstateSet[this.jjnewStateCnt++] = 68;
                            break;
                        }
                        case 70: {
                            if (this.curChar != 'c') break;
                            this.jjstateSet[this.jjnewStateCnt++] = 69;
                            break;
                        }
                        case 71: {
                            if (this.curChar != 'n') break;
                            this.jjstateSet[this.jjnewStateCnt++] = 72;
                            break;
                        }
                        case 73: {
                            if (this.curChar != 'g') break;
                            this.jjstateSet[this.jjnewStateCnt++] = 71;
                            break;
                        }
                        case 74: {
                            if (this.curChar != 'i') break;
                            this.jjstateSet[this.jjnewStateCnt++] = 73;
                            break;
                        }
                        case 75: {
                            if (this.curChar != 's') break;
                            this.jjstateSet[this.jjnewStateCnt++] = 74;
                            break;
                        }
                        case 76: {
                            if (this.curChar != 's') break;
                            this.jjstateSet[this.jjnewStateCnt++] = 75;
                            break;
                        }
                        case 77: {
                            if (this.curChar != 'a') break;
                            this.jjstateSet[this.jjnewStateCnt++] = 76;
                            break;
                        }
                        case 78: {
                            if (this.curChar != 'l') break;
                            this.jjstateSet[this.jjnewStateCnt++] = 79;
                            break;
                        }
                        case 80: {
                            if (this.curChar != 'a') break;
                            this.jjstateSet[this.jjnewStateCnt++] = 78;
                            break;
                        }
                        case 81: {
                            if (this.curChar != 'b') break;
                            this.jjstateSet[this.jjnewStateCnt++] = 80;
                            break;
                        }
                        case 82: {
                            if (this.curChar != 'o') break;
                            this.jjstateSet[this.jjnewStateCnt++] = 81;
                            break;
                        }
                        case 83: {
                            if (this.curChar != 'l') break;
                            this.jjstateSet[this.jjnewStateCnt++] = 82;
                            break;
                        }
                        case 84: {
                            if (this.curChar != 'g') break;
                            this.jjstateSet[this.jjnewStateCnt++] = 83;
                            break;
                        }
                        case 85: {
                            if (this.curChar != 'l') break;
                            this.jjstateSet[this.jjnewStateCnt++] = 86;
                            break;
                        }
                        case 87: {
                            if (this.curChar != 'a') break;
                            this.jjstateSet[this.jjnewStateCnt++] = 85;
                            break;
                        }
                        case 88: {
                            if (this.curChar != 'c') break;
                            this.jjstateSet[this.jjnewStateCnt++] = 87;
                            break;
                        }
                        case 89: {
                            if (this.curChar != 'o') break;
                            this.jjstateSet[this.jjnewStateCnt++] = 88;
                            break;
                        }
                        case 90: {
                            if (this.curChar != 'l') break;
                            this.jjstateSet[this.jjnewStateCnt++] = 89;
                            break;
                        }
                        case 91: {
                            if (this.curChar != 'e') break;
                            this.jjstateSet[this.jjnewStateCnt++] = 92;
                            break;
                        }
                        case 93: {
                            if (this.curChar != 'd') break;
                            this.jjstateSet[this.jjnewStateCnt++] = 91;
                            break;
                        }
                        case 94: {
                            if (this.curChar != 'u') break;
                            this.jjstateSet[this.jjnewStateCnt++] = 93;
                            break;
                        }
                        case 95: {
                            if (this.curChar != 'l') break;
                            this.jjstateSet[this.jjnewStateCnt++] = 94;
                            break;
                        }
                        case 96: {
                            if (this.curChar != 'c') break;
                            this.jjstateSet[this.jjnewStateCnt++] = 95;
                            break;
                        }
                        case 97: {
                            if (this.curChar != 'n') break;
                            this.jjstateSet[this.jjnewStateCnt++] = 96;
                            break;
                        }
                        case 98: {
                            if (this.curChar != 'i') break;
                            this.jjstateSet[this.jjnewStateCnt++] = 97;
                            break;
                        }
                        case 99: {
                            if (this.curChar != 't') break;
                            this.jjstateSet[this.jjnewStateCnt++] = 100;
                            break;
                        }
                        case 101: {
                            if (this.curChar != 'r') break;
                            this.jjstateSet[this.jjnewStateCnt++] = 99;
                            break;
                        }
                        case 102: {
                            if (this.curChar != 'o') break;
                            this.jjstateSet[this.jjnewStateCnt++] = 101;
                            break;
                        }
                        case 103: {
                            if (this.curChar != 'p') break;
                            this.jjstateSet[this.jjnewStateCnt++] = 102;
                            break;
                        }
                        case 104: {
                            if (this.curChar != 'm') break;
                            this.jjstateSet[this.jjnewStateCnt++] = 103;
                            break;
                        }
                        case 105: {
                            if (this.curChar != 'i') break;
                            this.jjstateSet[this.jjnewStateCnt++] = 104;
                            break;
                        }
                        case 106: {
                            if (this.curChar != 'n') break;
                            this.jjstateSet[this.jjnewStateCnt++] = 107;
                            break;
                        }
                        case 108: {
                            if (this.curChar != 'o') break;
                            this.jjstateSet[this.jjnewStateCnt++] = 106;
                            break;
                        }
                        case 109: {
                            if (this.curChar != 'i') break;
                            this.jjstateSet[this.jjnewStateCnt++] = 108;
                            break;
                        }
                        case 110: {
                            if (this.curChar != 't') break;
                            this.jjstateSet[this.jjnewStateCnt++] = 109;
                            break;
                        }
                        case 111: {
                            if (this.curChar != 'c') break;
                            this.jjstateSet[this.jjnewStateCnt++] = 110;
                            break;
                        }
                        case 112: {
                            if (this.curChar != 'n') break;
                            this.jjstateSet[this.jjnewStateCnt++] = 111;
                            break;
                        }
                        case 113: {
                            if (this.curChar != 'u') break;
                            this.jjstateSet[this.jjnewStateCnt++] = 112;
                            break;
                        }
                        case 114: {
                            if (this.curChar != 'f') break;
                            this.jjstateSet[this.jjnewStateCnt++] = 113;
                            break;
                        }
                        case 115: {
                            if (this.curChar != 'o') break;
                            this.jjstateSet[this.jjnewStateCnt++] = 116;
                            break;
                        }
                        case 117: {
                            if (this.curChar != 'r') break;
                            this.jjstateSet[this.jjnewStateCnt++] = 115;
                            break;
                        }
                        case 118: {
                            if (this.curChar != 'c') break;
                            this.jjstateSet[this.jjnewStateCnt++] = 117;
                            break;
                        }
                        case 119: {
                            if (this.curChar != 'a') break;
                            this.jjstateSet[this.jjnewStateCnt++] = 118;
                            break;
                        }
                        case 120: {
                            if (this.curChar != 'm') break;
                            this.jjstateSet[this.jjnewStateCnt++] = 119;
                            break;
                        }
                        case 121: {
                            if (this.curChar != 'm') break;
                            this.jjstateSet[this.jjnewStateCnt++] = 122;
                            break;
                        }
                        case 123: {
                            if (this.curChar != 'r') break;
                            this.jjstateSet[this.jjnewStateCnt++] = 121;
                            break;
                        }
                        case 124: {
                            if (this.curChar != 'o') break;
                            this.jjstateSet[this.jjnewStateCnt++] = 123;
                            break;
                        }
                        case 125: {
                            if (this.curChar != 'f') break;
                            this.jjstateSet[this.jjnewStateCnt++] = 124;
                            break;
                        }
                        case 126: {
                            if (this.curChar != 's') break;
                            this.jjstateSet[this.jjnewStateCnt++] = 125;
                            break;
                        }
                        case 127: {
                            if (this.curChar != 'n') break;
                            this.jjstateSet[this.jjnewStateCnt++] = 126;
                            break;
                        }
                        case 128: {
                            if (this.curChar != 'a') break;
                            this.jjstateSet[this.jjnewStateCnt++] = 127;
                            break;
                        }
                        case 129: {
                            if (this.curChar != 'r') break;
                            this.jjstateSet[this.jjnewStateCnt++] = 128;
                            break;
                        }
                        case 130: {
                            if (this.curChar != 't') break;
                            this.jjstateSet[this.jjnewStateCnt++] = 129;
                            break;
                        }
                        case 131: {
                            if (this.curChar != 't') break;
                            this.jjstateSet[this.jjnewStateCnt++] = 132;
                            break;
                        }
                        case 133: {
                            if (this.curChar != 'i') break;
                            this.jjstateSet[this.jjnewStateCnt++] = 131;
                            break;
                        }
                        case 134: {
                            if (this.curChar != 's') break;
                            this.jjstateSet[this.jjnewStateCnt++] = 133;
                            break;
                        }
                        case 135: {
                            if (this.curChar != 'i') break;
                            this.jjstateSet[this.jjnewStateCnt++] = 134;
                            break;
                        }
                        case 136: {
                            if (this.curChar != 'v') break;
                            this.jjstateSet[this.jjnewStateCnt++] = 135;
                            break;
                        }
                        case 137: {
                            if (this.curChar != 'p') break;
                            this.jjstateSet[this.jjnewStateCnt++] = 138;
                            break;
                        }
                        case 139: {
                            if (this.curChar != 'o') break;
                            this.jjstateSet[this.jjnewStateCnt++] = 137;
                            break;
                        }
                        case 140: {
                            if (this.curChar != 't') break;
                            this.jjstateSet[this.jjnewStateCnt++] = 139;
                            break;
                        }
                        case 141: {
                            if (this.curChar != 's') break;
                            this.jjstateSet[this.jjnewStateCnt++] = 140;
                            break;
                        }
                        case 142: {
                            if (this.curChar != 'n') break;
                            this.jjstateSet[this.jjnewStateCnt++] = 143;
                            break;
                        }
                        case 144: {
                            if (this.curChar != 'r') break;
                            this.jjstateSet[this.jjnewStateCnt++] = 142;
                            break;
                        }
                        case 145: {
                            if (this.curChar != 'u') break;
                            this.jjstateSet[this.jjnewStateCnt++] = 144;
                            break;
                        }
                        case 146: {
                            if (this.curChar != 't') break;
                            this.jjstateSet[this.jjnewStateCnt++] = 145;
                            break;
                        }
                        case 147: {
                            if (this.curChar != 'e') break;
                            this.jjstateSet[this.jjnewStateCnt++] = 146;
                            break;
                        }
                        case 148: {
                            if (this.curChar != 'r') break;
                            this.jjstateSet[this.jjnewStateCnt++] = 147;
                            break;
                        }
                        case 149: {
                            if (this.curChar != 'l') break;
                            this.jjstateSet[this.jjnewStateCnt++] = 150;
                            break;
                        }
                        case 151: {
                            if (this.curChar != 'l') break;
                            this.jjstateSet[this.jjnewStateCnt++] = 149;
                            break;
                        }
                        case 152: {
                            if (this.curChar != 'a') break;
                            this.jjstateSet[this.jjnewStateCnt++] = 151;
                            break;
                        }
                        case 153: {
                            if (this.curChar != 'c') break;
                            this.jjstateSet[this.jjnewStateCnt++] = 152;
                            break;
                        }
                        case 154: {
                            if (this.curChar != 'g') break;
                            this.jjstateSet[this.jjnewStateCnt++] = 155;
                            break;
                        }
                        case 156: {
                            if (this.curChar != 'n') break;
                            this.jjstateSet[this.jjnewStateCnt++] = 154;
                            break;
                        }
                        case 157: {
                            if (this.curChar != 'i') break;
                            this.jjstateSet[this.jjnewStateCnt++] = 156;
                            break;
                        }
                        case 158: {
                            if (this.curChar != 't') break;
                            this.jjstateSet[this.jjnewStateCnt++] = 157;
                            break;
                        }
                        case 159: {
                            if (this.curChar != 't') break;
                            this.jjstateSet[this.jjnewStateCnt++] = 158;
                            break;
                        }
                        case 160: {
                            if (this.curChar != 'e') break;
                            this.jjstateSet[this.jjnewStateCnt++] = 159;
                            break;
                        }
                        case 161: {
                            if (this.curChar != 's') break;
                            this.jjstateSet[this.jjnewStateCnt++] = 160;
                            break;
                        }
                        case 162: {
                            if (this.curChar != 's') break;
                            this.jjAddStates(142, 143);
                            break;
                        }
                        case 164: {
                            if (this.curChar != ']' || kind <= 29) continue block644;
                            kind = 29;
                            break;
                        }
                        case 165: {
                            if (this.curChar != 's') break;
                            this.jjstateSet[this.jjnewStateCnt++] = 162;
                            break;
                        }
                        case 166: {
                            if (this.curChar != 'e') break;
                            this.jjstateSet[this.jjnewStateCnt++] = 165;
                            break;
                        }
                        case 167: {
                            if (this.curChar != 'r') break;
                            this.jjstateSet[this.jjnewStateCnt++] = 166;
                            break;
                        }
                        case 168: {
                            if (this.curChar != 'p') break;
                            this.jjstateSet[this.jjnewStateCnt++] = 167;
                            break;
                        }
                        case 169: {
                            if (this.curChar != 'm') break;
                            this.jjstateSet[this.jjnewStateCnt++] = 168;
                            break;
                        }
                        case 170: {
                            if (this.curChar != 'o') break;
                            this.jjstateSet[this.jjnewStateCnt++] = 169;
                            break;
                        }
                        case 171: {
                            if (this.curChar != 'c') break;
                            this.jjstateSet[this.jjnewStateCnt++] = 170;
                            break;
                        }
                        case 172: {
                            if (this.curChar != 't') break;
                            this.jjAddStates(144, 145);
                            break;
                        }
                        case 174: {
                            if (this.curChar != ']' || kind <= 30) continue block644;
                            kind = 30;
                            break;
                        }
                        case 175: {
                            if (this.curChar != 'n') break;
                            this.jjstateSet[this.jjnewStateCnt++] = 172;
                            break;
                        }
                        case 176: {
                            if (this.curChar != 'e') break;
                            this.jjstateSet[this.jjnewStateCnt++] = 175;
                            break;
                        }
                        case 177: {
                            if (this.curChar != 'm') break;
                            this.jjstateSet[this.jjnewStateCnt++] = 176;
                            break;
                        }
                        case 178: {
                            if (this.curChar != 'm') break;
                            this.jjstateSet[this.jjnewStateCnt++] = 177;
                            break;
                        }
                        case 179: {
                            if (this.curChar != 'o') break;
                            this.jjstateSet[this.jjnewStateCnt++] = 178;
                            break;
                        }
                        case 180: {
                            if (this.curChar != 'c') break;
                            this.jjstateSet[this.jjnewStateCnt++] = 179;
                            break;
                        }
                        case 181: {
                            if (this.curChar != 'o') break;
                            this.jjstateSet[this.jjnewStateCnt++] = 182;
                            break;
                        }
                        case 182: {
                            if ((0x1000000010000L & l) == 0L) break;
                            this.jjstateSet[this.jjnewStateCnt++] = 188;
                            break;
                        }
                        case 183: {
                            if (this.curChar != 'e') break;
                            this.jjAddStates(146, 147);
                            break;
                        }
                        case 185: {
                            if (this.curChar != ']' || kind <= 32) continue block644;
                            kind = 32;
                            break;
                        }
                        case 186: {
                            if (this.curChar != 's') break;
                            this.jjstateSet[this.jjnewStateCnt++] = 183;
                            break;
                        }
                        case 187: {
                            if (this.curChar != 'r') break;
                            this.jjstateSet[this.jjnewStateCnt++] = 186;
                            break;
                        }
                        case 188: {
                            if (this.curChar != 'a') break;
                            this.jjstateSet[this.jjnewStateCnt++] = 187;
                            break;
                        }
                        case 189: {
                            if (this.curChar != 'n') break;
                            this.jjstateSet[this.jjnewStateCnt++] = 181;
                            break;
                        }
                        case 190: {
                            if (this.curChar != 'e') break;
                            this.jjAddStates(148, 150);
                            break;
                        }
                        case 193: {
                            if (this.curChar != ']' || kind <= 48) continue block644;
                            kind = 48;
                            break;
                        }
                        case 194: {
                            if (this.curChar != 's') break;
                            this.jjstateSet[this.jjnewStateCnt++] = 190;
                            break;
                        }
                        case 195: {
                            if (this.curChar != 'l') break;
                            this.jjstateSet[this.jjnewStateCnt++] = 194;
                            break;
                        }
                        case 196: {
                            if (this.curChar != 'e') break;
                            this.jjstateSet[this.jjnewStateCnt++] = 195;
                            break;
                        }
                        case 197: {
                            if (this.curChar != 'k') break;
                            this.jjAddStates(151, 153);
                            break;
                        }
                        case 200: {
                            if (this.curChar != ']' || kind <= 49) continue block644;
                            kind = 49;
                            break;
                        }
                        case 201: {
                            if (this.curChar != 'a') break;
                            this.jjstateSet[this.jjnewStateCnt++] = 197;
                            break;
                        }
                        case 202: {
                            if (this.curChar != 'e') break;
                            this.jjstateSet[this.jjnewStateCnt++] = 201;
                            break;
                        }
                        case 203: {
                            if (this.curChar != 'r') break;
                            this.jjstateSet[this.jjnewStateCnt++] = 202;
                            break;
                        }
                        case 204: {
                            if (this.curChar != 'b') break;
                            this.jjstateSet[this.jjnewStateCnt++] = 203;
                            break;
                        }
                        case 205: {
                            if (this.curChar != 'n') break;
                            this.jjAddStates(154, 156);
                            break;
                        }
                        case 208: {
                            if (this.curChar != ']' || kind <= 50) continue block644;
                            kind = 50;
                            break;
                        }
                        case 209: {
                            if (this.curChar != 'r') break;
                            this.jjstateSet[this.jjnewStateCnt++] = 205;
                            break;
                        }
                        case 210: {
                            if (this.curChar != 'u') break;
                            this.jjstateSet[this.jjnewStateCnt++] = 209;
                            break;
                        }
                        case 211: {
                            if (this.curChar != 't') break;
                            this.jjstateSet[this.jjnewStateCnt++] = 210;
                            break;
                        }
                        case 212: {
                            if (this.curChar != 'e') break;
                            this.jjstateSet[this.jjnewStateCnt++] = 211;
                            break;
                        }
                        case 213: {
                            if (this.curChar != 'r') break;
                            this.jjstateSet[this.jjnewStateCnt++] = 212;
                            break;
                        }
                        case 214: {
                            if (this.curChar != 'p') break;
                            this.jjAddStates(157, 159);
                            break;
                        }
                        case 217: {
                            if (this.curChar != ']' || kind <= 51) continue block644;
                            kind = 51;
                            break;
                        }
                        case 218: {
                            if (this.curChar != 'o') break;
                            this.jjstateSet[this.jjnewStateCnt++] = 214;
                            break;
                        }
                        case 219: {
                            if (this.curChar != 't') break;
                            this.jjstateSet[this.jjnewStateCnt++] = 218;
                            break;
                        }
                        case 220: {
                            if (this.curChar != 's') break;
                            this.jjstateSet[this.jjnewStateCnt++] = 219;
                            break;
                        }
                        case 221: {
                            if (this.curChar != 'h') break;
                            this.jjAddStates(160, 162);
                            break;
                        }
                        case 224: {
                            if (this.curChar != ']' || kind <= 52) continue block644;
                            kind = 52;
                            break;
                        }
                        case 225: {
                            if (this.curChar != 's') break;
                            this.jjstateSet[this.jjnewStateCnt++] = 221;
                            break;
                        }
                        case 226: {
                            if (this.curChar != 'u') break;
                            this.jjstateSet[this.jjnewStateCnt++] = 225;
                            break;
                        }
                        case 227: {
                            if (this.curChar != 'l') break;
                            this.jjstateSet[this.jjnewStateCnt++] = 226;
                            break;
                        }
                        case 228: {
                            if (this.curChar != 'f') break;
                            this.jjstateSet[this.jjnewStateCnt++] = 227;
                            break;
                        }
                        case 229: {
                            if (this.curChar != 't') break;
                            this.jjAddStates(163, 165);
                            break;
                        }
                        case 232: {
                            if (this.curChar != ']' || kind <= 53) continue block644;
                            kind = 53;
                            break;
                        }
                        case 233: {
                            if (this.curChar != 't') break;
                            this.jjAddStates(166, 168);
                            break;
                        }
                        case 236: {
                            if (this.curChar != ']' || kind <= 54) continue block644;
                            kind = 54;
                            break;
                        }
                        case 237: {
                            if (this.curChar != 'l') break;
                            this.jjstateSet[this.jjnewStateCnt++] = 233;
                            break;
                        }
                        case 238: {
                            if (this.curChar != 't') break;
                            this.jjAddStates(169, 171);
                            break;
                        }
                        case 241: {
                            if (this.curChar != ']' || kind <= 55) continue block644;
                            kind = 55;
                            break;
                        }
                        case 242: {
                            if (this.curChar != 'r') break;
                            this.jjstateSet[this.jjnewStateCnt++] = 238;
                            break;
                        }
                        case 243: {
                            if (this.curChar != 't') break;
                            this.jjAddStates(172, 174);
                            break;
                        }
                        case 246: {
                            if (this.curChar != ']' || kind <= 56) continue block644;
                            kind = 56;
                            break;
                        }
                        case 247: {
                            if (this.curChar != 'n') break;
                            this.jjstateSet[this.jjnewStateCnt++] = 243;
                            break;
                        }
                        case 248: {
                            if (this.curChar != 't') break;
                            this.jjAddStates(175, 176);
                            break;
                        }
                        case 250: {
                            if (this.curChar != ']' || kind <= 57) continue block644;
                            kind = 57;
                            break;
                        }
                        case 251: {
                            if (this.curChar != 'l') break;
                            this.jjstateSet[this.jjnewStateCnt++] = 248;
                            break;
                        }
                        case 252: {
                            if (this.curChar != 'u') break;
                            this.jjstateSet[this.jjnewStateCnt++] = 251;
                            break;
                        }
                        case 253: {
                            if (this.curChar != 'a') break;
                            this.jjstateSet[this.jjnewStateCnt++] = 252;
                            break;
                        }
                        case 254: {
                            if (this.curChar != 'f') break;
                            this.jjstateSet[this.jjnewStateCnt++] = 253;
                            break;
                        }
                        case 255: {
                            if (this.curChar != 'e') break;
                            this.jjstateSet[this.jjnewStateCnt++] = 254;
                            break;
                        }
                        case 256: {
                            if (this.curChar != 'd') break;
                            this.jjstateSet[this.jjnewStateCnt++] = 255;
                            break;
                        }
                        case 257: {
                            if (this.curChar != 'd') break;
                            this.jjAddStates(177, 179);
                            break;
                        }
                        case 260: {
                            if (this.curChar != ']' || kind <= 58) continue block644;
                            kind = 58;
                            break;
                        }
                        case 261: {
                            if (this.curChar != 'e') break;
                            this.jjstateSet[this.jjnewStateCnt++] = 257;
                            break;
                        }
                        case 262: {
                            if (this.curChar != 't') break;
                            this.jjstateSet[this.jjnewStateCnt++] = 261;
                            break;
                        }
                        case 263: {
                            if (this.curChar != 's') break;
                            this.jjstateSet[this.jjnewStateCnt++] = 262;
                            break;
                        }
                        case 264: {
                            if (this.curChar != 'e') break;
                            this.jjstateSet[this.jjnewStateCnt++] = 263;
                            break;
                        }
                        case 265: {
                            if (this.curChar != 'n') break;
                            this.jjstateSet[this.jjnewStateCnt++] = 264;
                            break;
                        }
                        case 266: {
                            if (this.curChar != 'd') break;
                            this.jjstateSet[this.jjnewStateCnt++] = 267;
                            break;
                        }
                        case 268: {
                            if (this.curChar != 'e') break;
                            this.jjstateSet[this.jjnewStateCnt++] = 266;
                            break;
                        }
                        case 269: {
                            if (this.curChar != 't') break;
                            this.jjstateSet[this.jjnewStateCnt++] = 268;
                            break;
                        }
                        case 270: {
                            if (this.curChar != 's') break;
                            this.jjstateSet[this.jjnewStateCnt++] = 269;
                            break;
                        }
                        case 271: {
                            if (this.curChar != 'e') break;
                            this.jjstateSet[this.jjnewStateCnt++] = 270;
                            break;
                        }
                        case 272: {
                            if (this.curChar != 'n') break;
                            this.jjstateSet[this.jjnewStateCnt++] = 271;
                            break;
                        }
                        case 273: {
                            if (this.curChar != 'e') break;
                            this.jjAddStates(180, 182);
                            break;
                        }
                        case 276: {
                            if (this.curChar != ']' || kind <= 60) continue block644;
                            kind = 60;
                            break;
                        }
                        case 277: {
                            if (this.curChar != 's') break;
                            this.jjstateSet[this.jjnewStateCnt++] = 273;
                            break;
                        }
                        case 278: {
                            if (this.curChar != 'r') break;
                            this.jjstateSet[this.jjnewStateCnt++] = 277;
                            break;
                        }
                        case 279: {
                            if (this.curChar != 'u') break;
                            this.jjstateSet[this.jjnewStateCnt++] = 278;
                            break;
                        }
                        case 280: {
                            if (this.curChar != 'c') break;
                            this.jjstateSet[this.jjnewStateCnt++] = 279;
                            break;
                        }
                        case 281: {
                            if (this.curChar != 'e') break;
                            this.jjstateSet[this.jjnewStateCnt++] = 280;
                            break;
                        }
                        case 282: {
                            if (this.curChar != 'r') break;
                            this.jjstateSet[this.jjnewStateCnt++] = 281;
                            break;
                        }
                        case 283: {
                            if (this.curChar != 'e') break;
                            this.jjstateSet[this.jjnewStateCnt++] = 284;
                            break;
                        }
                        case 285: {
                            if (this.curChar != 's') break;
                            this.jjstateSet[this.jjnewStateCnt++] = 283;
                            break;
                        }
                        case 286: {
                            if (this.curChar != 'r') break;
                            this.jjstateSet[this.jjnewStateCnt++] = 285;
                            break;
                        }
                        case 287: {
                            if (this.curChar != 'u') break;
                            this.jjstateSet[this.jjnewStateCnt++] = 286;
                            break;
                        }
                        case 288: {
                            if (this.curChar != 'c') break;
                            this.jjstateSet[this.jjnewStateCnt++] = 287;
                            break;
                        }
                        case 289: {
                            if (this.curChar != 'e') break;
                            this.jjstateSet[this.jjnewStateCnt++] = 288;
                            break;
                        }
                        case 290: {
                            if (this.curChar != 'r') break;
                            this.jjstateSet[this.jjnewStateCnt++] = 289;
                            break;
                        }
                        case 291: {
                            if (this.curChar != 'k') break;
                            this.jjAddStates(183, 185);
                            break;
                        }
                        case 294: {
                            if (this.curChar != ']' || kind <= 62) continue block644;
                            kind = 62;
                            break;
                        }
                        case 295: {
                            if (this.curChar != 'c') break;
                            this.jjstateSet[this.jjnewStateCnt++] = 291;
                            break;
                        }
                        case 296: {
                            if (this.curChar != 'a') break;
                            this.jjstateSet[this.jjnewStateCnt++] = 295;
                            break;
                        }
                        case 297: {
                            if (this.curChar != 'b') break;
                            this.jjstateSet[this.jjnewStateCnt++] = 296;
                            break;
                        }
                        case 298: {
                            if (this.curChar != 'l') break;
                            this.jjstateSet[this.jjnewStateCnt++] = 297;
                            break;
                        }
                        case 299: {
                            if (this.curChar != 'l') break;
                            this.jjstateSet[this.jjnewStateCnt++] = 298;
                            break;
                        }
                        case 300: {
                            if (this.curChar != 'a') break;
                            this.jjstateSet[this.jjnewStateCnt++] = 299;
                            break;
                        }
                        case 301: {
                            if (this.curChar != 'f') break;
                            this.jjstateSet[this.jjnewStateCnt++] = 300;
                            break;
                        }
                        case 302: {
                            if (this.curChar != 'e') break;
                            this.jjstateSet[this.jjnewStateCnt++] = 303;
                            break;
                        }
                        case 304: {
                            if (this.curChar != 'p') break;
                            this.jjstateSet[this.jjnewStateCnt++] = 302;
                            break;
                        }
                        case 305: {
                            if (this.curChar != 'a') break;
                            this.jjstateSet[this.jjnewStateCnt++] = 304;
                            break;
                        }
                        case 306: {
                            if (this.curChar != 'c') break;
                            this.jjstateSet[this.jjnewStateCnt++] = 305;
                            break;
                        }
                        case 307: {
                            if (this.curChar != 's') break;
                            this.jjstateSet[this.jjnewStateCnt++] = 306;
                            break;
                        }
                        case 308: {
                            if (this.curChar != 'e') break;
                            this.jjstateSet[this.jjnewStateCnt++] = 307;
                            break;
                        }
                        case 309: {
                            if (this.curChar != 'o') break;
                            this.jjstateSet[this.jjnewStateCnt++] = 310;
                            break;
                        }
                        case 310: {
                            if ((0x2000000020L & l) == 0L) break;
                            this.jjstateSet[this.jjnewStateCnt++] = 317;
                            break;
                        }
                        case 311: {
                            if (this.curChar != 'e') break;
                            this.jjAddStates(186, 187);
                            break;
                        }
                        case 313: {
                            if (this.curChar != ']' || kind <= 65) continue block644;
                            kind = 65;
                            break;
                        }
                        case 314: {
                            if (this.curChar != 'p') break;
                            this.jjstateSet[this.jjnewStateCnt++] = 311;
                            break;
                        }
                        case 315: {
                            if (this.curChar != 'a') break;
                            this.jjstateSet[this.jjnewStateCnt++] = 314;
                            break;
                        }
                        case 316: {
                            if (this.curChar != 'c') break;
                            this.jjstateSet[this.jjnewStateCnt++] = 315;
                            break;
                        }
                        case 317: {
                            if (this.curChar != 's') break;
                            this.jjstateSet[this.jjnewStateCnt++] = 316;
                            break;
                        }
                        case 318: {
                            if (this.curChar != 'n') break;
                            this.jjstateSet[this.jjnewStateCnt++] = 309;
                            break;
                        }
                        case 347: {
                            if (this.curChar != 'f') break;
                            this.jjAddStates(188, 189);
                            break;
                        }
                        case 349: {
                            if (this.curChar != ']' || kind <= 33) continue block644;
                            kind = 33;
                            break;
                        }
                        case 350: {
                            if (this.curChar != 'i') break;
                            this.jjstateSet[this.jjnewStateCnt++] = 347;
                            break;
                        }
                        case 354: {
                            if (this.curChar != 't') break;
                            this.jjAddStates(190, 191);
                            break;
                        }
                        case 356: {
                            if (this.curChar != ']' || kind <= 34) continue block644;
                            kind = 34;
                            break;
                        }
                        case 357: {
                            if (this.curChar != 's') break;
                            this.jjstateSet[this.jjnewStateCnt++] = 354;
                            break;
                        }
                        case 358: {
                            if (this.curChar != 'i') break;
                            this.jjstateSet[this.jjnewStateCnt++] = 357;
                            break;
                        }
                        case 359: {
                            if (this.curChar != 'l') break;
                            this.jjstateSet[this.jjnewStateCnt++] = 358;
                            break;
                        }
                        case 363: {
                            if (this.curChar != 's') break;
                            this.jjAddStates(192, 193);
                            break;
                        }
                        case 365: {
                            if (this.curChar != ']' || kind <= 35) continue block644;
                            kind = 35;
                            break;
                        }
                        case 366: {
                            if (this.curChar != 'm') break;
                            this.jjstateSet[this.jjnewStateCnt++] = 363;
                            break;
                        }
                        case 367: {
                            if (this.curChar != 'e') break;
                            this.jjstateSet[this.jjnewStateCnt++] = 366;
                            break;
                        }
                        case 368: {
                            if (this.curChar != 't') break;
                            this.jjstateSet[this.jjnewStateCnt++] = 367;
                            break;
                        }
                        case 369: {
                            if (this.curChar != 'i') break;
                            this.jjstateSet[this.jjnewStateCnt++] = 368;
                            break;
                        }
                        case 373: {
                            if (this.curChar != 'p') break;
                            this.jjAddStates(194, 195);
                            break;
                        }
                        case 375: {
                            if (this.curChar != ']' || kind <= 36) continue block644;
                            kind = 36;
                            break;
                        }
                        case 376: {
                            if (this.curChar != 'e') break;
                            this.jjstateSet[this.jjnewStateCnt++] = 373;
                            break;
                        }
                        case 377: {
                            if (this.curChar != 's') break;
                            this.jjstateSet[this.jjnewStateCnt++] = 376;
                            break;
                        }
                        case 381: {
                            if (this.curChar != 'r') break;
                            this.jjAddStates(196, 197);
                            break;
                        }
                        case 383: {
                            if (this.curChar != ']' || kind <= 37) continue block644;
                            kind = 37;
                            break;
                        }
                        case 384: {
                            if (this.curChar != 'e') break;
                            this.jjstateSet[this.jjnewStateCnt++] = 381;
                            break;
                        }
                        case 385: {
                            if (this.curChar != 'v') break;
                            this.jjstateSet[this.jjnewStateCnt++] = 384;
                            break;
                        }
                        case 386: {
                            if (this.curChar != 'o') break;
                            this.jjstateSet[this.jjnewStateCnt++] = 385;
                            break;
                        }
                        case 387: {
                            if (this.curChar != 'c') break;
                            this.jjstateSet[this.jjnewStateCnt++] = 386;
                            break;
                        }
                        case 388: {
                            if (this.curChar != 'e') break;
                            this.jjstateSet[this.jjnewStateCnt++] = 387;
                            break;
                        }
                        case 389: {
                            if (this.curChar != 'r') break;
                            this.jjstateSet[this.jjnewStateCnt++] = 388;
                            break;
                        }
                        case 393: {
                            if (this.curChar != 't') break;
                            this.jjAddStates(198, 199);
                            break;
                        }
                        case 395: {
                            if (this.curChar != ']' || kind <= 38) continue block644;
                            kind = 38;
                            break;
                        }
                        case 396: {
                            if (this.curChar != 'p') break;
                            this.jjstateSet[this.jjnewStateCnt++] = 393;
                            break;
                        }
                        case 397: {
                            if (this.curChar != 'm') break;
                            this.jjstateSet[this.jjnewStateCnt++] = 396;
                            break;
                        }
                        case 398: {
                            if (this.curChar != 'e') break;
                            this.jjstateSet[this.jjnewStateCnt++] = 397;
                            break;
                        }
                        case 399: {
                            if (this.curChar != 't') break;
                            this.jjstateSet[this.jjnewStateCnt++] = 398;
                            break;
                        }
                        case 400: {
                            if (this.curChar != 't') break;
                            this.jjstateSet[this.jjnewStateCnt++] = 399;
                            break;
                        }
                        case 401: {
                            if (this.curChar != 'a') break;
                            this.jjstateSet[this.jjnewStateCnt++] = 400;
                            break;
                        }
                        case 405: {
                            if (this.curChar != 'r') break;
                            this.jjstateSet[this.jjnewStateCnt++] = 406;
                            break;
                        }
                        case 406: {
                            if ((0x2000000020L & l) == 0L) break;
                            this.jjstateSet[this.jjnewStateCnt++] = 411;
                            break;
                        }
                        case 407: {
                            if (this.curChar != 'h') break;
                            this.jjAddStates(200, 201);
                            break;
                        }
                        case 409: {
                            if (this.curChar != ']' || kind <= 39) continue block644;
                            kind = 39;
                            break;
                        }
                        case 410: {
                            if (this.curChar != 'c') break;
                            this.jjstateSet[this.jjnewStateCnt++] = 407;
                            break;
                        }
                        case 411: {
                            if (this.curChar != 'a') break;
                            this.jjstateSet[this.jjnewStateCnt++] = 410;
                            break;
                        }
                        case 412: {
                            if (this.curChar != 'o') break;
                            this.jjstateSet[this.jjnewStateCnt++] = 405;
                            break;
                        }
                        case 413: {
                            if (this.curChar != 'f') break;
                            this.jjstateSet[this.jjnewStateCnt++] = 412;
                            break;
                        }
                        case 417: {
                            if (this.curChar != 'l') break;
                            this.jjAddStates(202, 203);
                            break;
                        }
                        case 419: {
                            if (this.curChar != ']' || kind <= 40) continue block644;
                            kind = 40;
                            break;
                        }
                        case 420: {
                            if (this.curChar != 'a') break;
                            this.jjstateSet[this.jjnewStateCnt++] = 417;
                            break;
                        }
                        case 421: {
                            if (this.curChar != 'c') break;
                            this.jjstateSet[this.jjnewStateCnt++] = 420;
                            break;
                        }
                        case 422: {
                            if (this.curChar != 'o') break;
                            this.jjstateSet[this.jjnewStateCnt++] = 421;
                            break;
                        }
                        case 423: {
                            if (this.curChar != 'l') break;
                            this.jjstateSet[this.jjnewStateCnt++] = 422;
                            break;
                        }
                        case 427: {
                            if (this.curChar != 'l') break;
                            this.jjAddStates(204, 205);
                            break;
                        }
                        case 429: {
                            if (this.curChar != ']' || kind <= 41) continue block644;
                            kind = 41;
                            break;
                        }
                        case 430: {
                            if (this.curChar != 'a') break;
                            this.jjstateSet[this.jjnewStateCnt++] = 427;
                            break;
                        }
                        case 431: {
                            if (this.curChar != 'b') break;
                            this.jjstateSet[this.jjnewStateCnt++] = 430;
                            break;
                        }
                        case 432: {
                            if (this.curChar != 'o') break;
                            this.jjstateSet[this.jjnewStateCnt++] = 431;
                            break;
                        }
                        case 433: {
                            if (this.curChar != 'l') break;
                            this.jjstateSet[this.jjnewStateCnt++] = 432;
                            break;
                        }
                        case 434: {
                            if (this.curChar != 'g') break;
                            this.jjstateSet[this.jjnewStateCnt++] = 433;
                            break;
                        }
                        case 438: {
                            if (this.curChar != 'n') break;
                            this.jjAddStates(206, 207);
                            break;
                        }
                        case 440: {
                            if (this.curChar != ']' || kind <= 42) continue block644;
                            kind = 42;
                            break;
                        }
                        case 441: {
                            if (this.curChar != 'g') break;
                            this.jjstateSet[this.jjnewStateCnt++] = 438;
                            break;
                        }
                        case 442: {
                            if (this.curChar != 'i') break;
                            this.jjstateSet[this.jjnewStateCnt++] = 441;
                            break;
                        }
                        case 443: {
                            if (this.curChar != 's') break;
                            this.jjstateSet[this.jjnewStateCnt++] = 442;
                            break;
                        }
                        case 444: {
                            if (this.curChar != 's') break;
                            this.jjstateSet[this.jjnewStateCnt++] = 443;
                            break;
                        }
                        case 445: {
                            if (this.curChar != 'a') break;
                            this.jjstateSet[this.jjnewStateCnt++] = 444;
                            break;
                        }
                        case 449: {
                            if (this.curChar != 'n') break;
                            this.jjAddStates(208, 209);
                            break;
                        }
                        case 451: {
                            if (this.curChar != ']' || kind <= 43) continue block644;
                            kind = 43;
                            break;
                        }
                        case 452: {
                            if (this.curChar != 'o') break;
                            this.jjstateSet[this.jjnewStateCnt++] = 449;
                            break;
                        }
                        case 453: {
                            if (this.curChar != 'i') break;
                            this.jjstateSet[this.jjnewStateCnt++] = 452;
                            break;
                        }
                        case 454: {
                            if (this.curChar != 't') break;
                            this.jjstateSet[this.jjnewStateCnt++] = 453;
                            break;
                        }
                        case 455: {
                            if (this.curChar != 'c') break;
                            this.jjstateSet[this.jjnewStateCnt++] = 454;
                            break;
                        }
                        case 456: {
                            if (this.curChar != 'n') break;
                            this.jjstateSet[this.jjnewStateCnt++] = 455;
                            break;
                        }
                        case 457: {
                            if (this.curChar != 'u') break;
                            this.jjstateSet[this.jjnewStateCnt++] = 456;
                            break;
                        }
                        case 458: {
                            if (this.curChar != 'f') break;
                            this.jjstateSet[this.jjnewStateCnt++] = 457;
                            break;
                        }
                        case 462: {
                            if (this.curChar != 'o') break;
                            this.jjAddStates(210, 211);
                            break;
                        }
                        case 464: {
                            if (this.curChar != ']' || kind <= 44) continue block644;
                            kind = 44;
                            break;
                        }
                        case 465: {
                            if (this.curChar != 'r') break;
                            this.jjstateSet[this.jjnewStateCnt++] = 462;
                            break;
                        }
                        case 466: {
                            if (this.curChar != 'c') break;
                            this.jjstateSet[this.jjnewStateCnt++] = 465;
                            break;
                        }
                        case 467: {
                            if (this.curChar != 'a') break;
                            this.jjstateSet[this.jjnewStateCnt++] = 466;
                            break;
                        }
                        case 468: {
                            if (this.curChar != 'm') break;
                            this.jjstateSet[this.jjnewStateCnt++] = 467;
                            break;
                        }
                        case 472: {
                            if (this.curChar != 's') break;
                            this.jjAddStates(212, 213);
                            break;
                        }
                        case 474: {
                            if (this.curChar != ']' || kind <= 45) continue block644;
                            kind = 45;
                            break;
                        }
                        case 475: {
                            if (this.curChar != 's') break;
                            this.jjstateSet[this.jjnewStateCnt++] = 472;
                            break;
                        }
                        case 476: {
                            if (this.curChar != 'e') break;
                            this.jjstateSet[this.jjnewStateCnt++] = 475;
                            break;
                        }
                        case 477: {
                            if (this.curChar != 'r') break;
                            this.jjstateSet[this.jjnewStateCnt++] = 476;
                            break;
                        }
                        case 478: {
                            if (this.curChar != 'p') break;
                            this.jjstateSet[this.jjnewStateCnt++] = 477;
                            break;
                        }
                        case 479: {
                            if (this.curChar != 'm') break;
                            this.jjstateSet[this.jjnewStateCnt++] = 478;
                            break;
                        }
                        case 480: {
                            if (this.curChar != 'o') break;
                            this.jjstateSet[this.jjnewStateCnt++] = 479;
                            break;
                        }
                        case 481: {
                            if (this.curChar != 'c') break;
                            this.jjstateSet[this.jjnewStateCnt++] = 480;
                            break;
                        }
                        case 485: {
                            if (this.curChar != 'm') break;
                            this.jjAddStates(214, 215);
                            break;
                        }
                        case 487: {
                            if (this.curChar != ']' || kind <= 46) continue block644;
                            kind = 46;
                            break;
                        }
                        case 488: {
                            if (this.curChar != 'r') break;
                            this.jjstateSet[this.jjnewStateCnt++] = 485;
                            break;
                        }
                        case 489: {
                            if (this.curChar != 'o') break;
                            this.jjstateSet[this.jjnewStateCnt++] = 488;
                            break;
                        }
                        case 490: {
                            if (this.curChar != 'f') break;
                            this.jjstateSet[this.jjnewStateCnt++] = 489;
                            break;
                        }
                        case 491: {
                            if (this.curChar != 's') break;
                            this.jjstateSet[this.jjnewStateCnt++] = 490;
                            break;
                        }
                        case 492: {
                            if (this.curChar != 'n') break;
                            this.jjstateSet[this.jjnewStateCnt++] = 491;
                            break;
                        }
                        case 493: {
                            if (this.curChar != 'a') break;
                            this.jjstateSet[this.jjnewStateCnt++] = 492;
                            break;
                        }
                        case 494: {
                            if (this.curChar != 'r') break;
                            this.jjstateSet[this.jjnewStateCnt++] = 493;
                            break;
                        }
                        case 495: {
                            if (this.curChar != 't') break;
                            this.jjstateSet[this.jjnewStateCnt++] = 494;
                            break;
                        }
                        case 499: {
                            if (this.curChar != 'h') break;
                            this.jjAddStates(216, 217);
                            break;
                        }
                        case 501: {
                            if (this.curChar != ']' || kind <= 47) continue block644;
                            kind = 47;
                            break;
                        }
                        case 502: {
                            if (this.curChar != 'c') break;
                            this.jjstateSet[this.jjnewStateCnt++] = 499;
                            break;
                        }
                        case 503: {
                            if (this.curChar != 't') break;
                            this.jjstateSet[this.jjnewStateCnt++] = 502;
                            break;
                        }
                        case 504: {
                            if (this.curChar != 'i') break;
                            this.jjstateSet[this.jjnewStateCnt++] = 503;
                            break;
                        }
                        case 505: {
                            if (this.curChar != 'w') break;
                            this.jjstateSet[this.jjnewStateCnt++] = 504;
                            break;
                        }
                        case 506: {
                            if (this.curChar != 's') break;
                            this.jjstateSet[this.jjnewStateCnt++] = 505;
                            break;
                        }
                        case 526: {
                            if (this.curChar != 'e') break;
                            this.jjAddStates(218, 219);
                            break;
                        }
                        case 528: {
                            if (this.curChar != ']' || kind <= 64) continue block644;
                            kind = 64;
                            break;
                        }
                        case 529: {
                            if (this.curChar != 'p') break;
                            this.jjstateSet[this.jjnewStateCnt++] = 526;
                            break;
                        }
                        case 530: {
                            if (this.curChar != 'a') break;
                            this.jjstateSet[this.jjnewStateCnt++] = 529;
                            break;
                        }
                        case 531: {
                            if (this.curChar != 'c') break;
                            this.jjstateSet[this.jjnewStateCnt++] = 530;
                            break;
                        }
                        case 532: {
                            if (this.curChar != 's') break;
                            this.jjstateSet[this.jjnewStateCnt++] = 531;
                            break;
                        }
                        case 533: {
                            if (this.curChar != 'e') break;
                            this.jjstateSet[this.jjnewStateCnt++] = 532;
                            break;
                        }
                        case 538: {
                            if (this.curChar != 'o') break;
                            this.jjstateSet[this.jjnewStateCnt++] = 539;
                            break;
                        }
                        case 539: {
                            if ((0x2000000020L & l) == 0L) break;
                            this.jjstateSet[this.jjnewStateCnt++] = 546;
                            break;
                        }
                        case 540: {
                            if (this.curChar != 'e') break;
                            this.jjAddStates(220, 221);
                            break;
                        }
                        case 542: {
                            if (this.curChar != ']' || kind <= 66) continue block644;
                            kind = 66;
                            break;
                        }
                        case 543: {
                            if (this.curChar != 'p') break;
                            this.jjstateSet[this.jjnewStateCnt++] = 540;
                            break;
                        }
                        case 544: {
                            if (this.curChar != 'a') break;
                            this.jjstateSet[this.jjnewStateCnt++] = 543;
                            break;
                        }
                        case 545: {
                            if (this.curChar != 'c') break;
                            this.jjstateSet[this.jjnewStateCnt++] = 544;
                            break;
                        }
                        case 546: {
                            if (this.curChar != 's') break;
                            this.jjstateSet[this.jjnewStateCnt++] = 545;
                            break;
                        }
                        case 547: {
                            if (this.curChar != 'n') break;
                            this.jjstateSet[this.jjnewStateCnt++] = 538;
                            break;
                        }
                        case 550: {
                            if (this.curChar != '@' || kind <= 67) continue block644;
                            kind = 67;
                            break;
                        }
                        case 551: {
                            if (this.curChar != 'l') break;
                            this.jjstateSet[this.jjnewStateCnt++] = 552;
                            break;
                        }
                        case 553: 
                        case 583: {
                            if (this.curChar != 't') break;
                            this.jjCheckNAdd(551);
                            break;
                        }
                        case 554: {
                            if (this.curChar != 'f') break;
                            this.jjstateSet[this.jjnewStateCnt++] = 553;
                            break;
                        }
                        case 556: {
                            if (this.curChar != 'l') break;
                            this.jjAddStates(299, 300);
                            break;
                        }
                        case 558: {
                            if (this.curChar != ']' || kind <= 70) continue block644;
                            kind = 70;
                            break;
                        }
                        case 559: 
                        case 586: {
                            if (this.curChar != 't') break;
                            this.jjCheckNAdd(556);
                            break;
                        }
                        case 560: {
                            if (this.curChar != 'f') break;
                            this.jjstateSet[this.jjnewStateCnt++] = 559;
                            break;
                        }
                        case 563: {
                            if ((0x7FFFFFE87FFFFFEL & l) == 0L) continue block644;
                            if (kind > 71) {
                                kind = 71;
                            }
                            this.jjstateSet[this.jjnewStateCnt++] = 563;
                            break;
                        }
                        case 565: {
                            if (this.curChar != '[') break;
                            this.jjAddStates(234, 298);
                            break;
                        }
                        case 584: {
                            if (this.curChar != 'f') break;
                            this.jjstateSet[this.jjnewStateCnt++] = 583;
                            break;
                        }
                        case 587: {
                            if (this.curChar != 'f') break;
                            this.jjstateSet[this.jjnewStateCnt++] = 586;
                            break;
                        }
                        case 590: {
                            if (this.curChar != '[') break;
                            this.jjAddStates(7, 8);
                            break;
                        }
                        case 594: {
                            if (this.curChar != '@') break;
                            this.jjCheckNAddStates(301, 304);
                            break;
                        }
                        case 595: 
                        case 596: {
                            if ((0x7FFFFFE87FFFFFFL & l) == 0L) break;
                            this.jjCheckNAddStates(222, 226);
                            break;
                        }
                        case 597: 
                        case 607: {
                            if (this.curChar != '\\') break;
                            this.jjCheckNAdd(598);
                            break;
                        }
                        case 600: 
                        case 601: {
                            if ((0x7FFFFFE87FFFFFFL & l) == 0L) break;
                            this.jjCheckNAddStates(229, 233);
                            break;
                        }
                        case 602: 
                        case 606: {
                            if (this.curChar != '\\') break;
                            this.jjCheckNAdd(603);
                            break;
                        }
                        case 605: {
                            if (this.curChar != ']' || kind <= 68) continue block644;
                            kind = 68;
                            break;
                        }
                    }
                } while (i != startsAt);
            } else {
                int hiByte = this.curChar >> 8;
                int i1 = hiByte >> 6;
                long l1 = 1L << (hiByte & 0x3F);
                int i2 = (this.curChar & 0xFF) >> 6;
                long l2 = 1L << (this.curChar & 0x3F);
                block645: do {
                    switch (this.jjstateSet[--i]) {
                        case 1: 
                        case 2: {
                            if (!FMParserTokenManager.jjCanMove_0(hiByte, i1, i2, l1, l2)) continue block645;
                            if (kind > 73) {
                                kind = 73;
                            }
                            this.jjCheckNAdd(1);
                            break;
                        }
                        case 595: 
                        case 596: {
                            if (!FMParserTokenManager.jjCanMove_1(hiByte, i1, i2, l1, l2)) break;
                            this.jjCheckNAddStates(222, 226);
                            break;
                        }
                        case 600: 
                        case 601: {
                            if (!FMParserTokenManager.jjCanMove_1(hiByte, i1, i2, l1, l2)) break;
                            this.jjCheckNAddStates(229, 233);
                            break;
                        }
                    }
                } while (i != startsAt);
            }
            if (kind != Integer.MAX_VALUE) {
                this.jjmatchedKind = kind;
                this.jjmatchedPos = curPos;
                kind = Integer.MAX_VALUE;
            }
            ++curPos;
            i = this.jjnewStateCnt;
            this.jjnewStateCnt = startsAt;
            if (i == (startsAt = 609 - this.jjnewStateCnt)) {
                return curPos;
            }
            try {
                this.curChar = this.input_stream.readChar();
            }
            catch (IOException e) {
                return curPos;
            }
        }
    }

    private final int jjStopStringLiteralDfa_2(int pos, long active0, long active1, long active2) {
        switch (pos) {
            case 0: {
                if ((active1 & 0x1000000000000000L) != 0L) {
                    return 2;
                }
                if ((active1 & 0x1800000L) != 0L || (active2 & 0x1CL) != 0L) {
                    this.jjmatchedKind = 133;
                    return 84;
                }
                if ((active1 & 0x10008000000000L) != 0L) {
                    return 42;
                }
                if ((active1 & 0x8000058000000L) != 0L) {
                    return 46;
                }
                return -1;
            }
            case 1: {
                if ((active2 & 0xCL) != 0L) {
                    return 84;
                }
                if ((active1 & 0x8000050000000L) != 0L) {
                    return 45;
                }
                if ((active1 & 0x1800000L) != 0L || (active2 & 0x10L) != 0L) {
                    if (this.jjmatchedPos != 1) {
                        this.jjmatchedKind = 133;
                        this.jjmatchedPos = 1;
                    }
                    return 84;
                }
                return -1;
            }
            case 2: {
                if ((active1 & 0x1800000L) != 0L || (active2 & 0x10L) != 0L) {
                    this.jjmatchedKind = 133;
                    this.jjmatchedPos = 2;
                    return 84;
                }
                return -1;
            }
            case 3: {
                if ((active1 & 0x800000L) != 0L || (active2 & 0x10L) != 0L) {
                    this.jjmatchedKind = 133;
                    this.jjmatchedPos = 3;
                    return 84;
                }
                if ((active1 & 0x1000000L) != 0L) {
                    return 84;
                }
                return -1;
            }
        }
        return -1;
    }

    private final int jjStartNfa_2(int pos, long active0, long active1, long active2) {
        return this.jjMoveNfa_2(this.jjStopStringLiteralDfa_2(pos, active0, active1, active2), pos + 1);
    }

    private final int jjStartNfaWithStates_2(int pos, int kind, int state) {
        this.jjmatchedKind = kind;
        this.jjmatchedPos = pos;
        try {
            this.curChar = this.input_stream.readChar();
        }
        catch (IOException e) {
            return pos + 1;
        }
        return this.jjMoveNfa_2(state, pos + 1);
    }

    private final int jjMoveStringLiteralDfa0_2() {
        switch (this.curChar) {
            case '!': {
                this.jjmatchedKind = 120;
                return this.jjMoveStringLiteralDfa1_2(0x800000000L, 0L);
            }
            case '%': {
                this.jjmatchedKind = 117;
                return this.jjMoveStringLiteralDfa1_2(0x10000000000L, 0L);
            }
            case '(': {
                return this.jjStopAtPos(0, 126);
            }
            case ')': {
                return this.jjStopAtPos(0, 127);
            }
            case '*': {
                this.jjmatchedKind = 113;
                return this.jjMoveStringLiteralDfa1_2(0x4004000000000L, 0L);
            }
            case '+': {
                this.jjmatchedKind = 111;
                return this.jjMoveStringLiteralDfa1_2(0x21000000000L, 0L);
            }
            case ',': {
                return this.jjStopAtPos(0, 121);
            }
            case '-': {
                this.jjmatchedKind = 112;
                return this.jjMoveStringLiteralDfa1_2(0x42000000000L, 0L);
            }
            case '.': {
                this.jjmatchedKind = 91;
                return this.jjMoveStringLiteralDfa1_2(0x8000050000000L, 0L);
            }
            case '/': {
                this.jjmatchedKind = 116;
                return this.jjMoveStringLiteralDfa1_2(0x8000000000L, 0L);
            }
            case ':': {
                return this.jjStopAtPos(0, 123);
            }
            case ';': {
                return this.jjStopAtPos(0, 122);
            }
            case '=': {
                this.jjmatchedKind = 97;
                return this.jjMoveStringLiteralDfa1_2(0x400000000L, 0L);
            }
            case '>': {
                return this.jjStopAtPos(0, 139);
            }
            case '?': {
                this.jjmatchedKind = 95;
                return this.jjMoveStringLiteralDfa1_2(0x100000000L, 0L);
            }
            case '[': {
                return this.jjStartNfaWithStates_2(0, 124, 2);
            }
            case ']': {
                return this.jjStopAtPos(0, 125);
            }
            case 'a': {
                return this.jjMoveStringLiteralDfa1_2(0L, 8L);
            }
            case 'f': {
                return this.jjMoveStringLiteralDfa1_2(0x800000L, 0L);
            }
            case 'i': {
                return this.jjMoveStringLiteralDfa1_2(0L, 4L);
            }
            case 't': {
                return this.jjMoveStringLiteralDfa1_2(0x1000000L, 0L);
            }
            case 'u': {
                return this.jjMoveStringLiteralDfa1_2(0L, 16L);
            }
            case '{': {
                return this.jjStopAtPos(0, 128);
            }
            case '}': {
                return this.jjStopAtPos(0, 129);
            }
        }
        return this.jjMoveNfa_2(1, 0);
    }

    private final int jjMoveStringLiteralDfa1_2(long active1, long active2) {
        try {
            this.curChar = this.input_stream.readChar();
        }
        catch (IOException e) {
            this.jjStopStringLiteralDfa_2(0, 0L, active1, active2);
            return 1;
        }
        switch (this.curChar) {
            case '*': {
                if ((active1 & 0x4000000000000L) == 0L) break;
                return this.jjStopAtPos(1, 114);
            }
            case '+': {
                if ((active1 & 0x20000000000L) == 0L) break;
                return this.jjStopAtPos(1, 105);
            }
            case '-': {
                if ((active1 & 0x40000000000L) == 0L) break;
                return this.jjStopAtPos(1, 106);
            }
            case '.': {
                if ((active1 & 0x10000000L) != 0L) {
                    this.jjmatchedKind = 92;
                    this.jjmatchedPos = 1;
                }
                return this.jjMoveStringLiteralDfa2_2(active1, 0x8000040000000L, active2, 0L);
            }
            case '=': {
                if ((active1 & 0x400000000L) != 0L) {
                    return this.jjStopAtPos(1, 98);
                }
                if ((active1 & 0x800000000L) != 0L) {
                    return this.jjStopAtPos(1, 99);
                }
                if ((active1 & 0x1000000000L) != 0L) {
                    return this.jjStopAtPos(1, 100);
                }
                if ((active1 & 0x2000000000L) != 0L) {
                    return this.jjStopAtPos(1, 101);
                }
                if ((active1 & 0x4000000000L) != 0L) {
                    return this.jjStopAtPos(1, 102);
                }
                if ((active1 & 0x8000000000L) != 0L) {
                    return this.jjStopAtPos(1, 103);
                }
                if ((active1 & 0x10000000000L) == 0L) break;
                return this.jjStopAtPos(1, 104);
            }
            case '?': {
                if ((active1 & 0x100000000L) == 0L) break;
                return this.jjStopAtPos(1, 96);
            }
            case 'a': {
                return this.jjMoveStringLiteralDfa2_2(active1, 0x800000L, active2, 0L);
            }
            case 'n': {
                if ((active2 & 4L) == 0L) break;
                return this.jjStartNfaWithStates_2(1, 130, 84);
            }
            case 'r': {
                return this.jjMoveStringLiteralDfa2_2(active1, 0x1000000L, active2, 0L);
            }
            case 's': {
                if ((active2 & 8L) != 0L) {
                    return this.jjStartNfaWithStates_2(1, 131, 84);
                }
                return this.jjMoveStringLiteralDfa2_2(active1, 0L, active2, 16L);
            }
        }
        return this.jjStartNfa_2(0, 0L, active1, active2);
    }

    private final int jjMoveStringLiteralDfa2_2(long old1, long active1, long old2, long active2) {
        if (((active1 &= old1) | (active2 &= old2)) == 0L) {
            return this.jjStartNfa_2(0, 0L, old1, old2);
        }
        try {
            this.curChar = this.input_stream.readChar();
        }
        catch (IOException e) {
            this.jjStopStringLiteralDfa_2(1, 0L, active1, active2);
            return 2;
        }
        switch (this.curChar) {
            case '*': {
                if ((active1 & 0x40000000L) == 0L) break;
                return this.jjStopAtPos(2, 94);
            }
            case '.': {
                if ((active1 & 0x8000000000000L) == 0L) break;
                return this.jjStopAtPos(2, 115);
            }
            case 'i': {
                return this.jjMoveStringLiteralDfa3_2(active1, 0L, active2, 16L);
            }
            case 'l': {
                return this.jjMoveStringLiteralDfa3_2(active1, 0x800000L, active2, 0L);
            }
            case 'u': {
                return this.jjMoveStringLiteralDfa3_2(active1, 0x1000000L, active2, 0L);
            }
        }
        return this.jjStartNfa_2(1, 0L, active1, active2);
    }

    private final int jjMoveStringLiteralDfa3_2(long old1, long active1, long old2, long active2) {
        if (((active1 &= old1) | (active2 &= old2)) == 0L) {
            return this.jjStartNfa_2(1, 0L, old1, old2);
        }
        try {
            this.curChar = this.input_stream.readChar();
        }
        catch (IOException e) {
            this.jjStopStringLiteralDfa_2(2, 0L, active1, active2);
            return 3;
        }
        switch (this.curChar) {
            case 'e': {
                if ((active1 & 0x1000000L) == 0L) break;
                return this.jjStartNfaWithStates_2(3, 88, 84);
            }
            case 'n': {
                return this.jjMoveStringLiteralDfa4_2(active1, 0L, active2, 16L);
            }
            case 's': {
                return this.jjMoveStringLiteralDfa4_2(active1, 0x800000L, active2, 0L);
            }
        }
        return this.jjStartNfa_2(2, 0L, active1, active2);
    }

    private final int jjMoveStringLiteralDfa4_2(long old1, long active1, long old2, long active2) {
        if (((active1 &= old1) | (active2 &= old2)) == 0L) {
            return this.jjStartNfa_2(2, 0L, old1, old2);
        }
        try {
            this.curChar = this.input_stream.readChar();
        }
        catch (IOException e) {
            this.jjStopStringLiteralDfa_2(3, 0L, active1, active2);
            return 4;
        }
        switch (this.curChar) {
            case 'e': {
                if ((active1 & 0x800000L) == 0L) break;
                return this.jjStartNfaWithStates_2(4, 87, 84);
            }
            case 'g': {
                if ((active2 & 0x10L) == 0L) break;
                return this.jjStartNfaWithStates_2(4, 132, 84);
            }
        }
        return this.jjStartNfa_2(3, 0L, active1, active2);
    }

    private final int jjMoveNfa_2(int startState, int curPos) {
        int startsAt = 0;
        this.jjnewStateCnt = 84;
        int i = 1;
        this.jjstateSet[0] = startState;
        int kind = Integer.MAX_VALUE;
        while (true) {
            long l;
            if (++this.jjround == Integer.MAX_VALUE) {
                this.ReInitRounds();
            }
            if (this.curChar < '@') {
                l = 1L << this.curChar;
                block107: do {
                    switch (this.jjstateSet[--i]) {
                        case 42: {
                            if (this.curChar != '>' || kind <= 140) continue block107;
                            kind = 140;
                            break;
                        }
                        case 1: {
                            if ((0x3FF000000000000L & l) != 0L) {
                                if (kind > 89) {
                                    kind = 89;
                                }
                                this.jjCheckNAddStates(305, 307);
                            } else if ((0x100002600L & l) != 0L) {
                                if (kind > 77) {
                                    kind = 77;
                                }
                                this.jjCheckNAdd(0);
                            } else if (this.curChar == '&') {
                                this.jjAddStates(308, 312);
                            } else if (this.curChar == '.') {
                                this.jjAddStates(313, 314);
                            } else if (this.curChar == '/') {
                                this.jjAddStates(315, 316);
                            } else if (this.curChar == '#') {
                                this.jjCheckNAdd(38);
                            } else if (this.curChar == '$') {
                                this.jjCheckNAdd(38);
                            } else if (this.curChar == '<') {
                                this.jjCheckNAdd(27);
                            } else if (this.curChar == '\'') {
                                this.jjCheckNAddStates(317, 319);
                            } else if (this.curChar == '\"') {
                                this.jjCheckNAddStates(320, 322);
                            }
                            if (this.curChar == '$') {
                                if (kind > 133) {
                                    kind = 133;
                                }
                                this.jjCheckNAddTwoStates(34, 35);
                            } else if (this.curChar == '&') {
                                if (kind > 118) {
                                    kind = 118;
                                }
                            } else if (this.curChar == '<' && kind > 107) {
                                kind = 107;
                            }
                            if (this.curChar != '<') break;
                            this.jjstateSet[this.jjnewStateCnt++] = 2;
                            break;
                        }
                        case 46: {
                            if (this.curChar == '.') {
                                this.jjstateSet[this.jjnewStateCnt++] = 47;
                            }
                            if (this.curChar != '.') break;
                            this.jjstateSet[this.jjnewStateCnt++] = 45;
                            break;
                        }
                        case 45: {
                            if (this.curChar == '!') {
                                if (kind <= 93) break;
                                kind = 93;
                                break;
                            }
                            if (this.curChar != '<' || kind <= 93) continue block107;
                            kind = 93;
                            break;
                        }
                        case 34: 
                        case 84: {
                            if ((0x3FF001000000000L & l) == 0L) continue block107;
                            if (kind > 133) {
                                kind = 133;
                            }
                            this.jjCheckNAddTwoStates(34, 35);
                            break;
                        }
                        case 0: {
                            if ((0x100002600L & l) == 0L) continue block107;
                            if (kind > 77) {
                                kind = 77;
                            }
                            this.jjCheckNAdd(0);
                            break;
                        }
                        case 2: {
                            if ((0xA00000000L & l) == 0L) break;
                            this.jjstateSet[this.jjnewStateCnt++] = 4;
                            break;
                        }
                        case 3: {
                            if (this.curChar != '-' || kind <= 78) continue block107;
                            kind = 78;
                            break;
                        }
                        case 4: {
                            if (this.curChar != '-') break;
                            this.jjstateSet[this.jjnewStateCnt++] = 3;
                            break;
                        }
                        case 5: {
                            if (this.curChar != '\"') break;
                            this.jjCheckNAddStates(320, 322);
                            break;
                        }
                        case 6: {
                            if ((0xFFFFFFFBFFFFFFFFL & l) == 0L) break;
                            this.jjCheckNAddStates(320, 322);
                            break;
                        }
                        case 9: {
                            if ((0x3FF000000000000L & l) == 0L) break;
                            this.jjCheckNAddStates(320, 322);
                            break;
                        }
                        case 10: {
                            if (this.curChar != '\"' || kind <= 85) continue block107;
                            kind = 85;
                            break;
                        }
                        case 11: {
                            if ((0x9400000000L & l) == 0L) break;
                            this.jjCheckNAddStates(320, 322);
                            break;
                        }
                        case 12: {
                            if (this.curChar != '\'') break;
                            this.jjCheckNAddStates(317, 319);
                            break;
                        }
                        case 13: {
                            if ((0xFFFFFF7FFFFFFFFFL & l) == 0L) break;
                            this.jjCheckNAddStates(317, 319);
                            break;
                        }
                        case 16: {
                            if ((0x3FF000000000000L & l) == 0L) break;
                            this.jjCheckNAddStates(317, 319);
                            break;
                        }
                        case 17: {
                            if (this.curChar != '\'' || kind <= 85) continue block107;
                            kind = 85;
                            break;
                        }
                        case 18: {
                            if ((0x9400000000L & l) == 0L) break;
                            this.jjCheckNAddStates(317, 319);
                            break;
                        }
                        case 20: {
                            if (this.curChar != '\"') break;
                            this.jjCheckNAddTwoStates(21, 22);
                            break;
                        }
                        case 21: {
                            if ((0xFFFFFFFBFFFFFFFFL & l) == 0L) break;
                            this.jjCheckNAddTwoStates(21, 22);
                            break;
                        }
                        case 22: {
                            if (this.curChar != '\"' || kind <= 86) continue block107;
                            kind = 86;
                            break;
                        }
                        case 23: {
                            if (this.curChar != '\'') break;
                            this.jjCheckNAddTwoStates(24, 25);
                            break;
                        }
                        case 24: {
                            if ((0xFFFFFF7FFFFFFFFFL & l) == 0L) break;
                            this.jjCheckNAddTwoStates(24, 25);
                            break;
                        }
                        case 25: {
                            if (this.curChar != '\'' || kind <= 86) continue block107;
                            kind = 86;
                            break;
                        }
                        case 26: {
                            if (this.curChar != '<' || kind <= 107) continue block107;
                            kind = 107;
                            break;
                        }
                        case 27: {
                            if (this.curChar != '=' || kind <= 108) continue block107;
                            kind = 108;
                            break;
                        }
                        case 28: {
                            if (this.curChar != '<') break;
                            this.jjCheckNAdd(27);
                            break;
                        }
                        case 29: 
                        case 81: {
                            if (this.curChar != '&' || kind <= 118) continue block107;
                            kind = 118;
                            break;
                        }
                        case 33: {
                            if (this.curChar != '$') continue block107;
                            if (kind > 133) {
                                kind = 133;
                            }
                            this.jjCheckNAddTwoStates(34, 35);
                            break;
                        }
                        case 36: {
                            if ((0x400600000000000L & l) == 0L) continue block107;
                            if (kind > 133) {
                                kind = 133;
                            }
                            this.jjCheckNAddTwoStates(34, 35);
                            break;
                        }
                        case 39: {
                            if (this.curChar != '$') break;
                            this.jjCheckNAdd(38);
                            break;
                        }
                        case 40: {
                            if (this.curChar != '#') break;
                            this.jjCheckNAdd(38);
                            break;
                        }
                        case 41: {
                            if (this.curChar != '/') break;
                            this.jjAddStates(315, 316);
                            break;
                        }
                        case 44: {
                            if (this.curChar != '.') break;
                            this.jjAddStates(313, 314);
                            break;
                        }
                        case 47: {
                            if (this.curChar != '!' || kind <= 93) continue block107;
                            kind = 93;
                            break;
                        }
                        case 48: {
                            if (this.curChar != '.') break;
                            this.jjstateSet[this.jjnewStateCnt++] = 47;
                            break;
                        }
                        case 49: {
                            if ((0x3FF000000000000L & l) == 0L) continue block107;
                            if (kind > 89) {
                                kind = 89;
                            }
                            this.jjCheckNAddStates(305, 307);
                            break;
                        }
                        case 50: {
                            if ((0x3FF000000000000L & l) == 0L) continue block107;
                            if (kind > 89) {
                                kind = 89;
                            }
                            this.jjCheckNAdd(50);
                            break;
                        }
                        case 51: {
                            if ((0x3FF000000000000L & l) == 0L) break;
                            this.jjCheckNAddTwoStates(51, 52);
                            break;
                        }
                        case 52: {
                            if (this.curChar != '.') break;
                            this.jjCheckNAdd(53);
                            break;
                        }
                        case 53: {
                            if ((0x3FF000000000000L & l) == 0L) continue block107;
                            if (kind > 90) {
                                kind = 90;
                            }
                            this.jjCheckNAdd(53);
                            break;
                        }
                        case 67: {
                            if (this.curChar != '&') break;
                            this.jjAddStates(308, 312);
                            break;
                        }
                        case 68: {
                            if (this.curChar != ';' || kind <= 107) continue block107;
                            kind = 107;
                            break;
                        }
                        case 71: {
                            if (this.curChar != ';') break;
                            this.jjCheckNAdd(27);
                            break;
                        }
                        case 74: {
                            if (this.curChar != ';' || kind <= 109) continue block107;
                            kind = 109;
                            break;
                        }
                        case 77: {
                            if (this.curChar != '=' || kind <= 110) continue block107;
                            kind = 110;
                            break;
                        }
                        case 78: {
                            if (this.curChar != ';') break;
                            this.jjstateSet[this.jjnewStateCnt++] = 77;
                            break;
                        }
                    }
                } while (i != startsAt);
            } else if (this.curChar < '\u0080') {
                l = 1L << (this.curChar & 0x3F);
                block108: do {
                    switch (this.jjstateSet[--i]) {
                        case 42: {
                            if (this.curChar != ']' || kind <= 140) continue block108;
                            kind = 140;
                            break;
                        }
                        case 1: {
                            if ((0x7FFFFFE87FFFFFFL & l) != 0L) {
                                if (kind > 133) {
                                    kind = 133;
                                }
                                this.jjCheckNAddTwoStates(34, 35);
                            } else if (this.curChar == '\\') {
                                this.jjAddStates(323, 326);
                            } else if (this.curChar == '|') {
                                this.jjstateSet[this.jjnewStateCnt++] = 31;
                            } else if (this.curChar == '[') {
                                this.jjstateSet[this.jjnewStateCnt++] = 2;
                            }
                            if (this.curChar == 'g') {
                                this.jjCheckNAddTwoStates(62, 83);
                                break;
                            }
                            if (this.curChar == 'l') {
                                this.jjCheckNAddTwoStates(55, 57);
                                break;
                            }
                            if (this.curChar == '\\') {
                                this.jjCheckNAdd(36);
                                break;
                            }
                            if (this.curChar == '|') {
                                if (kind <= 119) break;
                                kind = 119;
                                break;
                            }
                            if (this.curChar != 'r') break;
                            this.jjAddStates(327, 328);
                            break;
                        }
                        case 84: {
                            if ((0x7FFFFFE87FFFFFFL & l) != 0L) {
                                if (kind > 133) {
                                    kind = 133;
                                }
                                this.jjCheckNAddTwoStates(34, 35);
                                break;
                            }
                            if (this.curChar != '\\') break;
                            this.jjCheckNAdd(36);
                            break;
                        }
                        case 6: {
                            if ((0xFFFFFFFFEFFFFFFFL & l) == 0L) break;
                            this.jjCheckNAddStates(320, 322);
                            break;
                        }
                        case 7: {
                            if (this.curChar != '\\') break;
                            this.jjAddStates(329, 330);
                            break;
                        }
                        case 8: {
                            if (this.curChar != 'x') break;
                            this.jjstateSet[this.jjnewStateCnt++] = 9;
                            break;
                        }
                        case 9: {
                            if ((0x7E0000007EL & l) == 0L) break;
                            this.jjCheckNAddStates(320, 322);
                            break;
                        }
                        case 11: {
                            if ((0x81450C610000000L & l) == 0L) break;
                            this.jjCheckNAddStates(320, 322);
                            break;
                        }
                        case 13: {
                            if ((0xFFFFFFFFEFFFFFFFL & l) == 0L) break;
                            this.jjCheckNAddStates(317, 319);
                            break;
                        }
                        case 14: {
                            if (this.curChar != '\\') break;
                            this.jjAddStates(331, 332);
                            break;
                        }
                        case 15: {
                            if (this.curChar != 'x') break;
                            this.jjstateSet[this.jjnewStateCnt++] = 16;
                            break;
                        }
                        case 16: {
                            if ((0x7E0000007EL & l) == 0L) break;
                            this.jjCheckNAddStates(317, 319);
                            break;
                        }
                        case 18: {
                            if ((0x81450C610000000L & l) == 0L) break;
                            this.jjCheckNAddStates(317, 319);
                            break;
                        }
                        case 19: {
                            if (this.curChar != 'r') break;
                            this.jjAddStates(327, 328);
                            break;
                        }
                        case 21: {
                            this.jjAddStates(333, 334);
                            break;
                        }
                        case 24: {
                            this.jjAddStates(335, 336);
                            break;
                        }
                        case 30: 
                        case 31: {
                            if (this.curChar != '|' || kind <= 119) continue block108;
                            kind = 119;
                            break;
                        }
                        case 32: {
                            if (this.curChar != '|') break;
                            this.jjstateSet[this.jjnewStateCnt++] = 31;
                            break;
                        }
                        case 33: {
                            if ((0x7FFFFFE87FFFFFFL & l) == 0L) continue block108;
                            if (kind > 133) {
                                kind = 133;
                            }
                            this.jjCheckNAddTwoStates(34, 35);
                            break;
                        }
                        case 34: {
                            if ((0x7FFFFFE87FFFFFFL & l) == 0L) continue block108;
                            if (kind > 133) {
                                kind = 133;
                            }
                            this.jjCheckNAddTwoStates(34, 35);
                            break;
                        }
                        case 35: {
                            if (this.curChar != '\\') break;
                            this.jjCheckNAdd(36);
                            break;
                        }
                        case 37: {
                            if (this.curChar != '\\') break;
                            this.jjCheckNAdd(36);
                            break;
                        }
                        case 38: {
                            if (this.curChar != '{' || kind <= 134) continue block108;
                            kind = 134;
                            break;
                        }
                        case 54: {
                            if (this.curChar != 'l') break;
                            this.jjCheckNAddTwoStates(55, 57);
                            break;
                        }
                        case 55: {
                            if (this.curChar != 't' || kind <= 107) continue block108;
                            kind = 107;
                            break;
                        }
                        case 56: {
                            if (this.curChar != 'e' || kind <= 108) continue block108;
                            kind = 108;
                            break;
                        }
                        case 57: 
                        case 60: {
                            if (this.curChar != 't') break;
                            this.jjCheckNAdd(56);
                            break;
                        }
                        case 58: {
                            if (this.curChar != '\\') break;
                            this.jjAddStates(323, 326);
                            break;
                        }
                        case 59: {
                            if (this.curChar != 'l') break;
                            this.jjCheckNAdd(55);
                            break;
                        }
                        case 61: {
                            if (this.curChar != 'l') break;
                            this.jjstateSet[this.jjnewStateCnt++] = 60;
                            break;
                        }
                        case 62: {
                            if (this.curChar != 't' || kind <= 109) continue block108;
                            kind = 109;
                            break;
                        }
                        case 63: {
                            if (this.curChar != 'g') break;
                            this.jjCheckNAdd(62);
                            break;
                        }
                        case 64: {
                            if (this.curChar != 'e' || kind <= 110) continue block108;
                            kind = 110;
                            break;
                        }
                        case 65: 
                        case 83: {
                            if (this.curChar != 't') break;
                            this.jjCheckNAdd(64);
                            break;
                        }
                        case 66: {
                            if (this.curChar != 'g') break;
                            this.jjstateSet[this.jjnewStateCnt++] = 65;
                            break;
                        }
                        case 69: {
                            if (this.curChar != 't') break;
                            this.jjstateSet[this.jjnewStateCnt++] = 68;
                            break;
                        }
                        case 70: {
                            if (this.curChar != 'l') break;
                            this.jjstateSet[this.jjnewStateCnt++] = 69;
                            break;
                        }
                        case 72: {
                            if (this.curChar != 't') break;
                            this.jjstateSet[this.jjnewStateCnt++] = 71;
                            break;
                        }
                        case 73: {
                            if (this.curChar != 'l') break;
                            this.jjstateSet[this.jjnewStateCnt++] = 72;
                            break;
                        }
                        case 75: {
                            if (this.curChar != 't') break;
                            this.jjstateSet[this.jjnewStateCnt++] = 74;
                            break;
                        }
                        case 76: {
                            if (this.curChar != 'g') break;
                            this.jjstateSet[this.jjnewStateCnt++] = 75;
                            break;
                        }
                        case 79: {
                            if (this.curChar != 't') break;
                            this.jjstateSet[this.jjnewStateCnt++] = 78;
                            break;
                        }
                        case 80: {
                            if (this.curChar != 'g') break;
                            this.jjstateSet[this.jjnewStateCnt++] = 79;
                            break;
                        }
                        case 82: {
                            if (this.curChar != 'g') break;
                            this.jjCheckNAddTwoStates(62, 83);
                            break;
                        }
                    }
                } while (i != startsAt);
            } else {
                int hiByte = this.curChar >> 8;
                int i1 = hiByte >> 6;
                long l1 = 1L << (hiByte & 0x3F);
                int i2 = (this.curChar & 0xFF) >> 6;
                long l2 = 1L << (this.curChar & 0x3F);
                block109: do {
                    switch (this.jjstateSet[--i]) {
                        case 1: {
                            if (!FMParserTokenManager.jjCanMove_1(hiByte, i1, i2, l1, l2)) continue block109;
                            if (kind > 133) {
                                kind = 133;
                            }
                            this.jjCheckNAddTwoStates(34, 35);
                            break;
                        }
                        case 34: 
                        case 84: {
                            if (!FMParserTokenManager.jjCanMove_1(hiByte, i1, i2, l1, l2)) continue block109;
                            if (kind > 133) {
                                kind = 133;
                            }
                            this.jjCheckNAddTwoStates(34, 35);
                            break;
                        }
                        case 6: {
                            if (!FMParserTokenManager.jjCanMove_0(hiByte, i1, i2, l1, l2)) break;
                            this.jjAddStates(320, 322);
                            break;
                        }
                        case 13: {
                            if (!FMParserTokenManager.jjCanMove_0(hiByte, i1, i2, l1, l2)) break;
                            this.jjAddStates(317, 319);
                            break;
                        }
                        case 21: {
                            if (!FMParserTokenManager.jjCanMove_0(hiByte, i1, i2, l1, l2)) break;
                            this.jjAddStates(333, 334);
                            break;
                        }
                        case 24: {
                            if (!FMParserTokenManager.jjCanMove_0(hiByte, i1, i2, l1, l2)) break;
                            this.jjAddStates(335, 336);
                            break;
                        }
                    }
                } while (i != startsAt);
            }
            if (kind != Integer.MAX_VALUE) {
                this.jjmatchedKind = kind;
                this.jjmatchedPos = curPos;
                kind = Integer.MAX_VALUE;
            }
            ++curPos;
            i = this.jjnewStateCnt;
            this.jjnewStateCnt = startsAt;
            if (i == (startsAt = 84 - this.jjnewStateCnt)) {
                return curPos;
            }
            try {
                this.curChar = this.input_stream.readChar();
            }
            catch (IOException e) {
                return curPos;
            }
        }
    }

    private final int jjStopStringLiteralDfa_3(int pos, long active0, long active1, long active2) {
        switch (pos) {
            case 0: {
                if ((active1 & 0x1000000000000000L) != 0L) {
                    return 2;
                }
                if ((active1 & 0x1800000L) != 0L || (active2 & 0x1CL) != 0L) {
                    this.jjmatchedKind = 133;
                    return 81;
                }
                if ((active1 & 0x8000058000000L) != 0L) {
                    return 43;
                }
                return -1;
            }
            case 1: {
                if ((active2 & 0xCL) != 0L) {
                    return 81;
                }
                if ((active1 & 0x8000050000000L) != 0L) {
                    return 42;
                }
                if ((active1 & 0x1800000L) != 0L || (active2 & 0x10L) != 0L) {
                    if (this.jjmatchedPos != 1) {
                        this.jjmatchedKind = 133;
                        this.jjmatchedPos = 1;
                    }
                    return 81;
                }
                return -1;
            }
            case 2: {
                if ((active1 & 0x1800000L) != 0L || (active2 & 0x10L) != 0L) {
                    this.jjmatchedKind = 133;
                    this.jjmatchedPos = 2;
                    return 81;
                }
                return -1;
            }
            case 3: {
                if ((active1 & 0x800000L) != 0L || (active2 & 0x10L) != 0L) {
                    this.jjmatchedKind = 133;
                    this.jjmatchedPos = 3;
                    return 81;
                }
                if ((active1 & 0x1000000L) != 0L) {
                    return 81;
                }
                return -1;
            }
        }
        return -1;
    }

    private final int jjStartNfa_3(int pos, long active0, long active1, long active2) {
        return this.jjMoveNfa_3(this.jjStopStringLiteralDfa_3(pos, active0, active1, active2), pos + 1);
    }

    private final int jjStartNfaWithStates_3(int pos, int kind, int state) {
        this.jjmatchedKind = kind;
        this.jjmatchedPos = pos;
        try {
            this.curChar = this.input_stream.readChar();
        }
        catch (IOException e) {
            return pos + 1;
        }
        return this.jjMoveNfa_3(state, pos + 1);
    }

    private final int jjMoveStringLiteralDfa0_3() {
        switch (this.curChar) {
            case '!': {
                this.jjmatchedKind = 120;
                return this.jjMoveStringLiteralDfa1_3(0x800000000L, 0L);
            }
            case '%': {
                this.jjmatchedKind = 117;
                return this.jjMoveStringLiteralDfa1_3(0x10000000000L, 0L);
            }
            case '(': {
                return this.jjStopAtPos(0, 126);
            }
            case ')': {
                return this.jjStopAtPos(0, 127);
            }
            case '*': {
                this.jjmatchedKind = 113;
                return this.jjMoveStringLiteralDfa1_3(0x4004000000000L, 0L);
            }
            case '+': {
                this.jjmatchedKind = 111;
                return this.jjMoveStringLiteralDfa1_3(0x21000000000L, 0L);
            }
            case ',': {
                return this.jjStopAtPos(0, 121);
            }
            case '-': {
                this.jjmatchedKind = 112;
                return this.jjMoveStringLiteralDfa1_3(0x42000000000L, 0L);
            }
            case '.': {
                this.jjmatchedKind = 91;
                return this.jjMoveStringLiteralDfa1_3(0x8000050000000L, 0L);
            }
            case '/': {
                this.jjmatchedKind = 116;
                return this.jjMoveStringLiteralDfa1_3(0x8000000000L, 0L);
            }
            case ':': {
                return this.jjStopAtPos(0, 123);
            }
            case ';': {
                return this.jjStopAtPos(0, 122);
            }
            case '=': {
                this.jjmatchedKind = 97;
                return this.jjMoveStringLiteralDfa1_3(0x400000000L, 0L);
            }
            case '>': {
                this.jjmatchedKind = 141;
                return this.jjMoveStringLiteralDfa1_3(0L, 16384L);
            }
            case '?': {
                this.jjmatchedKind = 95;
                return this.jjMoveStringLiteralDfa1_3(0x100000000L, 0L);
            }
            case '[': {
                return this.jjStartNfaWithStates_3(0, 124, 2);
            }
            case ']': {
                return this.jjStopAtPos(0, 125);
            }
            case 'a': {
                return this.jjMoveStringLiteralDfa1_3(0L, 8L);
            }
            case 'f': {
                return this.jjMoveStringLiteralDfa1_3(0x800000L, 0L);
            }
            case 'i': {
                return this.jjMoveStringLiteralDfa1_3(0L, 4L);
            }
            case 't': {
                return this.jjMoveStringLiteralDfa1_3(0x1000000L, 0L);
            }
            case 'u': {
                return this.jjMoveStringLiteralDfa1_3(0L, 16L);
            }
            case '{': {
                return this.jjStopAtPos(0, 128);
            }
            case '}': {
                return this.jjStopAtPos(0, 129);
            }
        }
        return this.jjMoveNfa_3(1, 0);
    }

    private final int jjMoveStringLiteralDfa1_3(long active1, long active2) {
        try {
            this.curChar = this.input_stream.readChar();
        }
        catch (IOException e) {
            this.jjStopStringLiteralDfa_3(0, 0L, active1, active2);
            return 1;
        }
        switch (this.curChar) {
            case '*': {
                if ((active1 & 0x4000000000000L) == 0L) break;
                return this.jjStopAtPos(1, 114);
            }
            case '+': {
                if ((active1 & 0x20000000000L) == 0L) break;
                return this.jjStopAtPos(1, 105);
            }
            case '-': {
                if ((active1 & 0x40000000000L) == 0L) break;
                return this.jjStopAtPos(1, 106);
            }
            case '.': {
                if ((active1 & 0x10000000L) != 0L) {
                    this.jjmatchedKind = 92;
                    this.jjmatchedPos = 1;
                }
                return this.jjMoveStringLiteralDfa2_3(active1, 0x8000040000000L, active2, 0L);
            }
            case '=': {
                if ((active1 & 0x400000000L) != 0L) {
                    return this.jjStopAtPos(1, 98);
                }
                if ((active1 & 0x800000000L) != 0L) {
                    return this.jjStopAtPos(1, 99);
                }
                if ((active1 & 0x1000000000L) != 0L) {
                    return this.jjStopAtPos(1, 100);
                }
                if ((active1 & 0x2000000000L) != 0L) {
                    return this.jjStopAtPos(1, 101);
                }
                if ((active1 & 0x4000000000L) != 0L) {
                    return this.jjStopAtPos(1, 102);
                }
                if ((active1 & 0x8000000000L) != 0L) {
                    return this.jjStopAtPos(1, 103);
                }
                if ((active1 & 0x10000000000L) != 0L) {
                    return this.jjStopAtPos(1, 104);
                }
                if ((active2 & 0x4000L) == 0L) break;
                return this.jjStopAtPos(1, 142);
            }
            case '?': {
                if ((active1 & 0x100000000L) == 0L) break;
                return this.jjStopAtPos(1, 96);
            }
            case 'a': {
                return this.jjMoveStringLiteralDfa2_3(active1, 0x800000L, active2, 0L);
            }
            case 'n': {
                if ((active2 & 4L) == 0L) break;
                return this.jjStartNfaWithStates_3(1, 130, 81);
            }
            case 'r': {
                return this.jjMoveStringLiteralDfa2_3(active1, 0x1000000L, active2, 0L);
            }
            case 's': {
                if ((active2 & 8L) != 0L) {
                    return this.jjStartNfaWithStates_3(1, 131, 81);
                }
                return this.jjMoveStringLiteralDfa2_3(active1, 0L, active2, 16L);
            }
        }
        return this.jjStartNfa_3(0, 0L, active1, active2);
    }

    private final int jjMoveStringLiteralDfa2_3(long old1, long active1, long old2, long active2) {
        if (((active1 &= old1) | (active2 &= old2)) == 0L) {
            return this.jjStartNfa_3(0, 0L, old1, old2);
        }
        try {
            this.curChar = this.input_stream.readChar();
        }
        catch (IOException e) {
            this.jjStopStringLiteralDfa_3(1, 0L, active1, active2);
            return 2;
        }
        switch (this.curChar) {
            case '*': {
                if ((active1 & 0x40000000L) == 0L) break;
                return this.jjStopAtPos(2, 94);
            }
            case '.': {
                if ((active1 & 0x8000000000000L) == 0L) break;
                return this.jjStopAtPos(2, 115);
            }
            case 'i': {
                return this.jjMoveStringLiteralDfa3_3(active1, 0L, active2, 16L);
            }
            case 'l': {
                return this.jjMoveStringLiteralDfa3_3(active1, 0x800000L, active2, 0L);
            }
            case 'u': {
                return this.jjMoveStringLiteralDfa3_3(active1, 0x1000000L, active2, 0L);
            }
        }
        return this.jjStartNfa_3(1, 0L, active1, active2);
    }

    private final int jjMoveStringLiteralDfa3_3(long old1, long active1, long old2, long active2) {
        if (((active1 &= old1) | (active2 &= old2)) == 0L) {
            return this.jjStartNfa_3(1, 0L, old1, old2);
        }
        try {
            this.curChar = this.input_stream.readChar();
        }
        catch (IOException e) {
            this.jjStopStringLiteralDfa_3(2, 0L, active1, active2);
            return 3;
        }
        switch (this.curChar) {
            case 'e': {
                if ((active1 & 0x1000000L) == 0L) break;
                return this.jjStartNfaWithStates_3(3, 88, 81);
            }
            case 'n': {
                return this.jjMoveStringLiteralDfa4_3(active1, 0L, active2, 16L);
            }
            case 's': {
                return this.jjMoveStringLiteralDfa4_3(active1, 0x800000L, active2, 0L);
            }
        }
        return this.jjStartNfa_3(2, 0L, active1, active2);
    }

    private final int jjMoveStringLiteralDfa4_3(long old1, long active1, long old2, long active2) {
        if (((active1 &= old1) | (active2 &= old2)) == 0L) {
            return this.jjStartNfa_3(2, 0L, old1, old2);
        }
        try {
            this.curChar = this.input_stream.readChar();
        }
        catch (IOException e) {
            this.jjStopStringLiteralDfa_3(3, 0L, active1, active2);
            return 4;
        }
        switch (this.curChar) {
            case 'e': {
                if ((active1 & 0x800000L) == 0L) break;
                return this.jjStartNfaWithStates_3(4, 87, 81);
            }
            case 'g': {
                if ((active2 & 0x10L) == 0L) break;
                return this.jjStartNfaWithStates_3(4, 132, 81);
            }
        }
        return this.jjStartNfa_3(3, 0L, active1, active2);
    }

    private final int jjMoveNfa_3(int startState, int curPos) {
        int startsAt = 0;
        this.jjnewStateCnt = 81;
        int i = 1;
        this.jjstateSet[0] = startState;
        int kind = Integer.MAX_VALUE;
        while (true) {
            long l;
            if (++this.jjround == Integer.MAX_VALUE) {
                this.ReInitRounds();
            }
            if (this.curChar < '@') {
                l = 1L << this.curChar;
                block104: do {
                    switch (this.jjstateSet[--i]) {
                        case 43: {
                            if (this.curChar == '.') {
                                this.jjstateSet[this.jjnewStateCnt++] = 44;
                            }
                            if (this.curChar != '.') break;
                            this.jjstateSet[this.jjnewStateCnt++] = 42;
                            break;
                        }
                        case 42: {
                            if (this.curChar == '!') {
                                if (kind <= 93) break;
                                kind = 93;
                                break;
                            }
                            if (this.curChar != '<' || kind <= 93) continue block104;
                            kind = 93;
                            break;
                        }
                        case 1: {
                            if ((0x3FF000000000000L & l) != 0L) {
                                if (kind > 89) {
                                    kind = 89;
                                }
                                this.jjCheckNAddStates(337, 339);
                            } else if ((0x100002600L & l) != 0L) {
                                if (kind > 77) {
                                    kind = 77;
                                }
                                this.jjCheckNAdd(0);
                            } else if (this.curChar == '&') {
                                this.jjAddStates(340, 344);
                            } else if (this.curChar == '.') {
                                this.jjAddStates(345, 346);
                            } else if (this.curChar == '#') {
                                this.jjCheckNAdd(38);
                            } else if (this.curChar == '$') {
                                this.jjCheckNAdd(38);
                            } else if (this.curChar == '<') {
                                this.jjCheckNAdd(27);
                            } else if (this.curChar == '\'') {
                                this.jjCheckNAddStates(317, 319);
                            } else if (this.curChar == '\"') {
                                this.jjCheckNAddStates(320, 322);
                            }
                            if (this.curChar == '$') {
                                if (kind > 133) {
                                    kind = 133;
                                }
                                this.jjCheckNAddTwoStates(34, 35);
                            } else if (this.curChar == '&') {
                                if (kind > 118) {
                                    kind = 118;
                                }
                            } else if (this.curChar == '<' && kind > 107) {
                                kind = 107;
                            }
                            if (this.curChar != '<') break;
                            this.jjstateSet[this.jjnewStateCnt++] = 2;
                            break;
                        }
                        case 34: 
                        case 81: {
                            if ((0x3FF001000000000L & l) == 0L) continue block104;
                            if (kind > 133) {
                                kind = 133;
                            }
                            this.jjCheckNAddTwoStates(34, 35);
                            break;
                        }
                        case 0: {
                            if ((0x100002600L & l) == 0L) continue block104;
                            if (kind > 77) {
                                kind = 77;
                            }
                            this.jjCheckNAdd(0);
                            break;
                        }
                        case 2: {
                            if ((0xA00000000L & l) == 0L) break;
                            this.jjstateSet[this.jjnewStateCnt++] = 4;
                            break;
                        }
                        case 3: {
                            if (this.curChar != '-' || kind <= 78) continue block104;
                            kind = 78;
                            break;
                        }
                        case 4: {
                            if (this.curChar != '-') break;
                            this.jjstateSet[this.jjnewStateCnt++] = 3;
                            break;
                        }
                        case 5: {
                            if (this.curChar != '\"') break;
                            this.jjCheckNAddStates(320, 322);
                            break;
                        }
                        case 6: {
                            if ((0xFFFFFFFBFFFFFFFFL & l) == 0L) break;
                            this.jjCheckNAddStates(320, 322);
                            break;
                        }
                        case 9: {
                            if ((0x3FF000000000000L & l) == 0L) break;
                            this.jjCheckNAddStates(320, 322);
                            break;
                        }
                        case 10: {
                            if (this.curChar != '\"' || kind <= 85) continue block104;
                            kind = 85;
                            break;
                        }
                        case 11: {
                            if ((0x9400000000L & l) == 0L) break;
                            this.jjCheckNAddStates(320, 322);
                            break;
                        }
                        case 12: {
                            if (this.curChar != '\'') break;
                            this.jjCheckNAddStates(317, 319);
                            break;
                        }
                        case 13: {
                            if ((0xFFFFFF7FFFFFFFFFL & l) == 0L) break;
                            this.jjCheckNAddStates(317, 319);
                            break;
                        }
                        case 16: {
                            if ((0x3FF000000000000L & l) == 0L) break;
                            this.jjCheckNAddStates(317, 319);
                            break;
                        }
                        case 17: {
                            if (this.curChar != '\'' || kind <= 85) continue block104;
                            kind = 85;
                            break;
                        }
                        case 18: {
                            if ((0x9400000000L & l) == 0L) break;
                            this.jjCheckNAddStates(317, 319);
                            break;
                        }
                        case 20: {
                            if (this.curChar != '\"') break;
                            this.jjCheckNAddTwoStates(21, 22);
                            break;
                        }
                        case 21: {
                            if ((0xFFFFFFFBFFFFFFFFL & l) == 0L) break;
                            this.jjCheckNAddTwoStates(21, 22);
                            break;
                        }
                        case 22: {
                            if (this.curChar != '\"' || kind <= 86) continue block104;
                            kind = 86;
                            break;
                        }
                        case 23: {
                            if (this.curChar != '\'') break;
                            this.jjCheckNAddTwoStates(24, 25);
                            break;
                        }
                        case 24: {
                            if ((0xFFFFFF7FFFFFFFFFL & l) == 0L) break;
                            this.jjCheckNAddTwoStates(24, 25);
                            break;
                        }
                        case 25: {
                            if (this.curChar != '\'' || kind <= 86) continue block104;
                            kind = 86;
                            break;
                        }
                        case 26: {
                            if (this.curChar != '<' || kind <= 107) continue block104;
                            kind = 107;
                            break;
                        }
                        case 27: {
                            if (this.curChar != '=' || kind <= 108) continue block104;
                            kind = 108;
                            break;
                        }
                        case 28: {
                            if (this.curChar != '<') break;
                            this.jjCheckNAdd(27);
                            break;
                        }
                        case 29: 
                        case 78: {
                            if (this.curChar != '&' || kind <= 118) continue block104;
                            kind = 118;
                            break;
                        }
                        case 33: {
                            if (this.curChar != '$') continue block104;
                            if (kind > 133) {
                                kind = 133;
                            }
                            this.jjCheckNAddTwoStates(34, 35);
                            break;
                        }
                        case 36: {
                            if ((0x400600000000000L & l) == 0L) continue block104;
                            if (kind > 133) {
                                kind = 133;
                            }
                            this.jjCheckNAddTwoStates(34, 35);
                            break;
                        }
                        case 39: {
                            if (this.curChar != '$') break;
                            this.jjCheckNAdd(38);
                            break;
                        }
                        case 40: {
                            if (this.curChar != '#') break;
                            this.jjCheckNAdd(38);
                            break;
                        }
                        case 41: {
                            if (this.curChar != '.') break;
                            this.jjAddStates(345, 346);
                            break;
                        }
                        case 44: {
                            if (this.curChar != '!' || kind <= 93) continue block104;
                            kind = 93;
                            break;
                        }
                        case 45: {
                            if (this.curChar != '.') break;
                            this.jjstateSet[this.jjnewStateCnt++] = 44;
                            break;
                        }
                        case 46: {
                            if ((0x3FF000000000000L & l) == 0L) continue block104;
                            if (kind > 89) {
                                kind = 89;
                            }
                            this.jjCheckNAddStates(337, 339);
                            break;
                        }
                        case 47: {
                            if ((0x3FF000000000000L & l) == 0L) continue block104;
                            if (kind > 89) {
                                kind = 89;
                            }
                            this.jjCheckNAdd(47);
                            break;
                        }
                        case 48: {
                            if ((0x3FF000000000000L & l) == 0L) break;
                            this.jjCheckNAddTwoStates(48, 49);
                            break;
                        }
                        case 49: {
                            if (this.curChar != '.') break;
                            this.jjCheckNAdd(50);
                            break;
                        }
                        case 50: {
                            if ((0x3FF000000000000L & l) == 0L) continue block104;
                            if (kind > 90) {
                                kind = 90;
                            }
                            this.jjCheckNAdd(50);
                            break;
                        }
                        case 64: {
                            if (this.curChar != '&') break;
                            this.jjAddStates(340, 344);
                            break;
                        }
                        case 65: {
                            if (this.curChar != ';' || kind <= 107) continue block104;
                            kind = 107;
                            break;
                        }
                        case 68: {
                            if (this.curChar != ';') break;
                            this.jjCheckNAdd(27);
                            break;
                        }
                        case 71: {
                            if (this.curChar != ';' || kind <= 109) continue block104;
                            kind = 109;
                            break;
                        }
                        case 74: {
                            if (this.curChar != '=' || kind <= 110) continue block104;
                            kind = 110;
                            break;
                        }
                        case 75: {
                            if (this.curChar != ';') break;
                            this.jjstateSet[this.jjnewStateCnt++] = 74;
                            break;
                        }
                    }
                } while (i != startsAt);
            } else if (this.curChar < '\u0080') {
                l = 1L << (this.curChar & 0x3F);
                block105: do {
                    switch (this.jjstateSet[--i]) {
                        case 1: {
                            if ((0x7FFFFFE87FFFFFFL & l) != 0L) {
                                if (kind > 133) {
                                    kind = 133;
                                }
                                this.jjCheckNAddTwoStates(34, 35);
                            } else if (this.curChar == '\\') {
                                this.jjAddStates(347, 350);
                            } else if (this.curChar == '|') {
                                this.jjstateSet[this.jjnewStateCnt++] = 31;
                            } else if (this.curChar == '[') {
                                this.jjstateSet[this.jjnewStateCnt++] = 2;
                            }
                            if (this.curChar == 'g') {
                                this.jjCheckNAddTwoStates(59, 80);
                                break;
                            }
                            if (this.curChar == 'l') {
                                this.jjCheckNAddTwoStates(52, 54);
                                break;
                            }
                            if (this.curChar == '\\') {
                                this.jjCheckNAdd(36);
                                break;
                            }
                            if (this.curChar == '|') {
                                if (kind <= 119) break;
                                kind = 119;
                                break;
                            }
                            if (this.curChar != 'r') break;
                            this.jjAddStates(327, 328);
                            break;
                        }
                        case 81: {
                            if ((0x7FFFFFE87FFFFFFL & l) != 0L) {
                                if (kind > 133) {
                                    kind = 133;
                                }
                                this.jjCheckNAddTwoStates(34, 35);
                                break;
                            }
                            if (this.curChar != '\\') break;
                            this.jjCheckNAdd(36);
                            break;
                        }
                        case 6: {
                            if ((0xFFFFFFFFEFFFFFFFL & l) == 0L) break;
                            this.jjCheckNAddStates(320, 322);
                            break;
                        }
                        case 7: {
                            if (this.curChar != '\\') break;
                            this.jjAddStates(329, 330);
                            break;
                        }
                        case 8: {
                            if (this.curChar != 'x') break;
                            this.jjstateSet[this.jjnewStateCnt++] = 9;
                            break;
                        }
                        case 9: {
                            if ((0x7E0000007EL & l) == 0L) break;
                            this.jjCheckNAddStates(320, 322);
                            break;
                        }
                        case 11: {
                            if ((0x81450C610000000L & l) == 0L) break;
                            this.jjCheckNAddStates(320, 322);
                            break;
                        }
                        case 13: {
                            if ((0xFFFFFFFFEFFFFFFFL & l) == 0L) break;
                            this.jjCheckNAddStates(317, 319);
                            break;
                        }
                        case 14: {
                            if (this.curChar != '\\') break;
                            this.jjAddStates(331, 332);
                            break;
                        }
                        case 15: {
                            if (this.curChar != 'x') break;
                            this.jjstateSet[this.jjnewStateCnt++] = 16;
                            break;
                        }
                        case 16: {
                            if ((0x7E0000007EL & l) == 0L) break;
                            this.jjCheckNAddStates(317, 319);
                            break;
                        }
                        case 18: {
                            if ((0x81450C610000000L & l) == 0L) break;
                            this.jjCheckNAddStates(317, 319);
                            break;
                        }
                        case 19: {
                            if (this.curChar != 'r') break;
                            this.jjAddStates(327, 328);
                            break;
                        }
                        case 21: {
                            this.jjAddStates(333, 334);
                            break;
                        }
                        case 24: {
                            this.jjAddStates(335, 336);
                            break;
                        }
                        case 30: 
                        case 31: {
                            if (this.curChar != '|' || kind <= 119) continue block105;
                            kind = 119;
                            break;
                        }
                        case 32: {
                            if (this.curChar != '|') break;
                            this.jjstateSet[this.jjnewStateCnt++] = 31;
                            break;
                        }
                        case 33: {
                            if ((0x7FFFFFE87FFFFFFL & l) == 0L) continue block105;
                            if (kind > 133) {
                                kind = 133;
                            }
                            this.jjCheckNAddTwoStates(34, 35);
                            break;
                        }
                        case 34: {
                            if ((0x7FFFFFE87FFFFFFL & l) == 0L) continue block105;
                            if (kind > 133) {
                                kind = 133;
                            }
                            this.jjCheckNAddTwoStates(34, 35);
                            break;
                        }
                        case 35: {
                            if (this.curChar != '\\') break;
                            this.jjCheckNAdd(36);
                            break;
                        }
                        case 37: {
                            if (this.curChar != '\\') break;
                            this.jjCheckNAdd(36);
                            break;
                        }
                        case 38: {
                            if (this.curChar != '{' || kind <= 134) continue block105;
                            kind = 134;
                            break;
                        }
                        case 51: {
                            if (this.curChar != 'l') break;
                            this.jjCheckNAddTwoStates(52, 54);
                            break;
                        }
                        case 52: {
                            if (this.curChar != 't' || kind <= 107) continue block105;
                            kind = 107;
                            break;
                        }
                        case 53: {
                            if (this.curChar != 'e' || kind <= 108) continue block105;
                            kind = 108;
                            break;
                        }
                        case 54: 
                        case 57: {
                            if (this.curChar != 't') break;
                            this.jjCheckNAdd(53);
                            break;
                        }
                        case 55: {
                            if (this.curChar != '\\') break;
                            this.jjAddStates(347, 350);
                            break;
                        }
                        case 56: {
                            if (this.curChar != 'l') break;
                            this.jjCheckNAdd(52);
                            break;
                        }
                        case 58: {
                            if (this.curChar != 'l') break;
                            this.jjstateSet[this.jjnewStateCnt++] = 57;
                            break;
                        }
                        case 59: {
                            if (this.curChar != 't' || kind <= 109) continue block105;
                            kind = 109;
                            break;
                        }
                        case 60: {
                            if (this.curChar != 'g') break;
                            this.jjCheckNAdd(59);
                            break;
                        }
                        case 61: {
                            if (this.curChar != 'e' || kind <= 110) continue block105;
                            kind = 110;
                            break;
                        }
                        case 62: 
                        case 80: {
                            if (this.curChar != 't') break;
                            this.jjCheckNAdd(61);
                            break;
                        }
                        case 63: {
                            if (this.curChar != 'g') break;
                            this.jjstateSet[this.jjnewStateCnt++] = 62;
                            break;
                        }
                        case 66: {
                            if (this.curChar != 't') break;
                            this.jjstateSet[this.jjnewStateCnt++] = 65;
                            break;
                        }
                        case 67: {
                            if (this.curChar != 'l') break;
                            this.jjstateSet[this.jjnewStateCnt++] = 66;
                            break;
                        }
                        case 69: {
                            if (this.curChar != 't') break;
                            this.jjstateSet[this.jjnewStateCnt++] = 68;
                            break;
                        }
                        case 70: {
                            if (this.curChar != 'l') break;
                            this.jjstateSet[this.jjnewStateCnt++] = 69;
                            break;
                        }
                        case 72: {
                            if (this.curChar != 't') break;
                            this.jjstateSet[this.jjnewStateCnt++] = 71;
                            break;
                        }
                        case 73: {
                            if (this.curChar != 'g') break;
                            this.jjstateSet[this.jjnewStateCnt++] = 72;
                            break;
                        }
                        case 76: {
                            if (this.curChar != 't') break;
                            this.jjstateSet[this.jjnewStateCnt++] = 75;
                            break;
                        }
                        case 77: {
                            if (this.curChar != 'g') break;
                            this.jjstateSet[this.jjnewStateCnt++] = 76;
                            break;
                        }
                        case 79: {
                            if (this.curChar != 'g') break;
                            this.jjCheckNAddTwoStates(59, 80);
                            break;
                        }
                    }
                } while (i != startsAt);
            } else {
                int hiByte = this.curChar >> 8;
                int i1 = hiByte >> 6;
                long l1 = 1L << (hiByte & 0x3F);
                int i2 = (this.curChar & 0xFF) >> 6;
                long l2 = 1L << (this.curChar & 0x3F);
                block106: do {
                    switch (this.jjstateSet[--i]) {
                        case 1: {
                            if (!FMParserTokenManager.jjCanMove_1(hiByte, i1, i2, l1, l2)) continue block106;
                            if (kind > 133) {
                                kind = 133;
                            }
                            this.jjCheckNAddTwoStates(34, 35);
                            break;
                        }
                        case 34: 
                        case 81: {
                            if (!FMParserTokenManager.jjCanMove_1(hiByte, i1, i2, l1, l2)) continue block106;
                            if (kind > 133) {
                                kind = 133;
                            }
                            this.jjCheckNAddTwoStates(34, 35);
                            break;
                        }
                        case 6: {
                            if (!FMParserTokenManager.jjCanMove_0(hiByte, i1, i2, l1, l2)) break;
                            this.jjAddStates(320, 322);
                            break;
                        }
                        case 13: {
                            if (!FMParserTokenManager.jjCanMove_0(hiByte, i1, i2, l1, l2)) break;
                            this.jjAddStates(317, 319);
                            break;
                        }
                        case 21: {
                            if (!FMParserTokenManager.jjCanMove_0(hiByte, i1, i2, l1, l2)) break;
                            this.jjAddStates(333, 334);
                            break;
                        }
                        case 24: {
                            if (!FMParserTokenManager.jjCanMove_0(hiByte, i1, i2, l1, l2)) break;
                            this.jjAddStates(335, 336);
                            break;
                        }
                    }
                } while (i != startsAt);
            }
            if (kind != Integer.MAX_VALUE) {
                this.jjmatchedKind = kind;
                this.jjmatchedPos = curPos;
                kind = Integer.MAX_VALUE;
            }
            ++curPos;
            i = this.jjnewStateCnt;
            this.jjnewStateCnt = startsAt;
            if (i == (startsAt = 81 - this.jjnewStateCnt)) {
                return curPos;
            }
            try {
                this.curChar = this.input_stream.readChar();
            }
            catch (IOException e) {
                return curPos;
            }
        }
    }

    private final int jjStopStringLiteralDfa_5(int pos, long active0, long active1) {
        switch (pos) {
            default: 
        }
        return -1;
    }

    private final int jjStartNfa_5(int pos, long active0, long active1) {
        return this.jjMoveNfa_5(this.jjStopStringLiteralDfa_5(pos, active0, active1), pos + 1);
    }

    private final int jjStartNfaWithStates_5(int pos, int kind, int state) {
        this.jjmatchedKind = kind;
        this.jjmatchedPos = pos;
        try {
            this.curChar = this.input_stream.readChar();
        }
        catch (IOException e) {
            return pos + 1;
        }
        return this.jjMoveNfa_5(state, pos + 1);
    }

    private final int jjMoveStringLiteralDfa0_5() {
        switch (this.curChar) {
            case '-': {
                return this.jjStartNfaWithStates_5(0, 82, 3);
            }
        }
        return this.jjMoveNfa_5(1, 0);
    }

    private final int jjMoveNfa_5(int startState, int curPos) {
        int startsAt = 0;
        this.jjnewStateCnt = 6;
        int i = 1;
        this.jjstateSet[0] = startState;
        int kind = Integer.MAX_VALUE;
        while (true) {
            long l;
            if (++this.jjround == Integer.MAX_VALUE) {
                this.ReInitRounds();
            }
            if (this.curChar < '@') {
                l = 1L << this.curChar;
                block17: do {
                    switch (this.jjstateSet[--i]) {
                        case 3: {
                            if (this.curChar == '-') {
                                this.jjstateSet[this.jjnewStateCnt++] = 4;
                            }
                            if (this.curChar != '-') break;
                            this.jjstateSet[this.jjnewStateCnt++] = 2;
                            break;
                        }
                        case 1: {
                            if ((0xBFFFDFFFFFFFFFFFL & l) != 0L) {
                                if (kind > 79) {
                                    kind = 79;
                                }
                                this.jjCheckNAdd(0);
                                break;
                            }
                            if (this.curChar != '-') break;
                            this.jjAddStates(351, 352);
                            break;
                        }
                        case 0: {
                            if ((0xBFFFDFFFFFFFFFFFL & l) == 0L) continue block17;
                            kind = 79;
                            this.jjCheckNAdd(0);
                            break;
                        }
                        case 2: {
                            if (this.curChar != '>') break;
                            kind = 83;
                            break;
                        }
                        case 5: {
                            if (this.curChar != '-') break;
                            this.jjstateSet[this.jjnewStateCnt++] = 4;
                            break;
                        }
                    }
                } while (i != startsAt);
            } else if (this.curChar < '\u0080') {
                l = 1L << (this.curChar & 0x3F);
                block18: do {
                    switch (this.jjstateSet[--i]) {
                        case 0: 
                        case 1: {
                            if ((0xFFFFFFFFDFFFFFFFL & l) == 0L) continue block18;
                            kind = 79;
                            this.jjCheckNAdd(0);
                            break;
                        }
                        case 4: {
                            if (this.curChar != ']') break;
                            kind = 83;
                            break;
                        }
                    }
                } while (i != startsAt);
            } else {
                int hiByte = this.curChar >> 8;
                int i1 = hiByte >> 6;
                long l1 = 1L << (hiByte & 0x3F);
                int i2 = (this.curChar & 0xFF) >> 6;
                long l2 = 1L << (this.curChar & 0x3F);
                block19: do {
                    switch (this.jjstateSet[--i]) {
                        case 0: 
                        case 1: {
                            if (!FMParserTokenManager.jjCanMove_0(hiByte, i1, i2, l1, l2)) continue block19;
                            if (kind > 79) {
                                kind = 79;
                            }
                            this.jjCheckNAdd(0);
                            break;
                        }
                    }
                } while (i != startsAt);
            }
            if (kind != Integer.MAX_VALUE) {
                this.jjmatchedKind = kind;
                this.jjmatchedPos = curPos;
                kind = Integer.MAX_VALUE;
            }
            ++curPos;
            i = this.jjnewStateCnt;
            this.jjnewStateCnt = startsAt;
            if (i == (startsAt = 6 - this.jjnewStateCnt)) {
                return curPos;
            }
            try {
                this.curChar = this.input_stream.readChar();
            }
            catch (IOException e) {
                return curPos;
            }
        }
    }

    private final int jjStopStringLiteralDfa_6(int pos, long active0, long active1, long active2) {
        switch (pos) {
            case 0: {
                if ((active1 & 0x1800000L) != 0L || (active2 & 0x1CL) != 0L) {
                    this.jjmatchedKind = 133;
                    return 80;
                }
                if ((active1 & 0x10008000000000L) != 0L) {
                    return 38;
                }
                if ((active1 & 0x8000058000000L) != 0L) {
                    return 42;
                }
                return -1;
            }
            case 1: {
                if ((active2 & 0xCL) != 0L) {
                    return 80;
                }
                if ((active1 & 0x8000050000000L) != 0L) {
                    return 41;
                }
                if ((active1 & 0x1800000L) != 0L || (active2 & 0x10L) != 0L) {
                    if (this.jjmatchedPos != 1) {
                        this.jjmatchedKind = 133;
                        this.jjmatchedPos = 1;
                    }
                    return 80;
                }
                return -1;
            }
            case 2: {
                if ((active1 & 0x1800000L) != 0L || (active2 & 0x10L) != 0L) {
                    this.jjmatchedKind = 133;
                    this.jjmatchedPos = 2;
                    return 80;
                }
                return -1;
            }
            case 3: {
                if ((active1 & 0x800000L) != 0L || (active2 & 0x10L) != 0L) {
                    this.jjmatchedKind = 133;
                    this.jjmatchedPos = 3;
                    return 80;
                }
                if ((active1 & 0x1000000L) != 0L) {
                    return 80;
                }
                return -1;
            }
        }
        return -1;
    }

    private final int jjStartNfa_6(int pos, long active0, long active1, long active2) {
        return this.jjMoveNfa_6(this.jjStopStringLiteralDfa_6(pos, active0, active1, active2), pos + 1);
    }

    private final int jjStartNfaWithStates_6(int pos, int kind, int state) {
        this.jjmatchedKind = kind;
        this.jjmatchedPos = pos;
        try {
            this.curChar = this.input_stream.readChar();
        }
        catch (IOException e) {
            return pos + 1;
        }
        return this.jjMoveNfa_6(state, pos + 1);
    }

    private final int jjMoveStringLiteralDfa0_6() {
        switch (this.curChar) {
            case '!': {
                this.jjmatchedKind = 120;
                return this.jjMoveStringLiteralDfa1_6(0x800000000L, 0L);
            }
            case '%': {
                this.jjmatchedKind = 117;
                return this.jjMoveStringLiteralDfa1_6(0x10000000000L, 0L);
            }
            case '(': {
                return this.jjStopAtPos(0, 126);
            }
            case ')': {
                return this.jjStopAtPos(0, 127);
            }
            case '*': {
                this.jjmatchedKind = 113;
                return this.jjMoveStringLiteralDfa1_6(0x4004000000000L, 0L);
            }
            case '+': {
                this.jjmatchedKind = 111;
                return this.jjMoveStringLiteralDfa1_6(0x21000000000L, 0L);
            }
            case ',': {
                return this.jjStopAtPos(0, 121);
            }
            case '-': {
                this.jjmatchedKind = 112;
                return this.jjMoveStringLiteralDfa1_6(0x42000000000L, 0L);
            }
            case '.': {
                this.jjmatchedKind = 91;
                return this.jjMoveStringLiteralDfa1_6(0x8000050000000L, 0L);
            }
            case '/': {
                this.jjmatchedKind = 116;
                return this.jjMoveStringLiteralDfa1_6(0x8000000000L, 0L);
            }
            case ':': {
                return this.jjStopAtPos(0, 123);
            }
            case ';': {
                return this.jjStopAtPos(0, 122);
            }
            case '=': {
                this.jjmatchedKind = 97;
                return this.jjMoveStringLiteralDfa1_6(0x400000000L, 0L);
            }
            case '>': {
                return this.jjStopAtPos(0, 139);
            }
            case '?': {
                this.jjmatchedKind = 95;
                return this.jjMoveStringLiteralDfa1_6(0x100000000L, 0L);
            }
            case '[': {
                return this.jjStopAtPos(0, 124);
            }
            case ']': {
                return this.jjStopAtPos(0, 125);
            }
            case 'a': {
                return this.jjMoveStringLiteralDfa1_6(0L, 8L);
            }
            case 'f': {
                return this.jjMoveStringLiteralDfa1_6(0x800000L, 0L);
            }
            case 'i': {
                return this.jjMoveStringLiteralDfa1_6(0L, 4L);
            }
            case 't': {
                return this.jjMoveStringLiteralDfa1_6(0x1000000L, 0L);
            }
            case 'u': {
                return this.jjMoveStringLiteralDfa1_6(0L, 16L);
            }
            case '{': {
                return this.jjStopAtPos(0, 128);
            }
            case '}': {
                return this.jjStopAtPos(0, 129);
            }
        }
        return this.jjMoveNfa_6(0, 0);
    }

    private final int jjMoveStringLiteralDfa1_6(long active1, long active2) {
        try {
            this.curChar = this.input_stream.readChar();
        }
        catch (IOException e) {
            this.jjStopStringLiteralDfa_6(0, 0L, active1, active2);
            return 1;
        }
        switch (this.curChar) {
            case '*': {
                if ((active1 & 0x4000000000000L) == 0L) break;
                return this.jjStopAtPos(1, 114);
            }
            case '+': {
                if ((active1 & 0x20000000000L) == 0L) break;
                return this.jjStopAtPos(1, 105);
            }
            case '-': {
                if ((active1 & 0x40000000000L) == 0L) break;
                return this.jjStopAtPos(1, 106);
            }
            case '.': {
                if ((active1 & 0x10000000L) != 0L) {
                    this.jjmatchedKind = 92;
                    this.jjmatchedPos = 1;
                }
                return this.jjMoveStringLiteralDfa2_6(active1, 0x8000040000000L, active2, 0L);
            }
            case '=': {
                if ((active1 & 0x400000000L) != 0L) {
                    return this.jjStopAtPos(1, 98);
                }
                if ((active1 & 0x800000000L) != 0L) {
                    return this.jjStopAtPos(1, 99);
                }
                if ((active1 & 0x1000000000L) != 0L) {
                    return this.jjStopAtPos(1, 100);
                }
                if ((active1 & 0x2000000000L) != 0L) {
                    return this.jjStopAtPos(1, 101);
                }
                if ((active1 & 0x4000000000L) != 0L) {
                    return this.jjStopAtPos(1, 102);
                }
                if ((active1 & 0x8000000000L) != 0L) {
                    return this.jjStopAtPos(1, 103);
                }
                if ((active1 & 0x10000000000L) == 0L) break;
                return this.jjStopAtPos(1, 104);
            }
            case '?': {
                if ((active1 & 0x100000000L) == 0L) break;
                return this.jjStopAtPos(1, 96);
            }
            case 'a': {
                return this.jjMoveStringLiteralDfa2_6(active1, 0x800000L, active2, 0L);
            }
            case 'n': {
                if ((active2 & 4L) == 0L) break;
                return this.jjStartNfaWithStates_6(1, 130, 80);
            }
            case 'r': {
                return this.jjMoveStringLiteralDfa2_6(active1, 0x1000000L, active2, 0L);
            }
            case 's': {
                if ((active2 & 8L) != 0L) {
                    return this.jjStartNfaWithStates_6(1, 131, 80);
                }
                return this.jjMoveStringLiteralDfa2_6(active1, 0L, active2, 16L);
            }
        }
        return this.jjStartNfa_6(0, 0L, active1, active2);
    }

    private final int jjMoveStringLiteralDfa2_6(long old1, long active1, long old2, long active2) {
        if (((active1 &= old1) | (active2 &= old2)) == 0L) {
            return this.jjStartNfa_6(0, 0L, old1, old2);
        }
        try {
            this.curChar = this.input_stream.readChar();
        }
        catch (IOException e) {
            this.jjStopStringLiteralDfa_6(1, 0L, active1, active2);
            return 2;
        }
        switch (this.curChar) {
            case '*': {
                if ((active1 & 0x40000000L) == 0L) break;
                return this.jjStopAtPos(2, 94);
            }
            case '.': {
                if ((active1 & 0x8000000000000L) == 0L) break;
                return this.jjStopAtPos(2, 115);
            }
            case 'i': {
                return this.jjMoveStringLiteralDfa3_6(active1, 0L, active2, 16L);
            }
            case 'l': {
                return this.jjMoveStringLiteralDfa3_6(active1, 0x800000L, active2, 0L);
            }
            case 'u': {
                return this.jjMoveStringLiteralDfa3_6(active1, 0x1000000L, active2, 0L);
            }
        }
        return this.jjStartNfa_6(1, 0L, active1, active2);
    }

    private final int jjMoveStringLiteralDfa3_6(long old1, long active1, long old2, long active2) {
        if (((active1 &= old1) | (active2 &= old2)) == 0L) {
            return this.jjStartNfa_6(1, 0L, old1, old2);
        }
        try {
            this.curChar = this.input_stream.readChar();
        }
        catch (IOException e) {
            this.jjStopStringLiteralDfa_6(2, 0L, active1, active2);
            return 3;
        }
        switch (this.curChar) {
            case 'e': {
                if ((active1 & 0x1000000L) == 0L) break;
                return this.jjStartNfaWithStates_6(3, 88, 80);
            }
            case 'n': {
                return this.jjMoveStringLiteralDfa4_6(active1, 0L, active2, 16L);
            }
            case 's': {
                return this.jjMoveStringLiteralDfa4_6(active1, 0x800000L, active2, 0L);
            }
        }
        return this.jjStartNfa_6(2, 0L, active1, active2);
    }

    private final int jjMoveStringLiteralDfa4_6(long old1, long active1, long old2, long active2) {
        if (((active1 &= old1) | (active2 &= old2)) == 0L) {
            return this.jjStartNfa_6(2, 0L, old1, old2);
        }
        try {
            this.curChar = this.input_stream.readChar();
        }
        catch (IOException e) {
            this.jjStopStringLiteralDfa_6(3, 0L, active1, active2);
            return 4;
        }
        switch (this.curChar) {
            case 'e': {
                if ((active1 & 0x800000L) == 0L) break;
                return this.jjStartNfaWithStates_6(4, 87, 80);
            }
            case 'g': {
                if ((active2 & 0x10L) == 0L) break;
                return this.jjStartNfaWithStates_6(4, 132, 80);
            }
        }
        return this.jjStartNfa_6(3, 0L, active1, active2);
    }

    private final int jjMoveNfa_6(int startState, int curPos) {
        int startsAt = 0;
        this.jjnewStateCnt = 80;
        int i = 1;
        this.jjstateSet[0] = startState;
        int kind = Integer.MAX_VALUE;
        while (true) {
            long l;
            if (++this.jjround == Integer.MAX_VALUE) {
                this.ReInitRounds();
            }
            if (this.curChar < '@') {
                l = 1L << this.curChar;
                block103: do {
                    switch (this.jjstateSet[--i]) {
                        case 41: {
                            if (this.curChar == '!') {
                                if (kind <= 93) break;
                                kind = 93;
                                break;
                            }
                            if (this.curChar != '<' || kind <= 93) continue block103;
                            kind = 93;
                            break;
                        }
                        case 0: {
                            if ((0x3FF000000000000L & l) != 0L) {
                                if (kind > 89) {
                                    kind = 89;
                                }
                                this.jjCheckNAddStates(353, 355);
                            } else if ((0x100002600L & l) != 0L) {
                                if (kind > 143) {
                                    kind = 143;
                                }
                                this.jjCheckNAdd(36);
                            } else if (this.curChar == '&') {
                                this.jjAddStates(356, 360);
                            } else if (this.curChar == '.') {
                                this.jjAddStates(361, 362);
                            } else if (this.curChar == '/') {
                                this.jjAddStates(363, 364);
                            } else if (this.curChar == '#') {
                                this.jjCheckNAdd(33);
                            } else if (this.curChar == '$') {
                                this.jjCheckNAdd(33);
                            } else if (this.curChar == '<') {
                                this.jjCheckNAdd(22);
                            } else if (this.curChar == '\'') {
                                this.jjCheckNAddStates(365, 367);
                            } else if (this.curChar == '\"') {
                                this.jjCheckNAddStates(368, 370);
                            }
                            if (this.curChar == '$') {
                                if (kind > 133) {
                                    kind = 133;
                                }
                                this.jjCheckNAddTwoStates(29, 30);
                                break;
                            }
                            if (this.curChar == '&') {
                                if (kind <= 118) break;
                                kind = 118;
                                break;
                            }
                            if (this.curChar != '<' || kind <= 107) continue block103;
                            kind = 107;
                            break;
                        }
                        case 42: {
                            if (this.curChar == '.') {
                                this.jjstateSet[this.jjnewStateCnt++] = 43;
                            }
                            if (this.curChar != '.') break;
                            this.jjstateSet[this.jjnewStateCnt++] = 41;
                            break;
                        }
                        case 29: 
                        case 80: {
                            if ((0x3FF001000000000L & l) == 0L) continue block103;
                            if (kind > 133) {
                                kind = 133;
                            }
                            this.jjCheckNAddTwoStates(29, 30);
                            break;
                        }
                        case 38: {
                            if (this.curChar != '>' || kind <= 140) continue block103;
                            kind = 140;
                            break;
                        }
                        case 1: {
                            if ((0xFFFFFFFBFFFFFFFFL & l) == 0L) break;
                            this.jjCheckNAddStates(368, 370);
                            break;
                        }
                        case 4: {
                            if ((0x3FF000000000000L & l) == 0L) break;
                            this.jjCheckNAddStates(368, 370);
                            break;
                        }
                        case 5: {
                            if (this.curChar != '\"' || kind <= 85) continue block103;
                            kind = 85;
                            break;
                        }
                        case 6: {
                            if ((0x9400000000L & l) == 0L) break;
                            this.jjCheckNAddStates(368, 370);
                            break;
                        }
                        case 7: {
                            if (this.curChar != '\'') break;
                            this.jjCheckNAddStates(365, 367);
                            break;
                        }
                        case 8: {
                            if ((0xFFFFFF7FFFFFFFFFL & l) == 0L) break;
                            this.jjCheckNAddStates(365, 367);
                            break;
                        }
                        case 11: {
                            if ((0x3FF000000000000L & l) == 0L) break;
                            this.jjCheckNAddStates(365, 367);
                            break;
                        }
                        case 12: {
                            if (this.curChar != '\'' || kind <= 85) continue block103;
                            kind = 85;
                            break;
                        }
                        case 13: {
                            if ((0x9400000000L & l) == 0L) break;
                            this.jjCheckNAddStates(365, 367);
                            break;
                        }
                        case 15: {
                            if (this.curChar != '\"') break;
                            this.jjCheckNAddTwoStates(16, 17);
                            break;
                        }
                        case 16: {
                            if ((0xFFFFFFFBFFFFFFFFL & l) == 0L) break;
                            this.jjCheckNAddTwoStates(16, 17);
                            break;
                        }
                        case 17: {
                            if (this.curChar != '\"' || kind <= 86) continue block103;
                            kind = 86;
                            break;
                        }
                        case 18: {
                            if (this.curChar != '\'') break;
                            this.jjCheckNAddTwoStates(19, 20);
                            break;
                        }
                        case 19: {
                            if ((0xFFFFFF7FFFFFFFFFL & l) == 0L) break;
                            this.jjCheckNAddTwoStates(19, 20);
                            break;
                        }
                        case 20: {
                            if (this.curChar != '\'' || kind <= 86) continue block103;
                            kind = 86;
                            break;
                        }
                        case 21: {
                            if (this.curChar != '<' || kind <= 107) continue block103;
                            kind = 107;
                            break;
                        }
                        case 22: {
                            if (this.curChar != '=' || kind <= 108) continue block103;
                            kind = 108;
                            break;
                        }
                        case 23: {
                            if (this.curChar != '<') break;
                            this.jjCheckNAdd(22);
                            break;
                        }
                        case 24: 
                        case 77: {
                            if (this.curChar != '&' || kind <= 118) continue block103;
                            kind = 118;
                            break;
                        }
                        case 28: {
                            if (this.curChar != '$') continue block103;
                            if (kind > 133) {
                                kind = 133;
                            }
                            this.jjCheckNAddTwoStates(29, 30);
                            break;
                        }
                        case 31: {
                            if ((0x400600000000000L & l) == 0L) continue block103;
                            if (kind > 133) {
                                kind = 133;
                            }
                            this.jjCheckNAddTwoStates(29, 30);
                            break;
                        }
                        case 34: {
                            if (this.curChar != '$') break;
                            this.jjCheckNAdd(33);
                            break;
                        }
                        case 35: {
                            if (this.curChar != '#') break;
                            this.jjCheckNAdd(33);
                            break;
                        }
                        case 36: {
                            if ((0x100002600L & l) == 0L) continue block103;
                            if (kind > 143) {
                                kind = 143;
                            }
                            this.jjCheckNAdd(36);
                            break;
                        }
                        case 37: {
                            if (this.curChar != '/') break;
                            this.jjAddStates(363, 364);
                            break;
                        }
                        case 40: {
                            if (this.curChar != '.') break;
                            this.jjAddStates(361, 362);
                            break;
                        }
                        case 43: {
                            if (this.curChar != '!' || kind <= 93) continue block103;
                            kind = 93;
                            break;
                        }
                        case 44: {
                            if (this.curChar != '.') break;
                            this.jjstateSet[this.jjnewStateCnt++] = 43;
                            break;
                        }
                        case 45: {
                            if ((0x3FF000000000000L & l) == 0L) continue block103;
                            if (kind > 89) {
                                kind = 89;
                            }
                            this.jjCheckNAddStates(353, 355);
                            break;
                        }
                        case 46: {
                            if ((0x3FF000000000000L & l) == 0L) continue block103;
                            if (kind > 89) {
                                kind = 89;
                            }
                            this.jjCheckNAdd(46);
                            break;
                        }
                        case 47: {
                            if ((0x3FF000000000000L & l) == 0L) break;
                            this.jjCheckNAddTwoStates(47, 48);
                            break;
                        }
                        case 48: {
                            if (this.curChar != '.') break;
                            this.jjCheckNAdd(49);
                            break;
                        }
                        case 49: {
                            if ((0x3FF000000000000L & l) == 0L) continue block103;
                            if (kind > 90) {
                                kind = 90;
                            }
                            this.jjCheckNAdd(49);
                            break;
                        }
                        case 63: {
                            if (this.curChar != '&') break;
                            this.jjAddStates(356, 360);
                            break;
                        }
                        case 64: {
                            if (this.curChar != ';' || kind <= 107) continue block103;
                            kind = 107;
                            break;
                        }
                        case 67: {
                            if (this.curChar != ';') break;
                            this.jjCheckNAdd(22);
                            break;
                        }
                        case 70: {
                            if (this.curChar != ';' || kind <= 109) continue block103;
                            kind = 109;
                            break;
                        }
                        case 73: {
                            if (this.curChar != '=' || kind <= 110) continue block103;
                            kind = 110;
                            break;
                        }
                        case 74: {
                            if (this.curChar != ';') break;
                            this.jjstateSet[this.jjnewStateCnt++] = 73;
                            break;
                        }
                    }
                } while (i != startsAt);
            } else if (this.curChar < '\u0080') {
                l = 1L << (this.curChar & 0x3F);
                block104: do {
                    switch (this.jjstateSet[--i]) {
                        case 0: {
                            if ((0x7FFFFFE87FFFFFFL & l) != 0L) {
                                if (kind > 133) {
                                    kind = 133;
                                }
                                this.jjCheckNAddTwoStates(29, 30);
                            } else if (this.curChar == '\\') {
                                this.jjAddStates(371, 374);
                            } else if (this.curChar == '|') {
                                this.jjstateSet[this.jjnewStateCnt++] = 26;
                            }
                            if (this.curChar == 'g') {
                                this.jjCheckNAddTwoStates(58, 79);
                                break;
                            }
                            if (this.curChar == 'l') {
                                this.jjCheckNAddTwoStates(51, 53);
                                break;
                            }
                            if (this.curChar == '\\') {
                                this.jjCheckNAdd(31);
                                break;
                            }
                            if (this.curChar == '|') {
                                if (kind <= 119) break;
                                kind = 119;
                                break;
                            }
                            if (this.curChar != 'r') break;
                            this.jjAddStates(331, 332);
                            break;
                        }
                        case 80: {
                            if ((0x7FFFFFE87FFFFFFL & l) != 0L) {
                                if (kind > 133) {
                                    kind = 133;
                                }
                                this.jjCheckNAddTwoStates(29, 30);
                                break;
                            }
                            if (this.curChar != '\\') break;
                            this.jjCheckNAdd(31);
                            break;
                        }
                        case 38: {
                            if (this.curChar != ']' || kind <= 140) continue block104;
                            kind = 140;
                            break;
                        }
                        case 1: {
                            if ((0xFFFFFFFFEFFFFFFFL & l) == 0L) break;
                            this.jjCheckNAddStates(368, 370);
                            break;
                        }
                        case 2: {
                            if (this.curChar != '\\') break;
                            this.jjAddStates(375, 376);
                            break;
                        }
                        case 3: {
                            if (this.curChar != 'x') break;
                            this.jjstateSet[this.jjnewStateCnt++] = 4;
                            break;
                        }
                        case 4: {
                            if ((0x7E0000007EL & l) == 0L) break;
                            this.jjCheckNAddStates(368, 370);
                            break;
                        }
                        case 6: {
                            if ((0x81450C610000000L & l) == 0L) break;
                            this.jjCheckNAddStates(368, 370);
                            break;
                        }
                        case 8: {
                            if ((0xFFFFFFFFEFFFFFFFL & l) == 0L) break;
                            this.jjCheckNAddStates(365, 367);
                            break;
                        }
                        case 9: {
                            if (this.curChar != '\\') break;
                            this.jjAddStates(377, 378);
                            break;
                        }
                        case 10: {
                            if (this.curChar != 'x') break;
                            this.jjstateSet[this.jjnewStateCnt++] = 11;
                            break;
                        }
                        case 11: {
                            if ((0x7E0000007EL & l) == 0L) break;
                            this.jjCheckNAddStates(365, 367);
                            break;
                        }
                        case 13: {
                            if ((0x81450C610000000L & l) == 0L) break;
                            this.jjCheckNAddStates(365, 367);
                            break;
                        }
                        case 14: {
                            if (this.curChar != 'r') break;
                            this.jjAddStates(331, 332);
                            break;
                        }
                        case 16: {
                            this.jjAddStates(379, 380);
                            break;
                        }
                        case 19: {
                            this.jjAddStates(381, 382);
                            break;
                        }
                        case 25: 
                        case 26: {
                            if (this.curChar != '|' || kind <= 119) continue block104;
                            kind = 119;
                            break;
                        }
                        case 27: {
                            if (this.curChar != '|') break;
                            this.jjstateSet[this.jjnewStateCnt++] = 26;
                            break;
                        }
                        case 28: {
                            if ((0x7FFFFFE87FFFFFFL & l) == 0L) continue block104;
                            if (kind > 133) {
                                kind = 133;
                            }
                            this.jjCheckNAddTwoStates(29, 30);
                            break;
                        }
                        case 29: {
                            if ((0x7FFFFFE87FFFFFFL & l) == 0L) continue block104;
                            if (kind > 133) {
                                kind = 133;
                            }
                            this.jjCheckNAddTwoStates(29, 30);
                            break;
                        }
                        case 30: {
                            if (this.curChar != '\\') break;
                            this.jjCheckNAdd(31);
                            break;
                        }
                        case 32: {
                            if (this.curChar != '\\') break;
                            this.jjCheckNAdd(31);
                            break;
                        }
                        case 33: {
                            if (this.curChar != '{' || kind <= 134) continue block104;
                            kind = 134;
                            break;
                        }
                        case 50: {
                            if (this.curChar != 'l') break;
                            this.jjCheckNAddTwoStates(51, 53);
                            break;
                        }
                        case 51: {
                            if (this.curChar != 't' || kind <= 107) continue block104;
                            kind = 107;
                            break;
                        }
                        case 52: {
                            if (this.curChar != 'e' || kind <= 108) continue block104;
                            kind = 108;
                            break;
                        }
                        case 53: 
                        case 56: {
                            if (this.curChar != 't') break;
                            this.jjCheckNAdd(52);
                            break;
                        }
                        case 54: {
                            if (this.curChar != '\\') break;
                            this.jjAddStates(371, 374);
                            break;
                        }
                        case 55: {
                            if (this.curChar != 'l') break;
                            this.jjCheckNAdd(51);
                            break;
                        }
                        case 57: {
                            if (this.curChar != 'l') break;
                            this.jjstateSet[this.jjnewStateCnt++] = 56;
                            break;
                        }
                        case 58: {
                            if (this.curChar != 't' || kind <= 109) continue block104;
                            kind = 109;
                            break;
                        }
                        case 59: {
                            if (this.curChar != 'g') break;
                            this.jjCheckNAdd(58);
                            break;
                        }
                        case 60: {
                            if (this.curChar != 'e' || kind <= 110) continue block104;
                            kind = 110;
                            break;
                        }
                        case 61: 
                        case 79: {
                            if (this.curChar != 't') break;
                            this.jjCheckNAdd(60);
                            break;
                        }
                        case 62: {
                            if (this.curChar != 'g') break;
                            this.jjstateSet[this.jjnewStateCnt++] = 61;
                            break;
                        }
                        case 65: {
                            if (this.curChar != 't') break;
                            this.jjstateSet[this.jjnewStateCnt++] = 64;
                            break;
                        }
                        case 66: {
                            if (this.curChar != 'l') break;
                            this.jjstateSet[this.jjnewStateCnt++] = 65;
                            break;
                        }
                        case 68: {
                            if (this.curChar != 't') break;
                            this.jjstateSet[this.jjnewStateCnt++] = 67;
                            break;
                        }
                        case 69: {
                            if (this.curChar != 'l') break;
                            this.jjstateSet[this.jjnewStateCnt++] = 68;
                            break;
                        }
                        case 71: {
                            if (this.curChar != 't') break;
                            this.jjstateSet[this.jjnewStateCnt++] = 70;
                            break;
                        }
                        case 72: {
                            if (this.curChar != 'g') break;
                            this.jjstateSet[this.jjnewStateCnt++] = 71;
                            break;
                        }
                        case 75: {
                            if (this.curChar != 't') break;
                            this.jjstateSet[this.jjnewStateCnt++] = 74;
                            break;
                        }
                        case 76: {
                            if (this.curChar != 'g') break;
                            this.jjstateSet[this.jjnewStateCnt++] = 75;
                            break;
                        }
                        case 78: {
                            if (this.curChar != 'g') break;
                            this.jjCheckNAddTwoStates(58, 79);
                            break;
                        }
                    }
                } while (i != startsAt);
            } else {
                int hiByte = this.curChar >> 8;
                int i1 = hiByte >> 6;
                long l1 = 1L << (hiByte & 0x3F);
                int i2 = (this.curChar & 0xFF) >> 6;
                long l2 = 1L << (this.curChar & 0x3F);
                block105: do {
                    switch (this.jjstateSet[--i]) {
                        case 0: {
                            if (!FMParserTokenManager.jjCanMove_1(hiByte, i1, i2, l1, l2)) continue block105;
                            if (kind > 133) {
                                kind = 133;
                            }
                            this.jjCheckNAddTwoStates(29, 30);
                            break;
                        }
                        case 29: 
                        case 80: {
                            if (!FMParserTokenManager.jjCanMove_1(hiByte, i1, i2, l1, l2)) continue block105;
                            if (kind > 133) {
                                kind = 133;
                            }
                            this.jjCheckNAddTwoStates(29, 30);
                            break;
                        }
                        case 1: {
                            if (!FMParserTokenManager.jjCanMove_0(hiByte, i1, i2, l1, l2)) break;
                            this.jjAddStates(368, 370);
                            break;
                        }
                        case 8: {
                            if (!FMParserTokenManager.jjCanMove_0(hiByte, i1, i2, l1, l2)) break;
                            this.jjAddStates(365, 367);
                            break;
                        }
                        case 16: {
                            if (!FMParserTokenManager.jjCanMove_0(hiByte, i1, i2, l1, l2)) break;
                            this.jjAddStates(379, 380);
                            break;
                        }
                        case 19: {
                            if (!FMParserTokenManager.jjCanMove_0(hiByte, i1, i2, l1, l2)) break;
                            this.jjAddStates(381, 382);
                            break;
                        }
                    }
                } while (i != startsAt);
            }
            if (kind != Integer.MAX_VALUE) {
                this.jjmatchedKind = kind;
                this.jjmatchedPos = curPos;
                kind = Integer.MAX_VALUE;
            }
            ++curPos;
            i = this.jjnewStateCnt;
            this.jjnewStateCnt = startsAt;
            if (i == (startsAt = 80 - this.jjnewStateCnt)) {
                return curPos;
            }
            try {
                this.curChar = this.input_stream.readChar();
            }
            catch (IOException e) {
                return curPos;
            }
        }
    }

    private final int jjStopStringLiteralDfa_4(int pos, long active0, long active1, long active2) {
        switch (pos) {
            case 0: {
                if ((active1 & 0x1000000000000000L) != 0L) {
                    return 2;
                }
                if ((active1 & 0x1800000L) != 0L || (active2 & 0x1CL) != 0L) {
                    this.jjmatchedKind = 133;
                    return 86;
                }
                if ((active1 & 0x10008000000000L) != 0L) {
                    return 44;
                }
                if ((active1 & 0x8000058000000L) != 0L) {
                    return 48;
                }
                if ((active1 & 0x100000800000000L) != 0L) {
                    return 42;
                }
                return -1;
            }
            case 1: {
                if ((active2 & 0xCL) != 0L) {
                    return 86;
                }
                if ((active1 & 0x8000050000000L) != 0L) {
                    return 47;
                }
                if ((active1 & 0x1800000L) != 0L || (active2 & 0x10L) != 0L) {
                    if (this.jjmatchedPos != 1) {
                        this.jjmatchedKind = 133;
                        this.jjmatchedPos = 1;
                    }
                    return 86;
                }
                return -1;
            }
            case 2: {
                if ((active1 & 0x1800000L) != 0L || (active2 & 0x10L) != 0L) {
                    this.jjmatchedKind = 133;
                    this.jjmatchedPos = 2;
                    return 86;
                }
                return -1;
            }
            case 3: {
                if ((active1 & 0x800000L) != 0L || (active2 & 0x10L) != 0L) {
                    this.jjmatchedKind = 133;
                    this.jjmatchedPos = 3;
                    return 86;
                }
                if ((active1 & 0x1000000L) != 0L) {
                    return 86;
                }
                return -1;
            }
        }
        return -1;
    }

    private final int jjStartNfa_4(int pos, long active0, long active1, long active2) {
        return this.jjMoveNfa_4(this.jjStopStringLiteralDfa_4(pos, active0, active1, active2), pos + 1);
    }

    private final int jjStartNfaWithStates_4(int pos, int kind, int state) {
        this.jjmatchedKind = kind;
        this.jjmatchedPos = pos;
        try {
            this.curChar = this.input_stream.readChar();
        }
        catch (IOException e) {
            return pos + 1;
        }
        return this.jjMoveNfa_4(state, pos + 1);
    }

    private final int jjMoveStringLiteralDfa0_4() {
        switch (this.curChar) {
            case '!': {
                this.jjmatchedKind = 120;
                return this.jjMoveStringLiteralDfa1_4(0x800000000L, 0L);
            }
            case '%': {
                this.jjmatchedKind = 117;
                return this.jjMoveStringLiteralDfa1_4(0x10000000000L, 0L);
            }
            case '(': {
                return this.jjStopAtPos(0, 126);
            }
            case ')': {
                return this.jjStopAtPos(0, 127);
            }
            case '*': {
                this.jjmatchedKind = 113;
                return this.jjMoveStringLiteralDfa1_4(0x4004000000000L, 0L);
            }
            case '+': {
                this.jjmatchedKind = 111;
                return this.jjMoveStringLiteralDfa1_4(0x21000000000L, 0L);
            }
            case ',': {
                return this.jjStopAtPos(0, 121);
            }
            case '-': {
                this.jjmatchedKind = 112;
                return this.jjMoveStringLiteralDfa1_4(0x42000000000L, 0L);
            }
            case '.': {
                this.jjmatchedKind = 91;
                return this.jjMoveStringLiteralDfa1_4(0x8000050000000L, 0L);
            }
            case '/': {
                this.jjmatchedKind = 116;
                return this.jjMoveStringLiteralDfa1_4(0x8000000000L, 0L);
            }
            case ':': {
                return this.jjStopAtPos(0, 123);
            }
            case ';': {
                return this.jjStopAtPos(0, 122);
            }
            case '=': {
                this.jjmatchedKind = 97;
                return this.jjMoveStringLiteralDfa1_4(0x400000000L, 0L);
            }
            case '>': {
                return this.jjStopAtPos(0, 139);
            }
            case '?': {
                this.jjmatchedKind = 95;
                return this.jjMoveStringLiteralDfa1_4(0x100000000L, 0L);
            }
            case '[': {
                return this.jjStartNfaWithStates_4(0, 124, 2);
            }
            case ']': {
                return this.jjStopAtPos(0, 125);
            }
            case 'a': {
                return this.jjMoveStringLiteralDfa1_4(0L, 8L);
            }
            case 'f': {
                return this.jjMoveStringLiteralDfa1_4(0x800000L, 0L);
            }
            case 'i': {
                return this.jjMoveStringLiteralDfa1_4(0L, 4L);
            }
            case 't': {
                return this.jjMoveStringLiteralDfa1_4(0x1000000L, 0L);
            }
            case 'u': {
                return this.jjMoveStringLiteralDfa1_4(0L, 16L);
            }
            case '{': {
                return this.jjStopAtPos(0, 128);
            }
            case '}': {
                return this.jjStopAtPos(0, 129);
            }
        }
        return this.jjMoveNfa_4(1, 0);
    }

    private final int jjMoveStringLiteralDfa1_4(long active1, long active2) {
        try {
            this.curChar = this.input_stream.readChar();
        }
        catch (IOException e) {
            this.jjStopStringLiteralDfa_4(0, 0L, active1, active2);
            return 1;
        }
        switch (this.curChar) {
            case '*': {
                if ((active1 & 0x4000000000000L) == 0L) break;
                return this.jjStopAtPos(1, 114);
            }
            case '+': {
                if ((active1 & 0x20000000000L) == 0L) break;
                return this.jjStopAtPos(1, 105);
            }
            case '-': {
                if ((active1 & 0x40000000000L) == 0L) break;
                return this.jjStopAtPos(1, 106);
            }
            case '.': {
                if ((active1 & 0x10000000L) != 0L) {
                    this.jjmatchedKind = 92;
                    this.jjmatchedPos = 1;
                }
                return this.jjMoveStringLiteralDfa2_4(active1, 0x8000040000000L, active2, 0L);
            }
            case '=': {
                if ((active1 & 0x400000000L) != 0L) {
                    return this.jjStopAtPos(1, 98);
                }
                if ((active1 & 0x800000000L) != 0L) {
                    return this.jjStopAtPos(1, 99);
                }
                if ((active1 & 0x1000000000L) != 0L) {
                    return this.jjStopAtPos(1, 100);
                }
                if ((active1 & 0x2000000000L) != 0L) {
                    return this.jjStopAtPos(1, 101);
                }
                if ((active1 & 0x4000000000L) != 0L) {
                    return this.jjStopAtPos(1, 102);
                }
                if ((active1 & 0x8000000000L) != 0L) {
                    return this.jjStopAtPos(1, 103);
                }
                if ((active1 & 0x10000000000L) == 0L) break;
                return this.jjStopAtPos(1, 104);
            }
            case '?': {
                if ((active1 & 0x100000000L) == 0L) break;
                return this.jjStopAtPos(1, 96);
            }
            case 'a': {
                return this.jjMoveStringLiteralDfa2_4(active1, 0x800000L, active2, 0L);
            }
            case 'n': {
                if ((active2 & 4L) == 0L) break;
                return this.jjStartNfaWithStates_4(1, 130, 86);
            }
            case 'r': {
                return this.jjMoveStringLiteralDfa2_4(active1, 0x1000000L, active2, 0L);
            }
            case 's': {
                if ((active2 & 8L) != 0L) {
                    return this.jjStartNfaWithStates_4(1, 131, 86);
                }
                return this.jjMoveStringLiteralDfa2_4(active1, 0L, active2, 16L);
            }
        }
        return this.jjStartNfa_4(0, 0L, active1, active2);
    }

    private final int jjMoveStringLiteralDfa2_4(long old1, long active1, long old2, long active2) {
        if (((active1 &= old1) | (active2 &= old2)) == 0L) {
            return this.jjStartNfa_4(0, 0L, old1, old2);
        }
        try {
            this.curChar = this.input_stream.readChar();
        }
        catch (IOException e) {
            this.jjStopStringLiteralDfa_4(1, 0L, active1, active2);
            return 2;
        }
        switch (this.curChar) {
            case '*': {
                if ((active1 & 0x40000000L) == 0L) break;
                return this.jjStopAtPos(2, 94);
            }
            case '.': {
                if ((active1 & 0x8000000000000L) == 0L) break;
                return this.jjStopAtPos(2, 115);
            }
            case 'i': {
                return this.jjMoveStringLiteralDfa3_4(active1, 0L, active2, 16L);
            }
            case 'l': {
                return this.jjMoveStringLiteralDfa3_4(active1, 0x800000L, active2, 0L);
            }
            case 'u': {
                return this.jjMoveStringLiteralDfa3_4(active1, 0x1000000L, active2, 0L);
            }
        }
        return this.jjStartNfa_4(1, 0L, active1, active2);
    }

    private final int jjMoveStringLiteralDfa3_4(long old1, long active1, long old2, long active2) {
        if (((active1 &= old1) | (active2 &= old2)) == 0L) {
            return this.jjStartNfa_4(1, 0L, old1, old2);
        }
        try {
            this.curChar = this.input_stream.readChar();
        }
        catch (IOException e) {
            this.jjStopStringLiteralDfa_4(2, 0L, active1, active2);
            return 3;
        }
        switch (this.curChar) {
            case 'e': {
                if ((active1 & 0x1000000L) == 0L) break;
                return this.jjStartNfaWithStates_4(3, 88, 86);
            }
            case 'n': {
                return this.jjMoveStringLiteralDfa4_4(active1, 0L, active2, 16L);
            }
            case 's': {
                return this.jjMoveStringLiteralDfa4_4(active1, 0x800000L, active2, 0L);
            }
        }
        return this.jjStartNfa_4(2, 0L, active1, active2);
    }

    private final int jjMoveStringLiteralDfa4_4(long old1, long active1, long old2, long active2) {
        if (((active1 &= old1) | (active2 &= old2)) == 0L) {
            return this.jjStartNfa_4(2, 0L, old1, old2);
        }
        try {
            this.curChar = this.input_stream.readChar();
        }
        catch (IOException e) {
            this.jjStopStringLiteralDfa_4(3, 0L, active1, active2);
            return 4;
        }
        switch (this.curChar) {
            case 'e': {
                if ((active1 & 0x800000L) == 0L) break;
                return this.jjStartNfaWithStates_4(4, 87, 86);
            }
            case 'g': {
                if ((active2 & 0x10L) == 0L) break;
                return this.jjStartNfaWithStates_4(4, 132, 86);
            }
        }
        return this.jjStartNfa_4(3, 0L, active1, active2);
    }

    private final int jjMoveNfa_4(int startState, int curPos) {
        int startsAt = 0;
        this.jjnewStateCnt = 86;
        int i = 1;
        this.jjstateSet[0] = startState;
        int kind = Integer.MAX_VALUE;
        while (true) {
            long l;
            if (++this.jjround == Integer.MAX_VALUE) {
                this.ReInitRounds();
            }
            if (this.curChar < '@') {
                l = 1L << this.curChar;
                block109: do {
                    switch (this.jjstateSet[--i]) {
                        case 47: {
                            if (this.curChar == '!') {
                                if (kind <= 93) break;
                                kind = 93;
                                break;
                            }
                            if (this.curChar != '<' || kind <= 93) continue block109;
                            kind = 93;
                            break;
                        }
                        case 1: {
                            if ((0x3FF000000000000L & l) != 0L) {
                                if (kind > 89) {
                                    kind = 89;
                                }
                                this.jjCheckNAddStates(383, 385);
                            } else if ((0x100002600L & l) != 0L) {
                                if (kind > 77) {
                                    kind = 77;
                                }
                                this.jjCheckNAdd(0);
                            } else if (this.curChar == '&') {
                                this.jjAddStates(386, 390);
                            } else if (this.curChar == '.') {
                                this.jjAddStates(391, 392);
                            } else if (this.curChar == '/') {
                                this.jjAddStates(393, 394);
                            } else if (this.curChar == '!') {
                                this.jjCheckNAdd(42);
                            } else if (this.curChar == '#') {
                                this.jjCheckNAdd(38);
                            } else if (this.curChar == '$') {
                                this.jjCheckNAdd(38);
                            } else if (this.curChar == '<') {
                                this.jjCheckNAdd(27);
                            } else if (this.curChar == '\'') {
                                this.jjCheckNAddStates(317, 319);
                            } else if (this.curChar == '\"') {
                                this.jjCheckNAddStates(320, 322);
                            }
                            if (this.curChar == '$') {
                                if (kind > 133) {
                                    kind = 133;
                                }
                                this.jjCheckNAddTwoStates(34, 35);
                            } else if (this.curChar == '&') {
                                if (kind > 118) {
                                    kind = 118;
                                }
                            } else if (this.curChar == '<' && kind > 107) {
                                kind = 107;
                            }
                            if (this.curChar != '<') break;
                            this.jjstateSet[this.jjnewStateCnt++] = 2;
                            break;
                        }
                        case 48: {
                            if (this.curChar == '.') {
                                this.jjstateSet[this.jjnewStateCnt++] = 49;
                            }
                            if (this.curChar != '.') break;
                            this.jjstateSet[this.jjnewStateCnt++] = 47;
                            break;
                        }
                        case 44: {
                            if (this.curChar != '>' || kind <= 140) continue block109;
                            kind = 140;
                            break;
                        }
                        case 34: 
                        case 86: {
                            if ((0x3FF001000000000L & l) == 0L) continue block109;
                            if (kind > 133) {
                                kind = 133;
                            }
                            this.jjCheckNAddTwoStates(34, 35);
                            break;
                        }
                        case 0: {
                            if ((0x100002600L & l) == 0L) continue block109;
                            if (kind > 77) {
                                kind = 77;
                            }
                            this.jjCheckNAdd(0);
                            break;
                        }
                        case 2: {
                            if ((0xA00000000L & l) == 0L) break;
                            this.jjstateSet[this.jjnewStateCnt++] = 4;
                            break;
                        }
                        case 3: {
                            if (this.curChar != '-' || kind <= 78) continue block109;
                            kind = 78;
                            break;
                        }
                        case 4: {
                            if (this.curChar != '-') break;
                            this.jjstateSet[this.jjnewStateCnt++] = 3;
                            break;
                        }
                        case 5: {
                            if (this.curChar != '\"') break;
                            this.jjCheckNAddStates(320, 322);
                            break;
                        }
                        case 6: {
                            if ((0xFFFFFFFBFFFFFFFFL & l) == 0L) break;
                            this.jjCheckNAddStates(320, 322);
                            break;
                        }
                        case 9: {
                            if ((0x3FF000000000000L & l) == 0L) break;
                            this.jjCheckNAddStates(320, 322);
                            break;
                        }
                        case 10: {
                            if (this.curChar != '\"' || kind <= 85) continue block109;
                            kind = 85;
                            break;
                        }
                        case 11: {
                            if ((0x9400000000L & l) == 0L) break;
                            this.jjCheckNAddStates(320, 322);
                            break;
                        }
                        case 12: {
                            if (this.curChar != '\'') break;
                            this.jjCheckNAddStates(317, 319);
                            break;
                        }
                        case 13: {
                            if ((0xFFFFFF7FFFFFFFFFL & l) == 0L) break;
                            this.jjCheckNAddStates(317, 319);
                            break;
                        }
                        case 16: {
                            if ((0x3FF000000000000L & l) == 0L) break;
                            this.jjCheckNAddStates(317, 319);
                            break;
                        }
                        case 17: {
                            if (this.curChar != '\'' || kind <= 85) continue block109;
                            kind = 85;
                            break;
                        }
                        case 18: {
                            if ((0x9400000000L & l) == 0L) break;
                            this.jjCheckNAddStates(317, 319);
                            break;
                        }
                        case 20: {
                            if (this.curChar != '\"') break;
                            this.jjCheckNAddTwoStates(21, 22);
                            break;
                        }
                        case 21: {
                            if ((0xFFFFFFFBFFFFFFFFL & l) == 0L) break;
                            this.jjCheckNAddTwoStates(21, 22);
                            break;
                        }
                        case 22: {
                            if (this.curChar != '\"' || kind <= 86) continue block109;
                            kind = 86;
                            break;
                        }
                        case 23: {
                            if (this.curChar != '\'') break;
                            this.jjCheckNAddTwoStates(24, 25);
                            break;
                        }
                        case 24: {
                            if ((0xFFFFFF7FFFFFFFFFL & l) == 0L) break;
                            this.jjCheckNAddTwoStates(24, 25);
                            break;
                        }
                        case 25: {
                            if (this.curChar != '\'' || kind <= 86) continue block109;
                            kind = 86;
                            break;
                        }
                        case 26: {
                            if (this.curChar != '<' || kind <= 107) continue block109;
                            kind = 107;
                            break;
                        }
                        case 27: {
                            if (this.curChar != '=' || kind <= 108) continue block109;
                            kind = 108;
                            break;
                        }
                        case 28: {
                            if (this.curChar != '<') break;
                            this.jjCheckNAdd(27);
                            break;
                        }
                        case 29: 
                        case 83: {
                            if (this.curChar != '&' || kind <= 118) continue block109;
                            kind = 118;
                            break;
                        }
                        case 33: {
                            if (this.curChar != '$') continue block109;
                            if (kind > 133) {
                                kind = 133;
                            }
                            this.jjCheckNAddTwoStates(34, 35);
                            break;
                        }
                        case 36: {
                            if ((0x400600000000000L & l) == 0L) continue block109;
                            if (kind > 133) {
                                kind = 133;
                            }
                            this.jjCheckNAddTwoStates(34, 35);
                            break;
                        }
                        case 39: {
                            if (this.curChar != '$') break;
                            this.jjCheckNAdd(38);
                            break;
                        }
                        case 40: {
                            if (this.curChar != '#') break;
                            this.jjCheckNAdd(38);
                            break;
                        }
                        case 41: {
                            if (this.curChar != '!') break;
                            this.jjCheckNAdd(42);
                            break;
                        }
                        case 42: {
                            if ((0x100002600L & l) == 0L) continue block109;
                            if (kind > 144) {
                                kind = 144;
                            }
                            this.jjCheckNAdd(42);
                            break;
                        }
                        case 43: {
                            if (this.curChar != '/') break;
                            this.jjAddStates(393, 394);
                            break;
                        }
                        case 46: {
                            if (this.curChar != '.') break;
                            this.jjAddStates(391, 392);
                            break;
                        }
                        case 49: {
                            if (this.curChar != '!' || kind <= 93) continue block109;
                            kind = 93;
                            break;
                        }
                        case 50: {
                            if (this.curChar != '.') break;
                            this.jjstateSet[this.jjnewStateCnt++] = 49;
                            break;
                        }
                        case 51: {
                            if ((0x3FF000000000000L & l) == 0L) continue block109;
                            if (kind > 89) {
                                kind = 89;
                            }
                            this.jjCheckNAddStates(383, 385);
                            break;
                        }
                        case 52: {
                            if ((0x3FF000000000000L & l) == 0L) continue block109;
                            if (kind > 89) {
                                kind = 89;
                            }
                            this.jjCheckNAdd(52);
                            break;
                        }
                        case 53: {
                            if ((0x3FF000000000000L & l) == 0L) break;
                            this.jjCheckNAddTwoStates(53, 54);
                            break;
                        }
                        case 54: {
                            if (this.curChar != '.') break;
                            this.jjCheckNAdd(55);
                            break;
                        }
                        case 55: {
                            if ((0x3FF000000000000L & l) == 0L) continue block109;
                            if (kind > 90) {
                                kind = 90;
                            }
                            this.jjCheckNAdd(55);
                            break;
                        }
                        case 69: {
                            if (this.curChar != '&') break;
                            this.jjAddStates(386, 390);
                            break;
                        }
                        case 70: {
                            if (this.curChar != ';' || kind <= 107) continue block109;
                            kind = 107;
                            break;
                        }
                        case 73: {
                            if (this.curChar != ';') break;
                            this.jjCheckNAdd(27);
                            break;
                        }
                        case 76: {
                            if (this.curChar != ';' || kind <= 109) continue block109;
                            kind = 109;
                            break;
                        }
                        case 79: {
                            if (this.curChar != '=' || kind <= 110) continue block109;
                            kind = 110;
                            break;
                        }
                        case 80: {
                            if (this.curChar != ';') break;
                            this.jjstateSet[this.jjnewStateCnt++] = 79;
                            break;
                        }
                    }
                } while (i != startsAt);
            } else if (this.curChar < '\u0080') {
                l = 1L << (this.curChar & 0x3F);
                block110: do {
                    switch (this.jjstateSet[--i]) {
                        case 1: {
                            if ((0x7FFFFFE87FFFFFFL & l) != 0L) {
                                if (kind > 133) {
                                    kind = 133;
                                }
                                this.jjCheckNAddTwoStates(34, 35);
                            } else if (this.curChar == '\\') {
                                this.jjAddStates(395, 398);
                            } else if (this.curChar == '|') {
                                this.jjstateSet[this.jjnewStateCnt++] = 31;
                            } else if (this.curChar == '[') {
                                this.jjstateSet[this.jjnewStateCnt++] = 2;
                            }
                            if (this.curChar == 'g') {
                                this.jjCheckNAddTwoStates(64, 85);
                                break;
                            }
                            if (this.curChar == 'l') {
                                this.jjCheckNAddTwoStates(57, 59);
                                break;
                            }
                            if (this.curChar == '\\') {
                                this.jjCheckNAdd(36);
                                break;
                            }
                            if (this.curChar == '|') {
                                if (kind <= 119) break;
                                kind = 119;
                                break;
                            }
                            if (this.curChar != 'r') break;
                            this.jjAddStates(327, 328);
                            break;
                        }
                        case 44: {
                            if (this.curChar != ']' || kind <= 140) continue block110;
                            kind = 140;
                            break;
                        }
                        case 86: {
                            if ((0x7FFFFFE87FFFFFFL & l) != 0L) {
                                if (kind > 133) {
                                    kind = 133;
                                }
                                this.jjCheckNAddTwoStates(34, 35);
                                break;
                            }
                            if (this.curChar != '\\') break;
                            this.jjCheckNAdd(36);
                            break;
                        }
                        case 6: {
                            if ((0xFFFFFFFFEFFFFFFFL & l) == 0L) break;
                            this.jjCheckNAddStates(320, 322);
                            break;
                        }
                        case 7: {
                            if (this.curChar != '\\') break;
                            this.jjAddStates(329, 330);
                            break;
                        }
                        case 8: {
                            if (this.curChar != 'x') break;
                            this.jjstateSet[this.jjnewStateCnt++] = 9;
                            break;
                        }
                        case 9: {
                            if ((0x7E0000007EL & l) == 0L) break;
                            this.jjCheckNAddStates(320, 322);
                            break;
                        }
                        case 11: {
                            if ((0x81450C610000000L & l) == 0L) break;
                            this.jjCheckNAddStates(320, 322);
                            break;
                        }
                        case 13: {
                            if ((0xFFFFFFFFEFFFFFFFL & l) == 0L) break;
                            this.jjCheckNAddStates(317, 319);
                            break;
                        }
                        case 14: {
                            if (this.curChar != '\\') break;
                            this.jjAddStates(331, 332);
                            break;
                        }
                        case 15: {
                            if (this.curChar != 'x') break;
                            this.jjstateSet[this.jjnewStateCnt++] = 16;
                            break;
                        }
                        case 16: {
                            if ((0x7E0000007EL & l) == 0L) break;
                            this.jjCheckNAddStates(317, 319);
                            break;
                        }
                        case 18: {
                            if ((0x81450C610000000L & l) == 0L) break;
                            this.jjCheckNAddStates(317, 319);
                            break;
                        }
                        case 19: {
                            if (this.curChar != 'r') break;
                            this.jjAddStates(327, 328);
                            break;
                        }
                        case 21: {
                            this.jjAddStates(333, 334);
                            break;
                        }
                        case 24: {
                            this.jjAddStates(335, 336);
                            break;
                        }
                        case 30: 
                        case 31: {
                            if (this.curChar != '|' || kind <= 119) continue block110;
                            kind = 119;
                            break;
                        }
                        case 32: {
                            if (this.curChar != '|') break;
                            this.jjstateSet[this.jjnewStateCnt++] = 31;
                            break;
                        }
                        case 33: {
                            if ((0x7FFFFFE87FFFFFFL & l) == 0L) continue block110;
                            if (kind > 133) {
                                kind = 133;
                            }
                            this.jjCheckNAddTwoStates(34, 35);
                            break;
                        }
                        case 34: {
                            if ((0x7FFFFFE87FFFFFFL & l) == 0L) continue block110;
                            if (kind > 133) {
                                kind = 133;
                            }
                            this.jjCheckNAddTwoStates(34, 35);
                            break;
                        }
                        case 35: {
                            if (this.curChar != '\\') break;
                            this.jjCheckNAdd(36);
                            break;
                        }
                        case 37: {
                            if (this.curChar != '\\') break;
                            this.jjCheckNAdd(36);
                            break;
                        }
                        case 38: {
                            if (this.curChar != '{' || kind <= 134) continue block110;
                            kind = 134;
                            break;
                        }
                        case 56: {
                            if (this.curChar != 'l') break;
                            this.jjCheckNAddTwoStates(57, 59);
                            break;
                        }
                        case 57: {
                            if (this.curChar != 't' || kind <= 107) continue block110;
                            kind = 107;
                            break;
                        }
                        case 58: {
                            if (this.curChar != 'e' || kind <= 108) continue block110;
                            kind = 108;
                            break;
                        }
                        case 59: 
                        case 62: {
                            if (this.curChar != 't') break;
                            this.jjCheckNAdd(58);
                            break;
                        }
                        case 60: {
                            if (this.curChar != '\\') break;
                            this.jjAddStates(395, 398);
                            break;
                        }
                        case 61: {
                            if (this.curChar != 'l') break;
                            this.jjCheckNAdd(57);
                            break;
                        }
                        case 63: {
                            if (this.curChar != 'l') break;
                            this.jjstateSet[this.jjnewStateCnt++] = 62;
                            break;
                        }
                        case 64: {
                            if (this.curChar != 't' || kind <= 109) continue block110;
                            kind = 109;
                            break;
                        }
                        case 65: {
                            if (this.curChar != 'g') break;
                            this.jjCheckNAdd(64);
                            break;
                        }
                        case 66: {
                            if (this.curChar != 'e' || kind <= 110) continue block110;
                            kind = 110;
                            break;
                        }
                        case 67: 
                        case 85: {
                            if (this.curChar != 't') break;
                            this.jjCheckNAdd(66);
                            break;
                        }
                        case 68: {
                            if (this.curChar != 'g') break;
                            this.jjstateSet[this.jjnewStateCnt++] = 67;
                            break;
                        }
                        case 71: {
                            if (this.curChar != 't') break;
                            this.jjstateSet[this.jjnewStateCnt++] = 70;
                            break;
                        }
                        case 72: {
                            if (this.curChar != 'l') break;
                            this.jjstateSet[this.jjnewStateCnt++] = 71;
                            break;
                        }
                        case 74: {
                            if (this.curChar != 't') break;
                            this.jjstateSet[this.jjnewStateCnt++] = 73;
                            break;
                        }
                        case 75: {
                            if (this.curChar != 'l') break;
                            this.jjstateSet[this.jjnewStateCnt++] = 74;
                            break;
                        }
                        case 77: {
                            if (this.curChar != 't') break;
                            this.jjstateSet[this.jjnewStateCnt++] = 76;
                            break;
                        }
                        case 78: {
                            if (this.curChar != 'g') break;
                            this.jjstateSet[this.jjnewStateCnt++] = 77;
                            break;
                        }
                        case 81: {
                            if (this.curChar != 't') break;
                            this.jjstateSet[this.jjnewStateCnt++] = 80;
                            break;
                        }
                        case 82: {
                            if (this.curChar != 'g') break;
                            this.jjstateSet[this.jjnewStateCnt++] = 81;
                            break;
                        }
                        case 84: {
                            if (this.curChar != 'g') break;
                            this.jjCheckNAddTwoStates(64, 85);
                            break;
                        }
                    }
                } while (i != startsAt);
            } else {
                int hiByte = this.curChar >> 8;
                int i1 = hiByte >> 6;
                long l1 = 1L << (hiByte & 0x3F);
                int i2 = (this.curChar & 0xFF) >> 6;
                long l2 = 1L << (this.curChar & 0x3F);
                block111: do {
                    switch (this.jjstateSet[--i]) {
                        case 1: {
                            if (!FMParserTokenManager.jjCanMove_1(hiByte, i1, i2, l1, l2)) continue block111;
                            if (kind > 133) {
                                kind = 133;
                            }
                            this.jjCheckNAddTwoStates(34, 35);
                            break;
                        }
                        case 34: 
                        case 86: {
                            if (!FMParserTokenManager.jjCanMove_1(hiByte, i1, i2, l1, l2)) continue block111;
                            if (kind > 133) {
                                kind = 133;
                            }
                            this.jjCheckNAddTwoStates(34, 35);
                            break;
                        }
                        case 6: {
                            if (!FMParserTokenManager.jjCanMove_0(hiByte, i1, i2, l1, l2)) break;
                            this.jjAddStates(320, 322);
                            break;
                        }
                        case 13: {
                            if (!FMParserTokenManager.jjCanMove_0(hiByte, i1, i2, l1, l2)) break;
                            this.jjAddStates(317, 319);
                            break;
                        }
                        case 21: {
                            if (!FMParserTokenManager.jjCanMove_0(hiByte, i1, i2, l1, l2)) break;
                            this.jjAddStates(333, 334);
                            break;
                        }
                        case 24: {
                            if (!FMParserTokenManager.jjCanMove_0(hiByte, i1, i2, l1, l2)) break;
                            this.jjAddStates(335, 336);
                            break;
                        }
                    }
                } while (i != startsAt);
            }
            if (kind != Integer.MAX_VALUE) {
                this.jjmatchedKind = kind;
                this.jjmatchedPos = curPos;
                kind = Integer.MAX_VALUE;
            }
            ++curPos;
            i = this.jjnewStateCnt;
            this.jjnewStateCnt = startsAt;
            if (i == (startsAt = 86 - this.jjnewStateCnt)) {
                return curPos;
            }
            try {
                this.curChar = this.input_stream.readChar();
            }
            catch (IOException e) {
                return curPos;
            }
        }
    }

    private static final boolean jjCanMove_0(int hiByte, int i1, int i2, long l1, long l2) {
        switch (hiByte) {
            case 0: {
                return (jjbitVec2[i2] & l2) != 0L;
            }
        }
        return (jjbitVec0[i1] & l1) != 0L;
    }

    private static final boolean jjCanMove_1(int hiByte, int i1, int i2, long l1, long l2) {
        switch (hiByte) {
            case 0: {
                return (jjbitVec4[i2] & l2) != 0L;
            }
            case 32: {
                return (jjbitVec5[i2] & l2) != 0L;
            }
            case 33: {
                return (jjbitVec6[i2] & l2) != 0L;
            }
            case 44: {
                return (jjbitVec7[i2] & l2) != 0L;
            }
            case 45: {
                return (jjbitVec8[i2] & l2) != 0L;
            }
            case 46: {
                return (jjbitVec9[i2] & l2) != 0L;
            }
            case 48: {
                return (jjbitVec10[i2] & l2) != 0L;
            }
            case 49: {
                return (jjbitVec11[i2] & l2) != 0L;
            }
            case 51: {
                return (jjbitVec12[i2] & l2) != 0L;
            }
            case 77: {
                return (jjbitVec13[i2] & l2) != 0L;
            }
            case 164: {
                return (jjbitVec14[i2] & l2) != 0L;
            }
            case 166: {
                return (jjbitVec15[i2] & l2) != 0L;
            }
            case 167: {
                return (jjbitVec16[i2] & l2) != 0L;
            }
            case 168: {
                return (jjbitVec17[i2] & l2) != 0L;
            }
            case 169: {
                return (jjbitVec18[i2] & l2) != 0L;
            }
            case 170: {
                return (jjbitVec19[i2] & l2) != 0L;
            }
            case 171: {
                return (jjbitVec20[i2] & l2) != 0L;
            }
            case 215: {
                return (jjbitVec21[i2] & l2) != 0L;
            }
            case 251: {
                return (jjbitVec22[i2] & l2) != 0L;
            }
            case 253: {
                return (jjbitVec23[i2] & l2) != 0L;
            }
            case 254: {
                return (jjbitVec24[i2] & l2) != 0L;
            }
            case 255: {
                return (jjbitVec25[i2] & l2) != 0L;
            }
        }
        return (jjbitVec3[i1] & l1) != 0L;
    }

    public FMParserTokenManager(SimpleCharStream stream) {
        this.input_stream = stream;
    }

    public FMParserTokenManager(SimpleCharStream stream, int lexState) {
        this(stream);
        this.SwitchTo(lexState);
    }

    public void ReInit(SimpleCharStream stream) {
        this.jjnewStateCnt = 0;
        this.jjmatchedPos = 0;
        this.curLexState = this.defaultLexState;
        this.input_stream = stream;
        this.ReInitRounds();
    }

    private final void ReInitRounds() {
        this.jjround = -2147483647;
        int i = 609;
        while (i-- > 0) {
            this.jjrounds[i] = Integer.MIN_VALUE;
        }
    }

    public void ReInit(SimpleCharStream stream, int lexState) {
        this.ReInit(stream);
        this.SwitchTo(lexState);
    }

    public void SwitchTo(int lexState) {
        if (lexState >= 8 || lexState < 0) {
            throw new TokenMgrError("Error: Ignoring invalid lexical state : " + lexState + ". State unchanged.", 2);
        }
        this.curLexState = lexState;
    }

    protected Token jjFillToken() {
        Token t = Token.newToken(this.jjmatchedKind);
        t.kind = this.jjmatchedKind;
        String im = jjstrLiteralImages[this.jjmatchedKind];
        t.image = im == null ? this.input_stream.GetImage() : im;
        t.beginLine = this.input_stream.getBeginLine();
        t.beginColumn = this.input_stream.getBeginColumn();
        t.endLine = this.input_stream.getEndLine();
        t.endColumn = this.input_stream.getEndColumn();
        return t;
    }

    public Token getNextToken() {
        Object specialToken = null;
        int curPos = 0;
        block16: while (true) {
            try {
                this.curChar = this.input_stream.BeginToken();
            }
            catch (IOException e) {
                this.jjmatchedKind = 0;
                Token matchedToken = this.jjFillToken();
                return matchedToken;
            }
            this.image = null;
            this.jjimageLen = 0;
            switch (this.curLexState) {
                case 0: {
                    this.jjmatchedKind = Integer.MAX_VALUE;
                    this.jjmatchedPos = 0;
                    curPos = this.jjMoveStringLiteralDfa0_0();
                    break;
                }
                case 1: {
                    this.jjmatchedKind = Integer.MAX_VALUE;
                    this.jjmatchedPos = 0;
                    curPos = this.jjMoveStringLiteralDfa0_1();
                    break;
                }
                case 2: {
                    this.jjmatchedKind = Integer.MAX_VALUE;
                    this.jjmatchedPos = 0;
                    curPos = this.jjMoveStringLiteralDfa0_2();
                    break;
                }
                case 3: {
                    this.jjmatchedKind = Integer.MAX_VALUE;
                    this.jjmatchedPos = 0;
                    curPos = this.jjMoveStringLiteralDfa0_3();
                    break;
                }
                case 4: {
                    this.jjmatchedKind = Integer.MAX_VALUE;
                    this.jjmatchedPos = 0;
                    curPos = this.jjMoveStringLiteralDfa0_4();
                    break;
                }
                case 5: {
                    try {
                        this.input_stream.backup(0);
                        while (this.curChar < '@' && (0x4000000000000000L & 1L << this.curChar) != 0L || this.curChar >> 6 == 1 && (0x20000000L & 1L << (this.curChar & 0x3F)) != 0L) {
                            this.curChar = this.input_stream.BeginToken();
                        }
                    }
                    catch (IOException e1) {
                        continue block16;
                    }
                    this.jjmatchedKind = Integer.MAX_VALUE;
                    this.jjmatchedPos = 0;
                    curPos = this.jjMoveStringLiteralDfa0_5();
                    break;
                }
                case 6: {
                    this.jjmatchedKind = Integer.MAX_VALUE;
                    this.jjmatchedPos = 0;
                    curPos = this.jjMoveStringLiteralDfa0_6();
                    break;
                }
                case 7: {
                    this.jjmatchedKind = Integer.MAX_VALUE;
                    this.jjmatchedPos = 0;
                    curPos = this.jjMoveStringLiteralDfa0_7();
                }
            }
            if (this.jjmatchedKind == Integer.MAX_VALUE) break;
            if (this.jjmatchedPos + 1 < curPos) {
                this.input_stream.backup(curPos - this.jjmatchedPos - 1);
            }
            if ((jjtoToken[this.jjmatchedKind >> 6] & 1L << (this.jjmatchedKind & 0x3F)) != 0L) {
                Token matchedToken = this.jjFillToken();
                this.TokenLexicalActions(matchedToken);
                if (jjnewLexState[this.jjmatchedKind] != -1) {
                    this.curLexState = jjnewLexState[this.jjmatchedKind];
                }
                return matchedToken;
            }
            this.SkipLexicalActions(null);
            if (jjnewLexState[this.jjmatchedKind] == -1) continue;
            this.curLexState = jjnewLexState[this.jjmatchedKind];
        }
        int error_line = this.input_stream.getEndLine();
        int error_column = this.input_stream.getEndColumn();
        String error_after = null;
        boolean EOFSeen = false;
        try {
            this.input_stream.readChar();
            this.input_stream.backup(1);
        }
        catch (IOException e1) {
            EOFSeen = true;
            String string = error_after = curPos <= 1 ? "" : this.input_stream.GetImage();
            if (this.curChar == '\n' || this.curChar == '\r') {
                ++error_line;
                error_column = 0;
            }
            ++error_column;
        }
        if (!EOFSeen) {
            this.input_stream.backup(1);
            error_after = curPos <= 1 ? "" : this.input_stream.GetImage();
        }
        throw new TokenMgrError(EOFSeen, this.curLexState, error_line, error_column, error_after, this.curChar, 0);
    }

    void SkipLexicalActions(Token matchedToken) {
        switch (this.jjmatchedKind) {
            case 83: {
                if (this.image == null) {
                    this.lengthOfMatch = this.jjmatchedPos + 1;
                    this.image = new StringBuffer(new String(this.input_stream.GetSuffix(this.jjimageLen + this.lengthOfMatch)));
                } else {
                    this.lengthOfMatch = this.jjmatchedPos + 1;
                    this.image.append(new String(this.input_stream.GetSuffix(this.jjimageLen + this.lengthOfMatch)));
                }
                if (this.parenthesisNesting > 0) {
                    this.SwitchTo(3);
                    break;
                }
                if (this.inInvocation) {
                    this.SwitchTo(4);
                    break;
                }
                this.SwitchTo(2);
                break;
            }
        }
    }

    void TokenLexicalActions(Token matchedToken) {
        switch (this.jjmatchedKind) {
            case 6: {
                if (this.image == null) {
                    this.lengthOfMatch = this.jjmatchedPos + 1;
                    this.image = new StringBuffer(new String(this.input_stream.GetSuffix(this.jjimageLen + this.lengthOfMatch)));
                } else {
                    this.lengthOfMatch = this.jjmatchedPos + 1;
                    this.image.append(new String(this.input_stream.GetSuffix(this.jjimageLen + this.lengthOfMatch)));
                }
                this.strictSyntaxCheck(matchedToken, 0);
                break;
            }
            case 7: {
                if (this.image == null) {
                    this.lengthOfMatch = this.jjmatchedPos + 1;
                    this.image = new StringBuffer(new String(this.input_stream.GetSuffix(this.jjimageLen + this.lengthOfMatch)));
                } else {
                    this.lengthOfMatch = this.jjmatchedPos + 1;
                    this.image.append(new String(this.input_stream.GetSuffix(this.jjimageLen + this.lengthOfMatch)));
                }
                this.strictSyntaxCheck(matchedToken, 0);
                break;
            }
            case 8: {
                if (this.image == null) {
                    this.lengthOfMatch = this.jjmatchedPos + 1;
                    this.image = new StringBuffer(new String(this.input_stream.GetSuffix(this.jjimageLen + this.lengthOfMatch)));
                } else {
                    this.lengthOfMatch = this.jjmatchedPos + 1;
                    this.image.append(new String(this.input_stream.GetSuffix(this.jjimageLen + this.lengthOfMatch)));
                }
                this.strictSyntaxCheck(matchedToken, 2);
                break;
            }
            case 9: {
                if (this.image == null) {
                    this.lengthOfMatch = this.jjmatchedPos + 1;
                    this.image = new StringBuffer(new String(this.input_stream.GetSuffix(this.jjimageLen + this.lengthOfMatch)));
                } else {
                    this.lengthOfMatch = this.jjmatchedPos + 1;
                    this.image.append(new String(this.input_stream.GetSuffix(this.jjimageLen + this.lengthOfMatch)));
                }
                this.strictSyntaxCheck(matchedToken, FMParserTokenManager.getTagNamingConvention(matchedToken, 4), 2);
                break;
            }
            case 10: {
                if (this.image == null) {
                    this.lengthOfMatch = this.jjmatchedPos + 1;
                    this.image = new StringBuffer(new String(this.input_stream.GetSuffix(this.jjimageLen + this.lengthOfMatch)));
                } else {
                    this.lengthOfMatch = this.jjmatchedPos + 1;
                    this.image.append(new String(this.input_stream.GetSuffix(this.jjimageLen + this.lengthOfMatch)));
                }
                this.strictSyntaxCheck(matchedToken, 2);
                break;
            }
            case 11: {
                if (this.image == null) {
                    this.lengthOfMatch = this.jjmatchedPos + 1;
                    this.image = new StringBuffer(new String(this.input_stream.GetSuffix(this.jjimageLen + this.lengthOfMatch)));
                } else {
                    this.lengthOfMatch = this.jjmatchedPos + 1;
                    this.image.append(new String(this.input_stream.GetSuffix(this.jjimageLen + this.lengthOfMatch)));
                }
                this.strictSyntaxCheck(matchedToken, 2);
                break;
            }
            case 13: {
                if (this.image == null) {
                    this.lengthOfMatch = this.jjmatchedPos + 1;
                    this.image = new StringBuffer(new String(this.input_stream.GetSuffix(this.jjimageLen + this.lengthOfMatch)));
                } else {
                    this.lengthOfMatch = this.jjmatchedPos + 1;
                    this.image.append(new String(this.input_stream.GetSuffix(this.jjimageLen + this.lengthOfMatch)));
                }
                this.strictSyntaxCheck(matchedToken, FMParserTokenManager.getTagNamingConvention(matchedToken, 3), 2);
                break;
            }
            case 14: {
                if (this.image == null) {
                    this.lengthOfMatch = this.jjmatchedPos + 1;
                    this.image = new StringBuffer(new String(this.input_stream.GetSuffix(this.jjimageLen + this.lengthOfMatch)));
                } else {
                    this.lengthOfMatch = this.jjmatchedPos + 1;
                    this.image.append(new String(this.input_stream.GetSuffix(this.jjimageLen + this.lengthOfMatch)));
                }
                this.strictSyntaxCheck(matchedToken, 2);
                break;
            }
            case 15: {
                if (this.image == null) {
                    this.lengthOfMatch = this.jjmatchedPos + 1;
                    this.image = new StringBuffer(new String(this.input_stream.GetSuffix(this.jjimageLen + this.lengthOfMatch)));
                } else {
                    this.lengthOfMatch = this.jjmatchedPos + 1;
                    this.image.append(new String(this.input_stream.GetSuffix(this.jjimageLen + this.lengthOfMatch)));
                }
                this.strictSyntaxCheck(matchedToken, 2);
                break;
            }
            case 16: {
                if (this.image == null) {
                    this.lengthOfMatch = this.jjmatchedPos + 1;
                    this.image = new StringBuffer(new String(this.input_stream.GetSuffix(this.jjimageLen + this.lengthOfMatch)));
                } else {
                    this.lengthOfMatch = this.jjmatchedPos + 1;
                    this.image.append(new String(this.input_stream.GetSuffix(this.jjimageLen + this.lengthOfMatch)));
                }
                this.strictSyntaxCheck(matchedToken, 2);
                break;
            }
            case 17: {
                if (this.image == null) {
                    this.lengthOfMatch = this.jjmatchedPos + 1;
                    this.image = new StringBuffer(new String(this.input_stream.GetSuffix(this.jjimageLen + this.lengthOfMatch)));
                } else {
                    this.lengthOfMatch = this.jjmatchedPos + 1;
                    this.image.append(new String(this.input_stream.GetSuffix(this.jjimageLen + this.lengthOfMatch)));
                }
                this.strictSyntaxCheck(matchedToken, 2);
                break;
            }
            case 18: {
                if (this.image == null) {
                    this.lengthOfMatch = this.jjmatchedPos + 1;
                    this.image = new StringBuffer(new String(this.input_stream.GetSuffix(this.jjimageLen + this.lengthOfMatch)));
                } else {
                    this.lengthOfMatch = this.jjmatchedPos + 1;
                    this.image.append(new String(this.input_stream.GetSuffix(this.jjimageLen + this.lengthOfMatch)));
                }
                this.strictSyntaxCheck(matchedToken, 2);
                break;
            }
            case 19: {
                if (this.image == null) {
                    this.lengthOfMatch = this.jjmatchedPos + 1;
                    this.image = new StringBuffer(new String(this.input_stream.GetSuffix(this.jjimageLen + this.lengthOfMatch)));
                } else {
                    this.lengthOfMatch = this.jjmatchedPos + 1;
                    this.image.append(new String(this.input_stream.GetSuffix(this.jjimageLen + this.lengthOfMatch)));
                }
                this.strictSyntaxCheck(matchedToken, 2);
                break;
            }
            case 20: {
                if (this.image == null) {
                    this.lengthOfMatch = this.jjmatchedPos + 1;
                    this.image = new StringBuffer(new String(this.input_stream.GetSuffix(this.jjimageLen + this.lengthOfMatch)));
                } else {
                    this.lengthOfMatch = this.jjmatchedPos + 1;
                    this.image.append(new String(this.input_stream.GetSuffix(this.jjimageLen + this.lengthOfMatch)));
                }
                this.strictSyntaxCheck(matchedToken, 2);
                break;
            }
            case 21: {
                if (this.image == null) {
                    this.lengthOfMatch = this.jjmatchedPos + 1;
                    this.image = new StringBuffer(new String(this.input_stream.GetSuffix(this.jjimageLen + this.lengthOfMatch)));
                } else {
                    this.lengthOfMatch = this.jjmatchedPos + 1;
                    this.image.append(new String(this.input_stream.GetSuffix(this.jjimageLen + this.lengthOfMatch)));
                }
                this.strictSyntaxCheck(matchedToken, 2);
                break;
            }
            case 22: {
                if (this.image == null) {
                    this.lengthOfMatch = this.jjmatchedPos + 1;
                    this.image = new StringBuffer(new String(this.input_stream.GetSuffix(this.jjimageLen + this.lengthOfMatch)));
                } else {
                    this.lengthOfMatch = this.jjmatchedPos + 1;
                    this.image.append(new String(this.input_stream.GetSuffix(this.jjimageLen + this.lengthOfMatch)));
                }
                this.strictSyntaxCheck(matchedToken, 2);
                break;
            }
            case 23: {
                if (this.image == null) {
                    this.lengthOfMatch = this.jjmatchedPos + 1;
                    this.image = new StringBuffer(new String(this.input_stream.GetSuffix(this.jjimageLen + this.lengthOfMatch)));
                } else {
                    this.lengthOfMatch = this.jjmatchedPos + 1;
                    this.image.append(new String(this.input_stream.GetSuffix(this.jjimageLen + this.lengthOfMatch)));
                }
                this.strictSyntaxCheck(matchedToken, 2);
                break;
            }
            case 24: {
                if (this.image == null) {
                    this.lengthOfMatch = this.jjmatchedPos + 1;
                    this.image = new StringBuffer(new String(this.input_stream.GetSuffix(this.jjimageLen + this.lengthOfMatch)));
                } else {
                    this.lengthOfMatch = this.jjmatchedPos + 1;
                    this.image.append(new String(this.input_stream.GetSuffix(this.jjimageLen + this.lengthOfMatch)));
                }
                this.strictSyntaxCheck(matchedToken, 2);
                break;
            }
            case 25: {
                if (this.image == null) {
                    this.lengthOfMatch = this.jjmatchedPos + 1;
                    this.image = new StringBuffer(new String(this.input_stream.GetSuffix(this.jjimageLen + this.lengthOfMatch)));
                } else {
                    this.lengthOfMatch = this.jjmatchedPos + 1;
                    this.image.append(new String(this.input_stream.GetSuffix(this.jjimageLen + this.lengthOfMatch)));
                }
                this.strictSyntaxCheck(matchedToken, 2);
                break;
            }
            case 26: {
                if (this.image == null) {
                    this.lengthOfMatch = this.jjmatchedPos + 1;
                    this.image = new StringBuffer(new String(this.input_stream.GetSuffix(this.jjimageLen + this.lengthOfMatch)));
                } else {
                    this.lengthOfMatch = this.jjmatchedPos + 1;
                    this.image.append(new String(this.input_stream.GetSuffix(this.jjimageLen + this.lengthOfMatch)));
                }
                this.strictSyntaxCheck(matchedToken, 2);
                break;
            }
            case 27: {
                if (this.image == null) {
                    this.lengthOfMatch = this.jjmatchedPos + 1;
                    this.image = new StringBuffer(new String(this.input_stream.GetSuffix(this.jjimageLen + this.lengthOfMatch)));
                } else {
                    this.lengthOfMatch = this.jjmatchedPos + 1;
                    this.image.append(new String(this.input_stream.GetSuffix(this.jjimageLen + this.lengthOfMatch)));
                }
                this.strictSyntaxCheck(matchedToken, 2);
                break;
            }
            case 28: {
                if (this.image == null) {
                    this.lengthOfMatch = this.jjmatchedPos + 1;
                    this.image = new StringBuffer(new String(this.input_stream.GetSuffix(this.jjimageLen + this.lengthOfMatch)));
                } else {
                    this.lengthOfMatch = this.jjmatchedPos + 1;
                    this.image.append(new String(this.input_stream.GetSuffix(this.jjimageLen + this.lengthOfMatch)));
                }
                this.strictSyntaxCheck(matchedToken, 2);
                break;
            }
            case 29: {
                if (this.image == null) {
                    this.lengthOfMatch = this.jjmatchedPos + 1;
                    this.image = new StringBuffer(new String(this.input_stream.GetSuffix(this.jjimageLen + this.lengthOfMatch)));
                } else {
                    this.lengthOfMatch = this.jjmatchedPos + 1;
                    this.image.append(new String(this.input_stream.GetSuffix(this.jjimageLen + this.lengthOfMatch)));
                }
                this.strictSyntaxCheck(matchedToken, 0);
                break;
            }
            case 30: {
                if (this.image == null) {
                    this.lengthOfMatch = this.jjmatchedPos + 1;
                    this.image = new StringBuffer(new String(this.input_stream.GetSuffix(this.jjimageLen + this.lengthOfMatch)));
                } else {
                    this.lengthOfMatch = this.jjmatchedPos + 1;
                    this.image.append(new String(this.input_stream.GetSuffix(this.jjimageLen + this.lengthOfMatch)));
                }
                this.strictSyntaxCheck(matchedToken, 7);
                this.noparseTag = "comment";
                break;
            }
            case 31: {
                if (this.image == null) {
                    this.lengthOfMatch = this.jjmatchedPos + 1;
                    this.image = new StringBuffer(new String(this.input_stream.GetSuffix(this.jjimageLen + this.lengthOfMatch)));
                } else {
                    this.lengthOfMatch = this.jjmatchedPos + 1;
                    this.image.append(new String(this.input_stream.GetSuffix(this.jjimageLen + this.lengthOfMatch)));
                }
                this.noparseTag = "-->";
                this.strictSyntaxCheck(matchedToken, 7);
                break;
            }
            case 32: {
                if (this.image == null) {
                    this.lengthOfMatch = this.jjmatchedPos + 1;
                    this.image = new StringBuffer(new String(this.input_stream.GetSuffix(this.jjimageLen + this.lengthOfMatch)));
                } else {
                    this.lengthOfMatch = this.jjmatchedPos + 1;
                    this.image.append(new String(this.input_stream.GetSuffix(this.jjimageLen + this.lengthOfMatch)));
                }
                int tagNamingConvention = FMParserTokenManager.getTagNamingConvention(matchedToken, 2);
                this.strictSyntaxCheck(matchedToken, tagNamingConvention, 7);
                this.noparseTag = tagNamingConvention == 12 ? "noParse" : "noparse";
                break;
            }
            case 33: {
                if (this.image == null) {
                    this.lengthOfMatch = this.jjmatchedPos + 1;
                    this.image = new StringBuffer(new String(this.input_stream.GetSuffix(this.jjimageLen + this.lengthOfMatch)));
                } else {
                    this.lengthOfMatch = this.jjmatchedPos + 1;
                    this.image.append(new String(this.input_stream.GetSuffix(this.jjimageLen + this.lengthOfMatch)));
                }
                this.strictSyntaxCheck(matchedToken, 0);
                break;
            }
            case 34: {
                if (this.image == null) {
                    this.lengthOfMatch = this.jjmatchedPos + 1;
                    this.image = new StringBuffer(new String(this.input_stream.GetSuffix(this.jjimageLen + this.lengthOfMatch)));
                } else {
                    this.lengthOfMatch = this.jjmatchedPos + 1;
                    this.image.append(new String(this.input_stream.GetSuffix(this.jjimageLen + this.lengthOfMatch)));
                }
                this.strictSyntaxCheck(matchedToken, 0);
                break;
            }
            case 35: {
                if (this.image == null) {
                    this.lengthOfMatch = this.jjmatchedPos + 1;
                    this.image = new StringBuffer(new String(this.input_stream.GetSuffix(this.jjimageLen + this.lengthOfMatch)));
                } else {
                    this.lengthOfMatch = this.jjmatchedPos + 1;
                    this.image.append(new String(this.input_stream.GetSuffix(this.jjimageLen + this.lengthOfMatch)));
                }
                this.strictSyntaxCheck(matchedToken, 0);
                break;
            }
            case 36: {
                if (this.image == null) {
                    this.lengthOfMatch = this.jjmatchedPos + 1;
                    this.image = new StringBuffer(new String(this.input_stream.GetSuffix(this.jjimageLen + this.lengthOfMatch)));
                } else {
                    this.lengthOfMatch = this.jjmatchedPos + 1;
                    this.image.append(new String(this.input_stream.GetSuffix(this.jjimageLen + this.lengthOfMatch)));
                }
                this.strictSyntaxCheck(matchedToken, 0);
                break;
            }
            case 37: {
                if (this.image == null) {
                    this.lengthOfMatch = this.jjmatchedPos + 1;
                    this.image = new StringBuffer(new String(this.input_stream.GetSuffix(this.jjimageLen + this.lengthOfMatch)));
                } else {
                    this.lengthOfMatch = this.jjmatchedPos + 1;
                    this.image.append(new String(this.input_stream.GetSuffix(this.jjimageLen + this.lengthOfMatch)));
                }
                this.strictSyntaxCheck(matchedToken, 0);
                break;
            }
            case 38: {
                if (this.image == null) {
                    this.lengthOfMatch = this.jjmatchedPos + 1;
                    this.image = new StringBuffer(new String(this.input_stream.GetSuffix(this.jjimageLen + this.lengthOfMatch)));
                } else {
                    this.lengthOfMatch = this.jjmatchedPos + 1;
                    this.image.append(new String(this.input_stream.GetSuffix(this.jjimageLen + this.lengthOfMatch)));
                }
                this.strictSyntaxCheck(matchedToken, 0);
                break;
            }
            case 39: {
                if (this.image == null) {
                    this.lengthOfMatch = this.jjmatchedPos + 1;
                    this.image = new StringBuffer(new String(this.input_stream.GetSuffix(this.jjimageLen + this.lengthOfMatch)));
                } else {
                    this.lengthOfMatch = this.jjmatchedPos + 1;
                    this.image.append(new String(this.input_stream.GetSuffix(this.jjimageLen + this.lengthOfMatch)));
                }
                this.strictSyntaxCheck(matchedToken, FMParserTokenManager.getTagNamingConvention(matchedToken, 3), 0);
                break;
            }
            case 40: {
                if (this.image == null) {
                    this.lengthOfMatch = this.jjmatchedPos + 1;
                    this.image = new StringBuffer(new String(this.input_stream.GetSuffix(this.jjimageLen + this.lengthOfMatch)));
                } else {
                    this.lengthOfMatch = this.jjmatchedPos + 1;
                    this.image.append(new String(this.input_stream.GetSuffix(this.jjimageLen + this.lengthOfMatch)));
                }
                this.strictSyntaxCheck(matchedToken, 0);
                break;
            }
            case 41: {
                if (this.image == null) {
                    this.lengthOfMatch = this.jjmatchedPos + 1;
                    this.image = new StringBuffer(new String(this.input_stream.GetSuffix(this.jjimageLen + this.lengthOfMatch)));
                } else {
                    this.lengthOfMatch = this.jjmatchedPos + 1;
                    this.image.append(new String(this.input_stream.GetSuffix(this.jjimageLen + this.lengthOfMatch)));
                }
                this.strictSyntaxCheck(matchedToken, 0);
                break;
            }
            case 42: {
                if (this.image == null) {
                    this.lengthOfMatch = this.jjmatchedPos + 1;
                    this.image = new StringBuffer(new String(this.input_stream.GetSuffix(this.jjimageLen + this.lengthOfMatch)));
                } else {
                    this.lengthOfMatch = this.jjmatchedPos + 1;
                    this.image.append(new String(this.input_stream.GetSuffix(this.jjimageLen + this.lengthOfMatch)));
                }
                this.strictSyntaxCheck(matchedToken, 0);
                break;
            }
            case 43: {
                if (this.image == null) {
                    this.lengthOfMatch = this.jjmatchedPos + 1;
                    this.image = new StringBuffer(new String(this.input_stream.GetSuffix(this.jjimageLen + this.lengthOfMatch)));
                } else {
                    this.lengthOfMatch = this.jjmatchedPos + 1;
                    this.image.append(new String(this.input_stream.GetSuffix(this.jjimageLen + this.lengthOfMatch)));
                }
                this.strictSyntaxCheck(matchedToken, 0);
                break;
            }
            case 44: {
                if (this.image == null) {
                    this.lengthOfMatch = this.jjmatchedPos + 1;
                    this.image = new StringBuffer(new String(this.input_stream.GetSuffix(this.jjimageLen + this.lengthOfMatch)));
                } else {
                    this.lengthOfMatch = this.jjmatchedPos + 1;
                    this.image.append(new String(this.input_stream.GetSuffix(this.jjimageLen + this.lengthOfMatch)));
                }
                this.strictSyntaxCheck(matchedToken, 0);
                break;
            }
            case 45: {
                if (this.image == null) {
                    this.lengthOfMatch = this.jjmatchedPos + 1;
                    this.image = new StringBuffer(new String(this.input_stream.GetSuffix(this.jjimageLen + this.lengthOfMatch)));
                } else {
                    this.lengthOfMatch = this.jjmatchedPos + 1;
                    this.image.append(new String(this.input_stream.GetSuffix(this.jjimageLen + this.lengthOfMatch)));
                }
                this.strictSyntaxCheck(matchedToken, 0);
                break;
            }
            case 46: {
                if (this.image == null) {
                    this.lengthOfMatch = this.jjmatchedPos + 1;
                    this.image = new StringBuffer(new String(this.input_stream.GetSuffix(this.jjimageLen + this.lengthOfMatch)));
                } else {
                    this.lengthOfMatch = this.jjmatchedPos + 1;
                    this.image.append(new String(this.input_stream.GetSuffix(this.jjimageLen + this.lengthOfMatch)));
                }
                this.strictSyntaxCheck(matchedToken, 0);
                break;
            }
            case 47: {
                if (this.image == null) {
                    this.lengthOfMatch = this.jjmatchedPos + 1;
                    this.image = new StringBuffer(new String(this.input_stream.GetSuffix(this.jjimageLen + this.lengthOfMatch)));
                } else {
                    this.lengthOfMatch = this.jjmatchedPos + 1;
                    this.image.append(new String(this.input_stream.GetSuffix(this.jjimageLen + this.lengthOfMatch)));
                }
                this.strictSyntaxCheck(matchedToken, 0);
                break;
            }
            case 48: {
                if (this.image == null) {
                    this.lengthOfMatch = this.jjmatchedPos + 1;
                    this.image = new StringBuffer(new String(this.input_stream.GetSuffix(this.jjimageLen + this.lengthOfMatch)));
                } else {
                    this.lengthOfMatch = this.jjmatchedPos + 1;
                    this.image.append(new String(this.input_stream.GetSuffix(this.jjimageLen + this.lengthOfMatch)));
                }
                this.strictSyntaxCheck(matchedToken, 0);
                break;
            }
            case 49: {
                if (this.image == null) {
                    this.lengthOfMatch = this.jjmatchedPos + 1;
                    this.image = new StringBuffer(new String(this.input_stream.GetSuffix(this.jjimageLen + this.lengthOfMatch)));
                } else {
                    this.lengthOfMatch = this.jjmatchedPos + 1;
                    this.image.append(new String(this.input_stream.GetSuffix(this.jjimageLen + this.lengthOfMatch)));
                }
                this.strictSyntaxCheck(matchedToken, 0);
                break;
            }
            case 50: {
                if (this.image == null) {
                    this.lengthOfMatch = this.jjmatchedPos + 1;
                    this.image = new StringBuffer(new String(this.input_stream.GetSuffix(this.jjimageLen + this.lengthOfMatch)));
                } else {
                    this.lengthOfMatch = this.jjmatchedPos + 1;
                    this.image.append(new String(this.input_stream.GetSuffix(this.jjimageLen + this.lengthOfMatch)));
                }
                this.strictSyntaxCheck(matchedToken, 0);
                break;
            }
            case 51: {
                if (this.image == null) {
                    this.lengthOfMatch = this.jjmatchedPos + 1;
                    this.image = new StringBuffer(new String(this.input_stream.GetSuffix(this.jjimageLen + this.lengthOfMatch)));
                } else {
                    this.lengthOfMatch = this.jjmatchedPos + 1;
                    this.image.append(new String(this.input_stream.GetSuffix(this.jjimageLen + this.lengthOfMatch)));
                }
                this.strictSyntaxCheck(matchedToken, 0);
                break;
            }
            case 52: {
                if (this.image == null) {
                    this.lengthOfMatch = this.jjmatchedPos + 1;
                    this.image = new StringBuffer(new String(this.input_stream.GetSuffix(this.jjimageLen + this.lengthOfMatch)));
                } else {
                    this.lengthOfMatch = this.jjmatchedPos + 1;
                    this.image.append(new String(this.input_stream.GetSuffix(this.jjimageLen + this.lengthOfMatch)));
                }
                this.strictSyntaxCheck(matchedToken, 0);
                break;
            }
            case 53: {
                if (this.image == null) {
                    this.lengthOfMatch = this.jjmatchedPos + 1;
                    this.image = new StringBuffer(new String(this.input_stream.GetSuffix(this.jjimageLen + this.lengthOfMatch)));
                } else {
                    this.lengthOfMatch = this.jjmatchedPos + 1;
                    this.image.append(new String(this.input_stream.GetSuffix(this.jjimageLen + this.lengthOfMatch)));
                }
                this.strictSyntaxCheck(matchedToken, 0);
                break;
            }
            case 54: {
                if (this.image == null) {
                    this.lengthOfMatch = this.jjmatchedPos + 1;
                    this.image = new StringBuffer(new String(this.input_stream.GetSuffix(this.jjimageLen + this.lengthOfMatch)));
                } else {
                    this.lengthOfMatch = this.jjmatchedPos + 1;
                    this.image.append(new String(this.input_stream.GetSuffix(this.jjimageLen + this.lengthOfMatch)));
                }
                this.strictSyntaxCheck(matchedToken, 0);
                break;
            }
            case 55: {
                if (this.image == null) {
                    this.lengthOfMatch = this.jjmatchedPos + 1;
                    this.image = new StringBuffer(new String(this.input_stream.GetSuffix(this.jjimageLen + this.lengthOfMatch)));
                } else {
                    this.lengthOfMatch = this.jjmatchedPos + 1;
                    this.image.append(new String(this.input_stream.GetSuffix(this.jjimageLen + this.lengthOfMatch)));
                }
                this.strictSyntaxCheck(matchedToken, 0);
                break;
            }
            case 56: {
                if (this.image == null) {
                    this.lengthOfMatch = this.jjmatchedPos + 1;
                    this.image = new StringBuffer(new String(this.input_stream.GetSuffix(this.jjimageLen + this.lengthOfMatch)));
                } else {
                    this.lengthOfMatch = this.jjmatchedPos + 1;
                    this.image.append(new String(this.input_stream.GetSuffix(this.jjimageLen + this.lengthOfMatch)));
                }
                this.strictSyntaxCheck(matchedToken, 0);
                break;
            }
            case 57: {
                if (this.image == null) {
                    this.lengthOfMatch = this.jjmatchedPos + 1;
                    this.image = new StringBuffer(new String(this.input_stream.GetSuffix(this.jjimageLen + this.lengthOfMatch)));
                } else {
                    this.lengthOfMatch = this.jjmatchedPos + 1;
                    this.image.append(new String(this.input_stream.GetSuffix(this.jjimageLen + this.lengthOfMatch)));
                }
                this.strictSyntaxCheck(matchedToken, 0);
                break;
            }
            case 58: {
                if (this.image == null) {
                    this.lengthOfMatch = this.jjmatchedPos + 1;
                    this.image = new StringBuffer(new String(this.input_stream.GetSuffix(this.jjimageLen + this.lengthOfMatch)));
                } else {
                    this.lengthOfMatch = this.jjmatchedPos + 1;
                    this.image.append(new String(this.input_stream.GetSuffix(this.jjimageLen + this.lengthOfMatch)));
                }
                this.strictSyntaxCheck(matchedToken, 0);
                break;
            }
            case 59: {
                if (this.image == null) {
                    this.lengthOfMatch = this.jjmatchedPos + 1;
                    this.image = new StringBuffer(new String(this.input_stream.GetSuffix(this.jjimageLen + this.lengthOfMatch)));
                } else {
                    this.lengthOfMatch = this.jjmatchedPos + 1;
                    this.image.append(new String(this.input_stream.GetSuffix(this.jjimageLen + this.lengthOfMatch)));
                }
                this.strictSyntaxCheck(matchedToken, 2);
                break;
            }
            case 60: {
                if (this.image == null) {
                    this.lengthOfMatch = this.jjmatchedPos + 1;
                    this.image = new StringBuffer(new String(this.input_stream.GetSuffix(this.jjimageLen + this.lengthOfMatch)));
                } else {
                    this.lengthOfMatch = this.jjmatchedPos + 1;
                    this.image.append(new String(this.input_stream.GetSuffix(this.jjimageLen + this.lengthOfMatch)));
                }
                this.strictSyntaxCheck(matchedToken, 0);
                break;
            }
            case 61: {
                if (this.image == null) {
                    this.lengthOfMatch = this.jjmatchedPos + 1;
                    this.image = new StringBuffer(new String(this.input_stream.GetSuffix(this.jjimageLen + this.lengthOfMatch)));
                } else {
                    this.lengthOfMatch = this.jjmatchedPos + 1;
                    this.image.append(new String(this.input_stream.GetSuffix(this.jjimageLen + this.lengthOfMatch)));
                }
                this.strictSyntaxCheck(matchedToken, 2);
                break;
            }
            case 62: {
                if (this.image == null) {
                    this.lengthOfMatch = this.jjmatchedPos + 1;
                    this.image = new StringBuffer(new String(this.input_stream.GetSuffix(this.jjimageLen + this.lengthOfMatch)));
                } else {
                    this.lengthOfMatch = this.jjmatchedPos + 1;
                    this.image.append(new String(this.input_stream.GetSuffix(this.jjimageLen + this.lengthOfMatch)));
                }
                this.strictSyntaxCheck(matchedToken, 0);
                break;
            }
            case 63: {
                if (this.image == null) {
                    this.lengthOfMatch = this.jjmatchedPos + 1;
                    this.image = new StringBuffer(new String(this.input_stream.GetSuffix(this.jjimageLen + this.lengthOfMatch)));
                } else {
                    this.lengthOfMatch = this.jjmatchedPos + 1;
                    this.image.append(new String(this.input_stream.GetSuffix(this.jjimageLen + this.lengthOfMatch)));
                }
                this.strictSyntaxCheck(matchedToken, 2);
                break;
            }
            case 64: {
                if (this.image == null) {
                    this.lengthOfMatch = this.jjmatchedPos + 1;
                    this.image = new StringBuffer(new String(this.input_stream.GetSuffix(this.jjimageLen + this.lengthOfMatch)));
                } else {
                    this.lengthOfMatch = this.jjmatchedPos + 1;
                    this.image.append(new String(this.input_stream.GetSuffix(this.jjimageLen + this.lengthOfMatch)));
                }
                this.strictSyntaxCheck(matchedToken, 0);
                break;
            }
            case 65: {
                if (this.image == null) {
                    this.lengthOfMatch = this.jjmatchedPos + 1;
                    this.image = new StringBuffer(new String(this.input_stream.GetSuffix(this.jjimageLen + this.lengthOfMatch)));
                } else {
                    this.lengthOfMatch = this.jjmatchedPos + 1;
                    this.image.append(new String(this.input_stream.GetSuffix(this.jjimageLen + this.lengthOfMatch)));
                }
                this.strictSyntaxCheck(matchedToken, FMParserTokenManager.getTagNamingConvention(matchedToken, 2), 0);
                break;
            }
            case 66: {
                if (this.image == null) {
                    this.lengthOfMatch = this.jjmatchedPos + 1;
                    this.image = new StringBuffer(new String(this.input_stream.GetSuffix(this.jjimageLen + this.lengthOfMatch)));
                } else {
                    this.lengthOfMatch = this.jjmatchedPos + 1;
                    this.image.append(new String(this.input_stream.GetSuffix(this.jjimageLen + this.lengthOfMatch)));
                }
                this.strictSyntaxCheck(matchedToken, FMParserTokenManager.getTagNamingConvention(matchedToken, 2), 0);
                break;
            }
            case 67: {
                if (this.image == null) {
                    this.lengthOfMatch = this.jjmatchedPos + 1;
                    this.image = new StringBuffer(new String(this.input_stream.GetSuffix(this.jjimageLen + this.lengthOfMatch)));
                } else {
                    this.lengthOfMatch = this.jjmatchedPos + 1;
                    this.image.append(new String(this.input_stream.GetSuffix(this.jjimageLen + this.lengthOfMatch)));
                }
                this.unifiedCall(matchedToken);
                break;
            }
            case 68: {
                if (this.image == null) {
                    this.lengthOfMatch = this.jjmatchedPos + 1;
                    this.image = new StringBuffer(new String(this.input_stream.GetSuffix(this.jjimageLen + this.lengthOfMatch)));
                } else {
                    this.lengthOfMatch = this.jjmatchedPos + 1;
                    this.image.append(new String(this.input_stream.GetSuffix(this.jjimageLen + this.lengthOfMatch)));
                }
                this.unifiedCallEnd(matchedToken);
                break;
            }
            case 69: {
                if (this.image == null) {
                    this.lengthOfMatch = this.jjmatchedPos + 1;
                    this.image = new StringBuffer(new String(this.input_stream.GetSuffix(this.jjimageLen + this.lengthOfMatch)));
                } else {
                    this.lengthOfMatch = this.jjmatchedPos + 1;
                    this.image.append(new String(this.input_stream.GetSuffix(this.jjimageLen + this.lengthOfMatch)));
                }
                this.ftlHeader(matchedToken);
                break;
            }
            case 70: {
                if (this.image == null) {
                    this.lengthOfMatch = this.jjmatchedPos + 1;
                    this.image = new StringBuffer(new String(this.input_stream.GetSuffix(this.jjimageLen + this.lengthOfMatch)));
                } else {
                    this.lengthOfMatch = this.jjmatchedPos + 1;
                    this.image.append(new String(this.input_stream.GetSuffix(this.jjimageLen + this.lengthOfMatch)));
                }
                this.ftlHeader(matchedToken);
                break;
            }
            case 71: {
                if (this.image == null) {
                    this.lengthOfMatch = this.jjmatchedPos + 1;
                    this.image = new StringBuffer(new String(this.input_stream.GetSuffix(this.jjimageLen + this.lengthOfMatch)));
                } else {
                    this.lengthOfMatch = this.jjmatchedPos + 1;
                    this.image.append(new String(this.input_stream.GetSuffix(this.jjimageLen + this.lengthOfMatch)));
                }
                if (!this.directiveSyntaxEstablished && this.incompatibleImprovements < _TemplateAPI.VERSION_INT_2_3_19) {
                    matchedToken.kind = 73;
                    break;
                }
                char firstChar = matchedToken.image.charAt(0);
                if (!this.directiveSyntaxEstablished && this.autodetectTagSyntax) {
                    this.squBracTagSyntax = firstChar == '[';
                    this.directiveSyntaxEstablished = true;
                }
                if (firstChar == '<' && this.squBracTagSyntax) {
                    matchedToken.kind = 73;
                    break;
                }
                if (firstChar == '[' && !this.squBracTagSyntax) {
                    matchedToken.kind = 73;
                    break;
                }
                if (!this.strictEscapeSyntax) break;
                String dn = matchedToken.image;
                int index = dn.indexOf(35);
                if (_CoreAPI.BUILT_IN_DIRECTIVE_NAMES.contains(dn = dn.substring(index + 1))) {
                    throw new TokenMgrError("#" + dn + " is an existing directive, but the tag is malformed. " + " (See FreeMarker Manual / Directive Reference.)", 0, matchedToken.beginLine, matchedToken.beginColumn + 1, matchedToken.endLine, matchedToken.endColumn);
                }
                String tip = null;
                tip = dn.equals("set") || dn.equals("var") ? "Use #assign or #local or #global, depending on the intented scope (#assign is template-scope). (If you have seen this directive in use elsewhere, this was a planned directive, so maybe you need to upgrade FreeMarker.)" : (dn.equals("else_if") || dn.equals("elif") ? "Use #elseif." : (dn.equals("no_escape") ? "Use #noescape instead." : (dn.equals("method") ? "Use #function instead." : (dn.equals("head") || dn.equals("template") || dn.equals("fm") ? "You may meant #ftl." : (dn.equals("try") || dn.equals("atempt") ? "You may meant #attempt." : (dn.equals("for") || dn.equals("each") || dn.equals("iterate") || dn.equals("iterator") ? "You may meant #list (http://freemarker.org/docs/ref_directive_list.html)." : (dn.equals("prefix") ? "You may meant #import. (If you have seen this directive in use elsewhere, this was a planned directive, so maybe you need to upgrade FreeMarker.)" : (dn.equals("item") | dn.equals("row") | dn.equals("rows") ? "You may meant #items." : (dn.equals("separator") | dn.equals("separate") | dn.equals("separ") ? "You may meant #sep." : "Help (latest version): http://freemarker.org/docs/ref_directive_alphaidx.html; you're using FreeMarker " + Configuration.getVersion() + ".")))))))));
                throw new TokenMgrError("Unknown directive: #" + dn + (tip != null ? ". " + tip : ""), 0, matchedToken.beginLine, matchedToken.beginColumn + 1, matchedToken.endLine, matchedToken.endColumn);
            }
            case 124: {
                if (this.image == null) {
                    this.image = new StringBuffer(jjstrLiteralImages[124]);
                } else {
                    this.image.append(jjstrLiteralImages[124]);
                }
                ++this.bracketNesting;
                break;
            }
            case 125: {
                if (this.image == null) {
                    this.image = new StringBuffer(jjstrLiteralImages[125]);
                } else {
                    this.image.append(jjstrLiteralImages[125]);
                }
                this.closeBracket(matchedToken);
                break;
            }
            case 126: {
                if (this.image == null) {
                    this.image = new StringBuffer(jjstrLiteralImages[126]);
                } else {
                    this.image.append(jjstrLiteralImages[126]);
                }
                ++this.parenthesisNesting;
                if (this.parenthesisNesting != 1) break;
                this.SwitchTo(3);
                break;
            }
            case 127: {
                if (this.image == null) {
                    this.image = new StringBuffer(jjstrLiteralImages[127]);
                } else {
                    this.image.append(jjstrLiteralImages[127]);
                }
                --this.parenthesisNesting;
                if (this.parenthesisNesting != 0) break;
                if (this.inInvocation) {
                    this.SwitchTo(4);
                    break;
                }
                this.SwitchTo(2);
                break;
            }
            case 128: {
                if (this.image == null) {
                    this.image = new StringBuffer(jjstrLiteralImages[128]);
                } else {
                    this.image.append(jjstrLiteralImages[128]);
                }
                ++this.hashLiteralNesting;
                break;
            }
            case 129: {
                if (this.image == null) {
                    this.image = new StringBuffer(jjstrLiteralImages[129]);
                } else {
                    this.image.append(jjstrLiteralImages[129]);
                }
                if (this.hashLiteralNesting == 0) {
                    this.SwitchTo(0);
                    break;
                }
                --this.hashLiteralNesting;
                break;
            }
            case 133: {
                if (this.image == null) {
                    this.lengthOfMatch = this.jjmatchedPos + 1;
                    this.image = new StringBuffer(new String(this.input_stream.GetSuffix(this.jjimageLen + this.lengthOfMatch)));
                } else {
                    this.lengthOfMatch = this.jjmatchedPos + 1;
                    this.image.append(new String(this.input_stream.GetSuffix(this.jjimageLen + this.lengthOfMatch)));
                }
                String s = matchedToken.image;
                if (s.indexOf(92) == -1) break;
                int srcLn = s.length();
                char[] newS = new char[srcLn - 1];
                int dstIdx = 0;
                for (int srcIdx = 0; srcIdx < srcLn; ++srcIdx) {
                    char c = s.charAt(srcIdx);
                    if (c == '\\') continue;
                    newS[dstIdx++] = c;
                }
                matchedToken.image = new String(newS, 0, dstIdx);
                break;
            }
            case 134: {
                if (this.image == null) {
                    this.lengthOfMatch = this.jjmatchedPos + 1;
                    this.image = new StringBuffer(new String(this.input_stream.GetSuffix(this.jjimageLen + this.lengthOfMatch)));
                } else {
                    this.lengthOfMatch = this.jjmatchedPos + 1;
                    this.image.append(new String(this.input_stream.GetSuffix(this.jjimageLen + this.lengthOfMatch)));
                }
                if ("".length() != 0) break;
                char c = matchedToken.image.charAt(0);
                throw new TokenMgrError("You can't use \"" + c + "{\" here as you are already in FreeMarker-expression-mode. Thus, instead " + "of " + c + "{myExpression}, just write myExpression. " + "(" + c + "{...} is only needed where otherwise static text is expected, i.e, outside " + "FreeMarker tags and ${...}-s.)", 0, matchedToken.beginLine, matchedToken.beginColumn, matchedToken.endLine, matchedToken.endColumn);
            }
            case 139: {
                if (this.image == null) {
                    this.image = new StringBuffer(jjstrLiteralImages[139]);
                } else {
                    this.image.append(jjstrLiteralImages[139]);
                }
                if (this.inFTLHeader) {
                    this.eatNewline();
                }
                this.inFTLHeader = false;
                if (this.squBracTagSyntax) {
                    matchedToken.kind = 141;
                    break;
                }
                this.SwitchTo(0);
                break;
            }
            case 140: {
                if (this.image == null) {
                    this.lengthOfMatch = this.jjmatchedPos + 1;
                    this.image = new StringBuffer(new String(this.input_stream.GetSuffix(this.jjimageLen + this.lengthOfMatch)));
                } else {
                    this.lengthOfMatch = this.jjmatchedPos + 1;
                    this.image.append(new String(this.input_stream.GetSuffix(this.jjimageLen + this.lengthOfMatch)));
                }
                if (this.inFTLHeader) {
                    this.eatNewline();
                }
                this.inFTLHeader = false;
                this.SwitchTo(0);
                break;
            }
            case 145: {
                if (this.image == null) {
                    this.lengthOfMatch = this.jjmatchedPos + 1;
                    this.image = new StringBuffer(new String(this.input_stream.GetSuffix(this.jjimageLen + this.lengthOfMatch)));
                } else {
                    this.lengthOfMatch = this.jjmatchedPos + 1;
                    this.image.append(new String(this.input_stream.GetSuffix(this.jjimageLen + this.lengthOfMatch)));
                }
                if (!this.noparseTag.equals("-->")) break;
                boolean squareBracket = matchedToken.image.endsWith("]");
                if ((!this.squBracTagSyntax || !squareBracket) && (this.squBracTagSyntax || squareBracket)) break;
                matchedToken.image = matchedToken.image + ";";
                this.SwitchTo(0);
                break;
            }
            case 146: {
                if (this.image == null) {
                    this.lengthOfMatch = this.jjmatchedPos + 1;
                    this.image = new StringBuffer(new String(this.input_stream.GetSuffix(this.jjimageLen + this.lengthOfMatch)));
                } else {
                    this.lengthOfMatch = this.jjmatchedPos + 1;
                    this.image.append(new String(this.input_stream.GetSuffix(this.jjimageLen + this.lengthOfMatch)));
                }
                StringTokenizer st = new StringTokenizer(this.image.toString(), " \t\n\r<>[]/#", false);
                if (!st.nextToken().equals(this.noparseTag)) break;
                matchedToken.image = matchedToken.image + ";";
                this.SwitchTo(0);
                break;
            }
        }
    }
}

