/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sisu.plexus;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.codehaus.plexus.component.annotations.Component;
import org.eclipse.sisu.inject.DeferredClass;
import org.eclipse.sisu.inject.Logs;
import org.eclipse.sisu.plexus.ComponentImpl;
import org.eclipse.sisu.plexus.Hints;
import org.eclipse.sisu.plexus.Roles;
import org.eclipse.sisu.space.ClassSpace;
import org.eclipse.sisu.space.CloningClassSpace;

final class PlexusTypeRegistry {
    private static final Component LOAD_ON_START_PLACEHOLDER = new ComponentImpl(Object.class, "", "load-on-start", "");
    private final Map<String, Component> components = new HashMap<String, Component>();
    private final Map<String, DeferredClass<?>> implementations = new HashMap();
    private final Set<String> deferredNames = new HashSet<String>();
    private final ClassSpace space;
    private CloningClassSpace clones;

    PlexusTypeRegistry(ClassSpace space) {
        this.space = space;
    }

    ClassSpace getSpace() {
        return this.space;
    }

    void loadOnStart(String role, String hint) {
        String key = Roles.canonicalRoleHint(role, hint);
        Component c = this.components.get(key);
        if (c == null) {
            this.components.put(key, LOAD_ON_START_PLACEHOLDER);
        } else if (!"load-on-start".equals(c.instantiationStrategy())) {
            this.components.put(key, new ComponentImpl(c.role(), c.hint(), "load-on-start", c.description()));
        }
    }

    String addComponent(String role, String hint, String instantiationStrategy, String description, String implementation) {
        Class<?> roleType = this.loadRole(role, implementation);
        if (roleType == null) {
            return null;
        }
        String canonicalHint = Hints.canonicalHint(hint);
        String key = Roles.canonicalRoleHint(role, canonicalHint);
        Component oldComponent = this.components.get(key);
        if (oldComponent == null) {
            this.components.put(key, new ComponentImpl(roleType, canonicalHint, instantiationStrategy, description));
        } else if (LOAD_ON_START_PLACEHOLDER == oldComponent) {
            this.components.put(key, new ComponentImpl(roleType, canonicalHint, "load-on-start", description));
        }
        DeferredClass<?> implementationType = this.implementations.get(key);
        if (implementationType == null) {
            implementationType = this.deferredNames.add(implementation) ? this.space.deferLoadClass(implementation) : this.cloneImplementation(implementation);
            this.implementations.put(key, implementationType);
            return implementationType.getName();
        }
        String oldImplementation = implementationType.getName();
        if (implementation.equals(CloningClassSpace.originalName(oldImplementation))) {
            return oldImplementation;
        }
        Logs.trace("Duplicate implementations for Plexus role: {}", key, null);
        Logs.trace("Using: {} ignoring: {}", oldImplementation, implementation);
        return null;
    }

    Map<Component, DeferredClass<?>> getComponents() {
        HashMap map = new HashMap();
        for (Map.Entry<String, DeferredClass<?>> i : this.implementations.entrySet()) {
            map.put(this.components.get(i.getKey()), i.getValue());
        }
        return map;
    }

    private Class<?> loadRole(String role, String implementation) {
        try {
            return this.space.loadClass(role);
        }
        catch (TypeNotPresentException e) {
            Logs.trace("Ignoring Plexus role: {}", role, e);
            return null;
        }
    }

    private DeferredClass<?> cloneImplementation(String implementation) {
        if (this.clones == null) {
            this.clones = new CloningClassSpace(this.space);
        }
        return this.clones.cloneClass(implementation);
    }
}

