/*
 * Decompiled with CFR 0.152.
 */
package cz.o2.proxima.server;

import com.google.protobuf.ByteString;
import com.google.protobuf.MessageOrBuilder;
import com.google.protobuf.TextFormat;
import cz.o2.proxima.functional.Consumer;
import cz.o2.proxima.proto.service.RetrieveServiceGrpc;
import cz.o2.proxima.proto.service.Rpc;
import cz.o2.proxima.repository.AttributeDescriptor;
import cz.o2.proxima.repository.AttributeFamilyDescriptor;
import cz.o2.proxima.repository.EntityDescriptor;
import cz.o2.proxima.repository.Repository;
import cz.o2.proxima.server.metrics.Metrics;
import cz.o2.proxima.storage.randomaccess.KeyValue;
import cz.o2.proxima.storage.randomaccess.RandomAccessReader;
import io.grpc.stub.StreamObserver;
import java.io.Serializable;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RetrieveService
extends RetrieveServiceGrpc.RetrieveServiceImplBase {
    private static final Logger log = LoggerFactory.getLogger(RetrieveService.class);
    private final Map<AttributeDescriptor<?>, RandomAccessReader> readerMap;
    private final Repository repo;

    public RetrieveService(Repository repo) {
        this.repo = repo;
        this.readerMap = Collections.synchronizedMap(new HashMap());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void listAttributes(Rpc.ListRequest request, StreamObserver<Rpc.ListResponse> responseObserver) {
        try {
            Metrics.LIST_REQUESTS.increment();
            log.info("Processing listAttributes {}", (Object)TextFormat.shortDebugString((MessageOrBuilder)request));
            if (request.getEntity().isEmpty() || request.getKey().isEmpty() || request.getWildcardPrefix().isEmpty()) {
                throw new Status(400, "Missing some required fields");
            }
            EntityDescriptor entity = (EntityDescriptor)this.repo.findEntity(request.getEntity()).orElseThrow(() -> new Status(404, "Entity " + request.getEntity() + " not found"));
            AttributeDescriptor wildcard = (AttributeDescriptor)entity.findAttribute(request.getWildcardPrefix() + ".*").orElseThrow(() -> new Status(404, "Entity " + request.getEntity() + " does not have wildcard attribute " + request.getWildcardPrefix()));
            RandomAccessReader reader = this.instantiateReader(wildcard);
            Rpc.ListResponse.Builder response = Rpc.ListResponse.newBuilder().setStatus(200);
            RandomAccessReader randomAccessReader = reader;
            synchronized (randomAccessReader) {
                reader.scanWildcard(request.getKey(), wildcard, reader.fetchOffset(RandomAccessReader.Listing.ATTRIBUTE, request.getOffset()), request.getLimit() > 0 ? request.getLimit() : -1, (Consumer & Serializable)kv -> response.addValue(Rpc.ListResponse.AttrValue.newBuilder().setAttribute(kv.getAttribute()).setValue(ByteString.copyFrom((byte[])kv.getValueBytes()))));
            }
            responseObserver.onNext((Object)response.build());
            responseObserver.onCompleted();
        }
        catch (Status s) {
            responseObserver.onNext((Object)Rpc.ListResponse.newBuilder().setStatus(s.statusCode).setStatusMessage(s.message).build());
            responseObserver.onCompleted();
        }
        catch (Exception ex) {
            log.error("Failed to process request {}", (Object)request, (Object)ex);
            responseObserver.onNext((Object)Rpc.ListResponse.newBuilder().setStatus(500).setStatusMessage(ex.getMessage()).build());
            responseObserver.onCompleted();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void get(Rpc.GetRequest request, StreamObserver<Rpc.GetResponse> responseObserver) {
        Metrics.GET_REQUESTS.increment();
        log.info("Processing get {}", (Object)TextFormat.shortDebugString((MessageOrBuilder)request));
        try {
            RandomAccessReader reader;
            if (request.getEntity().isEmpty() || request.getKey().isEmpty() || request.getAttribute().isEmpty()) {
                throw new Status(400, "Missing some required fields");
            }
            EntityDescriptor entity = (EntityDescriptor)this.repo.findEntity(request.getEntity()).orElseThrow(() -> new Status(404, "Entity " + request.getEntity() + " not found"));
            AttributeDescriptor attribute = (AttributeDescriptor)entity.findAttribute(request.getAttribute()).orElseThrow(() -> new Status(404, "Entity " + request.getEntity() + " does not have attribute " + request.getAttribute()));
            RandomAccessReader randomAccessReader = reader = this.instantiateReader(attribute);
            synchronized (randomAccessReader) {
                KeyValue kv = (KeyValue)reader.get(request.getKey(), request.getAttribute(), attribute).orElseThrow(() -> new Status(404, "Key " + request.getKey() + " and/or attribute " + request.getAttribute() + " not found"));
                responseObserver.onNext((Object)Rpc.GetResponse.newBuilder().setStatus(200).setValue(ByteString.copyFrom((byte[])kv.getValueBytes())).build());
            }
            responseObserver.onCompleted();
        }
        catch (Status s) {
            responseObserver.onNext((Object)Rpc.GetResponse.newBuilder().setStatus(s.statusCode).setStatusMessage(s.message).build());
            responseObserver.onCompleted();
        }
        catch (Exception ex) {
            log.error("Failed to process request {}", (Object)request, (Object)ex);
            responseObserver.onNext((Object)Rpc.GetResponse.newBuilder().setStatus(500).setStatusMessage(ex.getMessage()).build());
            responseObserver.onCompleted();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private RandomAccessReader instantiateReader(AttributeDescriptor<?> attr) throws Status {
        Map<AttributeDescriptor<?>, RandomAccessReader> map = this.readerMap;
        synchronized (map) {
            RandomAccessReader reader = this.readerMap.get(attr);
            if (reader == null) {
                AttributeFamilyDescriptor family = this.repo.getFamiliesForAttribute(attr).stream().filter(af -> af.getAccess().canRandomRead()).findAny().orElseThrow(() -> new Status(400, "Attribute " + attr + " has no random access family"));
                RandomAccessReader newReader = (RandomAccessReader)family.getRandomAccessReader().orElseThrow(() -> new Status(500, "Random access family " + family + " has no reader"));
                family.getAttributes().forEach(a -> this.readerMap.put((AttributeDescriptor<?>)a, newReader));
                return newReader;
            }
            return reader;
        }
    }

    private class Status
    extends Exception {
        final int statusCode;
        final String message;

        Status(int statusCode, String message) {
            this.statusCode = statusCode;
            this.message = message;
        }
    }
}

