/*
 * Decompiled with CFR 0.152.
 */
package cz.o2.proxima.server.metrics;

import cz.o2.proxima.metrics.ApproxPercentileMetric;
import cz.o2.proxima.metrics.Metric;
import cz.o2.proxima.metrics.TimeAveragingMetric;
import java.lang.management.ManagementFactory;
import java.time.Duration;
import javax.management.MBeanServer;
import javax.management.ObjectName;

public class Metrics {
    private static final String GROUP = "cz.o2.proxima.server";
    public static final Metric<Double> INGEST_SINGLE = TimeAveragingMetric.of((String)"cz.o2.proxima.server", (String)"ingest-single", (long)1000L);
    public static final Metric<Double> INGEST_BULK = TimeAveragingMetric.of((String)"cz.o2.proxima.server", (String)"ingest-bulk", (long)1000L);
    public static final ApproxPercentileMetric BULK_SIZE = ApproxPercentileMetric.of((String)"cz.o2.proxima.server", (String)"bulk-size", (long)Duration.ofHours(1L).toMillis(), (long)Duration.ofMinutes(5L).toMillis());
    public static final Metric<Double> INGESTS = TimeAveragingMetric.of((String)"cz.o2.proxima.server", (String)"ingests", (long)1000L);
    public static final Metric<Double> COMMIT_LOG_APPEND = TimeAveragingMetric.of((String)"cz.o2.proxima.server", (String)"commit-log-append", (long)1000L);
    public static final Metric<Double> GET_REQUESTS = TimeAveragingMetric.of((String)"cz.o2.proxima.server", (String)"get-requests", (long)1000L);
    public static final Metric<Double> LIST_REQUESTS = TimeAveragingMetric.of((String)"cz.o2.proxima.server", (String)"list-requests", (long)1000L);
    public static final Metric<Double> UPDATE_REQUESTS = TimeAveragingMetric.of((String)"cz.o2.proxima.server", (String)"update-requests", (long)1000L);
    public static final Metric<Double> DELETE_REQUESTS = TimeAveragingMetric.of((String)"cz.o2.proxima.server", (String)"delete-requests", (long)1000L);
    public static final Metric<Double> DELETE_WILDCARD_REQUESTS = TimeAveragingMetric.of((String)"cz.o2.proxima.server", (String)"delete-wildcard-requests", (long)1000L);
    public static final Metric<Double> NON_COMMIT_LOG_UPDATES = TimeAveragingMetric.of((String)"cz.o2.proxima.server", (String)"non-commit-updates", (long)1000L);
    public static final Metric<Double> NON_COMMIT_LOG_DELETES = TimeAveragingMetric.of((String)"cz.o2.proxima.server", (String)"non-commit-deletes", (long)1000L);
    public static final Metric<Double> COMMIT_UPDATE_DISCARDED = TimeAveragingMetric.of((String)"cz.o2.proxima.server", (String)"commits-discarded", (long)1000L);
    public static final Metric<Double> NON_COMMIT_WRITES_RETRIES = TimeAveragingMetric.of((String)"cz.o2.proxima.server", (String)"non-commit-retries", (long)1000L);
    public static final Metric<Double> INVALID_REQUEST = TimeAveragingMetric.of((String)"cz.o2.proxima.server", (String)"invalid-request", (long)1000L);
    public static final Metric<Double> INVALID_ENTITY = TimeAveragingMetric.of((String)"cz.o2.proxima.server", (String)"invalid-entity", (long)1000L);
    public static final Metric<Double> INVALID_ATTRIBUTE = TimeAveragingMetric.of((String)"cz.o2.proxima.server", (String)"invalid-attribute", (long)1000L);
    private static final Metric[] ALL = new Metric[]{INGEST_SINGLE, INGEST_BULK, BULK_SIZE, INGESTS, COMMIT_LOG_APPEND, GET_REQUESTS, LIST_REQUESTS, UPDATE_REQUESTS, DELETE_REQUESTS, DELETE_WILDCARD_REQUESTS, NON_COMMIT_LOG_UPDATES, NON_COMMIT_LOG_DELETES, COMMIT_UPDATE_DISCARDED, NON_COMMIT_WRITES_RETRIES, INVALID_REQUEST, INVALID_ENTITY, INVALID_ATTRIBUTE};

    public static void register() {
        MBeanServer mbs = ManagementFactory.getPlatformMBeanServer();
        try {
            for (Metric m : ALL) {
                ObjectName mxbeanName = new ObjectName(m.getGroup() + "." + m.getName() + ":type=" + m.getClass().getSimpleName());
                mbs.registerMBean(m, mxbeanName);
            }
        }
        catch (Exception ex) {
            throw new RuntimeException(ex);
        }
    }

    private Metrics() {
    }
}

