/*
 * Decompiled with CFR 0.152.
 */
package cz.o2.proxima.beam;

import com.typesafe.config.ConfigFactory;
import cz.o2.proxima.beam.core.BeamDataOperator;
import cz.o2.proxima.example.Example;
import cz.o2.proxima.functional.Consumer;
import cz.o2.proxima.repository.AttributeDescriptor;
import cz.o2.proxima.storage.commitlog.Position;
import cz.o2.proxima.testing.model.Model;
import java.io.Serializable;
import org.apache.beam.sdk.Pipeline;
import org.apache.beam.sdk.extensions.euphoria.core.client.functional.UnaryFunction;
import org.apache.beam.sdk.extensions.euphoria.core.client.operator.CountByKey;
import org.apache.beam.sdk.extensions.euphoria.core.client.operator.hint.OutputHint;
import org.apache.beam.sdk.transforms.windowing.AfterWatermark;
import org.apache.beam.sdk.transforms.windowing.FixedWindows;
import org.apache.beam.sdk.transforms.windowing.Trigger;
import org.apache.beam.sdk.transforms.windowing.WindowFn;
import org.apache.beam.sdk.values.PCollection;
import org.apache.beam.sdk.values.WindowingStrategy;
import org.joda.time.Duration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class ReadMe {
    private static final Logger log = LoggerFactory.getLogger(ReadMe.class);

    private Model createModel() {
        return Model.of(ConfigFactory.defaultApplication());
    }

    private void createStream() {
        Model model = this.createModel();
        BeamDataOperator operator = (BeamDataOperator)model.getRepo().asDataOperator(BeamDataOperator.class, new Consumer[0]);
        Pipeline pipeline = Pipeline.create();
        PCollection input = operator.getStream(pipeline, Position.OLDEST, false, true, new AttributeDescriptor[]{model.getEvent().getDataDescriptor()});
        PCollection counted = CountByKey.of((PCollection)input).keyBy((UnaryFunction & Serializable)el -> model.getEvent().getDataDescriptor().valueOf(el).map(Example.BaseEvent::getProductId).orElse("")).windowBy((WindowFn)FixedWindows.of((Duration)Duration.standardMinutes((long)1L))).triggeredBy((Trigger)AfterWatermark.pastEndOfWindow()).accumulationMode(WindowingStrategy.AccumulationMode.DISCARDING_FIRED_PANES).output(new OutputHint[0]);
    }

    private ReadMe() {
        this.createStream();
    }
}

