/*
 * Decompiled with CFR 0.152.
 */
package cz.o2.proxima.beam.core.io;

import cz.o2.proxima.beam.core.io.AbstractRepositoryCoder;
import cz.o2.proxima.repository.AttributeDescriptor;
import cz.o2.proxima.repository.EntityDescriptor;
import cz.o2.proxima.repository.Repository;
import cz.o2.proxima.repository.RepositoryFactory;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.apache.beam.sdk.coders.Coder;
import org.apache.beam.sdk.coders.CoderException;
import org.apache.beam.sdk.coders.StringUtf8Coder;
import org.apache.beam.sdk.values.TypeDescriptor;

public class AttributeDescriptorCoder
extends AbstractRepositoryCoder<AttributeDescriptor<?>> {
    private static final long serialVersionUID = 1L;
    private static final Coder<String> STRING_CODER = StringUtf8Coder.of();

    public static AttributeDescriptorCoder of(Repository repo) {
        return AttributeDescriptorCoder.of(repo.asFactory());
    }

    public static AttributeDescriptorCoder of(RepositoryFactory factory) {
        return new AttributeDescriptorCoder(factory);
    }

    private AttributeDescriptorCoder(RepositoryFactory factory) {
        super(factory);
    }

    public void encode(AttributeDescriptor<?> value, OutputStream outStream) throws CoderException, IOException {
        STRING_CODER.encode((Object)value.getEntity(), outStream);
        STRING_CODER.encode((Object)value.getName(), outStream);
    }

    public AttributeDescriptor<?> decode(InputStream inStream) throws IOException {
        String entity = (String)STRING_CODER.decode(inStream);
        EntityDescriptor entityDesc = this.repo().getEntity(entity);
        return entityDesc.getAttribute((String)STRING_CODER.decode(inStream));
    }

    public TypeDescriptor<AttributeDescriptor<?>> getEncodedTypeDescriptor() {
        return TypeDescriptor.of(AttributeDescriptor.class);
    }

    public void verifyDeterministic() {
    }
}

