/*
 * Decompiled with CFR 0.152.
 */
package cz.o2.proxima.beam.core.io;

import cz.o2.proxima.beam.core.io.AbstractRepositoryCoder;
import cz.o2.proxima.repository.EntityDescriptor;
import cz.o2.proxima.repository.Repository;
import cz.o2.proxima.repository.RepositoryFactory;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.apache.beam.sdk.coders.Coder;
import org.apache.beam.sdk.coders.CoderException;
import org.apache.beam.sdk.coders.StringUtf8Coder;
import org.apache.beam.sdk.values.TypeDescriptor;

public class EntityDescriptorCoder
extends AbstractRepositoryCoder<EntityDescriptor> {
    private static final long serialVersionUID = 1L;
    private static final Coder<String> STRING_CODER = StringUtf8Coder.of();

    public static EntityDescriptorCoder of(Repository repo) {
        return EntityDescriptorCoder.of(repo.asFactory());
    }

    public static EntityDescriptorCoder of(RepositoryFactory factory) {
        return new EntityDescriptorCoder(factory);
    }

    private EntityDescriptorCoder(RepositoryFactory repositoryFactory) {
        super(repositoryFactory);
    }

    public void encode(EntityDescriptor value, OutputStream outStream) throws CoderException, IOException {
        STRING_CODER.encode((Object)value.getName(), outStream);
    }

    public EntityDescriptor decode(InputStream inStream) throws CoderException, IOException {
        return this.repo().getEntity((String)STRING_CODER.decode(inStream));
    }

    public TypeDescriptor<EntityDescriptor> getEncodedTypeDescriptor() {
        return TypeDescriptor.of(EntityDescriptor.class);
    }

    public void verifyDeterministic() {
    }
}

