/*
 * Decompiled with CFR 0.152.
 */
package cz.o2.proxima.beam.core.io;

import cz.o2.proxima.util.Pair;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Objects;
import org.apache.beam.sdk.coders.Coder;
import org.apache.beam.sdk.coders.CustomCoder;
import org.apache.beam.sdk.values.TypeDescriptor;
import org.apache.beam.sdk.values.TypeParameter;

public class PairCoder<K, V>
extends CustomCoder<Pair<K, V>> {
    private static final long serialVersionUID = 1L;
    private final Coder<K> keyCoder;
    private final Coder<V> valueCoder;

    public static <K, V> PairCoder<K, V> of(Coder<K> keyCoder, Coder<V> valueCoder) {
        return new PairCoder<K, V>(keyCoder, valueCoder);
    }

    public static <K, V> TypeDescriptor<Pair<K, V>> descriptor(TypeDescriptor<K> key, TypeDescriptor<V> value) {
        return new TypeDescriptor<Pair<K, V>>(){}.where(new TypeParameter<K>(){}, key).where(new TypeParameter<V>(){}, value);
    }

    private PairCoder(Coder<K> keyCoder, Coder<V> valueCoder) {
        this.keyCoder = keyCoder;
        this.valueCoder = valueCoder;
    }

    public void encode(Pair<K, V> value, OutputStream outStream) throws IOException {
        this.keyCoder.encode(value.getFirst(), outStream);
        this.valueCoder.encode(value.getSecond(), outStream);
    }

    public Pair<K, V> decode(InputStream inStream) throws IOException {
        return Pair.of((Object)this.keyCoder.decode(inStream), (Object)this.valueCoder.decode(inStream));
    }

    public TypeDescriptor<Pair<K, V>> getEncodedTypeDescriptor() {
        return PairCoder.descriptor(this.keyCoder.getEncodedTypeDescriptor(), this.valueCoder.getEncodedTypeDescriptor());
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof PairCoder)) {
            return false;
        }
        PairCoder other = (PairCoder)((Object)obj);
        return other.keyCoder.equals(this.keyCoder) && other.valueCoder.equals(this.valueCoder);
    }

    public int hashCode() {
        return Objects.hash(this.keyCoder, this.valueCoder);
    }

    public void verifyDeterministic() {
    }

    public Coder<K> getKeyCoder() {
        return this.keyCoder;
    }

    public Coder<V> getValueCoder() {
        return this.valueCoder;
    }
}

