/*
 * Decompiled with CFR 0.152.
 */
package cz.o2.proxima.beam.core.io;

import cz.o2.proxima.repository.AttributeDescriptor;
import cz.o2.proxima.repository.EntityDescriptor;
import cz.o2.proxima.repository.Repository;
import cz.o2.proxima.repository.RepositoryFactory;
import cz.o2.proxima.storage.StreamElement;
import java.io.DataInput;
import java.io.DataInputStream;
import java.io.DataOutput;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import javax.annotation.Nullable;
import org.apache.beam.sdk.coders.CustomCoder;
import org.apache.beam.sdk.values.TypeDescriptor;

public class StreamElementCoder
extends CustomCoder<StreamElement> {
    private static final long serialVersionUID = 1L;
    private final RepositoryFactory repository;

    public static StreamElementCoder of(RepositoryFactory factory) {
        return new StreamElementCoder(factory);
    }

    public static StreamElementCoder of(Repository repository) {
        return new StreamElementCoder(repository.asFactory());
    }

    private StreamElementCoder(RepositoryFactory repository) {
        this.repository = repository;
    }

    public void encode(StreamElement value, OutputStream outStream) throws IOException {
        DataOutputStream output = new DataOutputStream(outStream);
        output.writeUTF(value.getEntityDescriptor().getName());
        output.writeUTF(value.getUuid());
        output.writeUTF(value.getKey());
        Type type = value.isDelete() ? (value.isDeleteWildcard() ? Type.DELETE_WILDCARD : Type.DELETE) : Type.UPDATE;
        output.writeInt(type.ordinal());
        String attribute = value.getAttribute();
        output.writeUTF(attribute == null ? value.getAttributeDescriptor().getName() : attribute);
        output.writeLong(value.getStamp());
        StreamElementCoder.writeBytes(value.getValue(), output);
    }

    public StreamElement decode(InputStream inStream) throws IOException {
        DataInputStream input = new DataInputStream(inStream);
        String entityName = input.readUTF();
        EntityDescriptor entityDescriptor = (EntityDescriptor)this.repository.apply().findEntity(entityName).orElseThrow(() -> new IOException(String.format("Unable to find entity [%s].", entityName)));
        String uuid = input.readUTF();
        String key = input.readUTF();
        int typeOrdinal = input.readInt();
        Type type = Type.values()[typeOrdinal];
        String attributeName = input.readUTF();
        if (type.equals((Object)Type.DELETE_WILDCARD)) {
            attributeName = attributeName.substring(0, attributeName.length() - 1);
        }
        String attribute = attributeName;
        AttributeDescriptor attributeDescriptor = (AttributeDescriptor)entityDescriptor.findAttribute(attribute, true).orElseThrow(() -> new IOException(String.format("Unable to find attribute [%s] of entity [%s].", attribute, entityName)));
        long stamp = input.readLong();
        byte[] value = StreamElementCoder.readBytes(input);
        switch (type) {
            case DELETE_WILDCARD: {
                return StreamElement.deleteWildcard((EntityDescriptor)entityDescriptor, (AttributeDescriptor)attributeDescriptor, (String)uuid, (String)key, (long)stamp);
            }
            case DELETE: {
                return StreamElement.delete((EntityDescriptor)entityDescriptor, (AttributeDescriptor)attributeDescriptor, (String)uuid, (String)key, (String)attribute, (long)stamp);
            }
            case UPDATE: {
                return StreamElement.upsert((EntityDescriptor)entityDescriptor, (AttributeDescriptor)attributeDescriptor, (String)uuid, (String)key, (String)attribute, (long)stamp, (byte[])value);
            }
        }
        throw new IllegalStateException("Unknown type " + (Object)((Object)type));
    }

    public TypeDescriptor<StreamElement> getEncodedTypeDescriptor() {
        return TypeDescriptor.of(StreamElement.class);
    }

    private static void writeBytes(@Nullable byte[] value, DataOutput output) throws IOException {
        if (value == null) {
            output.writeInt(-1);
        } else {
            output.writeInt(value.length);
            output.write(value);
        }
    }

    @Nullable
    private static byte[] readBytes(DataInput input) throws IOException {
        int length = input.readInt();
        if (length >= 0) {
            byte[] ret = new byte[length];
            input.readFully(ret);
            return ret;
        }
        return null;
    }

    public boolean equals(Object obj) {
        return obj instanceof StreamElementCoder;
    }

    public int hashCode() {
        return 0;
    }

    public void verifyDeterministic() {
    }

    private static enum Type {
        UPDATE,
        DELETE,
        DELETE_WILDCARD;

    }
}

