/*
 * Decompiled with CFR 0.152.
 */
package cz.o2.proxima.beam.direct.io;

import cz.o2.proxima.beam.direct.io.AbstractDirectBoundedSource;
import cz.o2.proxima.beam.direct.io.BeamBatchLogReader;
import cz.o2.proxima.direct.batch.BatchLogObservable;
import cz.o2.proxima.direct.core.Partition;
import cz.o2.proxima.repository.AttributeDescriptor;
import cz.o2.proxima.repository.RepositoryFactory;
import cz.o2.proxima.storage.StreamElement;
import java.io.IOException;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import org.apache.beam.sdk.io.BoundedSource;
import org.apache.beam.sdk.options.PipelineOptions;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DirectBatchSource
extends AbstractDirectBoundedSource {
    private static final Logger log = LoggerFactory.getLogger(DirectBatchSource.class);
    private static final long serialVersionUID = 1L;
    private final BatchLogObservable reader;
    private final List<AttributeDescriptor<?>> attrs;
    private final long startStamp;
    private final long endStamp;
    @Nullable
    private final Partition split;

    static DirectBatchSource of(RepositoryFactory factory, BatchLogObservable reader, List<AttributeDescriptor<?>> attrs, long startStamp, long endStamp) {
        return new DirectBatchSource(factory, reader, attrs, startStamp, endStamp);
    }

    private DirectBatchSource(RepositoryFactory factory, BatchLogObservable reader, List<AttributeDescriptor<?>> attrs, long startStamp, long endStamp) {
        super(factory);
        this.reader = Objects.requireNonNull(reader);
        this.attrs = Objects.requireNonNull(attrs);
        this.startStamp = startStamp;
        this.endStamp = endStamp;
        this.split = null;
    }

    private DirectBatchSource(DirectBatchSource parent, Partition split) {
        super(parent.factory);
        this.reader = parent.reader;
        this.attrs = parent.attrs;
        this.startStamp = parent.startStamp;
        this.endStamp = parent.endStamp;
        this.split = split;
    }

    public List<? extends BoundedSource<StreamElement>> split(long desiredBundleSizeBytes, PipelineOptions arg1) throws Exception {
        if (this.split != null) {
            return Arrays.asList(this);
        }
        return this.reader.getPartitions(this.startStamp, this.endStamp).stream().map(p -> new DirectBatchSource(this, (Partition)p)).collect(Collectors.toList());
    }

    public BoundedSource.BoundedReader<StreamElement> createReader(PipelineOptions options) throws IOException {
        return BeamBatchLogReader.of(this, this.reader, this.attrs, this.split, this.startStamp, this.endStamp);
    }
}

