/*
 * Decompiled with CFR 0.152.
 */
package cz.o2.proxima.beam.direct.io;

import cz.o2.proxima.beam.direct.io.AbstractDirectBoundedSource;
import cz.o2.proxima.beam.direct.io.BeamCommitLogReader;
import cz.o2.proxima.direct.commitlog.CommitLogReader;
import cz.o2.proxima.direct.core.Partition;
import cz.o2.proxima.repository.RepositoryFactory;
import cz.o2.proxima.storage.StreamElement;
import cz.o2.proxima.storage.commitlog.Position;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nullable;
import org.apache.beam.sdk.io.BoundedSource;
import org.apache.beam.sdk.options.PipelineOptions;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class DirectBoundedSource
extends AbstractDirectBoundedSource {
    private static final Logger log = LoggerFactory.getLogger(DirectBoundedSource.class);
    private static final long serialVersionUID = 1L;
    private final String name;
    private final CommitLogReader reader;
    private final Position position;
    private final long limit;
    private final Partition partition;

    static DirectBoundedSource of(RepositoryFactory factory, String name, CommitLogReader reader, Position position, long limit) {
        return new DirectBoundedSource(factory, name, reader, position, limit, null);
    }

    DirectBoundedSource(RepositoryFactory factory, String name, CommitLogReader reader, Position position, long limit, @Nullable Partition partition) {
        super(factory);
        this.name = name;
        this.reader = Objects.requireNonNull(reader);
        this.position = position;
        this.limit = limit;
        this.partition = partition;
    }

    public List<BoundedSource<StreamElement>> split(long desiredBundleSizeBytes, PipelineOptions opts) throws Exception {
        if (this.partition != null) {
            return Arrays.asList(new BoundedSource[]{this});
        }
        ArrayList<BoundedSource<StreamElement>> ret = new ArrayList<BoundedSource<StreamElement>>();
        List partitions = this.reader.getPartitions();
        for (Partition p : partitions) {
            ret.add(new DirectBoundedSource(this.factory, this.name, this.reader, this.position, this.limit / (long)partitions.size(), p));
        }
        log.debug("Split source {} into {}", (Object)this, ret);
        return ret;
    }

    public BoundedSource.BoundedReader<StreamElement> createReader(PipelineOptions options) throws IOException {
        log.debug("Creating reader reading from position {} on partition {}", (Object)this.position, (Object)this.partition);
        return BeamCommitLogReader.bounded(this, this.name, this.reader, this.position, this.limit, this.partition);
    }
}

