/*
 * Decompiled with CFR 0.152.
 */
package cz.o2.proxima.beam.direct.io;

import cz.o2.proxima.beam.core.BeamDataOperator;
import cz.o2.proxima.beam.core.DataAccessor;
import cz.o2.proxima.beam.direct.io.DirectDataAccessorWrapper;
import cz.o2.proxima.direct.core.DataAccessorFactory;
import cz.o2.proxima.direct.core.DirectDataOperator;
import cz.o2.proxima.repository.DataOperator;
import cz.o2.proxima.repository.EntityDescriptor;
import cz.o2.proxima.repository.Repository;
import cz.o2.proxima.storage.internal.AbstractDataAccessorFactory;
import java.net.URI;
import java.util.Map;
import javax.annotation.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DirectDataAccessorFactory
implements cz.o2.proxima.beam.core.DataAccessorFactory {
    private static final Logger log = LoggerFactory.getLogger(DirectDataAccessorFactory.class);
    private static final long serialVersionUID = 1L;
    @Nullable
    private transient DirectDataOperator direct;

    public void setup(Repository repo) {
        this.direct = repo.hasOperator("direct") ? (DirectDataOperator)repo.getOrCreateOperator(DirectDataOperator.class) : null;
    }

    public AbstractDataAccessorFactory.Accept accepts(URI uri) {
        return this.direct != null && this.direct.getAccessorFactory(uri).isPresent() ? AbstractDataAccessorFactory.Accept.ACCEPT_IF_NEEDED : AbstractDataAccessorFactory.Accept.REJECT;
    }

    public DataAccessor createAccessor(BeamDataOperator op, EntityDescriptor entity, URI uri, Map<String, Object> cfg) {
        if (op.hasDirect()) {
            cz.o2.proxima.direct.core.DataAccessor directAccessor = (cz.o2.proxima.direct.core.DataAccessor)((DataAccessorFactory)op.getDirect().getAccessorFactory(uri).orElseThrow(() -> new IllegalStateException("Missing directLoader?"))).createAccessor((DataOperator)op.getDirect(), entity, uri, cfg);
            return new DirectDataAccessorWrapper(op.getRepository(), directAccessor, uri, op.getDirect().getContext());
        }
        throw new IllegalStateException("Missing direct operator. Cannot create accessor");
    }
}

