/*
 * Decompiled with CFR 0.152.
 */
package com.google.api.client.auth.oauth;

import com.google.api.client.auth.oauth.OAuthHmacSha256Signer;
import java.security.GeneralSecurityException;
import org.junit.Assert;
import org.junit.Test;

public class OAuthHmacSha256SignerTest {
    @Test
    public void testComputeSignatureWithNullSecrets() throws GeneralSecurityException {
        OAuthHmacSha256Signer signer = new OAuthHmacSha256Signer(null);
        String expectedSignature = "l/Es58FI4BtBciSH9XtY/5jXFee70v7/rPiQgEpvv00=";
        Assert.assertEquals((Object)expectedSignature, (Object)signer.computeSignature("baseString"));
    }

    @Test
    public void testComputeSignatureWithNullClientSecret() throws GeneralSecurityException {
        OAuthHmacSha256Signer signer = new OAuthHmacSha256Signer(null);
        signer.setTokenSecret("tokenSecret");
        String expectedSignature = "PgNWY2qQ53qvk3WySct/f037/usxMGpNDjmJeISmgCM=";
        Assert.assertEquals((Object)expectedSignature, (Object)signer.computeSignature("baseString"));
    }

    @Test
    public void testComputeSignatureWithNullTokenSecret() throws GeneralSecurityException {
        OAuthHmacSha256Signer signer = new OAuthHmacSha256Signer("clientSecret");
        String expectedSignature = "cNrT2sqgyQ+dd7rbAhYBFBk8o82/yZyZkavqsfMDqpo=";
        Assert.assertEquals((Object)expectedSignature, (Object)signer.computeSignature("baseString"));
    }

    @Test
    public void testComputeSignature() throws GeneralSecurityException {
        OAuthHmacSha256Signer signer = new OAuthHmacSha256Signer("clientSecret");
        signer.setTokenSecret("tokenSecret");
        String expectedSignature = "sfnrBcfwccOs2mpc60VQ5zXx5ReP/46lgUcBhU2a4PM=";
        Assert.assertEquals((Object)expectedSignature, (Object)signer.computeSignature("baseString"));
    }
}

