/*
 * Decompiled with CFR 0.152.
 */
package com.google.api.client.googleapis;

import com.google.api.client.googleapis.MethodOverride;
import com.google.api.client.http.GenericUrl;
import com.google.api.client.http.HttpRequest;
import com.google.api.client.http.HttpTransport;
import com.google.api.client.http.UrlEncodedContent;
import com.google.api.client.testing.http.HttpTesting;
import com.google.api.client.testing.http.MockHttpTransport;
import cz.o2.proxima.internal.shaded.com.google.common.collect.ImmutableList;
import cz.o2.proxima.internal.shaded.com.google.common.collect.ImmutableSet;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Arrays;
import java.util.Collection;
import java.util.Set;
import junit.framework.TestCase;

public class MethodOverrideTest
extends TestCase {
    private static final ImmutableList<String> OVERRIDDEN_METHODS = ImmutableList.of((Object)"FOO", (Object)"DELETE", (Object)"HEAD", (Object)"OPTIONS", (Object)"PATCH", (Object)"PUT", (Object)"TRACE");
    private static final ImmutableList<String> SUPPORTED_METHODS = ImmutableList.builder().addAll(OVERRIDDEN_METHODS).add((Object[])new String[]{"GET", "POST"}).build();

    public MethodOverrideTest(String name) {
        super(name);
    }

    public void testIntercept() throws Exception {
        this.subtestIntercept((Collection<String>)ImmutableSet.of(), (HttpTransport)new MockHttpTransport(), new MethodOverride());
        this.subtestIntercept((Collection<String>)OVERRIDDEN_METHODS, (HttpTransport)new MockHttpTransport(), new MethodOverride.Builder().setOverrideAllMethods(true).build());
        this.subtestIntercept((Collection<String>)OVERRIDDEN_METHODS, (HttpTransport)new MockHttpTransport.Builder().setSupportedMethods((Set)ImmutableSet.of((Object)"GET", (Object)"POST")).build(), new MethodOverride());
    }

    private void subtestIntercept(Collection<String> methodsThatShouldOverride, HttpTransport transport, MethodOverride interceptor) throws Exception {
        for (String requestMethod : SUPPORTED_METHODS) {
            this.subtestIntercept(methodsThatShouldOverride.contains(requestMethod), transport, interceptor, requestMethod);
        }
    }

    private void subtestIntercept(boolean shouldOverride, HttpTransport transport, MethodOverride interceptor, String requestMethod) throws Exception {
        HttpRequest request = transport.createRequestFactory().buildRequest(requestMethod, HttpTesting.SIMPLE_GENERIC_URL, null);
        interceptor.intercept(request);
        MethodOverrideTest.assertEquals((String)requestMethod, (String)(shouldOverride ? "POST" : requestMethod), (String)request.getRequestMethod());
        MethodOverrideTest.assertEquals((String)requestMethod, (Object)(shouldOverride ? requestMethod : null), (Object)request.getHeaders().get((Object)"X-HTTP-Method-Override"));
    }

    public void testInterceptMaxLength() throws IOException {
        MockHttpTransport transport = new MockHttpTransport();
        GenericUrl url = new GenericUrl("http://google.com/");
        url.set("a", (Object)"foo");
        HttpRequest request = transport.createRequestFactory().buildGetRequest(HttpTesting.SIMPLE_GENERIC_URL);
        new MethodOverride().intercept(request);
        MethodOverrideTest.assertEquals((String)"GET", (String)request.getRequestMethod());
        MethodOverrideTest.assertNull((Object)request.getHeaders().get((Object)"X-HTTP-Method-Override"));
        MethodOverrideTest.assertNull((Object)request.getContent());
        char[] arr = new char[2048];
        Arrays.fill(arr, 'x');
        url.set("a", (Object)new String(arr));
        request.setUrl(url);
        new MethodOverride().intercept(request);
        MethodOverrideTest.assertEquals((String)"POST", (String)request.getRequestMethod());
        MethodOverrideTest.assertEquals((Object)"GET", (Object)request.getHeaders().get((Object)"X-HTTP-Method-Override"));
        MethodOverrideTest.assertEquals((Object)HttpTesting.SIMPLE_GENERIC_URL, (Object)request.getUrl());
        char[] arr2 = new char[arr.length + 2];
        Arrays.fill(arr2, 'x');
        arr2[0] = 97;
        arr2[1] = 61;
        UrlEncodedContent content = (UrlEncodedContent)request.getContent();
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        content.writeTo((OutputStream)out);
        MethodOverrideTest.assertEquals((String)new String(arr2), (String)out.toString());
    }
}

