/*
 * Decompiled with CFR 0.152.
 */
package com.google.api.client.googleapis.auth.oauth2;

import com.google.api.client.googleapis.auth.oauth2.GoogleCredential;
import com.google.api.client.googleapis.testing.auth.oauth2.MockTokenServerTransport;
import com.google.api.client.http.HttpTransport;
import com.google.api.client.json.GenericJson;
import com.google.api.client.json.JsonFactory;
import com.google.api.client.json.gson.GsonFactory;
import com.google.api.client.testing.http.MockHttpTransport;
import com.google.api.client.testing.util.SecurityTestUtils;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.security.PrivateKey;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import junit.framework.TestCase;
import org.junit.Assert;

public class GoogleCredentialTest
extends TestCase {
    private static final JsonFactory JSON_FACTORY = new GsonFactory();
    private static final Collection<String> SCOPES = Collections.unmodifiableCollection(Arrays.asList("scope1", "scope2"));
    private static final Collection<String> EMPTY_SCOPES = Collections.emptyList();
    private static final String SA_KEY_TEXT = "-----BEGIN PRIVATE KEY-----\nMIICdgIBADANBgkqhkiG9w0BAQEFAASCAmAwggJcAgEAAoGBALX0PQoe1igW12ikv1bN/r9lN749y2ijmbc/mFHPyS3hNTyOCjDvBbXYbDhQJzWVUikh4mvGBA07qTj79Xc3yBDfKP2IeyYQIFe0t0zkd7R9Zdn98Y2rIQC47aAbDfubtkU1U72t4zL11kHvoa0/RuFZjncvlr42X7be7lYh4p3NAgMBAAECgYASk5wDw4Az2ZkmeuN6Fk/y9H+Lcb2pskJIXjrL533vrDWGOC48LrsThMQPv8cxBky8HFSEklPpkfTF95tpD43iVwJRB/GrCtGTw65IfJ4/tI09h6zGc4yqvIo1cHX/LQ+SxKLGyir/dQM925rGt/VojxY5ryJR7GLbCzxPnJm/oQJBANwOCO6D2hy1LQYJhXh7O+RLtA/tSnT1xyMQsGT+uUCMiKS2bSKx2wxo9k7h3OegNJIu1q6nZ6AbxDK8H3+d0dUCQQDTrPSXagBxzp8PecbaCHjzNRSQE2in81qYnrAFNB4o3DpHyMMY6s5ALLeHKscEWnqP8Ur6X4PvzZecCWU9BKAZAkAutLPknAuxSCsUOvUfS1i87ex77Ot+w6POp34pEX+UWb+u5iFn2cQacDTHLV1LtE80L8jVLSbrbrlH43H0DjU5AkEAgidhycxS86dxpEljnOMCw8CKoUBd5I880IUahEiUltk7OLJYS/Ts1wbn3kPOVX3wyJs8WBDtBkFrDHW2ezth2QJADj3e1YhMVdjJW5jqwlD/VNddGjgzyunmiZg0uOXsHXbytYmsA545S8KRQFaJKFXYYFo2kOjqOiC1T2cAzMDjCQ==\n-----END PRIVATE KEY-----\n";
    private static final String SA_KEY_ID = "key_id";

    public void testRefreshToken_ServiceAccounts() throws Exception {
        String serviceAccountEmail = "36680232662-vrd7ji19q3ne0ah2csanun6bnr@developer.gserviceaccount.com";
        String accessToken = "1/MkSJoj1xsli0AccessToken_NKPY2";
        MockTokenServerTransport transport = new MockTokenServerTransport();
        transport.addServiceAccount("36680232662-vrd7ji19q3ne0ah2csanun6bnr@developer.gserviceaccount.com", "1/MkSJoj1xsli0AccessToken_NKPY2");
        GoogleCredential credential = new GoogleCredential.Builder().setServiceAccountId("36680232662-vrd7ji19q3ne0ah2csanun6bnr@developer.gserviceaccount.com").setServiceAccountScopes(SCOPES).setServiceAccountPrivateKey((PrivateKey)SecurityTestUtils.newRsaPrivateKey()).setTransport((HttpTransport)transport).setJsonFactory(JSON_FACTORY).build();
        GoogleCredentialTest.assertTrue((boolean)credential.refreshToken());
        GoogleCredentialTest.assertEquals((String)"1/MkSJoj1xsli0AccessToken_NKPY2", (String)credential.getAccessToken());
    }

    public void testRefreshToken_User() throws Exception {
        String accessToken = "1/MkSJoj1xsli0AccessToken_NKPY2";
        String clientSecret = "jakuaL9YyieakhECKL2SwZcu";
        String clientId = "ya29.1.AADtN_UtlxN3PuGAxrN2XQnZTVRvDyVWnYq4I6dws";
        String refreshToken = "1/Tl6awhpFjkMkSJoj1xsli0H2eL5YsMgU_NKPY2TyGWY";
        MockTokenServerTransport transport = new MockTokenServerTransport();
        transport.addClient("ya29.1.AADtN_UtlxN3PuGAxrN2XQnZTVRvDyVWnYq4I6dws", "jakuaL9YyieakhECKL2SwZcu");
        transport.addRefreshToken("1/Tl6awhpFjkMkSJoj1xsli0H2eL5YsMgU_NKPY2TyGWY", "1/MkSJoj1xsli0AccessToken_NKPY2");
        GoogleCredential credential = new GoogleCredential.Builder().setClientSecrets("ya29.1.AADtN_UtlxN3PuGAxrN2XQnZTVRvDyVWnYq4I6dws", "jakuaL9YyieakhECKL2SwZcu").setTransport((HttpTransport)transport).setJsonFactory(JSON_FACTORY).build();
        credential.setRefreshToken("1/Tl6awhpFjkMkSJoj1xsli0H2eL5YsMgU_NKPY2TyGWY");
        GoogleCredentialTest.assertTrue((boolean)credential.refreshToken());
        GoogleCredentialTest.assertEquals((String)"1/MkSJoj1xsli0AccessToken_NKPY2", (String)credential.getAccessToken());
    }

    public void testCreateScoped() throws Exception {
        String serviceAccountEmail = "36680232662-vrd7ji19q3ne0ah2csanun6bnr@developer.gserviceaccount.com";
        String accessToken = "1/MkSJoj1xsli0AccessToken_NKPY2";
        MockTokenServerTransport transport = new MockTokenServerTransport();
        transport.addServiceAccount("36680232662-vrd7ji19q3ne0ah2csanun6bnr@developer.gserviceaccount.com", "1/MkSJoj1xsli0AccessToken_NKPY2");
        GoogleCredential credential = new GoogleCredential.Builder().setServiceAccountId("36680232662-vrd7ji19q3ne0ah2csanun6bnr@developer.gserviceaccount.com").setServiceAccountScopes(EMPTY_SCOPES).setServiceAccountPrivateKey((PrivateKey)SecurityTestUtils.newRsaPrivateKey()).setTransport((HttpTransport)transport).setJsonFactory(JSON_FACTORY).build();
        GoogleCredentialTest.assertTrue((boolean)credential.createScopedRequired());
        try {
            credential.refreshToken();
            GoogleCredentialTest.fail((String)"Should not be able to refresh token without scopes.");
        }
        catch (Exception exception) {
            // empty catch block
        }
        GoogleCredential scopedCredential = credential.createScoped(SCOPES);
        GoogleCredentialTest.assertFalse((boolean)scopedCredential.createScopedRequired());
        GoogleCredentialTest.assertNotSame((Object)credential, (Object)scopedCredential);
        GoogleCredentialTest.assertTrue((boolean)scopedCredential.refreshToken());
        GoogleCredentialTest.assertEquals((String)"1/MkSJoj1xsli0AccessToken_NKPY2", (String)scopedCredential.getAccessToken());
        GoogleCredentialTest.assertSame((Object)credential.getTransport(), (Object)scopedCredential.getTransport());
        GoogleCredentialTest.assertSame((Object)credential.getJsonFactory(), (Object)scopedCredential.getJsonFactory());
        GoogleCredentialTest.assertSame((Object)credential.getServiceAccountId(), (Object)scopedCredential.getServiceAccountId());
        GoogleCredentialTest.assertSame((Object)credential.getServiceAccountUser(), (Object)scopedCredential.getServiceAccountUser());
        GoogleCredentialTest.assertSame((Object)credential.getServiceAccountPrivateKey(), (Object)scopedCredential.getServiceAccountPrivateKey());
    }

    public void testCreateScopesNotSet() throws Exception {
        String serviceAccountEmail = "36680232662-vrd7ji19q3ne0ah2csanun6bnr@developer.gserviceaccount.com";
        String accessToken = "1/MkSJoj1xsli0AccessToken_NKPY2";
        MockTokenServerTransport transport = new MockTokenServerTransport();
        transport.addServiceAccount("36680232662-vrd7ji19q3ne0ah2csanun6bnr@developer.gserviceaccount.com", "1/MkSJoj1xsli0AccessToken_NKPY2");
        GoogleCredential credential = new GoogleCredential.Builder().setServiceAccountId("36680232662-vrd7ji19q3ne0ah2csanun6bnr@developer.gserviceaccount.com").setServiceAccountPrivateKey((PrivateKey)SecurityTestUtils.newRsaPrivateKey()).setTransport((HttpTransport)transport).setJsonFactory(JSON_FACTORY).build();
        GoogleCredentialTest.assertTrue((boolean)credential.getServiceAccountScopes().isEmpty());
    }

    public void testGetApplicationDefaultNullTransportThrows() throws IOException {
        try {
            GoogleCredential.getApplicationDefault(null, (JsonFactory)JSON_FACTORY);
            GoogleCredentialTest.fail();
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
    }

    public void testGetApplicationDefaultNullJsonFactoryThrows() throws IOException {
        MockHttpTransport transport = new MockHttpTransport();
        try {
            GoogleCredential.getApplicationDefault((HttpTransport)transport, null);
            GoogleCredentialTest.fail();
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
    }

    public void testFromStreamNullTransportThrows() throws IOException {
        ByteArrayInputStream stream = new ByteArrayInputStream("foo".getBytes());
        try {
            GoogleCredential.fromStream((InputStream)stream, null, (JsonFactory)JSON_FACTORY);
            GoogleCredentialTest.fail();
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
    }

    public void testFromStreamNullJsonFactoryThrows() throws IOException {
        MockHttpTransport transport = new MockHttpTransport();
        ByteArrayInputStream stream = new ByteArrayInputStream("foo".getBytes());
        try {
            GoogleCredential.fromStream((InputStream)stream, (HttpTransport)transport, null);
            GoogleCredentialTest.fail();
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
    }

    public void testFromStreamNullStreamThrows() throws IOException {
        MockHttpTransport transport = new MockHttpTransport();
        try {
            GoogleCredential.fromStream(null, (HttpTransport)transport, (JsonFactory)JSON_FACTORY);
            GoogleCredentialTest.fail();
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
    }

    public void testFromStreamServiceAccount() throws IOException {
        String accessToken = "1/MkSJoj1xsli0AccessToken_NKPY2";
        String serviceAccountId = "36680232662-vrd7ji19qe3nelgchd0ah2csanun6bnr.apps.googleusercontent.com";
        String serviceAccountEmail = "36680232662-vrd7ji19qgchd0ah2csanun6bnr@developer.gserviceaccount.com";
        MockTokenServerTransport transport = new MockTokenServerTransport();
        transport.addServiceAccount("36680232662-vrd7ji19qgchd0ah2csanun6bnr@developer.gserviceaccount.com", "1/MkSJoj1xsli0AccessToken_NKPY2");
        GenericJson serviceAccountContents = new GenericJson();
        serviceAccountContents.setFactory(JSON_FACTORY);
        serviceAccountContents.put("client_id", (Object)"36680232662-vrd7ji19qe3nelgchd0ah2csanun6bnr.apps.googleusercontent.com");
        serviceAccountContents.put("client_email", (Object)"36680232662-vrd7ji19qgchd0ah2csanun6bnr@developer.gserviceaccount.com");
        serviceAccountContents.put("private_key", (Object)SA_KEY_TEXT);
        serviceAccountContents.put("private_key_id", (Object)SA_KEY_ID);
        serviceAccountContents.put("type", (Object)"service_account");
        String json = serviceAccountContents.toPrettyString();
        ByteArrayInputStream serviceAccountStream = new ByteArrayInputStream(json.getBytes());
        GoogleCredential defaultCredential = GoogleCredential.fromStream((InputStream)serviceAccountStream, (HttpTransport)transport, (JsonFactory)JSON_FACTORY);
        GoogleCredentialTest.assertNotNull((Object)defaultCredential);
        defaultCredential = defaultCredential.createScoped(SCOPES);
        GoogleCredentialTest.assertTrue((boolean)defaultCredential.refreshToken());
        GoogleCredentialTest.assertEquals((String)"1/MkSJoj1xsli0AccessToken_NKPY2", (String)defaultCredential.getAccessToken());
    }

    public void testFromStreamServiceAccountAlternateTokenUri() throws IOException {
        String accessToken = "1/MkSJoj1xsli0AccessToken_NKPY2";
        String serviceAccountId = "36680232662-vrd7ji19qe3nelgchd0ah2csanun6bnr.apps.googleusercontent.com";
        String serviceAccountEmail = "36680232662-vrd7ji19qgchd0ah2csanun6bnr@developer.gserviceaccount.com";
        String tokenServerUrl = "http://another.auth.com/token";
        MockTokenServerTransport transport = new MockTokenServerTransport("http://another.auth.com/token");
        transport.addServiceAccount("36680232662-vrd7ji19qgchd0ah2csanun6bnr@developer.gserviceaccount.com", "1/MkSJoj1xsli0AccessToken_NKPY2");
        GenericJson serviceAccountContents = new GenericJson();
        serviceAccountContents.setFactory(JSON_FACTORY);
        serviceAccountContents.put("client_id", (Object)"36680232662-vrd7ji19qe3nelgchd0ah2csanun6bnr.apps.googleusercontent.com");
        serviceAccountContents.put("client_email", (Object)"36680232662-vrd7ji19qgchd0ah2csanun6bnr@developer.gserviceaccount.com");
        serviceAccountContents.put("private_key", (Object)SA_KEY_TEXT);
        serviceAccountContents.put("private_key_id", (Object)SA_KEY_ID);
        serviceAccountContents.put("type", (Object)"service_account");
        serviceAccountContents.put("token_uri", (Object)"http://another.auth.com/token");
        String json = serviceAccountContents.toPrettyString();
        ByteArrayInputStream serviceAccountStream = new ByteArrayInputStream(json.getBytes());
        GoogleCredential defaultCredential = GoogleCredential.fromStream((InputStream)serviceAccountStream, (HttpTransport)transport, (JsonFactory)JSON_FACTORY);
        GoogleCredentialTest.assertNotNull((Object)defaultCredential);
        GoogleCredentialTest.assertEquals((String)"http://another.auth.com/token", (String)defaultCredential.getTokenServerEncodedUrl());
        defaultCredential = defaultCredential.createScoped(SCOPES);
        GoogleCredentialTest.assertEquals((String)"http://another.auth.com/token", (String)defaultCredential.getTokenServerEncodedUrl());
        GoogleCredentialTest.assertTrue((boolean)defaultCredential.refreshToken());
        GoogleCredentialTest.assertEquals((String)"1/MkSJoj1xsli0AccessToken_NKPY2", (String)defaultCredential.getAccessToken());
    }

    public void testFromStreamServiceAccountMissingClientIdThrows() throws IOException {
        String serviceAccountEmail = "36680232662-vrd7ji19qgchd0ah2csanun6bnr@developer.gserviceaccount.com";
        MockTokenServerTransport transport = new MockTokenServerTransport();
        GenericJson serviceAccountContents = new GenericJson();
        serviceAccountContents.setFactory(JSON_FACTORY);
        serviceAccountContents.put("client_email", (Object)"36680232662-vrd7ji19qgchd0ah2csanun6bnr@developer.gserviceaccount.com");
        serviceAccountContents.put("private_key", (Object)SA_KEY_TEXT);
        serviceAccountContents.put("private_key_id", (Object)SA_KEY_ID);
        serviceAccountContents.put("type", (Object)"service_account");
        String json = serviceAccountContents.toPrettyString();
        ByteArrayInputStream serviceAccountStream = new ByteArrayInputStream(json.getBytes());
        try {
            GoogleCredential.fromStream((InputStream)serviceAccountStream, (HttpTransport)transport, (JsonFactory)JSON_FACTORY);
            GoogleCredentialTest.fail();
        }
        catch (IOException expected) {
            GoogleCredentialTest.assertTrue((boolean)expected.getMessage().contains("client_id"));
        }
    }

    public void testFromStreamServiceAccountMissingClientEmailThrows() throws IOException {
        String serviceAccountId = "36680232662-vrd7ji19qe3nelgchd0ah2csanun6bnr.apps.googleusercontent.com";
        MockTokenServerTransport transport = new MockTokenServerTransport();
        GenericJson serviceAccountContents = new GenericJson();
        serviceAccountContents.setFactory(JSON_FACTORY);
        serviceAccountContents.put("client_id", (Object)"36680232662-vrd7ji19qe3nelgchd0ah2csanun6bnr.apps.googleusercontent.com");
        serviceAccountContents.put("private_key", (Object)SA_KEY_TEXT);
        serviceAccountContents.put("private_key_id", (Object)SA_KEY_ID);
        serviceAccountContents.put("type", (Object)"service_account");
        String json = serviceAccountContents.toPrettyString();
        ByteArrayInputStream serviceAccountStream = new ByteArrayInputStream(json.getBytes());
        try {
            GoogleCredential.fromStream((InputStream)serviceAccountStream, (HttpTransport)transport, (JsonFactory)JSON_FACTORY);
            GoogleCredentialTest.fail();
        }
        catch (IOException expected) {
            GoogleCredentialTest.assertTrue((boolean)expected.getMessage().contains("client_email"));
        }
    }

    public void testFromStreamServiceAccountMissingPrivateKeyThrows() throws IOException {
        String serviceAccountId = "36680232662-vrd7ji19qe3nelgchd0ah2csanun6bnr.apps.googleusercontent.com";
        String serviceAccountEmail = "36680232662-vrd7ji19qgchd0ah2csanun6bnr@developer.gserviceaccount.com";
        MockTokenServerTransport transport = new MockTokenServerTransport();
        GenericJson serviceAccountContents = new GenericJson();
        serviceAccountContents.setFactory(JSON_FACTORY);
        serviceAccountContents.put("client_id", (Object)"36680232662-vrd7ji19qe3nelgchd0ah2csanun6bnr.apps.googleusercontent.com");
        serviceAccountContents.put("client_email", (Object)"36680232662-vrd7ji19qgchd0ah2csanun6bnr@developer.gserviceaccount.com");
        serviceAccountContents.put("private_key_id", (Object)SA_KEY_ID);
        serviceAccountContents.put("type", (Object)"service_account");
        String json = serviceAccountContents.toPrettyString();
        ByteArrayInputStream serviceAccountStream = new ByteArrayInputStream(json.getBytes());
        try {
            GoogleCredential.fromStream((InputStream)serviceAccountStream, (HttpTransport)transport, (JsonFactory)JSON_FACTORY);
            GoogleCredentialTest.fail();
        }
        catch (IOException expected) {
            GoogleCredentialTest.assertTrue((boolean)expected.getMessage().contains("private_key"));
        }
    }

    public void testFromStreamServiceAccountMissingPrivateKeyIdThrows() throws IOException {
        String serviceAccountId = "36680232662-vrd7ji19qe3nelgchd0ah2csanun6bnr.apps.googleusercontent.com";
        String serviceAccountEmail = "36680232662-vrd7ji19qgchd0ah2csanun6bnr@developer.gserviceaccount.com";
        MockTokenServerTransport transport = new MockTokenServerTransport();
        GenericJson serviceAccountContents = new GenericJson();
        serviceAccountContents.setFactory(JSON_FACTORY);
        serviceAccountContents.put("client_id", (Object)"36680232662-vrd7ji19qe3nelgchd0ah2csanun6bnr.apps.googleusercontent.com");
        serviceAccountContents.put("client_email", (Object)"36680232662-vrd7ji19qgchd0ah2csanun6bnr@developer.gserviceaccount.com");
        serviceAccountContents.put("private_key", (Object)SA_KEY_TEXT);
        serviceAccountContents.put("type", (Object)"service_account");
        String json = serviceAccountContents.toPrettyString();
        ByteArrayInputStream serviceAccountStream = new ByteArrayInputStream(json.getBytes());
        try {
            GoogleCredential.fromStream((InputStream)serviceAccountStream, (HttpTransport)transport, (JsonFactory)JSON_FACTORY);
            GoogleCredentialTest.fail();
        }
        catch (IOException expected) {
            GoogleCredentialTest.assertTrue((boolean)expected.getMessage().contains("private_key_id"));
        }
    }

    public void testFromStreamUser() throws IOException {
        String accessToken = "1/MkSJoj1xsli0AccessToken_NKPY2";
        String clientSecret = "jakuaL9YyieakhECKL2SwZcu";
        String clientId = "ya29.1.AADtN_UtlxN3PSc5yhCqfA9nDFp1dfvH8cruGAxrN2XQnZTVRvDyVWnYq4I6dws";
        String refreshToken = "1/Tl6awhpFjkMkSJoj1xsli0H2eL5YsMgU_NKPY2TyGWY";
        MockTokenServerTransport transport = new MockTokenServerTransport();
        transport.addClient("ya29.1.AADtN_UtlxN3PSc5yhCqfA9nDFp1dfvH8cruGAxrN2XQnZTVRvDyVWnYq4I6dws", "jakuaL9YyieakhECKL2SwZcu");
        transport.addRefreshToken("1/Tl6awhpFjkMkSJoj1xsli0H2eL5YsMgU_NKPY2TyGWY", "1/MkSJoj1xsli0AccessToken_NKPY2");
        String json = GoogleCredentialTest.createUserJson("ya29.1.AADtN_UtlxN3PSc5yhCqfA9nDFp1dfvH8cruGAxrN2XQnZTVRvDyVWnYq4I6dws", "jakuaL9YyieakhECKL2SwZcu", "1/Tl6awhpFjkMkSJoj1xsli0H2eL5YsMgU_NKPY2TyGWY");
        ByteArrayInputStream userStream = new ByteArrayInputStream(json.getBytes());
        GoogleCredential defaultCredential = GoogleCredential.fromStream((InputStream)userStream, (HttpTransport)transport, (JsonFactory)JSON_FACTORY);
        GoogleCredentialTest.assertNotNull((Object)defaultCredential);
        GoogleCredentialTest.assertEquals((String)"1/Tl6awhpFjkMkSJoj1xsli0H2eL5YsMgU_NKPY2TyGWY", (String)defaultCredential.getRefreshToken());
        GoogleCredentialTest.assertTrue((boolean)defaultCredential.refreshToken());
        GoogleCredentialTest.assertEquals((String)"1/MkSJoj1xsli0AccessToken_NKPY2", (String)defaultCredential.getAccessToken());
    }

    public void testFromStreamUsertMissingClientIdThrows() throws IOException {
        String accessToken = "1/MkSJoj1xsli0AccessToken_NKPY2";
        String clientSecret = "jakuaL9YyieakhECKL2SwZcu";
        String clientId = "ya29.1.AADtN_UtlxN3PSruGAxrN2XQnZTVRvDyVWnYq4I6dws";
        String refreshToken = "1/Tl6awhpFjkMkSJoj1xsli0H2eL5YsMgU_NKPY2TyGWY";
        MockTokenServerTransport transport = new MockTokenServerTransport();
        transport.addClient("ya29.1.AADtN_UtlxN3PSruGAxrN2XQnZTVRvDyVWnYq4I6dws", "jakuaL9YyieakhECKL2SwZcu");
        transport.addRefreshToken("1/Tl6awhpFjkMkSJoj1xsli0H2eL5YsMgU_NKPY2TyGWY", "1/MkSJoj1xsli0AccessToken_NKPY2");
        String json = GoogleCredentialTest.createUserJson(null, "jakuaL9YyieakhECKL2SwZcu", "1/Tl6awhpFjkMkSJoj1xsli0H2eL5YsMgU_NKPY2TyGWY");
        ByteArrayInputStream userStream = new ByteArrayInputStream(json.getBytes());
        try {
            GoogleCredential.fromStream((InputStream)userStream, (HttpTransport)transport, (JsonFactory)JSON_FACTORY);
            GoogleCredentialTest.fail();
        }
        catch (IOException expected) {
            GoogleCredentialTest.assertTrue((boolean)expected.getMessage().contains("client_id"));
        }
    }

    public void testFromStreamUsertMissingClientSecretThrows() throws IOException {
        String accessToken = "1/MkSJoj1xsli0AccessToken_NKPY2";
        String clientSecret = "jakuaL9YyieakhECKL2SwZcu";
        String clientId = "ya29.1.AADtN_UtlxN3PSruGAxrN2XQnZTVRvDyVWnYq4I6dws";
        String refreshToken = "1/Tl6awhpFjkMkSJoj1xsli0H2eL5YsMgU_NKPY2TyGWY";
        MockTokenServerTransport transport = new MockTokenServerTransport();
        transport.addClient("ya29.1.AADtN_UtlxN3PSruGAxrN2XQnZTVRvDyVWnYq4I6dws", "jakuaL9YyieakhECKL2SwZcu");
        transport.addRefreshToken("1/Tl6awhpFjkMkSJoj1xsli0H2eL5YsMgU_NKPY2TyGWY", "1/MkSJoj1xsli0AccessToken_NKPY2");
        String json = GoogleCredentialTest.createUserJson("ya29.1.AADtN_UtlxN3PSruGAxrN2XQnZTVRvDyVWnYq4I6dws", null, "1/Tl6awhpFjkMkSJoj1xsli0H2eL5YsMgU_NKPY2TyGWY");
        ByteArrayInputStream userStream = new ByteArrayInputStream(json.getBytes());
        try {
            GoogleCredential.fromStream((InputStream)userStream, (HttpTransport)transport, (JsonFactory)JSON_FACTORY);
            GoogleCredentialTest.fail();
        }
        catch (IOException expected) {
            GoogleCredentialTest.assertTrue((boolean)expected.getMessage().contains("client_secret"));
        }
    }

    public void testFromStreamUsertMissingRefreshTokenThrows() throws IOException {
        String accessToken = "1/MkSJoj1xsli0AccessToken_NKPY2";
        String clientSecret = "jakuaL9YyieakhECKL2SwZcu";
        String clientId = "ya29.1.AADtN_UtlxN3PSruGAxrN2XQnZTVRvDyVWnYq4I6dws";
        String refreshToken = "1/Tl6awhpFjkMkSJoj1xsli0H2eL5YsMgU_NKPY2TyGWY";
        MockTokenServerTransport transport = new MockTokenServerTransport();
        transport.addClient("ya29.1.AADtN_UtlxN3PSruGAxrN2XQnZTVRvDyVWnYq4I6dws", "jakuaL9YyieakhECKL2SwZcu");
        transport.addRefreshToken("1/Tl6awhpFjkMkSJoj1xsli0H2eL5YsMgU_NKPY2TyGWY", "1/MkSJoj1xsli0AccessToken_NKPY2");
        String json = GoogleCredentialTest.createUserJson("ya29.1.AADtN_UtlxN3PSruGAxrN2XQnZTVRvDyVWnYq4I6dws", "jakuaL9YyieakhECKL2SwZcu", null);
        ByteArrayInputStream userStream = new ByteArrayInputStream(json.getBytes());
        try {
            GoogleCredential.fromStream((InputStream)userStream, (HttpTransport)transport, (JsonFactory)JSON_FACTORY);
            GoogleCredentialTest.fail();
        }
        catch (IOException expected) {
            GoogleCredentialTest.assertTrue((boolean)expected.getMessage().contains("refresh_token"));
        }
    }

    public void testCreateDelegated() throws Exception {
        String serviceAccountEmail = "36680232662-vrd7ji19q3ne0ah2csanun6bnr@developer.gserviceaccount.com";
        String accessToken = "1/MkSJoj1xsli0AccessToken_NKPY2";
        String delegateUser = "user@domain.com";
        MockTokenServerTransport transport = new MockTokenServerTransport();
        transport.addServiceAccount("36680232662-vrd7ji19q3ne0ah2csanun6bnr@developer.gserviceaccount.com", "1/MkSJoj1xsli0AccessToken_NKPY2");
        GoogleCredential credential = new GoogleCredential.Builder().setServiceAccountId("36680232662-vrd7ji19q3ne0ah2csanun6bnr@developer.gserviceaccount.com").setServiceAccountScopes(SCOPES).setServiceAccountPrivateKey((PrivateKey)SecurityTestUtils.newRsaPrivateKey()).setTransport((HttpTransport)transport).setJsonFactory(JSON_FACTORY).build();
        GoogleCredentialTest.assertNotSame((Object)"user@domain.com", (Object)credential.getServiceAccountUser());
        GoogleCredential delegatedCredential = credential.createDelegated("user@domain.com");
        GoogleCredentialTest.assertNotSame((Object)credential, (Object)delegatedCredential);
        GoogleCredentialTest.assertTrue((boolean)delegatedCredential.refreshToken());
        GoogleCredentialTest.assertEquals((String)"1/MkSJoj1xsli0AccessToken_NKPY2", (String)delegatedCredential.getAccessToken());
        GoogleCredentialTest.assertNotSame((Object)credential.getServiceAccountUser(), (Object)delegatedCredential.getServiceAccountUser());
        GoogleCredentialTest.assertSame((Object)credential.getTransport(), (Object)delegatedCredential.getTransport());
        GoogleCredentialTest.assertSame((Object)credential.getJsonFactory(), (Object)delegatedCredential.getJsonFactory());
        GoogleCredentialTest.assertSame((Object)credential.getServiceAccountId(), (Object)delegatedCredential.getServiceAccountId());
        GoogleCredentialTest.assertSame((Object)credential.getServiceAccountPrivateKey(), (Object)delegatedCredential.getServiceAccountPrivateKey());
    }

    public void testBuilderUserAccount() throws Exception {
        String accessToken = "1/MkSJoj1xsli0AccessToken_NKPY2";
        String clientSecret = "jakuaL9YyieakhECKL2SwZcu";
        String clientId = "ya29.1.AADtN_UtlxN3PuGAxrN2XQnZTVRvDyVWnYq4I6dws";
        String refreshToken = "1/Tl6awhpFjkMkSJoj1xsli0H2eL5YsMgU_NKPY2TyGWY";
        MockTokenServerTransport transport = new MockTokenServerTransport();
        transport.addClient("ya29.1.AADtN_UtlxN3PuGAxrN2XQnZTVRvDyVWnYq4I6dws", "jakuaL9YyieakhECKL2SwZcu");
        transport.addRefreshToken("1/Tl6awhpFjkMkSJoj1xsli0H2eL5YsMgU_NKPY2TyGWY", "1/MkSJoj1xsli0AccessToken_NKPY2");
        GoogleCredential credential = new GoogleCredential.Builder().setClientSecrets("ya29.1.AADtN_UtlxN3PuGAxrN2XQnZTVRvDyVWnYq4I6dws", "jakuaL9YyieakhECKL2SwZcu").setTransport((HttpTransport)transport).setJsonFactory(JSON_FACTORY).build();
        credential.setRefreshToken("1/Tl6awhpFjkMkSJoj1xsli0H2eL5YsMgU_NKPY2TyGWY");
        GoogleCredentialTest.assertTrue((boolean)credential.refreshToken());
        GoogleCredentialTest.assertEquals((String)"1/MkSJoj1xsli0AccessToken_NKPY2", (String)credential.getAccessToken());
        GoogleCredential newCredential = credential.toBuilder().build();
        GoogleCredentialTest.assertNotSame((Object)credential, (Object)newCredential);
        GoogleCredentialTest.assertSame((Object)credential.getClientAuthentication(), (Object)newCredential.getClientAuthentication());
        GoogleCredentialTest.assertEquals((Object)credential.getTransport(), (Object)newCredential.getTransport());
        GoogleCredentialTest.assertEquals((Object)credential.getJsonFactory(), (Object)newCredential.getJsonFactory());
    }

    public void testBuilderServiceAccount() throws Exception {
        String serviceAccountEmail = "36680232662-vrd7ji19q3ne0ah2csanun6bnr@developer.gserviceaccount.com";
        String accessToken = "1/MkSJoj1xsli0AccessToken_NKPY2";
        String refreshToken = "1/Tl6awhpFjkMkSJoj1xsli0H2eL5YsMgU_NKPY2TyGWY";
        String delegateUser = "user@domain.com";
        MockTokenServerTransport transport = new MockTokenServerTransport();
        transport.addServiceAccount("36680232662-vrd7ji19q3ne0ah2csanun6bnr@developer.gserviceaccount.com", "1/MkSJoj1xsli0AccessToken_NKPY2");
        GoogleCredential credential = new GoogleCredential.Builder().setServiceAccountId("36680232662-vrd7ji19q3ne0ah2csanun6bnr@developer.gserviceaccount.com").setServiceAccountScopes(SCOPES).setServiceAccountPrivateKey((PrivateKey)SecurityTestUtils.newRsaPrivateKey()).setServiceAccountUser("user@domain.com").setTransport((HttpTransport)transport).setJsonFactory(JSON_FACTORY).build();
        GoogleCredentialTest.assertTrue((boolean)credential.refreshToken());
        GoogleCredential newCredential = credential.toBuilder().build();
        GoogleCredentialTest.assertNotSame((Object)credential, (Object)newCredential);
        GoogleCredentialTest.assertEquals((String)credential.getServiceAccountId(), (String)newCredential.getServiceAccountId());
        GoogleCredentialTest.assertEquals((String)credential.getServiceAccountProjectId(), (String)newCredential.getServiceAccountProjectId());
        Assert.assertArrayEquals((Object[])credential.getServiceAccountScopes().toArray(), (Object[])newCredential.getServiceAccountScopes().toArray());
        GoogleCredentialTest.assertEquals((Object)credential.getServiceAccountPrivateKey(), (Object)newCredential.getServiceAccountPrivateKey());
        GoogleCredentialTest.assertEquals((String)credential.getServiceAccountPrivateKeyId(), (String)newCredential.getServiceAccountPrivateKeyId());
        GoogleCredentialTest.assertEquals((String)credential.getServiceAccountUser(), (String)newCredential.getServiceAccountUser());
        GoogleCredentialTest.assertTrue((boolean)newCredential.refreshToken());
        GoogleCredentialTest.assertEquals((String)credential.getAccessToken(), (String)newCredential.getAccessToken());
        GoogleCredentialTest.assertEquals((Object)credential.getTransport(), (Object)newCredential.getTransport());
        GoogleCredentialTest.assertEquals((Object)credential.getJsonFactory(), (Object)newCredential.getJsonFactory());
    }

    static String createUserJson(String clientId, String clientSecret, String refreshToken) throws IOException {
        GenericJson userCredentialContents = new GenericJson();
        userCredentialContents.setFactory(JSON_FACTORY);
        if (clientId != null) {
            userCredentialContents.put("client_id", (Object)clientId);
        }
        if (clientSecret != null) {
            userCredentialContents.put("client_secret", (Object)clientSecret);
        }
        if (refreshToken != null) {
            userCredentialContents.put("refresh_token", (Object)refreshToken);
        }
        userCredentialContents.put("type", (Object)"authorized_user");
        String json = userCredentialContents.toPrettyString();
        return json;
    }
}

