/*
 * Decompiled with CFR 0.152.
 */
package com.google.api.client.googleapis.json;

import com.google.api.client.googleapis.json.GoogleJsonErrorTest;
import com.google.api.client.googleapis.json.GoogleJsonResponseException;
import com.google.api.client.http.HttpRequest;
import com.google.api.client.http.HttpResponse;
import com.google.api.client.json.JsonFactory;
import com.google.api.client.testing.http.HttpTesting;
import com.google.api.client.testing.http.MockHttpTransport;
import com.google.api.client.testing.http.MockLowLevelHttpResponse;
import java.io.InputStream;
import junit.framework.TestCase;

public class GoogleJsonResponseExceptionTest
extends TestCase {
    public void testFrom_noDetails() throws Exception {
        MockHttpTransport transport = new MockHttpTransport();
        HttpRequest request = transport.createRequestFactory().buildGetRequest(HttpTesting.SIMPLE_GENERIC_URL);
        request.setThrowExceptionOnExecuteError(false);
        HttpResponse response = request.execute();
        GoogleJsonResponseException ge = GoogleJsonResponseException.from((JsonFactory)GoogleJsonErrorTest.FACTORY, (HttpResponse)response);
        GoogleJsonResponseExceptionTest.assertNull((Object)ge.getDetails());
        GoogleJsonResponseExceptionTest.assertTrue((boolean)ge.getMessage().startsWith("200"));
    }

    public void testFrom_withDetails() throws Exception {
        GoogleJsonErrorTest.ErrorTransport transport = new GoogleJsonErrorTest.ErrorTransport();
        HttpRequest request = transport.createRequestFactory().buildGetRequest(HttpTesting.SIMPLE_GENERIC_URL);
        request.setThrowExceptionOnExecuteError(false);
        HttpResponse response = request.execute();
        GoogleJsonResponseException ge = GoogleJsonResponseException.from((JsonFactory)GoogleJsonErrorTest.FACTORY, (HttpResponse)response);
        GoogleJsonResponseExceptionTest.assertEquals((String)"{\"code\":403,\"errors\":[{\"domain\":\"usageLimits\",\"message\":\"Access Not Configured\",\"reason\":\"accessNotConfigured\"}],\"message\":\"Access Not Configured\"}", (String)GoogleJsonErrorTest.FACTORY.toString((Object)ge.getDetails()));
        GoogleJsonResponseExceptionTest.assertTrue((boolean)ge.getMessage().startsWith("403"));
    }

    public void testFrom_detailsMissingContent() throws Exception {
        GoogleJsonErrorTest.ErrorTransport transport = new GoogleJsonErrorTest.ErrorTransport(null, "application/json; charset=UTF-8");
        HttpRequest request = transport.createRequestFactory().buildGetRequest(HttpTesting.SIMPLE_GENERIC_URL);
        request.setThrowExceptionOnExecuteError(false);
        HttpResponse response = request.execute();
        GoogleJsonResponseException ge = GoogleJsonResponseException.from((JsonFactory)GoogleJsonErrorTest.FACTORY, (HttpResponse)response);
        GoogleJsonResponseExceptionTest.assertNull((Object)ge.getDetails());
        GoogleJsonResponseExceptionTest.assertTrue((boolean)ge.getMessage().startsWith("403"));
    }

    public void testFrom_detailsArbitraryJsonContent() throws Exception {
        GoogleJsonErrorTest.ErrorTransport transport = new GoogleJsonErrorTest.ErrorTransport("{\"foo\":\"bar\"}", "application/json; charset=UTF-8");
        HttpRequest request = transport.createRequestFactory().buildGetRequest(HttpTesting.SIMPLE_GENERIC_URL);
        request.setThrowExceptionOnExecuteError(false);
        HttpResponse response = request.execute();
        GoogleJsonResponseException ge = GoogleJsonResponseException.from((JsonFactory)GoogleJsonErrorTest.FACTORY, (HttpResponse)response);
        GoogleJsonResponseExceptionTest.assertNull((Object)ge.getDetails());
        GoogleJsonResponseExceptionTest.assertTrue((boolean)ge.getMessage().startsWith("403"));
    }

    public void testFrom_detailsArbitraryXmlContent() throws Exception {
        GoogleJsonErrorTest.ErrorTransport transport = new GoogleJsonErrorTest.ErrorTransport("<foo>", "application/atom+xml; charset=utf-8");
        HttpRequest request = transport.createRequestFactory().buildGetRequest(HttpTesting.SIMPLE_GENERIC_URL);
        request.setThrowExceptionOnExecuteError(false);
        HttpResponse response = request.execute();
        GoogleJsonResponseException ge = GoogleJsonResponseException.from((JsonFactory)GoogleJsonErrorTest.FACTORY, (HttpResponse)response);
        GoogleJsonResponseExceptionTest.assertNull((Object)ge.getDetails());
        GoogleJsonResponseExceptionTest.assertTrue((boolean)ge.getMessage().startsWith("403"));
        GoogleJsonResponseExceptionTest.assertTrue((boolean)ge.getMessage().contains("<foo>"));
    }

    public void testFrom_errorNoContentButWithJsonContentType() throws Exception {
        GoogleJsonErrorTest.ErrorTransport transport = new GoogleJsonErrorTest.ErrorTransport("", "application/json; charset=UTF-8");
        HttpRequest request = transport.createRequestFactory().buildGetRequest(HttpTesting.SIMPLE_GENERIC_URL);
        request.setThrowExceptionOnExecuteError(false);
        HttpResponse response = request.execute();
        GoogleJsonResponseException ge = GoogleJsonResponseException.from((JsonFactory)GoogleJsonErrorTest.FACTORY, (HttpResponse)response);
        GoogleJsonResponseExceptionTest.assertNull((Object)ge.getDetails());
        GoogleJsonResponseExceptionTest.assertTrue((boolean)ge.getMessage().startsWith("403"));
    }

    public void testFrom_errorEmptyContentButWithJsonContentType() throws Exception {
        GoogleJsonErrorTest.ErrorTransport transport = new GoogleJsonErrorTest.ErrorTransport(null, "application/json; charset=UTF-8");
        HttpRequest request = transport.createRequestFactory().buildGetRequest(HttpTesting.SIMPLE_GENERIC_URL);
        request.setThrowExceptionOnExecuteError(false);
        HttpResponse response = request.execute();
        GoogleJsonResponseException ge = GoogleJsonResponseException.from((JsonFactory)GoogleJsonErrorTest.FACTORY, (HttpResponse)response);
        GoogleJsonResponseExceptionTest.assertNull((Object)ge.getDetails());
        GoogleJsonResponseExceptionTest.assertTrue((boolean)ge.getMessage().startsWith("403"));
    }

    public void testFrom_detailsErrorObject() throws Exception {
        GoogleJsonErrorTest.ErrorTransport transport = new GoogleJsonErrorTest.ErrorTransport("{\"error\": {\"message\": \"invalid_token\"}, \"error_description\": \"Invalid value\"}", "application/json; charset=UTF-8");
        HttpRequest request = transport.createRequestFactory().buildGetRequest(HttpTesting.SIMPLE_GENERIC_URL);
        request.setThrowExceptionOnExecuteError(false);
        HttpResponse response = request.execute();
        GoogleJsonResponseException ge = GoogleJsonResponseException.from((JsonFactory)GoogleJsonErrorTest.FACTORY, (HttpResponse)response);
        GoogleJsonResponseExceptionTest.assertNotNull((Object)ge.getDetails());
        GoogleJsonResponseExceptionTest.assertEquals((String)"invalid_token", (String)ge.getDetails().getMessage());
        GoogleJsonResponseExceptionTest.assertTrue((boolean)ge.getMessage().contains("403"));
    }

    public void testFrom_detailsErrorString() throws Exception {
        GoogleJsonErrorTest.ErrorTransport transport = new GoogleJsonErrorTest.ErrorTransport("{\"error\": \"invalid_token\", \"error_description\": \"Invalid value\"}", "application/json; charset=UTF-8");
        HttpRequest request = transport.createRequestFactory().buildGetRequest(HttpTesting.SIMPLE_GENERIC_URL);
        request.setThrowExceptionOnExecuteError(false);
        HttpResponse response = request.execute();
        GoogleJsonResponseException ge = GoogleJsonResponseException.from((JsonFactory)GoogleJsonErrorTest.FACTORY, (HttpResponse)response);
        GoogleJsonResponseExceptionTest.assertNull((Object)ge.getDetails());
        GoogleJsonResponseExceptionTest.assertTrue((boolean)ge.getMessage().contains("403"));
        GoogleJsonResponseExceptionTest.assertTrue((boolean)ge.getMessage().contains("invalid_token"));
    }

    public void testFrom_detailsNoErrorField() throws Exception {
        GoogleJsonErrorTest.ErrorTransport transport = new GoogleJsonErrorTest.ErrorTransport("{\"error_description\": \"Invalid value\"}", "application/json; charset=UTF-8");
        HttpRequest request = transport.createRequestFactory().buildGetRequest(HttpTesting.SIMPLE_GENERIC_URL);
        request.setThrowExceptionOnExecuteError(false);
        HttpResponse response = request.execute();
        GoogleJsonResponseException ge = GoogleJsonResponseException.from((JsonFactory)GoogleJsonErrorTest.FACTORY, (HttpResponse)response);
        GoogleJsonResponseExceptionTest.assertNull((Object)ge.getDetails());
        GoogleJsonResponseExceptionTest.assertTrue((boolean)ge.getMessage().startsWith("403"));
    }

    public void testFrom_detailsWithInvalidParameter() throws Exception {
        String DETAILS_ERROR = "{\"code\":400,\"details\":[{\"@type\":\"type.googleapis.com/google.dataflow.v1beta3.InvalidTemplateParameters\",\"parameterViolations\":[{\"description\":\"Parameter didn't match regex '^[0-9a-zA-Z_]+$'\",\"parameter\":\"safeBrowsingApiKey\"}]},{\"@type\":\"type.googleapis.com/google.rpc.DebugInfo\",\"detail\":\"test detail\"}],\"message\":\"The template parameters are invalid.\",\"status\":\"INVALID_ARGUMENT\"}";
        InputStream errorContent = GoogleJsonErrorTest.class.getResourceAsStream("error.json");
        GoogleJsonErrorTest.ErrorTransport transport = new GoogleJsonErrorTest.ErrorTransport(new MockLowLevelHttpResponse().setContent(errorContent).setContentType("application/json; charset=UTF-8").setStatusCode(403));
        HttpRequest request = transport.createRequestFactory().buildGetRequest(HttpTesting.SIMPLE_GENERIC_URL);
        request.setThrowExceptionOnExecuteError(false);
        HttpResponse response = request.execute();
        GoogleJsonResponseException ge = GoogleJsonResponseException.from((JsonFactory)GoogleJsonErrorTest.FACTORY, (HttpResponse)response);
        GoogleJsonResponseExceptionTest.assertNotNull((Object)ge.getDetails().getDetails());
    }
}

