/*
 * Decompiled with CFR 0.152.
 */
package com.google.api.client.googleapis.services;

import com.google.api.client.googleapis.services.AbstractGoogleClient;
import com.google.api.client.googleapis.services.AbstractGoogleClientRequest;
import com.google.api.client.googleapis.services.GoogleClientRequestInitializer;
import com.google.api.client.googleapis.testing.services.MockGoogleClient;
import com.google.api.client.googleapis.testing.services.MockGoogleClientRequest;
import com.google.api.client.http.AbstractInputStreamContent;
import com.google.api.client.http.EmptyContent;
import com.google.api.client.http.HttpExecuteInterceptor;
import com.google.api.client.http.HttpRequest;
import com.google.api.client.http.HttpRequestInitializer;
import com.google.api.client.http.HttpTransport;
import com.google.api.client.http.InputStreamContent;
import com.google.api.client.http.LowLevelHttpRequest;
import com.google.api.client.http.LowLevelHttpResponse;
import com.google.api.client.json.JsonFactory;
import com.google.api.client.json.JsonObjectParser;
import com.google.api.client.json.gson.GsonFactory;
import com.google.api.client.testing.http.MockHttpTransport;
import com.google.api.client.testing.http.MockLowLevelHttpRequest;
import com.google.api.client.testing.http.MockLowLevelHttpResponse;
import com.google.api.client.util.Key;
import com.google.api.client.util.ObjectParser;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import junit.framework.TestCase;

public class AbstractGoogleClientTest
extends TestCase {
    private static final JsonFactory JSON_FACTORY = new GsonFactory();
    private static final JsonObjectParser JSON_OBJECT_PARSER = new JsonObjectParser(JSON_FACTORY);
    private static final HttpTransport TRANSPORT = new MockHttpTransport();
    private static final String TEST_RESUMABLE_REQUEST_URL = "http://www.test.com/request/url?uploadType=resumable";
    private static final String TEST_UPLOAD_URL = "http://www.test.com/media/upload/location";
    private static final String TEST_CONTENT_TYPE = "image/jpeg";

    public void testGoogleClientBuilder() {
        String rootUrl = "http://www.testgoogleapis.com/test/";
        String servicePath = "path/v1/";
        TestRemoteRequestInitializer jsonHttpRequestInitializer = new TestRemoteRequestInitializer();
        String applicationName = "Test Application";
        MockGoogleClient.Builder setApplicationName = new MockGoogleClient.Builder(TRANSPORT, rootUrl, servicePath, (ObjectParser)JSON_OBJECT_PARSER, null).setApplicationName(applicationName).setGoogleClientRequestInitializer((GoogleClientRequestInitializer)jsonHttpRequestInitializer).setSuppressAllChecks(true);
        AbstractGoogleClient client = setApplicationName.build();
        AbstractGoogleClientTest.assertEquals((String)(rootUrl + servicePath), (String)client.getBaseUrl());
        AbstractGoogleClientTest.assertEquals((String)rootUrl, (String)client.getRootUrl());
        AbstractGoogleClientTest.assertEquals((String)servicePath, (String)client.getServicePath());
        AbstractGoogleClientTest.assertEquals((String)applicationName, (String)client.getApplicationName());
        AbstractGoogleClientTest.assertEquals((Object)jsonHttpRequestInitializer, (Object)client.getGoogleClientRequestInitializer());
        AbstractGoogleClientTest.assertTrue((boolean)client.getSuppressPatternChecks());
        AbstractGoogleClientTest.assertTrue((boolean)client.getSuppressRequiredParameterChecks());
    }

    public void testGoogleClientSuppressionDefaults() {
        String rootUrl = "http://www.testgoogleapis.com/test/";
        String servicePath = "path/v1/";
        MockGoogleClient.Builder googleClientBuilder = new MockGoogleClient.Builder(TRANSPORT, rootUrl, servicePath, (ObjectParser)JSON_OBJECT_PARSER, null);
        AbstractGoogleClientTest.assertFalse((boolean)googleClientBuilder.getSuppressPatternChecks());
        AbstractGoogleClientTest.assertFalse((boolean)googleClientBuilder.getSuppressRequiredParameterChecks());
        AbstractGoogleClient googleClient = googleClientBuilder.build();
        AbstractGoogleClientTest.assertFalse((boolean)googleClient.getSuppressPatternChecks());
        AbstractGoogleClientTest.assertFalse((boolean)googleClient.getSuppressRequiredParameterChecks());
    }

    public void testBaseServerAndBasePathBuilder() {
        MockGoogleClient client = new MockGoogleClient.Builder(TRANSPORT, "http://www.testgoogleapis.com/test/", "path/v1/", (ObjectParser)JSON_OBJECT_PARSER, null).setApplicationName("Test Application").setRootUrl("http://www.googleapis.com/test/").setServicePath("path/v2/").build();
        AbstractGoogleClientTest.assertEquals((String)"http://www.googleapis.com/test/path/v2/", (String)client.getBaseUrl());
    }

    public void testInitialize() throws Exception {
        TestRemoteRequestInitializer remoteRequestInitializer = new TestRemoteRequestInitializer();
        MockGoogleClient client = new MockGoogleClient.Builder(TRANSPORT, "http://www.test.com/", "", (ObjectParser)JSON_OBJECT_PARSER, null).setApplicationName("Test Application").setGoogleClientRequestInitializer((GoogleClientRequestInitializer)remoteRequestInitializer).build();
        client.initialize(null);
        AbstractGoogleClientTest.assertTrue((boolean)remoteRequestInitializer.isCalled);
    }

    public void testMediaUpload() throws Exception {
        MediaTransport transport = new MediaTransport();
        MockGoogleClient client = new MockGoogleClient.Builder((HttpTransport)transport, TEST_RESUMABLE_REQUEST_URL, "", (ObjectParser)JSON_OBJECT_PARSER, null).setApplicationName("Test Application").build();
        ByteArrayInputStream is = new ByteArrayInputStream(new byte[0xA00000]);
        InputStreamContent mediaContent = new InputStreamContent(TEST_CONTENT_TYPE, (InputStream)is);
        mediaContent.setLength(0xA00000L);
        MockGoogleClientRequest rq = new MockGoogleClientRequest((AbstractGoogleClient)client, "POST", "", null, A.class);
        rq.initializeMediaUpload((AbstractInputStreamContent)mediaContent);
        A result = (A)rq.execute();
        AbstractGoogleClientTest.assertEquals((String)"somevalue", (String)result.foo);
    }

    public void testMediaUpload_disableGZip() throws Exception {
        MediaTransport transport = new MediaTransport();
        transport.contentLengthNotSpecified = true;
        MockGoogleClient client = new MockGoogleClient.Builder((HttpTransport)transport, TEST_RESUMABLE_REQUEST_URL, "", (ObjectParser)JSON_OBJECT_PARSER, (HttpRequestInitializer)new GZipCheckerInitializer(true)).setApplicationName("Test Application").build();
        ByteArrayInputStream is = new ByteArrayInputStream(new byte[0xA00000]);
        InputStreamContent mediaContent = new InputStreamContent(TEST_CONTENT_TYPE, (InputStream)is);
        MockGoogleClientRequest rq = new MockGoogleClientRequest((AbstractGoogleClient)client, "POST", "", null, A.class);
        rq.initializeMediaUpload((AbstractInputStreamContent)mediaContent);
        rq.setDisableGZipContent(true);
        A result = (A)rq.execute();
        AbstractGoogleClientTest.assertEquals((String)"somevalue", (String)result.foo);
    }

    public void testMediaUpload_enableGZip() throws Exception {
        MediaTransport transport = new MediaTransport();
        transport.contentLengthNotSpecified = true;
        MockGoogleClient client = new MockGoogleClient.Builder((HttpTransport)transport, TEST_RESUMABLE_REQUEST_URL, "", (ObjectParser)JSON_OBJECT_PARSER, (HttpRequestInitializer)new GZipCheckerInitializer(false)).setApplicationName("Test Application").build();
        ByteArrayInputStream is = new ByteArrayInputStream(new byte[0xA00000]);
        InputStreamContent mediaContent = new InputStreamContent(TEST_CONTENT_TYPE, (InputStream)is);
        MockGoogleClientRequest rq = new MockGoogleClientRequest((AbstractGoogleClient)client, "POST", "", null, A.class);
        rq.initializeMediaUpload((AbstractInputStreamContent)mediaContent);
        rq.setDisableGZipContent(false);
        A result = (A)rq.execute();
        AbstractGoogleClientTest.assertEquals((String)"somevalue", (String)result.foo);
    }

    public void testMediaUpload_defaultGZip() throws Exception {
        MediaTransport transport = new MediaTransport();
        transport.contentLengthNotSpecified = true;
        MockGoogleClient client = new MockGoogleClient.Builder((HttpTransport)transport, TEST_RESUMABLE_REQUEST_URL, "", (ObjectParser)JSON_OBJECT_PARSER, (HttpRequestInitializer)new GZipCheckerInitializer(false)).setApplicationName("Test Application").build();
        ByteArrayInputStream is = new ByteArrayInputStream(new byte[0xA00000]);
        InputStreamContent mediaContent = new InputStreamContent(TEST_CONTENT_TYPE, (InputStream)is);
        MockGoogleClientRequest rq = new MockGoogleClientRequest((AbstractGoogleClient)client, "POST", "", null, A.class);
        rq.initializeMediaUpload((AbstractInputStreamContent)mediaContent);
        A result = (A)rq.execute();
        AbstractGoogleClientTest.assertEquals((String)"somevalue", (String)result.foo);
    }

    private static class GZipCheckerInterceptor
    implements HttpExecuteInterceptor {
        private boolean gzipDisabled;

        public GZipCheckerInterceptor(boolean gzipDisabled) {
            this.gzipDisabled = gzipDisabled;
        }

        public void intercept(HttpRequest request) {
            TestCase.assertEquals((!this.gzipDisabled && !(request.getContent() instanceof EmptyContent) ? 1 : 0) != 0, (request.getEncoding() != null ? 1 : 0) != 0);
        }
    }

    private static class GZipCheckerInitializer
    implements HttpRequestInitializer {
        private boolean gzipDisabled;

        public GZipCheckerInitializer(boolean gzipDisabled) {
            this.gzipDisabled = gzipDisabled;
        }

        public void initialize(HttpRequest request) {
            request.setInterceptor((HttpExecuteInterceptor)new GZipCheckerInterceptor(this.gzipDisabled));
        }
    }

    public static class A {
        @Key
        String foo;
    }

    private static class MediaTransport
    extends MockHttpTransport {
        int bytesUploaded;
        int contentLength = 0xA00000;
        boolean contentLengthNotSpecified;

        protected MediaTransport() {
        }

        public LowLevelHttpRequest buildRequest(String name, String url) {
            if (name.equals("POST")) {
                TestCase.assertEquals((String)AbstractGoogleClientTest.TEST_RESUMABLE_REQUEST_URL, (String)url);
                return new MockLowLevelHttpRequest(){

                    public LowLevelHttpResponse execute() {
                        if (!MediaTransport.this.contentLengthNotSpecified) {
                            TestCase.assertEquals((String)Integer.toString(MediaTransport.this.contentLength), (String)this.getFirstHeaderValue("x-upload-content-length"));
                        }
                        TestCase.assertEquals((String)AbstractGoogleClientTest.TEST_CONTENT_TYPE, (String)this.getFirstHeaderValue("x-upload-content-type"));
                        MockLowLevelHttpResponse response = new MockLowLevelHttpResponse();
                        response.setStatusCode(200);
                        response.addHeader("Location", AbstractGoogleClientTest.TEST_UPLOAD_URL);
                        return response;
                    }
                };
            }
            TestCase.assertEquals((String)AbstractGoogleClientTest.TEST_UPLOAD_URL, (String)url);
            return new MockLowLevelHttpRequest(){

                public LowLevelHttpResponse execute() {
                    MockLowLevelHttpResponse response = new MockLowLevelHttpResponse();
                    String bytesRange = MediaTransport.this.bytesUploaded + "-" + (MediaTransport.this.bytesUploaded + 0xA00000 - 1);
                    String expectedContentRange = "bytes " + bytesRange + "/" + MediaTransport.this.contentLength;
                    TestCase.assertEquals((String)expectedContentRange, (String)this.getFirstHeaderValue("Content-Range"));
                    MediaTransport.this.bytesUploaded += 0xA00000;
                    if (MediaTransport.this.bytesUploaded == MediaTransport.this.contentLength) {
                        response.setStatusCode(200);
                        response.setContent("{\"foo\":\"somevalue\"}");
                        response.setContentType("application/json; charset=UTF-8");
                    } else {
                        response.setStatusCode(308);
                        response.addHeader("Range", bytesRange);
                    }
                    return response;
                }
            };
        }
    }

    private static class TestRemoteRequestInitializer
    implements GoogleClientRequestInitializer {
        boolean isCalled;

        TestRemoteRequestInitializer() {
        }

        public void initialize(AbstractGoogleClientRequest<?> request) {
            this.isCalled = true;
        }
    }
}

