/*
 * Decompiled with CFR 0.152.
 */
package com.google.api.client.googleapis.services;

import com.google.api.client.googleapis.services.AbstractGoogleClient;
import com.google.api.client.googleapis.services.AbstractGoogleClientRequest;
import com.google.api.client.googleapis.services.CommonGoogleClientRequestInitializer;
import com.google.api.client.googleapis.services.GoogleClientRequestInitializer;
import com.google.api.client.googleapis.testing.services.MockGoogleClient;
import com.google.api.client.http.HttpContent;
import com.google.api.client.http.HttpHeaders;
import com.google.api.client.http.HttpTransport;
import com.google.api.client.testing.http.MockHttpTransport;
import com.google.api.client.util.Key;
import java.io.IOException;
import junit.framework.TestCase;

public class CommonGoogleClientRequestInitializerTest
extends TestCase {
    public void testInitialize() throws Exception {
        CommonGoogleClientRequestInitializer key = new CommonGoogleClientRequestInitializer("foo");
        MockGoogleClient client = new MockGoogleClient.Builder((HttpTransport)new MockHttpTransport(), "http://google.com/", "test/", null, null).setApplicationName("Test Application").build();
        MyRequest request = new MyRequest(client, "GET", "", null, String.class);
        CommonGoogleClientRequestInitializerTest.assertNull((Object)request.key);
        key.initialize((AbstractGoogleClientRequest)request);
        CommonGoogleClientRequestInitializerTest.assertEquals((String)"foo", (String)request.key);
    }

    public void testInitializeSetsUserAgent() throws IOException {
        CommonGoogleClientRequestInitializer requestInitializer = CommonGoogleClientRequestInitializer.newBuilder().setUserAgent("test user agent").build();
        MockGoogleClient client = new MockGoogleClient.Builder((HttpTransport)new MockHttpTransport(), "http://google.com/", "test/", null, null).setGoogleClientRequestInitializer((GoogleClientRequestInitializer)requestInitializer).setApplicationName("My Application").build();
        MyRequest request = new MyRequest(client, "GET", "", null, String.class);
        requestInitializer.initialize((AbstractGoogleClientRequest)request);
        HttpHeaders headers = request.getRequestHeaders();
        CommonGoogleClientRequestInitializerTest.assertEquals((String)"test user agent", (String)headers.getUserAgent());
    }

    public void testInitializeSetsUserProject() throws IOException {
        CommonGoogleClientRequestInitializer requestInitializer = CommonGoogleClientRequestInitializer.newBuilder().setUserProject("my quota project").build();
        MockGoogleClient client = new MockGoogleClient.Builder((HttpTransport)new MockHttpTransport(), "http://google.com/", "test/", null, null).setGoogleClientRequestInitializer((GoogleClientRequestInitializer)requestInitializer).setApplicationName("My Application").build();
        MyRequest request = new MyRequest(client, "GET", "", null, String.class);
        requestInitializer.initialize((AbstractGoogleClientRequest)request);
        HttpHeaders headers = request.getRequestHeaders();
        CommonGoogleClientRequestInitializerTest.assertEquals((Object)"my quota project", (Object)headers.get((Object)"X-Goog-User-Project"));
    }

    public void testInitializeSetsRequestReason() throws IOException {
        CommonGoogleClientRequestInitializer requestInitializer = CommonGoogleClientRequestInitializer.newBuilder().setRequestReason("some request reason").build();
        MockGoogleClient client = new MockGoogleClient.Builder((HttpTransport)new MockHttpTransport(), "http://google.com/", "test/", null, null).setGoogleClientRequestInitializer((GoogleClientRequestInitializer)requestInitializer).setApplicationName("My Application").build();
        MyRequest request = new MyRequest(client, "GET", "", null, String.class);
        requestInitializer.initialize((AbstractGoogleClientRequest)request);
        HttpHeaders headers = request.getRequestHeaders();
        CommonGoogleClientRequestInitializerTest.assertEquals((Object)"some request reason", (Object)headers.get((Object)"X-Goog-Request-Reason"));
    }

    public static class MyRequest
    extends AbstractGoogleClientRequest<String> {
        @Key
        String key;

        protected MyRequest(MockGoogleClient client, String method, String uriTemplate, HttpContent content, Class<String> responseClass) {
            super((AbstractGoogleClient)client, method, uriTemplate, content, responseClass);
        }
    }
}

