/*
 * Decompiled with CFR 0.152.
 */
package com.google.api.client.http;

import com.google.api.client.http.ConsumingInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import org.junit.Assert;
import org.junit.Test;

public class ConsumingInputStreamTest {
    @Test
    public void testClose_drainsBytesOnClose() throws IOException {
        MockInputStream mockInputStream = new MockInputStream("abc123".getBytes(StandardCharsets.UTF_8));
        ConsumingInputStream consumingInputStream = new ConsumingInputStream((InputStream)mockInputStream);
        Assert.assertEquals((long)6L, (long)mockInputStream.getBytesToRead());
        consumingInputStream.read();
        Assert.assertEquals((long)5L, (long)mockInputStream.getBytesToRead());
        consumingInputStream.close();
        Assert.assertEquals((long)0L, (long)mockInputStream.getBytesToRead());
    }

    private class MockInputStream
    extends InputStream {
        private int bytesToRead;

        MockInputStream(byte[] data) {
            this.bytesToRead = data.length;
        }

        @Override
        public int read() throws IOException {
            if (this.bytesToRead == 0) {
                return -1;
            }
            --this.bytesToRead;
            return 1;
        }

        int getBytesToRead() {
            return this.bytesToRead;
        }
    }
}

