/*
 * Decompiled with CFR 0.152.
 */
package com.google.api.client.http;

import com.google.api.client.http.GzipSupport;
import cz.o2.proxima.internal.shaded.com.google.common.io.ByteStreams;
import cz.o2.proxima.internal.shaded.com.google.common.io.CountingInputStream;
import cz.o2.proxima.internal.shaded.com.google.common.truth.Truth;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.SequenceInputStream;
import java.util.zip.GZIPInputStream;
import org.junit.Test;

public final class GzipSupportTest {
    @Test
    public void gzipInputStreamConsumesAllBytes() throws IOException {
        byte[] data = new byte[]{97, 98};
        byte[] member0 = new byte[]{31, -117, 8, 0, 0, 0, 0, 0, 2, 3, 75, 4, 0, 67, -66, -73, -24, 1, 0, 0, 0};
        byte[] member1 = new byte[]{31, -117, 8, 0, 0, 0, 0, 0, 2, 3, 75, 2, 0, -7, -17, -66, 113, 1, 0, 0, 0};
        int totalZippedBytes = member0.length + member1.length;
        try (SequenceInputStream s = new SequenceInputStream(new ByteArrayInputStream(member0), new ByteArrayInputStream(member1));
             CountingInputStream countS = new CountingInputStream((InputStream)s);
             GZIPInputStream g = GzipSupport.newGzipInputStream((InputStream)countS);
             CountingInputStream countG = new CountingInputStream((InputStream)g);){
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            ByteStreams.copy((InputStream)countG, (OutputStream)baos);
            Truth.assertThat((byte[])baos.toByteArray()).isEqualTo((Object)data);
            Truth.assertThat((Long)countG.getCount()).isEqualTo((Object)data.length);
            Truth.assertThat((Long)countS.getCount()).isEqualTo((Object)totalZippedBytes);
        }
    }
}

