/*
 * Decompiled with CFR 0.152.
 */
package com.google.api.client.http;

import com.google.api.client.http.HttpHeaders;
import com.google.api.client.http.HttpRequestTest;
import com.google.api.client.http.LowLevelHttpRequest;
import com.google.api.client.http.LowLevelHttpResponse;
import com.google.api.client.testing.http.MockLowLevelHttpRequest;
import com.google.api.client.testing.http.MockLowLevelHttpResponse;
import com.google.api.client.util.Key;
import cz.o2.proxima.internal.shaded.com.google.common.collect.ImmutableList;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.util.Arrays;
import java.util.List;
import junit.framework.TestCase;

public class HttpHeadersTest
extends TestCase {
    private static final String AUTHORIZATION_HEADERS = "Accept-Encoding: gzip\r\nAuthorization: Foo\r\nAuthorization: Bar\r\n";

    public HttpHeadersTest() {
    }

    public HttpHeadersTest(String name) {
        super(name);
    }

    public void testBasicAuthentication() {
        HttpHeaders headers = new HttpHeaders();
        headers.setBasicAuthentication("Aladdin", "open sesame");
        HttpHeadersTest.assertEquals((String)"Basic QWxhZGRpbjpvcGVuIHNlc2FtZQ==", (String)headers.getAuthorization());
    }

    public void testSerializeHeaders() throws Exception {
        MyHeaders myHeaders = new MyHeaders();
        myHeaders.foo = "bar";
        myHeaders.objNum = 5;
        myHeaders.list = ImmutableList.of((Object)"a", (Object)"b", (Object)"c");
        myHeaders.objList = ImmutableList.of((Object)"a2", (Object)"b2", (Object)"c2");
        myHeaders.r = new String[]{"a1", "a2"};
        myHeaders.setAcceptEncoding(null);
        myHeaders.setContentLength(Long.MAX_VALUE);
        myHeaders.setUserAgent("foo");
        myHeaders.addWarning("warn0");
        myHeaders.addWarning("warn1");
        myHeaders.set("a", "b");
        myHeaders.value = HttpRequestTest.E.VALUE;
        myHeaders.otherValue = HttpRequestTest.E.OTHER_VALUE;
        MockLowLevelHttpRequest lowLevelRequest = new MockLowLevelHttpRequest();
        ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
        OutputStreamWriter writer = new OutputStreamWriter(outputStream);
        HttpHeaders.serializeHeaders((HttpHeaders)myHeaders, null, null, null, (LowLevelHttpRequest)lowLevelRequest, null);
        HttpHeadersTest.assertEquals((Object)ImmutableList.of((Object)"bar"), (Object)lowLevelRequest.getHeaderValues("foo"));
        HttpHeadersTest.assertEquals((Object)ImmutableList.of((Object)"a", (Object)"b", (Object)"c"), (Object)lowLevelRequest.getHeaderValues("list"));
        HttpHeadersTest.assertEquals((Object)ImmutableList.of((Object)"a2", (Object)"b2", (Object)"c2"), (Object)lowLevelRequest.getHeaderValues("objlist"));
        HttpHeadersTest.assertEquals((Object)ImmutableList.of((Object)"a1", (Object)"a2"), (Object)lowLevelRequest.getHeaderValues("r"));
        HttpHeadersTest.assertTrue((boolean)lowLevelRequest.getHeaderValues("accept-encoding").isEmpty());
        HttpHeadersTest.assertEquals((Object)ImmutableList.of((Object)"foo"), (Object)lowLevelRequest.getHeaderValues("user-agent"));
        HttpHeadersTest.assertEquals((Object)ImmutableList.of((Object)"warn0", (Object)"warn1"), (Object)lowLevelRequest.getHeaderValues("warning"));
        HttpHeadersTest.assertEquals((Object)ImmutableList.of((Object)"b"), (Object)lowLevelRequest.getHeaderValues("a"));
        HttpHeadersTest.assertEquals((Object)ImmutableList.of((Object)"VALUE"), (Object)lowLevelRequest.getHeaderValues("value"));
        HttpHeadersTest.assertEquals((Object)ImmutableList.of((Object)"other"), (Object)lowLevelRequest.getHeaderValues("othervalue"));
        HttpHeadersTest.assertEquals((Object)ImmutableList.of((Object)String.valueOf(Long.MAX_VALUE)), (Object)lowLevelRequest.getHeaderValues("content-length"));
        HttpHeaders.serializeHeadersForMultipartRequests((HttpHeaders)myHeaders, null, null, (Writer)writer);
        StringBuilder expectedOutput = new StringBuilder();
        expectedOutput.append("Content-Length: " + String.valueOf(Long.MAX_VALUE) + "\r\n");
        expectedOutput.append("foo: bar\r\n");
        expectedOutput.append("list: a\r\n");
        expectedOutput.append("list: b\r\n");
        expectedOutput.append("list: c\r\n");
        expectedOutput.append("objList: a2\r\n");
        expectedOutput.append("objList: b2\r\n");
        expectedOutput.append("objList: c2\r\n");
        expectedOutput.append("objNum: 5\r\n");
        expectedOutput.append("otherValue: other\r\n");
        expectedOutput.append("r: a1\r\n");
        expectedOutput.append("r: a2\r\n");
        expectedOutput.append("someLong: 0\r\n");
        expectedOutput.append("User-Agent: foo\r\n");
        expectedOutput.append("value: VALUE\r\n");
        expectedOutput.append("Warning: warn0\r\n");
        expectedOutput.append("Warning: warn1\r\n");
        expectedOutput.append("a: b\r\n");
        HttpHeadersTest.assertEquals((String)expectedOutput.toString(), (String)outputStream.toString());
    }

    public void testFromHttpHeaders() {
        HttpHeaders rawHeaders = new HttpHeaders();
        rawHeaders.setContentLength(Long.valueOf(Long.MAX_VALUE));
        rawHeaders.setContentType("foo/bar");
        rawHeaders.setUserAgent("FooBar");
        rawHeaders.addWarning("warn0");
        rawHeaders.addWarning("warn1");
        rawHeaders.set("foo", (Object)"bar");
        rawHeaders.set("someLong", (Object)"5");
        rawHeaders.set("list", (Object)ImmutableList.of((Object)"a", (Object)"b", (Object)"c"));
        rawHeaders.set("objNum", (Object)"5");
        rawHeaders.set("objList", (Object)ImmutableList.of((Object)"a2", (Object)"b2", (Object)"c2"));
        rawHeaders.set("r", (Object)new String[]{"a1", "a2"});
        rawHeaders.set("a", (Object)"b");
        rawHeaders.set("value", (Object)HttpRequestTest.E.VALUE);
        rawHeaders.set("otherValue", (Object)HttpRequestTest.E.OTHER_VALUE);
        MyHeaders myHeaders = new MyHeaders();
        myHeaders.fromHttpHeaders(rawHeaders);
        HttpHeadersTest.assertEquals((long)Long.MAX_VALUE, (long)myHeaders.getContentLength());
        HttpHeadersTest.assertEquals((String)"foo/bar", (String)myHeaders.getContentType());
        HttpHeadersTest.assertEquals((String)"FooBar", (String)myHeaders.getUserAgent());
        HttpHeadersTest.assertEquals((String)"warn0", (String)((String)myHeaders.getWarning().get(0)));
        HttpHeadersTest.assertEquals((String)"warn1", (String)((String)myHeaders.getWarning().get(1)));
        HttpHeadersTest.assertEquals((String)"bar", (String)myHeaders.foo);
        HttpHeadersTest.assertEquals((long)5L, (long)myHeaders.someLong);
        HttpHeadersTest.assertEquals((Object)ImmutableList.of((Object)"5"), (Object)myHeaders.objNum);
        HttpHeadersTest.assertEquals((Object)ImmutableList.of((Object)"a", (Object)"b", (Object)"c"), myHeaders.list);
        HttpHeadersTest.assertEquals((Object)ImmutableList.of((Object)"a2", (Object)"b2", (Object)"c2"), (Object)myHeaders.objList);
        HttpHeadersTest.assertEquals((Object)ImmutableList.of((Object)"a1", (Object)"a2"), (Object)ImmutableList.copyOf((Object[])myHeaders.r));
        HttpHeadersTest.assertEquals((Object)ImmutableList.of((Object)"b"), (Object)myHeaders.get("a"));
        HttpHeadersTest.assertEquals((Object)((Object)HttpRequestTest.E.VALUE), (Object)((Object)myHeaders.value));
        HttpHeadersTest.assertEquals((Object)((Object)HttpRequestTest.E.OTHER_VALUE), (Object)((Object)myHeaders.otherValue));
    }

    public void testAuthorizationHeader() throws IOException {
        HttpHeaders headers = new HttpHeaders();
        headers.setAuthorization(Arrays.asList("Foo", "Bar"));
        ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
        OutputStreamWriter writer = new OutputStreamWriter(outputStream);
        HttpHeaders.serializeHeadersForMultipartRequests((HttpHeaders)headers, null, null, (Writer)writer);
        HttpHeadersTest.assertEquals((String)AUTHORIZATION_HEADERS, (String)outputStream.toString());
        MockLowLevelHttpResponse response = new MockLowLevelHttpResponse();
        response.addHeader("Authorization", "Foo");
        response.addHeader("Authorization", "Bar");
        headers = new HttpHeaders();
        headers.fromHttpResponse((LowLevelHttpResponse)response, null);
        Object authHeader = headers.get((Object)"Authorization");
        HttpHeadersTest.assertTrue((String)authHeader.toString(), (boolean)ImmutableList.of((Object)"Foo", (Object)"Bar").equals(authHeader));
    }

    public void testHeaderStringValues() {
        MyHeaders myHeaders = new MyHeaders();
        myHeaders.foo = "bar";
        myHeaders.objNum = 5;
        myHeaders.list = ImmutableList.of((Object)"a", (Object)"b", (Object)"c");
        myHeaders.objList = ImmutableList.of((Object)"a2", (Object)"b2", (Object)"c2");
        myHeaders.r = new String[]{"a1", "a2"};
        myHeaders.setAcceptEncoding(null);
        myHeaders.setContentLength(Long.MAX_VALUE);
        myHeaders.setUserAgent("foo");
        myHeaders.addWarning("warn");
        myHeaders.set("a", "b");
        myHeaders.value = HttpRequestTest.E.VALUE;
        myHeaders.otherValue = HttpRequestTest.E.OTHER_VALUE;
        HttpHeadersTest.assertEquals((String)"bar", (String)myHeaders.getFirstHeaderStringValue("foo"));
        HttpHeadersTest.assertEquals((String)"a", (String)myHeaders.getFirstHeaderStringValue("list"));
        HttpHeadersTest.assertEquals((String)"a2", (String)myHeaders.getFirstHeaderStringValue("objlist"));
        HttpHeadersTest.assertEquals((String)"a1", (String)myHeaders.getFirstHeaderStringValue("r"));
        HttpHeadersTest.assertNull((Object)myHeaders.getFirstHeaderStringValue("accept-encoding"));
        HttpHeadersTest.assertEquals((String)"foo", (String)myHeaders.getFirstHeaderStringValue("user-agent"));
        HttpHeadersTest.assertEquals((String)"warn", (String)myHeaders.getFirstHeaderStringValue("warning"));
        HttpHeadersTest.assertEquals((String)"b", (String)myHeaders.getFirstHeaderStringValue("a"));
        HttpHeadersTest.assertEquals((String)"VALUE", (String)myHeaders.getFirstHeaderStringValue("value"));
        HttpHeadersTest.assertEquals((String)"other", (String)myHeaders.getFirstHeaderStringValue("othervalue"));
        HttpHeadersTest.assertEquals((String)String.valueOf(Long.MAX_VALUE), (String)myHeaders.getFirstHeaderStringValue("content-length"));
        HttpHeadersTest.assertEquals((Object)ImmutableList.of((Object)"bar"), (Object)myHeaders.getHeaderStringValues("foo"));
        HttpHeadersTest.assertEquals((Object)ImmutableList.of((Object)"a", (Object)"b", (Object)"c"), (Object)myHeaders.getHeaderStringValues("list"));
        HttpHeadersTest.assertEquals((Object)ImmutableList.of((Object)"a2", (Object)"b2", (Object)"c2"), (Object)myHeaders.getHeaderStringValues("objlist"));
        HttpHeadersTest.assertEquals((Object)ImmutableList.of((Object)"a1", (Object)"a2"), (Object)myHeaders.getHeaderStringValues("r"));
        HttpHeadersTest.assertTrue((boolean)myHeaders.getHeaderStringValues("accept-encoding").isEmpty());
        HttpHeadersTest.assertEquals((Object)ImmutableList.of((Object)"foo"), (Object)myHeaders.getHeaderStringValues("user-agent"));
        HttpHeadersTest.assertEquals((Object)ImmutableList.of((Object)"warn"), (Object)myHeaders.getHeaderStringValues("warning"));
        HttpHeadersTest.assertEquals((Object)ImmutableList.of((Object)"b"), (Object)myHeaders.getHeaderStringValues("a"));
        HttpHeadersTest.assertEquals((Object)ImmutableList.of((Object)"VALUE"), (Object)myHeaders.getHeaderStringValues("value"));
        HttpHeadersTest.assertEquals((Object)ImmutableList.of((Object)"other"), (Object)myHeaders.getHeaderStringValues("othervalue"));
        HttpHeadersTest.assertEquals((Object)ImmutableList.of((Object)String.valueOf(Long.MAX_VALUE)), (Object)myHeaders.getHeaderStringValues("content-length"));
    }

    public void testParseAge() throws Exception {
        MockLowLevelHttpResponse httpResponse = new MockLowLevelHttpResponse().setHeaderNames(Arrays.asList("Age")).setHeaderValues(Arrays.asList("3456"));
        HttpHeaders httpHeaders = new HttpHeaders();
        httpHeaders.fromHttpResponse((LowLevelHttpResponse)httpResponse, null);
        HttpHeadersTest.assertEquals((long)3456L, (long)httpHeaders.getAge());
    }

    public void testFromHttpResponse_normalFlow() throws Exception {
        MockLowLevelHttpResponse httpResponse = new MockLowLevelHttpResponse().setHeaderNames(Arrays.asList("Content-Type", "Slug")).setHeaderValues(Arrays.asList("foo/bar", "123456789"));
        HttpHeaders httpHeaders = new HttpHeaders();
        httpHeaders.fromHttpResponse((LowLevelHttpResponse)httpResponse, null);
        HttpHeadersTest.assertEquals((String)"foo/bar", (String)httpHeaders.getContentType());
        HttpHeadersTest.assertEquals((Object)ImmutableList.of((Object)"123456789"), (Object)httpHeaders.get((Object)"Slug"));
        SlugHeaders slugHeaders = new SlugHeaders();
        slugHeaders.fromHttpHeaders(httpHeaders);
        HttpHeadersTest.assertEquals((String)"foo/bar", (String)slugHeaders.getContentType());
        HttpHeadersTest.assertEquals((String)"123456789", (String)slugHeaders.slug);
    }

    public void testFromHttpResponse_doubleConvert() throws Exception {
        MockLowLevelHttpResponse httpResponse = new MockLowLevelHttpResponse().setHeaderNames(Arrays.asList("Content-Type", "Slug")).setHeaderValues(Arrays.asList("foo/bar", "123456789"));
        SlugHeaders slugHeaders = new SlugHeaders();
        slugHeaders.fromHttpResponse((LowLevelHttpResponse)httpResponse, null);
        HttpHeadersTest.assertEquals((String)"foo/bar", (String)slugHeaders.getContentType());
        HttpHeadersTest.assertEquals((String)"123456789", (String)slugHeaders.slug);
        SlugHeaders slugHeaders2 = new SlugHeaders();
        slugHeaders2.fromHttpHeaders(slugHeaders);
        HttpHeadersTest.assertEquals((String)"foo/bar", (String)slugHeaders2.getContentType());
        HttpHeadersTest.assertEquals((String)"123456789", (String)slugHeaders2.slug);
    }

    public void testFromHttpResponse_clearOldValue() throws Exception {
        HttpHeaders headers = new HttpHeaders();
        headers.put("Foo", (Object)"oldValue");
        headers.fromHttpResponse((LowLevelHttpResponse)new MockLowLevelHttpResponse().setHeaderNames(Arrays.asList("Foo")).setHeaderValues(Arrays.asList("newvalue")), null);
        HttpHeadersTest.assertEquals(Arrays.asList("newvalue"), (Object)headers.get((Object)"Foo"));
    }

    public void testFromHttpResponse_void(String value) throws Exception {
        MockLowLevelHttpResponse httpResponse = new MockLowLevelHttpResponse().setHeaderNames(Arrays.asList("v", "v", "s")).setHeaderValues(Arrays.asList("ignore", "ignore2", "svalue"));
        V v = new V();
        v.fromHttpResponse((LowLevelHttpResponse)httpResponse, null);
        HttpHeadersTest.assertNull((Object)v.v);
        HttpHeadersTest.assertEquals((String)"svalue", (String)v.s);
    }

    public static class V
    extends HttpHeaders {
        @Key
        Void v;
        @Key
        String s;
    }

    public static class SlugHeaders
    extends HttpHeaders {
        @Key(value="Slug")
        String slug;
    }

    public static class MyHeaders
    extends HttpHeaders {
        @Key
        public String foo;
        @Key
        Object objNum;
        @Key
        Object objList;
        @Key
        long someLong;
        @Key
        List<String> list;
        @Key
        String[] r;
        @Key
        HttpRequestTest.E value;
        @Key
        HttpRequestTest.E otherValue;
    }
}

