/*
 * Decompiled with CFR 0.152.
 */
package com.google.api.client.http;

import com.google.api.client.http.HttpHeaders;
import com.google.api.client.http.HttpRequest;
import com.google.api.client.http.HttpResponse;
import com.google.api.client.http.HttpResponseException;
import com.google.api.client.http.HttpTransport;
import com.google.api.client.http.LowLevelHttpRequest;
import com.google.api.client.http.LowLevelHttpResponse;
import com.google.api.client.testing.http.HttpTesting;
import com.google.api.client.testing.http.MockHttpTransport;
import com.google.api.client.testing.http.MockLowLevelHttpRequest;
import com.google.api.client.testing.http.MockLowLevelHttpResponse;
import com.google.api.client.testing.util.LogRecordingHandler;
import com.google.api.client.testing.util.TestableByteArrayInputStream;
import com.google.api.client.util.Key;
import cz.o2.proxima.internal.shaded.com.google.common.io.ByteStreams;
import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.charset.StandardCharsets;
import java.text.NumberFormat;
import java.util.Arrays;
import java.util.Locale;
import java.util.logging.Handler;
import java.util.logging.Level;
import java.util.zip.GZIPInputStream;
import java.util.zip.GZIPOutputStream;
import junit.framework.TestCase;

public class HttpResponseTest
extends TestCase {
    private static final String SAMPLE = "123\u05d9\u05e0\u05d9\u05d1";
    private static final String SAMPLE2 = "123abc";
    private static final String JSON_SAMPLE = "{\"foo\": \"\u00dfar\"}";
    private static final String ERROR_SAMPLE = "{domain:'global',reason:'domainPolicy',message:'msg'}";
    private static final String VALID_CONTENT_TYPE = "text/plain";
    private static final String VALID_CONTENT_TYPE_WITH_PARAMS = "application/vnd.com.google.datastore.entity+json; charset=utf-8; version=v1; q=0.9";
    private static final String VALID_CONTENT_TYPE_WITHOUT_CHARSET = "text/csv; version=v1; q=0.9";
    private static final String INVALID_CONTENT_TYPE = "!!!invalid!!!";
    private static final String JSON_CONTENT_TYPE = "application/json";
    static final String ETAG_VALUE = "\"abc\"";

    public HttpResponseTest() {
    }

    public HttpResponseTest(String name) {
        super(name);
    }

    public void testParseAsString_none() throws Exception {
        MockHttpTransport transport = new MockHttpTransport();
        HttpRequest request = transport.createRequestFactory().buildGetRequest(HttpTesting.SIMPLE_GENERIC_URL);
        HttpResponse response = request.execute();
        HttpResponseTest.assertEquals((String)"", (String)response.parseAsString());
    }

    public void testParseAsString_utf8() throws Exception {
        MockHttpTransport transport = new MockHttpTransport(){

            public LowLevelHttpRequest buildRequest(String method, String url) throws IOException {
                return new MockLowLevelHttpRequest(){

                    public LowLevelHttpResponse execute() throws IOException {
                        MockLowLevelHttpResponse result = new MockLowLevelHttpResponse();
                        result.setContentType("application/json; charset=UTF-8");
                        result.setContent(HttpResponseTest.SAMPLE);
                        return result;
                    }
                };
            }
        };
        HttpRequest request = transport.createRequestFactory().buildGetRequest(HttpTesting.SIMPLE_GENERIC_URL);
        HttpResponse response = request.execute();
        HttpResponseTest.assertEquals((String)SAMPLE, (String)response.parseAsString());
        HttpResponseTest.assertEquals((String)"UTF-8", (String)response.getContentCharset().name());
    }

    public void testParseAsString_noContentType() throws Exception {
        MockHttpTransport transport = new MockHttpTransport(){

            public LowLevelHttpRequest buildRequest(String method, String url) throws IOException {
                return new MockLowLevelHttpRequest(){

                    public LowLevelHttpResponse execute() throws IOException {
                        MockLowLevelHttpResponse result = new MockLowLevelHttpResponse();
                        result.setContent(HttpResponseTest.SAMPLE2);
                        return result;
                    }
                };
            }
        };
        HttpRequest request = transport.createRequestFactory().buildGetRequest(HttpTesting.SIMPLE_GENERIC_URL);
        HttpResponse response = request.execute();
        HttpResponseTest.assertEquals((String)SAMPLE2, (String)response.parseAsString());
        HttpResponseTest.assertEquals((String)"ISO-8859-1", (String)response.getContentCharset().name());
    }

    public void testParseAsString_validContentType() throws Exception {
        MockHttpTransport transport = new MockHttpTransport(){

            public LowLevelHttpRequest buildRequest(String method, String url) throws IOException {
                return new MockLowLevelHttpRequest(){

                    public LowLevelHttpResponse execute() throws IOException {
                        MockLowLevelHttpResponse result = new MockLowLevelHttpResponse();
                        result.setContent(HttpResponseTest.SAMPLE2);
                        result.setContentType(HttpResponseTest.VALID_CONTENT_TYPE);
                        return result;
                    }
                };
            }
        };
        HttpRequest request = transport.createRequestFactory().buildGetRequest(HttpTesting.SIMPLE_GENERIC_URL);
        HttpResponse response = request.execute();
        HttpResponseTest.assertEquals((String)SAMPLE2, (String)response.parseAsString());
        HttpResponseTest.assertEquals((String)VALID_CONTENT_TYPE, (String)response.getContentType());
        HttpResponseTest.assertNotNull((Object)response.getMediaType());
        HttpResponseTest.assertEquals((String)"ISO-8859-1", (String)response.getContentCharset().name());
    }

    public void testParseAsString_validContentTypeWithParams() throws Exception {
        MockHttpTransport transport = new MockHttpTransport(){

            public LowLevelHttpRequest buildRequest(String method, String url) throws IOException {
                return new MockLowLevelHttpRequest(){

                    public LowLevelHttpResponse execute() throws IOException {
                        MockLowLevelHttpResponse result = new MockLowLevelHttpResponse();
                        result.setContent(HttpResponseTest.SAMPLE2);
                        result.setContentType(HttpResponseTest.VALID_CONTENT_TYPE_WITH_PARAMS);
                        return result;
                    }
                };
            }
        };
        HttpRequest request = transport.createRequestFactory().buildGetRequest(HttpTesting.SIMPLE_GENERIC_URL);
        HttpResponse response = request.execute();
        HttpResponseTest.assertEquals((String)SAMPLE2, (String)response.parseAsString());
        HttpResponseTest.assertEquals((String)VALID_CONTENT_TYPE_WITH_PARAMS, (String)response.getContentType());
        HttpResponseTest.assertNotNull((Object)response.getMediaType());
        HttpResponseTest.assertEquals((String)"UTF-8", (String)response.getContentCharset().name());
    }

    public void testParseAsString_invalidContentType() throws Exception {
        MockHttpTransport transport = new MockHttpTransport(){

            public LowLevelHttpRequest buildRequest(String method, String url) throws IOException {
                return new MockLowLevelHttpRequest(){

                    public LowLevelHttpResponse execute() throws IOException {
                        MockLowLevelHttpResponse result = new MockLowLevelHttpResponse();
                        result.setContent(HttpResponseTest.SAMPLE2);
                        result.setContentType(HttpResponseTest.INVALID_CONTENT_TYPE);
                        return result;
                    }
                };
            }
        };
        HttpRequest request = transport.createRequestFactory().buildGetRequest(HttpTesting.SIMPLE_GENERIC_URL);
        HttpResponse response = request.execute();
        HttpResponseTest.assertEquals((String)SAMPLE2, (String)response.parseAsString());
        HttpResponseTest.assertEquals((String)INVALID_CONTENT_TYPE, (String)response.getContentType());
        HttpResponseTest.assertNull((Object)response.getMediaType());
        HttpResponseTest.assertEquals((String)"ISO-8859-1", (String)response.getContentCharset().name());
    }

    public void testParseAsString_validContentTypeWithoutCharSetWithParams() throws Exception {
        MockHttpTransport transport = new MockHttpTransport(){

            public LowLevelHttpRequest buildRequest(String method, String url) throws IOException {
                return new MockLowLevelHttpRequest(){

                    public LowLevelHttpResponse execute() throws IOException {
                        MockLowLevelHttpResponse result = new MockLowLevelHttpResponse();
                        result.setContent(HttpResponseTest.SAMPLE2);
                        result.setContentType(HttpResponseTest.VALID_CONTENT_TYPE_WITHOUT_CHARSET);
                        return result;
                    }
                };
            }
        };
        HttpRequest request = transport.createRequestFactory().buildGetRequest(HttpTesting.SIMPLE_GENERIC_URL);
        HttpResponse response = request.execute();
        HttpResponseTest.assertEquals((String)SAMPLE2, (String)response.parseAsString());
        HttpResponseTest.assertEquals((String)VALID_CONTENT_TYPE_WITHOUT_CHARSET, (String)response.getContentType());
        HttpResponseTest.assertNotNull((Object)response.getMediaType());
        HttpResponseTest.assertEquals((String)"UTF-8", (String)response.getContentCharset().name());
    }

    public void testParseAsString_jsonContentType() throws IOException {
        MockHttpTransport transport = new MockHttpTransport(){

            public LowLevelHttpRequest buildRequest(String method, String url) throws IOException {
                return new MockLowLevelHttpRequest(){

                    public LowLevelHttpResponse execute() throws IOException {
                        MockLowLevelHttpResponse result = new MockLowLevelHttpResponse();
                        result.setContent(HttpResponseTest.JSON_SAMPLE);
                        result.setContentType(HttpResponseTest.JSON_CONTENT_TYPE);
                        return result;
                    }
                };
            }
        };
        HttpRequest request = transport.createRequestFactory().buildGetRequest(HttpTesting.SIMPLE_GENERIC_URL);
        HttpResponse response = request.execute();
        HttpResponseTest.assertEquals((String)JSON_SAMPLE, (String)response.parseAsString());
        HttpResponseTest.assertEquals((String)JSON_CONTENT_TYPE, (String)response.getContentType());
        HttpResponseTest.assertEquals((String)"UTF-8", (String)response.getContentCharset().name());
    }

    public void testStatusCode_negative_dontThrowException() throws Exception {
        this.subtestStatusCode_negative(false);
    }

    public void testStatusCode_negative_throwException() throws Exception {
        this.subtestStatusCode_negative(true);
    }

    private void subtestStatusCode_negative(boolean throwExceptionOnExecuteError) throws Exception {
        MockHttpTransport transport = new MockHttpTransport(){

            public LowLevelHttpRequest buildRequest(String method, String url) throws IOException {
                return new MockLowLevelHttpRequest().setResponse(new MockLowLevelHttpResponse().setStatusCode(-1));
            }
        };
        HttpRequest request = transport.createRequestFactory().buildGetRequest(HttpTesting.SIMPLE_GENERIC_URL);
        request.setThrowExceptionOnExecuteError(throwExceptionOnExecuteError);
        try {
            HttpResponse response = request.execute();
            HttpResponseTest.assertEquals((int)0, (int)response.getStatusCode());
            HttpResponseTest.assertFalse((boolean)throwExceptionOnExecuteError);
        }
        catch (HttpResponseException e) {
            HttpResponseTest.assertTrue((boolean)throwExceptionOnExecuteError);
            HttpResponseTest.assertEquals((int)0, (int)e.getStatusCode());
        }
    }

    public void testHeaderParsing() throws Exception {
        MockHttpTransport transport = new MockHttpTransport(){

            public LowLevelHttpRequest buildRequest(String method, String url) throws IOException {
                return new MockLowLevelHttpRequest(){

                    public LowLevelHttpResponse execute() throws IOException {
                        MockLowLevelHttpResponse result = new MockLowLevelHttpResponse();
                        result.addHeader("accept", "value");
                        result.addHeader("foo", "bar");
                        result.addHeader("goo", "car");
                        result.addHeader("hoo", "dar");
                        result.addHeader("hoo", "far");
                        result.addHeader("obj", "o");
                        result.addHeader("r", "a1");
                        result.addHeader("r", "a2");
                        result.addHeader("ETAG", HttpResponseTest.ETAG_VALUE);
                        return result;
                    }
                };
            }
        };
        HttpRequest request = transport.createRequestFactory().buildGetRequest(HttpTesting.SIMPLE_GENERIC_URL);
        request.setResponseHeaders((HttpHeaders)new MyHeaders());
        HttpResponse response = request.execute();
        HttpResponseTest.assertEquals((String)"value", (String)response.getHeaders().getAccept());
        HttpResponseTest.assertEquals((String)"bar", (String)((MyHeaders)response.getHeaders()).foo);
        HttpResponseTest.assertEquals(Arrays.asList("o"), (Object)((MyHeaders)response.getHeaders()).obj);
        HttpResponseTest.assertEquals(Arrays.asList("a1", "a2"), Arrays.asList(((MyHeaders)response.getHeaders()).r));
        HttpResponseTest.assertEquals(Arrays.asList("car"), (Object)response.getHeaders().get((Object)"goo"));
        HttpResponseTest.assertEquals(Arrays.asList("dar", "far"), (Object)response.getHeaders().get((Object)"hoo"));
        HttpResponseTest.assertEquals((String)ETAG_VALUE, (String)response.getHeaders().getETag());
    }

    public void testParseAs_noParser() throws Exception {
        try {
            new MockHttpTransport().createRequestFactory().buildGetRequest(HttpTesting.SIMPLE_GENERIC_URL).execute().parseAs(Object.class);
            HttpResponseTest.fail((String)("expected " + NullPointerException.class));
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
    }

    public void testParseAs_classNoContent() throws Exception {
        final MockLowLevelHttpResponse result = new MockLowLevelHttpResponse();
        for (final int status : new int[]{204, 304, 102}) {
            MockHttpTransport transport = new MockHttpTransport(){

                public LowLevelHttpRequest buildRequest(String method, String url) throws IOException {
                    return new MockLowLevelHttpRequest(){

                        public LowLevelHttpResponse execute() throws IOException {
                            result.setStatusCode(status);
                            result.setContentType(null);
                            result.setContent((InputStream)new ByteArrayInputStream(new byte[0]));
                            return result;
                        }
                    };
                }
            };
            Object parsed = transport.createRequestFactory().buildGetRequest(HttpTesting.SIMPLE_GENERIC_URL).setThrowExceptionOnExecuteError(false).execute().parseAs(Object.class);
            HttpResponseTest.assertNull((Object)parsed);
        }
    }

    public void testParseAs_typeNoContent() throws Exception {
        final MockLowLevelHttpResponse result = new MockLowLevelHttpResponse();
        for (final int status : new int[]{204, 304, 102}) {
            MockHttpTransport transport = new MockHttpTransport(){

                public LowLevelHttpRequest buildRequest(String method, String url) throws IOException {
                    return new MockLowLevelHttpRequest(){

                        public LowLevelHttpResponse execute() throws IOException {
                            result.setStatusCode(status);
                            result.setContentType(null);
                            result.setContent((InputStream)new ByteArrayInputStream(new byte[0]));
                            return result;
                        }
                    };
                }
            };
            Object parsed = transport.createRequestFactory().buildGetRequest(HttpTesting.SIMPLE_GENERIC_URL).setThrowExceptionOnExecuteError(false).execute().parseAs(Object.class);
            HttpResponseTest.assertNull((Object)parsed);
        }
    }

    public void testDownload() throws Exception {
        MockHttpTransport transport = new MockHttpTransport(){

            public LowLevelHttpRequest buildRequest(String method, String url) throws IOException {
                return new MockLowLevelHttpRequest(){

                    public LowLevelHttpResponse execute() throws IOException {
                        MockLowLevelHttpResponse result = new MockLowLevelHttpResponse();
                        result.setContentType("application/json; charset=UTF-8");
                        result.setContent(HttpResponseTest.SAMPLE);
                        return result;
                    }
                };
            }
        };
        HttpRequest request = transport.createRequestFactory().buildGetRequest(HttpTesting.SIMPLE_GENERIC_URL);
        HttpResponse response = request.execute();
        ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
        response.download((OutputStream)outputStream);
        HttpResponseTest.assertEquals((String)SAMPLE, (String)outputStream.toString("UTF-8"));
    }

    public void testDisconnectWithContent() throws Exception {
        final MockLowLevelHttpResponse lowLevelHttpResponse = new MockLowLevelHttpResponse();
        MockHttpTransport transport = new MockHttpTransport(){

            public LowLevelHttpRequest buildRequest(String method, String url) throws IOException {
                return new MockLowLevelHttpRequest(){

                    public LowLevelHttpResponse execute() throws IOException {
                        lowLevelHttpResponse.setContentType("application/json; charset=UTF-8");
                        lowLevelHttpResponse.setContent(HttpResponseTest.SAMPLE);
                        return lowLevelHttpResponse;
                    }
                };
            }
        };
        HttpRequest request = transport.createRequestFactory().buildGetRequest(HttpTesting.SIMPLE_GENERIC_URL);
        HttpResponse response = request.execute();
        HttpResponseTest.assertFalse((boolean)lowLevelHttpResponse.isDisconnected());
        TestableByteArrayInputStream content = (TestableByteArrayInputStream)lowLevelHttpResponse.getContent();
        HttpResponseTest.assertFalse((boolean)content.isClosed());
        response.disconnect();
        HttpResponseTest.assertTrue((boolean)lowLevelHttpResponse.isDisconnected());
        HttpResponseTest.assertTrue((boolean)content.isClosed());
    }

    public void testDisconnectWithNoContent() throws Exception {
        final MockLowLevelHttpResponse lowLevelHttpResponse = new MockLowLevelHttpResponse();
        MockHttpTransport transport = new MockHttpTransport(){

            public LowLevelHttpRequest buildRequest(String method, String url) throws IOException {
                return new MockLowLevelHttpRequest(){

                    public LowLevelHttpResponse execute() throws IOException {
                        return lowLevelHttpResponse;
                    }
                };
            }
        };
        HttpRequest request = transport.createRequestFactory().buildGetRequest(HttpTesting.SIMPLE_GENERIC_URL);
        HttpResponse response = request.execute();
        HttpResponseTest.assertFalse((boolean)lowLevelHttpResponse.isDisconnected());
        response.disconnect();
        HttpResponseTest.assertTrue((boolean)lowLevelHttpResponse.isDisconnected());
    }

    public void testContentLoggingLimitWithLoggingEnabledAndDisabled() throws Exception {
        this.subtestContentLoggingLimit("", 2, false, new String[0]);
        this.subtestContentLoggingLimit("A", 2, false, new String[0]);
        this.subtestContentLoggingLimit("ABC\u0000DEF", 20, true, "Total: 7 bytes", "ABC DEF");
        this.subtestContentLoggingLimit("A", 2, true, "Total: 1 byte", "A");
        try {
            this.subtestContentLoggingLimit("ABC", -1, true, new String[0]);
            HttpResponseTest.fail((String)("Expected: " + IllegalArgumentException.class));
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        this.subtestContentLoggingLimit("ABC", 0, true, "Total: 3 bytes");
        this.subtestContentLoggingLimit("ABC", 2, true, "Total: 3 bytes (logging first 2 bytes)", "AB");
        this.subtestContentLoggingLimit("ABC", 3, true, "Total: 3 bytes", "ABC");
        this.subtestContentLoggingLimit("ABC", 4, true, "Total: 3 bytes", "ABC");
        char[] a = new char[18000];
        Arrays.fill(a, 'x');
        String big = new String(a);
        String formated18kInteger = NumberFormat.getInstance().format(18000L);
        this.subtestContentLoggingLimit(big, Integer.MAX_VALUE, true, String.format("Total: %s bytes", formated18kInteger), big);
        this.subtestContentLoggingLimit(big, 4, true, String.format("Total: %s bytes (logging first 4 bytes)", formated18kInteger), "xxxx");
    }

    public void subtestContentLoggingLimit(final String content, int contentLoggingLimit, boolean loggingEnabled, String ... expectedMessages) throws Exception {
        MockHttpTransport transport = new MockHttpTransport(){

            public LowLevelHttpRequest buildRequest(String method, String url) throws IOException {
                return new MockLowLevelHttpRequest(){

                    public LowLevelHttpResponse execute() throws IOException {
                        MockLowLevelHttpResponse result = new MockLowLevelHttpResponse();
                        result.setContent(content);
                        result.setContentType(HttpResponseTest.VALID_CONTENT_TYPE);
                        return result;
                    }
                };
            }
        };
        HttpTransport.LOGGER.setLevel(Level.CONFIG);
        HttpRequest request = transport.createRequestFactory().buildGetRequest(HttpTesting.SIMPLE_GENERIC_URL);
        request.setLoggingEnabled(loggingEnabled);
        HttpResponse response = request.execute();
        HttpResponseTest.assertEquals((boolean)loggingEnabled, (boolean)response.isLoggingEnabled());
        response.setContentLoggingLimit(contentLoggingLimit);
        LogRecordingHandler recorder = new LogRecordingHandler();
        HttpTransport.LOGGER.addHandler((Handler)recorder);
        response.parseAsString();
        HttpResponseTest.assertEquals(Arrays.asList(expectedMessages), (Object)recorder.messages());
    }

    public void testGetContent_gzipNoContent() throws IOException {
        MockHttpTransport transport = new MockHttpTransport(){

            public LowLevelHttpRequest buildRequest(String method, String url) throws IOException {
                return new MockLowLevelHttpRequest(){

                    public LowLevelHttpResponse execute() throws IOException {
                        MockLowLevelHttpResponse result = new MockLowLevelHttpResponse();
                        result.setContent("");
                        result.setContentEncoding("gzip");
                        result.setContentType(HttpResponseTest.VALID_CONTENT_TYPE);
                        return result;
                    }
                };
            }
        };
        HttpRequest request = transport.createRequestFactory().buildHeadRequest(HttpTesting.SIMPLE_GENERIC_URL);
        InputStream noContent = request.execute().getContent();
        HttpResponseTest.assertNull((Object)noContent);
    }

    public void testGetContent_gzipEncoding_ReturnRawStream() throws IOException {
        MockHttpTransport transport = new MockHttpTransport(){

            public LowLevelHttpRequest buildRequest(String method, String url) throws IOException {
                return new MockLowLevelHttpRequest(){

                    public LowLevelHttpResponse execute() throws IOException {
                        MockLowLevelHttpResponse result = new MockLowLevelHttpResponse();
                        result.setContent("");
                        result.setContentEncoding("gzip");
                        result.setContentType(HttpResponseTest.VALID_CONTENT_TYPE);
                        return result;
                    }
                };
            }
        };
        HttpRequest request = transport.createRequestFactory().buildHeadRequest(HttpTesting.SIMPLE_GENERIC_URL);
        request.setResponseReturnRawInputStream(true);
        HttpResponseTest.assertFalse((String)"it should not decompress stream", (boolean)(request.execute().getContent() instanceof GZIPInputStream));
        HttpResponseTest.assertFalse((String)"it should not buffer stream", (boolean)(request.execute().getContent() instanceof BufferedInputStream));
    }

    public void testGetContent_gzipEncoding_finishReading() throws IOException {
        this.do_testGetContent_gzipEncoding_finishReading("gzip");
    }

    public void testGetContent_gzipEncoding_finishReadingWithUppercaseContentEncoding() throws IOException {
        this.do_testGetContent_gzipEncoding_finishReading("GZIP");
    }

    public void testGetContent_gzipEncoding_finishReadingWithDifferentDefaultLocaleAndUppercaseContentEncoding() throws IOException {
        Locale originalDefaultLocale = Locale.getDefault();
        try {
            Locale.setDefault(Locale.forLanguageTag("tr-TR"));
            this.do_testGetContent_gzipEncoding_finishReading("GZIP");
        }
        finally {
            Locale.setDefault(originalDefaultLocale);
        }
    }

    private void do_testGetContent_gzipEncoding_finishReading(String contentEncoding) throws IOException {
        byte[] mockBytes;
        byte[] dataToCompress = "abcd".getBytes(StandardCharsets.UTF_8);
        try (ByteArrayOutputStream byteStream = new ByteArrayOutputStream(dataToCompress.length);
             GZIPOutputStream zipStream = new GZIPOutputStream(byteStream);){
            zipStream.write(dataToCompress);
            zipStream.close();
            for (int i = 0; i < 1024; ++i) {
                byteStream.write(55);
            }
            mockBytes = byteStream.toByteArray();
        }
        final MockLowLevelHttpResponse mockResponse = new MockLowLevelHttpResponse();
        mockResponse.setContent(mockBytes);
        mockResponse.setContentEncoding(contentEncoding);
        mockResponse.setContentType(VALID_CONTENT_TYPE);
        MockHttpTransport transport = new MockHttpTransport(){

            public LowLevelHttpRequest buildRequest(String method, String url) throws IOException {
                return new MockLowLevelHttpRequest(){

                    public LowLevelHttpResponse execute() throws IOException {
                        return mockResponse;
                    }
                };
            }
        };
        HttpRequest request = transport.createRequestFactory().buildHeadRequest(HttpTesting.SIMPLE_GENERIC_URL);
        HttpResponse response = request.execute();
        try (TestableByteArrayInputStream output = (TestableByteArrayInputStream)mockResponse.getContent();){
            HttpResponseTest.assertFalse((boolean)output.isClosed());
            HttpResponseTest.assertEquals((String)"abcd", (String)response.parseAsString());
            HttpResponseTest.assertTrue((boolean)output.isClosed());
            HttpResponseTest.assertEquals((int)-1, (int)output.read());
        }
    }

    public void testGetContent_otherEncodingWithgzipInItsName_GzipIsNotUsed() throws IOException {
        final MockLowLevelHttpResponse mockResponse = new MockLowLevelHttpResponse();
        mockResponse.setContent("abcd");
        mockResponse.setContentEncoding("otherEncodingWithgzipInItsName");
        mockResponse.setContentType(VALID_CONTENT_TYPE);
        MockHttpTransport transport = new MockHttpTransport(){

            public LowLevelHttpRequest buildRequest(String method, String url) throws IOException {
                return new MockLowLevelHttpRequest(){

                    public LowLevelHttpResponse execute() throws IOException {
                        return mockResponse;
                    }
                };
            }
        };
        HttpRequest request = transport.createRequestFactory().buildHeadRequest(HttpTesting.SIMPLE_GENERIC_URL);
        HttpResponse response = request.execute();
        HttpResponseTest.assertEquals((String)"abcd", (String)response.parseAsString());
    }

    public void testGetContent_bufferedContent() throws IOException {
        MockHttpTransport transport = new MockHttpTransport(){

            public LowLevelHttpRequest buildRequest(String method, String url) throws IOException {
                return new MockLowLevelHttpRequest(){

                    public LowLevelHttpResponse execute() throws IOException {
                        byte[] dataToCompress = HttpResponseTest.ERROR_SAMPLE.getBytes(StandardCharsets.UTF_8);
                        ByteArrayOutputStream content = new ByteArrayOutputStream(dataToCompress.length);
                        try (GZIPOutputStream zipStream = new GZIPOutputStream(content);){
                            zipStream.write(dataToCompress);
                        }
                        MockLowLevelHttpResponse result = new MockLowLevelHttpResponse();
                        result.setStatusCode(403);
                        result.setContentType(HttpResponseTest.JSON_CONTENT_TYPE);
                        result.setContentEncoding("gzip");
                        result.setContent(content.toByteArray());
                        return result;
                    }
                };
            }
        };
        HttpRequest request = transport.createRequestFactory().buildGetRequest(HttpTesting.SIMPLE_GENERIC_URL).setThrowExceptionOnExecuteError(false);
        HttpResponse response = request.execute();
        InputStream content = response.getContent();
        HttpResponseTest.assertTrue((boolean)content.markSupported());
        try (RollbackInputStream is = new RollbackInputStream(content);){
            byte[] bytes = ByteStreams.toByteArray((InputStream)is);
            String text = new String(bytes, response.getContentCharset());
            HttpResponseTest.assertEquals((String)ERROR_SAMPLE, (String)text);
        }
        HttpResponseException exception = new HttpResponseException(response);
        HttpResponseTest.assertEquals((int)exception.getStatusCode(), (int)403);
        HttpResponseTest.assertEquals((String)exception.getContent(), (String)ERROR_SAMPLE);
    }

    static class RollbackInputStream
    extends FilterInputStream {
        private boolean closed;

        RollbackInputStream(InputStream in) {
            super(in);
            in.mark(8192);
        }

        @Override
        public void close() throws IOException {
            if (!this.closed) {
                this.closed = true;
                this.in.reset();
            }
        }
    }

    public static class MyHeaders
    extends HttpHeaders {
        @Key
        public String foo;
        @Key
        public Object obj;
        @Key
        String[] r;
    }
}

