/*
 * Decompiled with CFR 0.152.
 */
package com.google.api.client.http;

import com.google.api.client.http.ByteArrayContent;
import com.google.api.client.http.HttpContent;
import com.google.api.client.http.MultipartContent;
import com.google.api.client.util.StringUtils;
import java.io.ByteArrayOutputStream;
import java.io.OutputStream;
import java.nio.charset.StandardCharsets;
import junit.framework.TestCase;

public class MultipartContentTest
extends TestCase {
    private static final String BOUNDARY = "__END_OF_PART__";
    private static final String CRLF = "\r\n";
    private static final String CONTENT_TYPE = "application/json; charset=UTF-8";
    private static final String HEADERS = MultipartContentTest.headers("application/json; charset=UTF-8", "foo");

    private static String headers(String contentType, String value) {
        return "Content-Length: " + value.length() + CRLF + "Content-Type: " + contentType + CRLF + "content-transfer-encoding: binary" + CRLF;
    }

    public void testRandomContent() throws Exception {
        MultipartContent content = new MultipartContent();
        String boundaryString = content.getBoundary();
        MultipartContentTest.assertNotNull((Object)boundaryString);
        MultipartContentTest.assertTrue((boolean)boundaryString.startsWith(BOUNDARY));
        MultipartContentTest.assertTrue((boolean)boundaryString.endsWith("__"));
        MultipartContentTest.assertEquals((String)("multipart/related; boundary=" + boundaryString), (String)content.getType());
        String[][] VALUES = new String[][]{{"Hello world", "text/plain"}, {"<xml>Hi</xml>", "application/xml"}, {"{x:1,y:2}", "application/json"}};
        StringBuilder expectedStringBuilder = new StringBuilder();
        for (String[] valueTypePair : VALUES) {
            String contentValue = valueTypePair[0];
            String contentType = valueTypePair[1];
            content.addPart(new MultipartContent.Part((HttpContent)ByteArrayContent.fromString((String)contentType, (String)contentValue)));
            expectedStringBuilder.append("--").append(boundaryString).append(CRLF).append(MultipartContentTest.headers(contentType, contentValue)).append(CRLF).append(contentValue).append(CRLF);
        }
        expectedStringBuilder.append("--").append(boundaryString).append("--").append(CRLF);
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        content.writeTo((OutputStream)out);
        String expectedContent = expectedStringBuilder.toString();
        MultipartContentTest.assertEquals((String)expectedContent, (String)out.toString(StandardCharsets.UTF_8.name()));
        MultipartContentTest.assertEquals((long)StringUtils.getBytesUtf8((String)expectedContent).length, (long)content.getLength());
    }

    public void testContent() throws Exception {
        this.subtestContent("--__END_OF_PART__--\r\n", null, new String[0]);
        this.subtestContent("--__END_OF_PART__\r\n" + HEADERS + CRLF + "foo" + CRLF + "--" + BOUNDARY + "--" + CRLF, null, "foo");
        this.subtestContent("--__END_OF_PART__\r\n" + HEADERS + CRLF + "foo" + CRLF + "--" + BOUNDARY + CRLF + HEADERS + CRLF + "bar" + CRLF + "--" + BOUNDARY + "--" + CRLF, null, "foo", "bar");
        this.subtestContent("--myboundary\r\n" + HEADERS + CRLF + "foo" + CRLF + "--myboundary" + CRLF + HEADERS + CRLF + "bar" + CRLF + "--myboundary--" + CRLF, "myboundary", "foo", "bar");
    }

    private void subtestContent(String expectedContent, String boundaryString, String ... contents) throws Exception {
        MultipartContent content = new MultipartContent(boundaryString == null ? BOUNDARY : boundaryString);
        for (String contentValue : contents) {
            content.addPart(new MultipartContent.Part((HttpContent)ByteArrayContent.fromString((String)CONTENT_TYPE, (String)contentValue)));
        }
        if (boundaryString != null) {
            content.setBoundary(boundaryString);
        }
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        content.writeTo((OutputStream)out);
        MultipartContentTest.assertEquals((String)expectedContent, (String)out.toString(StandardCharsets.UTF_8.name()));
        MultipartContentTest.assertEquals((long)StringUtils.getBytesUtf8((String)expectedContent).length, (long)content.getLength());
        MultipartContentTest.assertEquals((String)(boundaryString == null ? "multipart/related; boundary=__END_OF_PART__" : "multipart/related; boundary=" + boundaryString), (String)content.getType());
    }
}

