/*
 * Decompiled with CFR 0.152.
 */
package com.google.api.client.http;

import com.google.api.client.http.UrlEncodedContent;
import com.google.api.client.http.UrlEncodedParser;
import com.google.api.client.util.ArrayMap;
import com.google.api.client.util.GenericData;
import com.google.api.client.util.Key;
import com.google.api.client.util.Objects;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import junit.framework.TestCase;

public class UrlEncodedParserTest
extends TestCase {
    static final String ENUM_VALUE = "otherValue=other&value=VALUE";

    public UrlEncodedParserTest() {
    }

    public UrlEncodedParserTest(String name) {
        super(name);
    }

    public void testParse_simple() {
        Simple actual = new Simple();
        UrlEncodedParser.parse((String)"v=ignore&v=ignore2&q=1&a=x=&b=y&c=z&q=2&undeclared=0&o=object&r=a1&r=a2", (Object)actual);
        Simple expected = new Simple();
        expected.a = "x=";
        expected.b = "y";
        expected.c = "z";
        expected.q = new ArrayList<String>(Arrays.asList("1", "2"));
        expected.r = new String[]{"a1", "a2"};
        expected.o = new ArrayList<String>(Arrays.asList("object"));
        UrlEncodedParserTest.assertEquals((Object)expected, (Object)actual);
        UrlEncodedParserTest.assertNull((Object)expected.v);
    }

    public void testParse_generic() {
        Generic actual = new Generic();
        UrlEncodedParser.parse((String)"p=4&q=1&a=x&p=3&b=y&c=z&d=v&q=2&p=5&o=object", (Object)((Object)actual));
        Generic expected = new Generic();
        expected.a = "x";
        expected.b = "y";
        expected.c = "z";
        expected.q = new ArrayList<String>(Arrays.asList("1", "2"));
        expected.o = new ArrayList<String>(Arrays.asList("object"));
        expected.set("d", Collections.singletonList("v")).set("p", Arrays.asList("4", "3", "5"));
        UrlEncodedParserTest.assertEquals((Object)((Object)expected), (Object)((Object)actual));
        UrlEncodedParserTest.assertEquals(ArrayList.class, actual.get("d").getClass());
    }

    public void testParse_map() {
        ArrayMap actual = new ArrayMap();
        UrlEncodedParser.parse((String)"p=4&q=1&a=x&p=3&b=y&c=z&d=v&q=2&p=5&noval1&noval2=", (Object)actual);
        ArrayMap expected = ArrayMap.create();
        expected.add((Object)"p", Arrays.asList("4", "3", "5"));
        expected.add((Object)"q", Arrays.asList("1", "2"));
        expected.add((Object)"a", Collections.singletonList("x"));
        expected.add((Object)"b", Collections.singletonList("y"));
        expected.add((Object)"c", Collections.singletonList("z"));
        expected.add((Object)"d", Collections.singletonList("v"));
        expected.add((Object)"noval1", Collections.singletonList(""));
        expected.add((Object)"noval2", Collections.singletonList(""));
        UrlEncodedParserTest.assertEquals((Object)expected, (Object)actual);
        UrlEncodedParserTest.assertEquals(ArrayList.class, actual.get((Object)"a").getClass());
    }

    public void testParse_encoding() {
        ArrayMap actual = new ArrayMap();
        UrlEncodedParser.parse((String)"q=%20", (Object)actual);
        ArrayMap expected = ArrayMap.create();
        expected.add((Object)"q", Collections.singletonList(" "));
        UrlEncodedParserTest.assertEquals((Object)expected, (Object)actual);
    }

    public void testParse_null() {
        ArrayMap actual = new ArrayMap();
        UrlEncodedParser.parse((String)null, (Object)actual);
        UrlEncodedParserTest.assertTrue((boolean)actual.isEmpty());
    }

    public void testParse_enum() throws IOException {
        EnumValue actual = new EnumValue();
        UrlEncodedParser.parse((String)ENUM_VALUE, (Object)((Object)actual));
        EnumValue expected = new EnumValue();
        expected.value = E.VALUE;
        expected.otherValue = E.OTHER_VALUE;
        UrlEncodedParserTest.assertEquals((Object)((Object)expected), (Object)((Object)actual));
        this.subtestWriteTo(ENUM_VALUE, (Object)actual);
    }

    private void subtestWriteTo(String expected, Object data) throws IOException {
        UrlEncodedContent content = new UrlEncodedContent(data);
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        content.writeTo((OutputStream)out);
        UrlEncodedParserTest.assertEquals((String)expected, (String)out.toString());
    }

    public static class EnumValue
    extends GenericData {
        @Key
        public E value;
        @Key
        public E otherValue;

        public EnumValue set(String fieldName, Object value) {
            return (EnumValue)super.set(fieldName, value);
        }
    }

    public static enum E {
        VALUE,
        OTHER_VALUE;

    }

    public static class Generic
    extends GenericData {
        @Key
        String a;
        @Key
        String b;
        @Key
        String c;
        @Key
        List<String> q;
        @Key
        Object o;

        public Generic set(String fieldName, Object value) {
            return (Generic)super.set(fieldName, value);
        }
    }

    public static class Simple {
        @Key
        Void v;
        @Key
        String a;
        @Key
        String b;
        @Key
        String c;
        @Key
        List<String> q;
        @Key
        String[] r;
        @Key
        Object o;

        public boolean equals(Object obj) {
            Simple other = (Simple)obj;
            return Objects.equal((Object)this.a, (Object)other.a) && Objects.equal((Object)this.b, (Object)other.b) && Objects.equal((Object)this.c, (Object)other.c) && Objects.equal(this.q, other.q) && Arrays.equals(this.r, other.r) && Objects.equal((Object)this.o, (Object)other.o);
        }

        public String toString() {
            return Objects.toStringHelper((Object)this).add("a", (Object)this.a).add("b", (Object)this.b).add("c", (Object)this.c).add("q", this.q).add("r", Arrays.asList(this.r)).add("o", this.o).toString();
        }
    }
}

