/*
 * Decompiled with CFR 0.152.
 */
package com.google.api.client.http.apache.v2;

import com.google.api.client.http.ByteArrayContent;
import com.google.api.client.http.InputStreamContent;
import com.google.api.client.http.apache.v2.ApacheHttpRequest;
import com.google.api.client.http.apache.v2.HttpExtensionMethod;
import com.google.api.client.testing.http.apache.MockHttpClient;
import com.google.api.client.util.StreamingContent;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import org.apache.http.client.HttpClient;
import org.apache.http.client.methods.HttpRequestBase;
import org.junit.Assert;
import org.junit.Test;

public class ApacheHttpRequestTest {
    @Test
    public void testContentLengthSet() throws Exception {
        HttpExtensionMethod base = new HttpExtensionMethod("POST", "http://www.google.com");
        ApacheHttpRequest request = new ApacheHttpRequest((HttpClient)new MockHttpClient(), (HttpRequestBase)base);
        ByteArrayContent content = new ByteArrayContent("text/plain", "sample".getBytes(StandardCharsets.UTF_8));
        request.setStreamingContent((StreamingContent)content);
        request.setContentLength(content.getLength());
        request.execute();
        Assert.assertFalse((boolean)base.getEntity().isChunked());
        Assert.assertEquals((long)6L, (long)base.getEntity().getContentLength());
    }

    @Test
    public void testChunked() throws Exception {
        byte[] buf = new byte[300];
        Arrays.fill(buf, (byte)32);
        HttpExtensionMethod base = new HttpExtensionMethod("POST", "http://www.google.com");
        ApacheHttpRequest request = new ApacheHttpRequest((HttpClient)new MockHttpClient(), (HttpRequestBase)base);
        InputStreamContent content = new InputStreamContent("text/plain", (InputStream)new ByteArrayInputStream(buf));
        request.setStreamingContent((StreamingContent)content);
        request.execute();
        Assert.assertTrue((boolean)base.getEntity().isChunked());
        Assert.assertEquals((long)-1L, (long)base.getEntity().getContentLength());
    }
}

