/*
 * Decompiled with CFR 0.152.
 */
package com.google.api.client.http.apache.v2;

import com.google.api.client.http.GenericUrl;
import com.google.api.client.http.HttpRequest;
import com.google.api.client.http.HttpResponse;
import com.google.api.client.http.HttpResponseException;
import com.google.api.client.http.LowLevelHttpResponse;
import com.google.api.client.http.apache.v2.ApacheHttpRequest;
import com.google.api.client.http.apache.v2.ApacheHttpTransport;
import com.google.api.client.testing.http.apache.MockHttpClient;
import com.google.api.client.util.ByteArrayStreamingContent;
import com.google.api.client.util.StreamingContent;
import com.sun.net.httpserver.HttpExchange;
import com.sun.net.httpserver.HttpHandler;
import com.sun.net.httpserver.HttpServer;
import java.io.IOException;
import java.io.OutputStream;
import java.net.InetSocketAddress;
import java.nio.charset.StandardCharsets;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.http.Header;
import org.apache.http.HttpClientConnection;
import org.apache.http.HttpException;
import org.apache.http.HttpRequestInterceptor;
import org.apache.http.HttpVersion;
import org.apache.http.ProtocolVersion;
import org.apache.http.client.ClientProtocolException;
import org.apache.http.client.HttpClient;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.conn.ConnectTimeoutException;
import org.apache.http.conn.HttpHostConnectException;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.message.BasicHttpResponse;
import org.apache.http.protocol.HttpContext;
import org.apache.http.protocol.HttpRequestExecutor;
import org.junit.Assert;
import org.junit.Assume;
import org.junit.Test;

public class ApacheHttpTransportTest {
    @Test
    public void testApacheHttpTransport() {
        ApacheHttpTransport transport = new ApacheHttpTransport();
        this.checkHttpTransport(transport);
        Assert.assertFalse((boolean)transport.isMtls());
    }

    @Test
    public void testApacheHttpTransportWithParam() {
        ApacheHttpTransport transport = new ApacheHttpTransport((HttpClient)HttpClients.custom().build(), true);
        this.checkHttpTransport(transport);
        Assert.assertTrue((boolean)transport.isMtls());
    }

    @Test
    public void testNewDefaultHttpClient() {
        HttpClient client = ApacheHttpTransport.newDefaultHttpClient();
        this.checkHttpClient(client);
    }

    private void checkHttpTransport(ApacheHttpTransport transport) {
        Assert.assertNotNull((Object)transport);
        HttpClient client = transport.getHttpClient();
        this.checkHttpClient(client);
    }

    private void checkHttpClient(HttpClient client) {
        Assert.assertNotNull((Object)client);
    }

    @Test
    public void testRequestsWithContent() throws IOException {
        MockHttpClient mockClient = new MockHttpClient(){

            public CloseableHttpResponse execute(HttpUriRequest request) throws IOException, ClientProtocolException {
                return new MockHttpResponse();
            }
        };
        ApacheHttpTransport transport = new ApacheHttpTransport((HttpClient)mockClient);
        this.subtestUnsupportedRequestsWithContent(transport.buildRequest("GET", "http://www.test.url"), "GET");
        this.subtestUnsupportedRequestsWithContent(transport.buildRequest("DELETE", "http://www.test.url"), "DELETE");
        this.subtestUnsupportedRequestsWithContent(transport.buildRequest("HEAD", "http://www.test.url"), "HEAD");
        this.execute(transport.buildRequest("PATCH", "http://www.test.url"));
        this.execute(transport.buildRequest("PUT", "http://www.test.url"));
        this.execute(transport.buildRequest("POST", "http://www.test.url"));
        this.execute(transport.buildRequest("PATCH", "http://www.test.url"));
    }

    private void subtestUnsupportedRequestsWithContent(ApacheHttpRequest request, String method) throws IOException {
        try {
            this.execute(request);
            Assert.fail((String)("expected " + IllegalStateException.class));
        }
        catch (IllegalStateException e) {
            Assert.assertEquals((Object)e.getMessage(), (Object)("Apache HTTP client does not support " + method + " requests with content."));
        }
    }

    private void execute(ApacheHttpRequest request) throws IOException {
        byte[] bytes = "abc".getBytes(StandardCharsets.UTF_8);
        request.setStreamingContent((StreamingContent)new ByteArrayStreamingContent(bytes));
        request.setContentType("text/html");
        request.setContentLength((long)bytes.length);
        request.execute();
    }

    @Test
    public void testRequestShouldNotFollowRedirects() throws IOException {
        final AtomicInteger requestsAttempted = new AtomicInteger(0);
        HttpRequestExecutor requestExecutor = new HttpRequestExecutor(){

            public org.apache.http.HttpResponse execute(org.apache.http.HttpRequest request, HttpClientConnection connection, HttpContext context) throws IOException, HttpException {
                BasicHttpResponse response = new BasicHttpResponse((ProtocolVersion)HttpVersion.HTTP_1_1, 302, null);
                response.addHeader("location", "https://google.com/path");
                requestsAttempted.incrementAndGet();
                return response;
            }
        };
        CloseableHttpClient client = HttpClients.custom().setRequestExecutor(requestExecutor).build();
        ApacheHttpTransport transport = new ApacheHttpTransport((HttpClient)client);
        ApacheHttpRequest request = transport.buildRequest("GET", "https://google.com");
        LowLevelHttpResponse response = request.execute();
        Assert.assertEquals((long)1L, (long)requestsAttempted.get());
        Assert.assertEquals((long)302L, (long)response.getStatusCode());
    }

    @Test
    public void testRequestCanSetHeaders() {
        final AtomicBoolean interceptorCalled = new AtomicBoolean(false);
        CloseableHttpClient client = HttpClients.custom().addInterceptorFirst(new HttpRequestInterceptor(){

            public void process(org.apache.http.HttpRequest request, HttpContext context) throws HttpException, IOException {
                Header header = request.getFirstHeader("foo");
                Assert.assertNotNull((String)"Should have found header", (Object)header);
                Assert.assertEquals((Object)"bar", (Object)header.getValue());
                interceptorCalled.set(true);
                throw new IOException("cancelling request");
            }
        }).build();
        ApacheHttpTransport transport = new ApacheHttpTransport((HttpClient)client);
        ApacheHttpRequest request = transport.buildRequest("GET", "https://google.com");
        request.addHeader("foo", "bar");
        try {
            LowLevelHttpResponse response = request.execute();
            Assert.fail((String)"should not actually make the request");
        }
        catch (IOException exception) {
            Assert.assertEquals((Object)"cancelling request", (Object)exception.getMessage());
        }
        Assert.assertTrue((String)"Expected to have called our test interceptor", (boolean)interceptorCalled.get());
    }

    @Test(timeout=10000L)
    public void testConnectTimeout() {
        Assume.assumeFalse((boolean)this.isWindows());
        Assume.assumeTrue((System.getProperty("java.version").compareTo("17") < 0 ? 1 : 0) != 0);
        ApacheHttpTransport httpTransport = new ApacheHttpTransport();
        GenericUrl url = new GenericUrl("http://google.com:81");
        try {
            httpTransport.createRequestFactory().buildGetRequest(url).setConnectTimeout(100).execute();
            Assert.fail((String)"should have thrown an exception");
        }
        catch (ConnectTimeoutException | HttpHostConnectException throwable) {
        }
        catch (IOException e) {
            Assert.fail((String)("unexpected IOException: " + e.getClass().getName() + ": " + e.getMessage()));
        }
    }

    @Test
    public void testNormalizedUrl() throws IOException {
        HttpHandler handler = new HttpHandler(){

            @Override
            public void handle(HttpExchange httpExchange) throws IOException {
                byte[] response = httpExchange.getRequestURI().toString().getBytes();
                httpExchange.sendResponseHeaders(200, response.length);
                try (OutputStream out = httpExchange.getResponseBody();){
                    out.write(response);
                }
            }
        };
        try (FakeServer server = new FakeServer(handler);){
            ApacheHttpTransport transport = new ApacheHttpTransport();
            GenericUrl testUrl = new GenericUrl("http://localhost/foo//bar");
            testUrl.setPort(server.getPort());
            HttpResponse response = transport.createRequestFactory().buildGetRequest(testUrl).execute();
            Assert.assertEquals((long)200L, (long)response.getStatusCode());
            Assert.assertEquals((Object)"/foo//bar", (Object)response.parseAsString());
        }
    }

    @Test
    public void testReadErrorStream() throws IOException {
        HttpHandler handler = new HttpHandler(){

            @Override
            public void handle(HttpExchange httpExchange) throws IOException {
                byte[] response = "Forbidden".getBytes(StandardCharsets.UTF_8);
                httpExchange.sendResponseHeaders(403, response.length);
                try (OutputStream out = httpExchange.getResponseBody();){
                    out.write(response);
                }
            }
        };
        try (FakeServer server = new FakeServer(handler);){
            ApacheHttpTransport transport = new ApacheHttpTransport();
            GenericUrl testUrl = new GenericUrl("http://localhost/foo//bar");
            testUrl.setPort(server.getPort());
            HttpRequest getRequest = transport.createRequestFactory().buildGetRequest(testUrl);
            getRequest.setThrowExceptionOnExecuteError(false);
            HttpResponse response = getRequest.execute();
            Assert.assertEquals((long)403L, (long)response.getStatusCode());
            Assert.assertEquals((Object)"Forbidden", (Object)response.parseAsString());
        }
    }

    @Test
    public void testReadErrorStream_withException() throws IOException {
        HttpHandler handler = new HttpHandler(){

            @Override
            public void handle(HttpExchange httpExchange) throws IOException {
                byte[] response = "Forbidden".getBytes(StandardCharsets.UTF_8);
                httpExchange.sendResponseHeaders(403, response.length);
                try (OutputStream out = httpExchange.getResponseBody();){
                    out.write(response);
                }
            }
        };
        try (FakeServer server = new FakeServer(handler);){
            ApacheHttpTransport transport = new ApacheHttpTransport();
            GenericUrl testUrl = new GenericUrl("http://localhost/foo//bar");
            testUrl.setPort(server.getPort());
            HttpRequest getRequest = transport.createRequestFactory().buildGetRequest(testUrl);
            try {
                getRequest.execute();
                Assert.fail();
            }
            catch (HttpResponseException ex) {
                Assert.assertEquals((Object)"Forbidden", (Object)ex.getContent());
            }
        }
    }

    private boolean isWindows() {
        return System.getProperty("os.name").startsWith("Windows");
    }

    private static class FakeServer
    implements AutoCloseable {
        private final HttpServer server = HttpServer.create(new InetSocketAddress(0), 0);
        private final ExecutorService executorService = Executors.newFixedThreadPool(1);

        FakeServer(HttpHandler httpHandler) throws IOException {
            this.server.setExecutor(this.executorService);
            this.server.createContext("/", httpHandler);
            this.server.start();
        }

        public int getPort() {
            return this.server.getAddress().getPort();
        }

        @Override
        public void close() {
            this.server.stop(0);
            this.executorService.shutdownNow();
        }
    }

    private static class MockHttpResponse
    extends BasicHttpResponse
    implements CloseableHttpResponse {
        public MockHttpResponse() {
            super((ProtocolVersion)HttpVersion.HTTP_1_1, 200, "OK");
        }

        public void close() throws IOException {
        }
    }
}

