/*
 * Decompiled with CFR 0.152.
 */
package com.google.api.client.util;

import com.google.api.client.util.ArrayMap;
import java.util.Iterator;
import java.util.Map;
import junit.framework.TestCase;

public class ArrayMapTest
extends TestCase {
    public ArrayMapTest() {
    }

    public ArrayMapTest(String testName) {
        super(testName);
    }

    public void testOf_zero() {
        ArrayMap map = ArrayMap.of((Object[])new Object[0]);
        ArrayMapTest.assertTrue((boolean)map.isEmpty());
    }

    public void testOf_one() {
        ArrayMap map = ArrayMap.of((Object[])new Object[]{"a", 1});
        ArrayMapTest.assertEquals((int)1, (int)map.size());
        ArrayMapTest.assertEquals((String)"a", (String)((String)map.getKey(0)));
        ArrayMapTest.assertEquals((Object)1, (Object)map.getValue(0));
    }

    public void testOf_two() {
        ArrayMap map = ArrayMap.of((Object[])new Object[]{"a", 1, "b", 2});
        ArrayMapTest.assertEquals((int)2, (int)map.size());
        ArrayMapTest.assertEquals((String)"a", (String)((String)map.getKey(0)));
        ArrayMapTest.assertEquals((Object)1, (Object)map.getValue(0));
        ArrayMapTest.assertEquals((String)"b", (String)((String)map.getKey(1)));
        ArrayMapTest.assertEquals((Object)2, (Object)map.getValue(1));
    }

    public void testRemove1() {
        ArrayMap map = ArrayMap.of((Object[])new Object[]{"a", 1, "b", 2});
        map.remove((Object)"b");
        ArrayMapTest.assertEquals((Object)ArrayMap.of((Object[])new Object[]{"a", 1}), (Object)map);
    }

    public void testRemove2() {
        ArrayMap map = ArrayMap.of((Object[])new Object[]{"a", 1, "b", 2});
        map.remove((Object)"a");
        ArrayMapTest.assertEquals((Object)ArrayMap.of((Object[])new Object[]{"b", 2}), (Object)map);
    }

    public void testRemove3() {
        ArrayMap map = ArrayMap.of((Object[])new Object[]{"a", 1});
        map.remove((Object)"a");
        ArrayMapTest.assertEquals((Object)ArrayMap.of((Object[])new Object[0]), (Object)map);
    }

    public void testRemove4() {
        ArrayMap map = ArrayMap.of((Object[])new Object[]{"a", 1, "b", 2, "c", 3});
        map.remove((Object)"b");
        ArrayMapTest.assertEquals((Object)ArrayMap.of((Object[])new Object[]{"a", 1, "c", 3}), (Object)map);
    }

    public void testClone_changingEntrySet() {
        ArrayMap map = ArrayMap.of((Object[])new Object[0]);
        ArrayMapTest.assertEquals((String)"{}", (String)map.toString());
        ArrayMap clone = map.clone();
        clone.add((Object)"foo", (Object)"bar");
        ArrayMapTest.assertEquals((String)"{foo=bar}", (String)clone.toString());
    }

    public void testSet() {
        ArrayMap map = ArrayMap.of((Object[])new Object[0]);
        map.set(0, (Object)"a", (Object)1);
        ArrayMapTest.assertEquals((Object)ArrayMap.of((Object[])new Object[]{"a", 1}), (Object)map);
        map.set(0, (Object)2);
        ArrayMapTest.assertEquals((Object)ArrayMap.of((Object[])new Object[]{"a", 2}), (Object)map);
        try {
            map.set(-1, (Object)1);
            ArrayMapTest.fail((String)"expected ArrayIndexOutOfBoundsException");
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            // empty catch block
        }
        try {
            map.set(1, (Object)1);
            ArrayMapTest.fail((String)"expected ArrayIndexOutOfBoundsException");
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            // empty catch block
        }
    }

    public void testHashCode() {
        ArrayMap map = ArrayMap.of((Object[])new Object[0]);
        map.set(0, (Object)"a", null);
        map.set(1, null, (Object)1);
        map.set(2, null, null);
        ArrayMapTest.assertTrue((map.hashCode() > 0 ? 1 : 0) != 0);
    }

    public void testIteratorRemove1() {
        ArrayMap map = new ArrayMap();
        map.put((Object)"a", (Object)"a");
        map.put((Object)"b", (Object)"b");
        map.put((Object)"c", (Object)"c");
        Iterator iter = map.entrySet().iterator();
        while (iter.hasNext()) {
            Map.Entry entry = (Map.Entry)iter.next();
            if ("all".equalsIgnoreCase((String)entry.getKey())) continue;
            iter.remove();
        }
        ArrayMapTest.assertEquals((int)0, (int)map.size());
    }

    public void testIteratorRemove2() {
        ArrayMap map = new ArrayMap();
        map.put((Object)"a", (Object)"a");
        map.put((Object)"b", (Object)"b");
        map.put((Object)"c", (Object)"c");
        Iterator iter = map.entrySet().iterator();
        while (iter.hasNext()) {
            Map.Entry entry = (Map.Entry)iter.next();
            if (!"b".equalsIgnoreCase((String)entry.getKey())) continue;
            iter.remove();
        }
        ArrayMapTest.assertEquals((int)2, (int)map.size());
        ArrayMapTest.assertEquals((String)"a", (String)((String)map.get((Object)"a")));
        ArrayMapTest.assertEquals((String)"c", (String)((String)map.get((Object)"c")));
    }

    public void testIteratorRemove3() {
        ArrayMap map = new ArrayMap();
        map.put((Object)"a", (Object)"a");
        map.put((Object)"b", (Object)"b");
        map.put((Object)"c", (Object)"c");
        Iterator iter = map.entrySet().iterator();
        while (iter.hasNext()) {
            Map.Entry entry = (Map.Entry)iter.next();
            if ("b".equalsIgnoreCase((String)entry.getKey())) continue;
            iter.remove();
        }
        ArrayMapTest.assertEquals((int)1, (int)map.size());
        ArrayMapTest.assertEquals((String)"b", (String)((String)map.get((Object)"b")));
    }
}

