/*
 * Decompiled with CFR 0.152.
 */
package com.google.api.client.util;

import com.google.api.client.util.Base64;
import java.nio.charset.StandardCharsets;
import junit.framework.TestCase;

public class Base64Test
extends TestCase {
    public void test_decodeBase64_withPadding() {
        String encoded = "Zm9vOmJhcg==";
        Base64Test.assertEquals((String)"foo:bar", (String)new String(Base64.decodeBase64((String)encoded), StandardCharsets.UTF_8));
    }

    public void test_decodeBase64_withoutPadding() {
        String encoded = "Zm9vOmJhcg";
        Base64Test.assertEquals((String)"foo:bar", (String)new String(Base64.decodeBase64((String)encoded), StandardCharsets.UTF_8));
    }

    public void test_decodeBase64_withTrailingWhitespace() {
        String encoded = "Zm9vOmJhcg==\r\n";
        Base64Test.assertEquals((String)"foo:bar", (String)new String(Base64.decodeBase64((String)encoded), StandardCharsets.UTF_8));
    }

    public void test_decodeBase64_withNullBytes_shouldReturnNull() {
        byte[] encoded = null;
        Base64Test.assertNull((Object)Base64.decodeBase64(encoded));
    }

    public void test_decodeBase64_withNull_shouldReturnNull() {
        String encoded = null;
        Base64Test.assertNull((Object)Base64.decodeBase64(encoded));
    }

    public void test_encodeBase64URLSafeString_withNull_shouldReturnNull() {
        Base64Test.assertNull((Object)Base64.encodeBase64URLSafeString(null));
    }

    public void test_encodeBase64URLSafe_withNull_shouldReturnNull() {
        Base64Test.assertNull((Object)Base64.encodeBase64URLSafe(null));
    }

    public void test_encodeBase64_withNull_shouldReturnNull() {
        Base64Test.assertNull((Object)Base64.encodeBase64(null));
    }
}

