/*
 * Decompiled with CFR 0.152.
 */
package com.google.api.client.util;

import com.google.api.client.util.Data;
import com.google.api.client.util.DataMap;
import com.google.api.client.util.Key;
import cz.o2.proxima.internal.shaded.com.google.common.collect.ImmutableList;
import cz.o2.proxima.internal.shaded.com.google.common.collect.Lists;
import java.util.Map;
import junit.framework.TestCase;

public class DataMapTest
extends TestCase {
    public void testSizeAndIsEmpty() {
        A a = new A();
        DataMap map = new DataMap((Object)a, false);
        DataMapTest.assertEquals((int)0, (int)map.size());
        DataMapTest.assertTrue((boolean)map.isEmpty());
        a.s = "s";
        DataMapTest.assertEquals((int)1, (int)map.size());
        DataMapTest.assertFalse((boolean)map.isEmpty());
        a.r = "r";
        DataMapTest.assertEquals((int)2, (int)map.size());
        DataMapTest.assertFalse((boolean)map.isEmpty());
        a.t = Data.NULL_STRING;
        DataMapTest.assertEquals((int)3, (int)map.size());
        DataMapTest.assertFalse((boolean)map.isEmpty());
    }

    public void testIterator() {
        A a = new A();
        a.s = "value";
        DataMap map = new DataMap((Object)a, false);
        DataMap.EntryIterator iterator = map.entrySet().iterator();
        DataMapTest.assertTrue((boolean)iterator.hasNext());
        Map.Entry entry = (Map.Entry)iterator.next();
        DataMapTest.assertEquals((String)"s", (String)((String)entry.getKey()));
        DataMapTest.assertEquals((Object)"value", entry.getValue());
        iterator.remove();
        DataMapTest.assertNull((Object)a.s);
        DataMapTest.assertFalse((boolean)iterator.hasNext());
    }

    public void testValues() {
        A a = new A();
        a.r = "r";
        a.s = "s";
        a.t = "t";
        DataMap map = new DataMap((Object)a, false);
        DataMapTest.assertEquals((Object)ImmutableList.of((Object)"r", (Object)"s", (Object)"t"), (Object)Lists.newArrayList((Iterable)map.values()));
        a.s = null;
        DataMapTest.assertEquals((Object)ImmutableList.of((Object)"r", (Object)"t"), (Object)Lists.newArrayList((Iterable)map.values()));
        a.r = null;
        DataMapTest.assertEquals((Object)ImmutableList.of((Object)"t"), (Object)Lists.newArrayList((Iterable)map.values()));
        a.t = null;
        DataMapTest.assertEquals((Object)ImmutableList.of(), (Object)Lists.newArrayList((Iterable)map.values()));
    }

    public void testKeys() {
        A a = new A();
        a.r = "r";
        a.s = "s";
        a.t = "t";
        DataMap map = new DataMap((Object)a, false);
        DataMapTest.assertEquals((Object)ImmutableList.of((Object)"r", (Object)"s", (Object)"t"), (Object)Lists.newArrayList((Iterable)map.keySet()));
        a.s = null;
        DataMapTest.assertEquals((Object)ImmutableList.of((Object)"r", (Object)"t"), (Object)Lists.newArrayList((Iterable)map.keySet()));
        a.r = null;
        DataMapTest.assertEquals((Object)ImmutableList.of((Object)"t"), (Object)Lists.newArrayList((Iterable)map.keySet()));
        a.t = null;
        DataMapTest.assertEquals((Object)ImmutableList.of(), (Object)Lists.newArrayList((Iterable)map.keySet()));
    }

    public void testClear() {
        A a = new A();
        a.r = "r";
        a.s = "s";
        DataMap map = new DataMap((Object)a, false);
        map.clear();
        DataMapTest.assertTrue((boolean)map.isEmpty());
        map.clear();
        DataMapTest.assertTrue((boolean)map.isEmpty());
    }

    public void testGetKeyAndContainsKey() {
        A a = new A();
        a.r = "rv";
        DataMap map = new DataMap((Object)a, false);
        DataMapTest.assertNull((Object)map.get((Object)"no"));
        DataMapTest.assertFalse((boolean)map.containsKey((Object)"no"));
        DataMapTest.assertNull((Object)map.get((Object)"s"));
        DataMapTest.assertFalse((boolean)map.containsKey((Object)"s"));
        DataMapTest.assertEquals((Object)"rv", (Object)map.get((Object)"r"));
        DataMapTest.assertTrue((boolean)map.containsKey((Object)"r"));
    }

    public void testPut() {
        A a = new A();
        a.r = "rv";
        DataMap map = new DataMap((Object)a, false);
        DataMapTest.assertNull((Object)map.put("s", (Object)"sv"));
        DataMapTest.assertEquals((String)"sv", (String)a.s);
        DataMapTest.assertEquals((Object)"rv", (Object)map.put("r", (Object)"rv2"));
        DataMapTest.assertEquals((String)"rv2", (String)a.r);
    }

    static class A {
        @Key
        String r;
        @Key
        String s;
        @Key
        String t;

        A() {
        }
    }
}

