/*
 * Decompiled with CFR 0.152.
 */
package com.google.api.client.util;

import com.google.api.client.testing.util.LogRecordingHandler;
import com.google.api.client.util.ByteArrayStreamingContent;
import com.google.api.client.util.LoggingStreamingContent;
import com.google.api.client.util.StreamingContent;
import java.io.ByteArrayOutputStream;
import java.io.OutputStream;
import java.util.Arrays;
import java.util.logging.Handler;
import java.util.logging.Level;
import java.util.logging.Logger;
import junit.framework.TestCase;

public class LoggingStreamingContentTest
extends TestCase {
    static final Logger LOGGER = Logger.getLogger(LoggingStreamingContentTest.class.getName());
    private static final byte[] SAMPLE_UTF8 = new byte[]{49, 50, 51, -41, -103, -41, -96, -41, -103, -41, -111};
    private static final String SAMPLE = "123\u05d9\u05e0\u05d9\u05d1";

    public void testWriteTo() throws Exception {
        LoggingStreamingContent logContent = new LoggingStreamingContent((StreamingContent)new ByteArrayStreamingContent(SAMPLE_UTF8), LOGGER, Level.CONFIG, Integer.MAX_VALUE);
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        LOGGER.setLevel(Level.CONFIG);
        LogRecordingHandler recorder = new LogRecordingHandler();
        LOGGER.addHandler((Handler)recorder);
        logContent.writeTo((OutputStream)out);
        out.close();
        LoggingStreamingContentTest.assertEquals(Arrays.asList("Total: 11 bytes", SAMPLE), (Object)recorder.messages());
    }

    public void testContentLoggingLimit() throws Exception {
        LOGGER.setLevel(Level.CONFIG);
        LogRecordingHandler recorder = new LogRecordingHandler();
        LOGGER.addHandler((Handler)recorder);
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        LoggingStreamingContent logContent = new LoggingStreamingContent((StreamingContent)new ByteArrayStreamingContent(SAMPLE_UTF8), LOGGER, Level.CONFIG, SAMPLE_UTF8.length);
        logContent.writeTo((OutputStream)out);
        LoggingStreamingContentTest.assertEquals(Arrays.asList("Total: 11 bytes", SAMPLE), (Object)recorder.messages());
        recorder = new LogRecordingHandler();
        LOGGER.addHandler((Handler)recorder);
        logContent = new LoggingStreamingContent((StreamingContent)new ByteArrayStreamingContent(SAMPLE_UTF8), LOGGER, Level.CONFIG, SAMPLE_UTF8.length - 1);
        logContent.writeTo((OutputStream)new ByteArrayOutputStream());
        LoggingStreamingContentTest.assertEquals(Arrays.asList("Total: 11 bytes (logging first 10 bytes)", "123\u05d9\u05e0\u05d9\ufffd"), (Object)recorder.messages());
        recorder = new LogRecordingHandler();
        LOGGER.addHandler((Handler)recorder);
        logContent = new LoggingStreamingContent((StreamingContent)new ByteArrayStreamingContent(SAMPLE_UTF8), LOGGER, Level.CONFIG, 0);
        logContent.writeTo((OutputStream)new ByteArrayOutputStream());
        LoggingStreamingContentTest.assertEquals(Arrays.asList("Total: 11 bytes"), (Object)recorder.messages());
        recorder = new LogRecordingHandler();
        LOGGER.addHandler((Handler)recorder);
        logContent = new LoggingStreamingContent((StreamingContent)new ByteArrayStreamingContent(SAMPLE_UTF8), LOGGER, Level.CONFIG, SAMPLE_UTF8.length);
        logContent.writeTo((OutputStream)new ByteArrayOutputStream());
        LoggingStreamingContentTest.assertEquals(Arrays.asList("Total: 11 bytes", SAMPLE), (Object)recorder.messages());
        try {
            logContent = new LoggingStreamingContent((StreamingContent)new ByteArrayStreamingContent(SAMPLE_UTF8), LOGGER, Level.CONFIG, -1);
            logContent.writeTo((OutputStream)new ByteArrayOutputStream());
            LoggingStreamingContentTest.fail((String)("Expected: " + IllegalArgumentException.class));
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }
}

