/*
 * Decompiled with CFR 0.152.
 */
package com.google.api.client.util.escape;

import com.google.api.client.util.escape.CharEscapers;
import junit.framework.TestCase;

public class CharEscapersTest
extends TestCase {
    public void testDecodeUriPath() {
        this.subtestDecodeUriPath(null, null);
        this.subtestDecodeUriPath("", "");
        this.subtestDecodeUriPath("abc", "abc");
        this.subtestDecodeUriPath("a+b%2Bc", "a+b+c");
        this.subtestDecodeUriPath("Go%3D%23%2F%25%26%20?%3Co%3Egle", "Go=#/%& ?<o>gle");
    }

    private void subtestDecodeUriPath(String input, String expected) {
        String actual = CharEscapers.decodeUriPath((String)input);
        CharEscapersTest.assertEquals((String)expected, (String)actual);
    }

    public void testDecodeUri_IllegalArgumentException() {
        this.subtestDecodeUri_IllegalArgumentException("abc%-1abc");
        this.subtestDecodeUri_IllegalArgumentException("%JJ");
        this.subtestDecodeUri_IllegalArgumentException("abc%0");
    }

    private void subtestDecodeUri_IllegalArgumentException(String input) {
        try {
            CharEscapers.decodeUriPath((String)input);
            CharEscapersTest.fail();
        }
        catch (IllegalArgumentException expected) {
            CharEscapersTest.assertNotNull((Object)expected.getMessage());
        }
    }
}

