/*
 * Decompiled with CFR 0.152.
 */
package com.google.auth.oauth2;

import com.google.api.client.json.GenericJson;
import com.google.api.client.json.JsonParser;
import com.google.api.client.testing.http.MockLowLevelHttpRequest;
import com.google.auth.TestUtils;
import com.google.auth.http.HttpTransportFactory;
import com.google.auth.oauth2.AccessToken;
import com.google.auth.oauth2.AwsCredentials;
import com.google.auth.oauth2.AwsSecurityCredentials;
import com.google.auth.oauth2.EnvironmentProvider;
import com.google.auth.oauth2.ExternalAccountCredentials;
import com.google.auth.oauth2.ExternalAccountCredentialsTest;
import com.google.auth.oauth2.OAuth2Utils;
import com.google.auth.oauth2.SystemEnvironmentProvider;
import com.google.auth.oauth2.TestEnvironmentProvider;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.net.URLDecoder;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.JUnit4;

@RunWith(value=JUnit4.class)
public class AwsCredentialsTest {
    private static final String STS_URL = "https://sts.googleapis.com";
    private static final String AWS_CREDENTIALS_URL = "https://www.aws-credentials.com";
    private static final String AWS_CREDENTIALS_URL_WITH_ROLE = "https://www.aws-credentials.com/roleName";
    private static final String AWS_REGION_URL = "https://www.aws-region.com";
    private static final String AWS_IMDSV2_SESSION_TOKEN_URL = "https://www.aws-session-token.com";
    private static final String AWS_IMDSV2_SESSION_TOKEN = "sessiontoken";
    private static final String GET_CALLER_IDENTITY_URL = "https://sts.amazonaws.com?Action=GetCallerIdentity&Version=2011-06-15";
    private static final String SERVICE_ACCOUNT_IMPERSONATION_URL = "https://iamcredentials.googleapis.com/v1/projects/-/serviceAccounts/testn@test.iam.gserviceaccount.com:generateAccessToken";
    private static final Map<String, Object> AWS_CREDENTIAL_SOURCE_MAP = new HashMap<String, Object>(){
        {
            this.put("environment_id", "aws1");
            this.put("region_url", "regionUrl");
            this.put("url", "url");
            this.put("regional_cred_verification_url", "regionalCredVerificationUrl");
        }
    };
    private static final Map<String, Object> EMPTY_METADATA_HEADERS = Collections.emptyMap();
    private static final Map<String, String> EMPTY_STRING_HEADERS = Collections.emptyMap();
    private static final AwsCredentials.AwsCredentialSource AWS_CREDENTIAL_SOURCE = new AwsCredentials.AwsCredentialSource(AWS_CREDENTIAL_SOURCE_MAP);
    private static final AwsCredentials AWS_CREDENTIAL = (AwsCredentials)AwsCredentials.newBuilder().setHttpTransportFactory(OAuth2Utils.HTTP_TRANSPORT_FACTORY).setAudience("audience").setSubjectTokenType("subjectTokenType").setTokenUrl("https://sts.googleapis.com").setTokenInfoUrl("tokenInfoUrl").setCredentialSource((ExternalAccountCredentials.CredentialSource)AWS_CREDENTIAL_SOURCE).build();

    @Test
    public void refreshAccessToken_withoutServiceAccountImpersonation() throws IOException {
        ExternalAccountCredentialsTest.MockExternalAccountCredentialsTransportFactory transportFactory = new ExternalAccountCredentialsTest.MockExternalAccountCredentialsTransportFactory();
        AwsCredentials awsCredential = (AwsCredentials)AwsCredentials.newBuilder((AwsCredentials)AWS_CREDENTIAL).setTokenUrl(transportFactory.transport.getStsUrl()).setHttpTransportFactory((HttpTransportFactory)transportFactory).setCredentialSource((ExternalAccountCredentials.CredentialSource)AwsCredentialsTest.buildAwsCredentialSource(transportFactory)).build();
        AccessToken accessToken = awsCredential.refreshAccessToken();
        Assert.assertEquals((Object)transportFactory.transport.getAccessToken(), (Object)accessToken.getTokenValue());
    }

    @Test
    public void refreshAccessToken_withServiceAccountImpersonation() throws IOException {
        ExternalAccountCredentialsTest.MockExternalAccountCredentialsTransportFactory transportFactory = new ExternalAccountCredentialsTest.MockExternalAccountCredentialsTransportFactory();
        transportFactory.transport.setExpireTime(TestUtils.getDefaultExpireTime());
        AwsCredentials awsCredential = (AwsCredentials)AwsCredentials.newBuilder((AwsCredentials)AWS_CREDENTIAL).setTokenUrl(transportFactory.transport.getStsUrl()).setServiceAccountImpersonationUrl(transportFactory.transport.getServiceAccountImpersonationUrl()).setHttpTransportFactory((HttpTransportFactory)transportFactory).setCredentialSource((ExternalAccountCredentials.CredentialSource)AwsCredentialsTest.buildAwsCredentialSource(transportFactory)).build();
        AccessToken accessToken = awsCredential.refreshAccessToken();
        Assert.assertEquals((Object)transportFactory.transport.getServiceAccountAccessToken(), (Object)accessToken.getTokenValue());
    }

    @Test
    public void refreshAccessToken_withServiceAccountImpersonationOptions() throws IOException {
        ExternalAccountCredentialsTest.MockExternalAccountCredentialsTransportFactory transportFactory = new ExternalAccountCredentialsTest.MockExternalAccountCredentialsTransportFactory();
        transportFactory.transport.setExpireTime(TestUtils.getDefaultExpireTime());
        AwsCredentials awsCredential = (AwsCredentials)AwsCredentials.newBuilder((AwsCredentials)AWS_CREDENTIAL).setTokenUrl(transportFactory.transport.getStsUrl()).setServiceAccountImpersonationUrl(transportFactory.transport.getServiceAccountImpersonationUrl()).setHttpTransportFactory((HttpTransportFactory)transportFactory).setCredentialSource((ExternalAccountCredentials.CredentialSource)AwsCredentialsTest.buildAwsCredentialSource(transportFactory)).setServiceAccountImpersonationOptions(ExternalAccountCredentialsTest.buildServiceAccountImpersonationOptions(2800)).build();
        AccessToken accessToken = awsCredential.refreshAccessToken();
        Assert.assertEquals((Object)transportFactory.transport.getServiceAccountAccessToken(), (Object)accessToken.getTokenValue());
        GenericJson query = (GenericJson)OAuth2Utils.JSON_FACTORY.createJsonParser(transportFactory.transport.getLastRequest().getContentAsString()).parseAndClose(GenericJson.class);
        Assert.assertEquals((Object)"2800s", (Object)query.get((Object)"lifetime"));
    }

    @Test
    public void retrieveSubjectToken() throws IOException {
        ExternalAccountCredentialsTest.MockExternalAccountCredentialsTransportFactory transportFactory = new ExternalAccountCredentialsTest.MockExternalAccountCredentialsTransportFactory();
        AwsCredentials awsCredential = (AwsCredentials)AwsCredentials.newBuilder((AwsCredentials)AWS_CREDENTIAL).setHttpTransportFactory((HttpTransportFactory)transportFactory).setCredentialSource((ExternalAccountCredentials.CredentialSource)AwsCredentialsTest.buildAwsCredentialSource(transportFactory)).build();
        String subjectToken = URLDecoder.decode(awsCredential.retrieveSubjectToken(), "UTF-8");
        JsonParser parser = OAuth2Utils.JSON_FACTORY.createJsonParser(subjectToken);
        GenericJson json = (GenericJson)parser.parseAndClose(GenericJson.class);
        List headersList = (List)json.get((Object)"headers");
        HashMap headers = new HashMap();
        for (Map header : headersList) {
            headers.put(header.get("key"), header.get("value"));
        }
        Assert.assertEquals((Object)"POST", (Object)json.get((Object)"method"));
        Assert.assertEquals((Object)GET_CALLER_IDENTITY_URL, (Object)json.get((Object)"url"));
        Assert.assertEquals((Object)URI.create(GET_CALLER_IDENTITY_URL).getHost(), headers.get("host"));
        Assert.assertEquals((Object)"token", headers.get("x-amz-security-token"));
        Assert.assertEquals((Object)awsCredential.getAudience(), headers.get("x-goog-cloud-target-resource"));
        Assert.assertTrue((boolean)headers.containsKey("x-amz-date"));
        Assert.assertNotNull(headers.get("Authorization"));
        List<MockLowLevelHttpRequest> requests = transportFactory.transport.getRequests();
        Assert.assertEquals((long)3L, (long)requests.size());
        AwsCredentialsTest.ValidateRequest(requests.get(0), AWS_REGION_URL, EMPTY_STRING_HEADERS);
        AwsCredentialsTest.ValidateRequest(requests.get(1), AWS_CREDENTIALS_URL, EMPTY_STRING_HEADERS);
        AwsCredentialsTest.ValidateRequest(requests.get(2), AWS_CREDENTIALS_URL_WITH_ROLE, EMPTY_STRING_HEADERS);
    }

    @Test
    public void retrieveSubjectTokenWithSessionTokenUrl() throws IOException {
        ExternalAccountCredentialsTest.MockExternalAccountCredentialsTransportFactory transportFactory = new ExternalAccountCredentialsTest.MockExternalAccountCredentialsTransportFactory();
        HashMap<String, String> credentialSourceMap = new HashMap<String, String>();
        credentialSourceMap.put("environment_id", "aws1");
        credentialSourceMap.put("region_url", transportFactory.transport.getAwsRegionUrl());
        credentialSourceMap.put("url", transportFactory.transport.getAwsCredentialsUrl());
        credentialSourceMap.put("regional_cred_verification_url", GET_CALLER_IDENTITY_URL);
        credentialSourceMap.put("imdsv2_session_token_url", transportFactory.transport.getAwsImdsv2SessionTokenUrl());
        AwsCredentials awsCredential = (AwsCredentials)AwsCredentials.newBuilder((AwsCredentials)AWS_CREDENTIAL).setHttpTransportFactory((HttpTransportFactory)transportFactory).setCredentialSource((ExternalAccountCredentials.CredentialSource)new AwsCredentials.AwsCredentialSource(credentialSourceMap)).build();
        String subjectToken = URLDecoder.decode(awsCredential.retrieveSubjectToken(), "UTF-8");
        JsonParser parser = OAuth2Utils.JSON_FACTORY.createJsonParser(subjectToken);
        GenericJson json = (GenericJson)parser.parseAndClose(GenericJson.class);
        List headersList = (List)json.get((Object)"headers");
        HashMap headers = new HashMap();
        for (Map header : headersList) {
            headers.put(header.get("key"), header.get("value"));
        }
        Assert.assertEquals((Object)"POST", (Object)json.get((Object)"method"));
        Assert.assertEquals((Object)GET_CALLER_IDENTITY_URL, (Object)json.get((Object)"url"));
        Assert.assertEquals((Object)URI.create(GET_CALLER_IDENTITY_URL).getHost(), headers.get("host"));
        Assert.assertEquals((Object)"token", headers.get("x-amz-security-token"));
        Assert.assertEquals((Object)awsCredential.getAudience(), headers.get("x-goog-cloud-target-resource"));
        Assert.assertTrue((boolean)headers.containsKey("x-amz-date"));
        Assert.assertNotNull(headers.get("Authorization"));
        List<MockLowLevelHttpRequest> requests = transportFactory.transport.getRequests();
        Assert.assertEquals((long)4L, (long)requests.size());
        AwsCredentialsTest.ValidateRequest(requests.get(0), AWS_IMDSV2_SESSION_TOKEN_URL, (Map<String, String>)new HashMap<String, String>(){
            {
                this.put("x-aws-ec2-metadata-token-ttl-seconds", "300");
            }
        });
        HashMap<String, String> sessionTokenHeader = new HashMap<String, String>(){
            {
                this.put("x-aws-ec2-metadata-token", AwsCredentialsTest.AWS_IMDSV2_SESSION_TOKEN);
            }
        };
        AwsCredentialsTest.ValidateRequest(requests.get(1), AWS_REGION_URL, (Map<String, String>)sessionTokenHeader);
        AwsCredentialsTest.ValidateRequest(requests.get(2), AWS_CREDENTIALS_URL, (Map<String, String>)sessionTokenHeader);
        AwsCredentialsTest.ValidateRequest(requests.get(3), AWS_CREDENTIALS_URL_WITH_ROLE, (Map<String, String>)sessionTokenHeader);
    }

    @Test
    public void retrieveSubjectToken_noRegion_expectThrows() {
        ExternalAccountCredentialsTest.MockExternalAccountCredentialsTransportFactory transportFactory = new ExternalAccountCredentialsTest.MockExternalAccountCredentialsTransportFactory();
        IOException response = new IOException();
        transportFactory.transport.addResponseErrorSequence(response);
        AwsCredentials awsCredential = (AwsCredentials)AwsCredentials.newBuilder((AwsCredentials)AWS_CREDENTIAL).setHttpTransportFactory((HttpTransportFactory)transportFactory).setCredentialSource((ExternalAccountCredentials.CredentialSource)AwsCredentialsTest.buildAwsCredentialSource(transportFactory)).build();
        try {
            awsCredential.retrieveSubjectToken();
            Assert.fail((String)"Should not be able to use credential without exception.");
        }
        catch (IOException exception) {
            Assert.assertEquals((Object)"Failed to retrieve AWS region.", (Object)exception.getMessage());
        }
        List<MockLowLevelHttpRequest> requests = transportFactory.transport.getRequests();
        Assert.assertEquals((long)1L, (long)requests.size());
        AwsCredentialsTest.ValidateRequest(requests.get(0), AWS_REGION_URL, EMPTY_STRING_HEADERS);
    }

    @Test
    public void retrieveSubjectToken_noRole_expectThrows() {
        ExternalAccountCredentialsTest.MockExternalAccountCredentialsTransportFactory transportFactory = new ExternalAccountCredentialsTest.MockExternalAccountCredentialsTransportFactory();
        IOException response = new IOException();
        transportFactory.transport.addResponseErrorSequence(response);
        transportFactory.transport.addResponseSequence(true, false);
        AwsCredentials awsCredential = (AwsCredentials)AwsCredentials.newBuilder((AwsCredentials)AWS_CREDENTIAL).setHttpTransportFactory((HttpTransportFactory)transportFactory).setCredentialSource((ExternalAccountCredentials.CredentialSource)AwsCredentialsTest.buildAwsCredentialSource(transportFactory)).build();
        try {
            awsCredential.retrieveSubjectToken();
            Assert.fail((String)"Should not be able to use credential without exception.");
        }
        catch (IOException exception) {
            Assert.assertEquals((Object)"Failed to retrieve AWS IAM role.", (Object)exception.getMessage());
        }
        List<MockLowLevelHttpRequest> requests = transportFactory.transport.getRequests();
        Assert.assertEquals((long)2L, (long)requests.size());
        AwsCredentialsTest.ValidateRequest(requests.get(0), AWS_REGION_URL, EMPTY_STRING_HEADERS);
        AwsCredentialsTest.ValidateRequest(requests.get(1), AWS_CREDENTIALS_URL, EMPTY_STRING_HEADERS);
    }

    @Test
    public void retrieveSubjectToken_noCredentials_expectThrows() {
        ExternalAccountCredentialsTest.MockExternalAccountCredentialsTransportFactory transportFactory = new ExternalAccountCredentialsTest.MockExternalAccountCredentialsTransportFactory();
        IOException response = new IOException();
        transportFactory.transport.addResponseErrorSequence(response);
        transportFactory.transport.addResponseSequence(true, true, false);
        AwsCredentials awsCredential = (AwsCredentials)AwsCredentials.newBuilder((AwsCredentials)AWS_CREDENTIAL).setHttpTransportFactory((HttpTransportFactory)transportFactory).setCredentialSource((ExternalAccountCredentials.CredentialSource)AwsCredentialsTest.buildAwsCredentialSource(transportFactory)).build();
        try {
            awsCredential.retrieveSubjectToken();
            Assert.fail((String)"Should not be able to use credential without exception.");
        }
        catch (IOException exception) {
            Assert.assertEquals((Object)"Failed to retrieve AWS credentials.", (Object)exception.getMessage());
        }
        List<MockLowLevelHttpRequest> requests = transportFactory.transport.getRequests();
        Assert.assertEquals((long)3L, (long)requests.size());
        AwsCredentialsTest.ValidateRequest(requests.get(0), AWS_REGION_URL, EMPTY_STRING_HEADERS);
        AwsCredentialsTest.ValidateRequest(requests.get(1), AWS_CREDENTIALS_URL, EMPTY_STRING_HEADERS);
        AwsCredentialsTest.ValidateRequest(requests.get(2), AWS_CREDENTIALS_URL_WITH_ROLE, EMPTY_STRING_HEADERS);
    }

    @Test
    public void retrieveSubjectToken_noRegionUrlProvided() {
        ExternalAccountCredentialsTest.MockExternalAccountCredentialsTransportFactory transportFactory = new ExternalAccountCredentialsTest.MockExternalAccountCredentialsTransportFactory();
        HashMap<String, String> credentialSource = new HashMap<String, String>();
        credentialSource.put("environment_id", "aws1");
        credentialSource.put("regional_cred_verification_url", GET_CALLER_IDENTITY_URL);
        AwsCredentials awsCredential = (AwsCredentials)AwsCredentials.newBuilder((AwsCredentials)AWS_CREDENTIAL).setHttpTransportFactory((HttpTransportFactory)transportFactory).setCredentialSource((ExternalAccountCredentials.CredentialSource)new AwsCredentials.AwsCredentialSource(credentialSource)).build();
        try {
            awsCredential.retrieveSubjectToken();
            Assert.fail((String)"Should not be able to use credential without exception.");
        }
        catch (IOException exception) {
            Assert.assertEquals((Object)"Unable to determine the AWS region. The credential source does not contain the region URL.", (Object)exception.getMessage());
        }
        List<MockLowLevelHttpRequest> requests = transportFactory.transport.getRequests();
        Assert.assertTrue((boolean)requests.isEmpty());
    }

    @Test
    public void getAwsSecurityCredentials_fromEnvironmentVariablesNoToken() throws IOException {
        TestEnvironmentProvider environmentProvider = new TestEnvironmentProvider();
        environmentProvider.setEnv("AWS_ACCESS_KEY_ID", "awsAccessKeyId").setEnv("AWS_SECRET_ACCESS_KEY", "awsSecretAccessKey");
        AwsCredentials testAwsCredentials = (AwsCredentials)AwsCredentials.newBuilder((AwsCredentials)AWS_CREDENTIAL).setEnvironmentProvider((EnvironmentProvider)environmentProvider).build();
        AwsSecurityCredentials credentials = testAwsCredentials.getAwsSecurityCredentials(EMPTY_METADATA_HEADERS);
        Assert.assertEquals((Object)"awsAccessKeyId", (Object)credentials.getAccessKeyId());
        Assert.assertEquals((Object)"awsSecretAccessKey", (Object)credentials.getSecretAccessKey());
        Assert.assertNull((Object)credentials.getToken());
    }

    @Test
    public void getAwsSecurityCredentials_fromEnvironmentVariablesWithToken() throws IOException {
        TestEnvironmentProvider environmentProvider = new TestEnvironmentProvider();
        environmentProvider.setEnv("AWS_ACCESS_KEY_ID", "awsAccessKeyId").setEnv("AWS_SECRET_ACCESS_KEY", "awsSecretAccessKey").setEnv("AWS_SESSION_TOKEN", "awsSessionToken");
        AwsCredentials testAwsCredentials = (AwsCredentials)AwsCredentials.newBuilder((AwsCredentials)AWS_CREDENTIAL).setEnvironmentProvider((EnvironmentProvider)environmentProvider).build();
        AwsSecurityCredentials credentials = testAwsCredentials.getAwsSecurityCredentials(EMPTY_METADATA_HEADERS);
        Assert.assertEquals((Object)"awsAccessKeyId", (Object)credentials.getAccessKeyId());
        Assert.assertEquals((Object)"awsSecretAccessKey", (Object)credentials.getSecretAccessKey());
        Assert.assertEquals((Object)"awsSessionToken", (Object)credentials.getToken());
    }

    @Test
    public void getAwsSecurityCredentials_fromMetadataServer() throws IOException {
        ExternalAccountCredentialsTest.MockExternalAccountCredentialsTransportFactory transportFactory = new ExternalAccountCredentialsTest.MockExternalAccountCredentialsTransportFactory();
        AwsCredentials awsCredential = (AwsCredentials)AwsCredentials.newBuilder((AwsCredentials)AWS_CREDENTIAL).setHttpTransportFactory((HttpTransportFactory)transportFactory).setCredentialSource((ExternalAccountCredentials.CredentialSource)AwsCredentialsTest.buildAwsCredentialSource(transportFactory)).build();
        AwsSecurityCredentials credentials = awsCredential.getAwsSecurityCredentials(EMPTY_METADATA_HEADERS);
        Assert.assertEquals((Object)"accessKeyId", (Object)credentials.getAccessKeyId());
        Assert.assertEquals((Object)"secretAccessKey", (Object)credentials.getSecretAccessKey());
        Assert.assertEquals((Object)"token", (Object)credentials.getToken());
        List<MockLowLevelHttpRequest> requests = transportFactory.transport.getRequests();
        Assert.assertEquals((long)2L, (long)requests.size());
        AwsCredentialsTest.ValidateRequest(requests.get(0), AWS_CREDENTIALS_URL, EMPTY_STRING_HEADERS);
        AwsCredentialsTest.ValidateRequest(requests.get(1), AWS_CREDENTIALS_URL_WITH_ROLE, EMPTY_STRING_HEADERS);
    }

    @Test
    public void getAwsSecurityCredentials_fromMetadataServer_noUrlProvided() {
        ExternalAccountCredentialsTest.MockExternalAccountCredentialsTransportFactory transportFactory = new ExternalAccountCredentialsTest.MockExternalAccountCredentialsTransportFactory();
        HashMap<String, String> credentialSource = new HashMap<String, String>();
        credentialSource.put("environment_id", "aws1");
        credentialSource.put("regional_cred_verification_url", GET_CALLER_IDENTITY_URL);
        AwsCredentials awsCredential = (AwsCredentials)AwsCredentials.newBuilder((AwsCredentials)AWS_CREDENTIAL).setHttpTransportFactory((HttpTransportFactory)transportFactory).setCredentialSource((ExternalAccountCredentials.CredentialSource)new AwsCredentials.AwsCredentialSource(credentialSource)).build();
        try {
            awsCredential.getAwsSecurityCredentials(EMPTY_METADATA_HEADERS);
            Assert.fail((String)"Should not be able to use credential without exception.");
        }
        catch (IOException exception) {
            Assert.assertEquals((Object)"Unable to determine the AWS IAM role name. The credential source does not contain the url field.", (Object)exception.getMessage());
        }
        List<MockLowLevelHttpRequest> requests = transportFactory.transport.getRequests();
        Assert.assertTrue((boolean)requests.isEmpty());
    }

    @Test
    public void getAwsRegion_awsRegionEnvironmentVariable() throws IOException {
        TestEnvironmentProvider environmentProvider = new TestEnvironmentProvider();
        environmentProvider.setEnv("AWS_REGION", "region");
        environmentProvider.setEnv("AWS_DEFAULT_REGION", "defaultRegion");
        ExternalAccountCredentialsTest.MockExternalAccountCredentialsTransportFactory transportFactory = new ExternalAccountCredentialsTest.MockExternalAccountCredentialsTransportFactory();
        AwsCredentials awsCredentials = (AwsCredentials)AwsCredentials.newBuilder((AwsCredentials)AWS_CREDENTIAL).setHttpTransportFactory((HttpTransportFactory)transportFactory).setCredentialSource((ExternalAccountCredentials.CredentialSource)AwsCredentialsTest.buildAwsCredentialSource(transportFactory)).setEnvironmentProvider((EnvironmentProvider)environmentProvider).build();
        String region = awsCredentials.getAwsRegion(EMPTY_METADATA_HEADERS);
        Assert.assertEquals((Object)"region", (Object)region);
        List<MockLowLevelHttpRequest> requests = transportFactory.transport.getRequests();
        Assert.assertTrue((boolean)requests.isEmpty());
    }

    @Test
    public void getAwsRegion_awsDefaultRegionEnvironmentVariable() throws IOException {
        TestEnvironmentProvider environmentProvider = new TestEnvironmentProvider();
        environmentProvider.setEnv("AWS_DEFAULT_REGION", "defaultRegion");
        ExternalAccountCredentialsTest.MockExternalAccountCredentialsTransportFactory transportFactory = new ExternalAccountCredentialsTest.MockExternalAccountCredentialsTransportFactory();
        AwsCredentials awsCredentials = (AwsCredentials)AwsCredentials.newBuilder((AwsCredentials)AWS_CREDENTIAL).setHttpTransportFactory((HttpTransportFactory)transportFactory).setCredentialSource((ExternalAccountCredentials.CredentialSource)AwsCredentialsTest.buildAwsCredentialSource(transportFactory)).setEnvironmentProvider((EnvironmentProvider)environmentProvider).build();
        String region = awsCredentials.getAwsRegion(EMPTY_METADATA_HEADERS);
        Assert.assertEquals((Object)"defaultRegion", (Object)region);
        List<MockLowLevelHttpRequest> requests = transportFactory.transport.getRequests();
        Assert.assertTrue((boolean)requests.isEmpty());
    }

    @Test
    public void getAwsRegion_metadataServer() throws IOException {
        ExternalAccountCredentialsTest.MockExternalAccountCredentialsTransportFactory transportFactory = new ExternalAccountCredentialsTest.MockExternalAccountCredentialsTransportFactory();
        AwsCredentials awsCredentials = (AwsCredentials)AwsCredentials.newBuilder((AwsCredentials)AWS_CREDENTIAL).setHttpTransportFactory((HttpTransportFactory)transportFactory).setCredentialSource((ExternalAccountCredentials.CredentialSource)AwsCredentialsTest.buildAwsCredentialSource(transportFactory)).build();
        String region = awsCredentials.getAwsRegion(EMPTY_METADATA_HEADERS);
        String expectedRegion = transportFactory.transport.getAwsRegion().substring(0, transportFactory.transport.getAwsRegion().length() - 1);
        Assert.assertEquals((Object)expectedRegion, (Object)region);
        List<MockLowLevelHttpRequest> requests = transportFactory.transport.getRequests();
        Assert.assertEquals((long)1L, (long)requests.size());
        AwsCredentialsTest.ValidateRequest(requests.get(0), AWS_REGION_URL, EMPTY_STRING_HEADERS);
    }

    @Test
    public void createdScoped_clonedCredentialWithAddedScopes() {
        AwsCredentials credentials = (AwsCredentials)AwsCredentials.newBuilder((AwsCredentials)AWS_CREDENTIAL).setServiceAccountImpersonationUrl(SERVICE_ACCOUNT_IMPERSONATION_URL).setQuotaProjectId("quotaProjectId").setClientId("clientId").setClientSecret("clientSecret").build();
        List<String> newScopes = Arrays.asList("scope1", "scope2");
        AwsCredentials newCredentials = (AwsCredentials)credentials.createScoped(newScopes);
        Assert.assertEquals((Object)credentials.getAudience(), (Object)newCredentials.getAudience());
        Assert.assertEquals((Object)credentials.getSubjectTokenType(), (Object)newCredentials.getSubjectTokenType());
        Assert.assertEquals((Object)credentials.getTokenUrl(), (Object)newCredentials.getTokenUrl());
        Assert.assertEquals((Object)credentials.getTokenInfoUrl(), (Object)newCredentials.getTokenInfoUrl());
        Assert.assertEquals((Object)credentials.getServiceAccountImpersonationUrl(), (Object)newCredentials.getServiceAccountImpersonationUrl());
        Assert.assertEquals((Object)credentials.getCredentialSource(), (Object)newCredentials.getCredentialSource());
        Assert.assertEquals((Object)credentials.getQuotaProjectId(), (Object)newCredentials.getQuotaProjectId());
        Assert.assertEquals((Object)credentials.getClientId(), (Object)newCredentials.getClientId());
        Assert.assertEquals((Object)credentials.getClientSecret(), (Object)newCredentials.getClientSecret());
        Assert.assertEquals(newScopes, (Object)newCredentials.getScopes());
    }

    @Test
    public void credentialSource_invalidAwsEnvironmentId() {
        HashMap<String, String> credentialSource = new HashMap<String, String>();
        credentialSource.put("regional_cred_verification_url", GET_CALLER_IDENTITY_URL);
        credentialSource.put("environment_id", "azure1");
        try {
            new AwsCredentials.AwsCredentialSource(credentialSource);
            Assert.fail((String)"Exception should be thrown.");
        }
        catch (IllegalArgumentException e) {
            Assert.assertEquals((Object)"Invalid AWS environment ID.", (Object)e.getMessage());
        }
    }

    @Test
    public void credentialSource_invalidAwsEnvironmentVersion() {
        HashMap<String, String> credentialSource = new HashMap<String, String>();
        int environmentVersion = 2;
        credentialSource.put("regional_cred_verification_url", GET_CALLER_IDENTITY_URL);
        credentialSource.put("environment_id", "aws" + environmentVersion);
        try {
            new AwsCredentials.AwsCredentialSource(credentialSource);
            Assert.fail((String)"Exception should be thrown.");
        }
        catch (IllegalArgumentException e) {
            Assert.assertEquals((Object)String.format("AWS version %s is not supported in the current build.", environmentVersion), (Object)e.getMessage());
        }
    }

    @Test
    public void credentialSource_missingRegionalCredVerificationUrl() {
        try {
            new AwsCredentials.AwsCredentialSource(new HashMap());
            Assert.fail((String)"Exception should be thrown.");
        }
        catch (IllegalArgumentException e) {
            Assert.assertEquals((Object)"A regional_cred_verification_url representing the GetCallerIdentity action URL must be specified.", (Object)e.getMessage());
        }
    }

    @Test
    public void builder() {
        List<String> scopes = Arrays.asList("scope1", "scope2");
        AwsCredentials credentials = (AwsCredentials)AwsCredentials.newBuilder().setHttpTransportFactory(OAuth2Utils.HTTP_TRANSPORT_FACTORY).setAudience("audience").setSubjectTokenType("subjectTokenType").setTokenUrl(STS_URL).setTokenInfoUrl("tokenInfoUrl").setCredentialSource((ExternalAccountCredentials.CredentialSource)AWS_CREDENTIAL_SOURCE).setTokenInfoUrl("tokenInfoUrl").setServiceAccountImpersonationUrl(SERVICE_ACCOUNT_IMPERSONATION_URL).setQuotaProjectId("quotaProjectId").setClientId("clientId").setClientSecret("clientSecret").setScopes(scopes).build();
        Assert.assertEquals((Object)"audience", (Object)credentials.getAudience());
        Assert.assertEquals((Object)"subjectTokenType", (Object)credentials.getSubjectTokenType());
        Assert.assertEquals((Object)credentials.getTokenUrl(), (Object)STS_URL);
        Assert.assertEquals((Object)credentials.getTokenInfoUrl(), (Object)"tokenInfoUrl");
        Assert.assertEquals((Object)credentials.getServiceAccountImpersonationUrl(), (Object)SERVICE_ACCOUNT_IMPERSONATION_URL);
        Assert.assertEquals((Object)credentials.getCredentialSource(), (Object)AWS_CREDENTIAL_SOURCE);
        Assert.assertEquals((Object)credentials.getQuotaProjectId(), (Object)"quotaProjectId");
        Assert.assertEquals((Object)credentials.getClientId(), (Object)"clientId");
        Assert.assertEquals((Object)credentials.getClientSecret(), (Object)"clientSecret");
        Assert.assertEquals((Object)credentials.getScopes(), scopes);
        Assert.assertEquals((Object)credentials.getEnvironmentProvider(), (Object)SystemEnvironmentProvider.getInstance());
    }

    private static void ValidateRequest(MockLowLevelHttpRequest request, String expectedUrl, Map<String, String> expectedHeaders) {
        Assert.assertEquals((Object)expectedUrl, (Object)request.getUrl());
        Map actualHeaders = request.getHeaders();
        for (Map.Entry<String, String> expectedHeader : expectedHeaders.entrySet()) {
            Assert.assertTrue((boolean)actualHeaders.containsKey(expectedHeader.getKey()));
            List actualValues = (List)actualHeaders.get(expectedHeader.getKey());
            Assert.assertEquals((long)1L, (long)actualValues.size());
            Assert.assertEquals((Object)expectedHeader.getValue(), actualValues.get(0));
        }
    }

    private static AwsCredentials.AwsCredentialSource buildAwsCredentialSource(ExternalAccountCredentialsTest.MockExternalAccountCredentialsTransportFactory transportFactory) {
        HashMap<String, String> credentialSourceMap = new HashMap<String, String>();
        credentialSourceMap.put("environment_id", "aws1");
        credentialSourceMap.put("region_url", transportFactory.transport.getAwsRegionUrl());
        credentialSourceMap.put("url", transportFactory.transport.getAwsCredentialsUrl());
        credentialSourceMap.put("regional_cred_verification_url", GET_CALLER_IDENTITY_URL);
        return new AwsCredentials.AwsCredentialSource(credentialSourceMap);
    }

    static InputStream writeAwsCredentialsStream(String stsUrl, String regionUrl, String metadataUrl) throws IOException {
        GenericJson json = new GenericJson();
        json.put("audience", (Object)"audience");
        json.put("subject_token_type", (Object)"subjectTokenType");
        json.put("token_url", (Object)stsUrl);
        json.put("token_info_url", (Object)"tokenInfoUrl");
        json.put("type", (Object)"external_account");
        GenericJson credentialSource = new GenericJson();
        credentialSource.put("environment_id", (Object)"aws1");
        credentialSource.put("region_url", (Object)regionUrl);
        credentialSource.put("url", (Object)metadataUrl);
        credentialSource.put("regional_cred_verification_url", (Object)GET_CALLER_IDENTITY_URL);
        json.put("credential_source", (Object)credentialSource);
        return TestUtils.jsonToInputStream(json);
    }
}

