/*
 * Decompiled with CFR 0.152.
 */
package com.google.auth.oauth2;

import com.google.api.client.json.GenericJson;
import com.google.api.client.json.JsonFactory;
import com.google.api.client.json.JsonObjectParser;
import com.google.auth.oauth2.AwsRequestSignature;
import com.google.auth.oauth2.AwsRequestSigner;
import com.google.auth.oauth2.AwsSecurityCredentials;
import com.google.auth.oauth2.OAuth2Utils;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class AwsRequestSignerTest {
    private static final String DATE = "Mon, 09 Sep 2011 23:36:00 GMT";
    private static final String X_AMZ_DATE = "20200811T065522Z";
    private static final AwsSecurityCredentials BOTOCORE_CREDENTIALS = new AwsSecurityCredentials("AKIDEXAMPLE", "wJalrXUtnFEMI/K7MDENG+bPxRfiCYEXAMPLEKEY", null);
    private AwsSecurityCredentials awsSecurityCredentials;

    @Before
    public void setUp() throws IOException {
        this.awsSecurityCredentials = this.retrieveAwsSecurityCredentials();
    }

    @Test
    public void sign_getHost() {
        String url = "https://host.foo.com";
        HashMap<String, String> headers = new HashMap<String, String>();
        headers.put("date", DATE);
        AwsRequestSigner signer = AwsRequestSigner.newBuilder((AwsSecurityCredentials)BOTOCORE_CREDENTIALS, (String)"GET", (String)url, (String)"us-east-1").setAdditionalHeaders(headers).build();
        AwsRequestSignature signature = signer.sign();
        String expectedSignature = "b27ccfbfa7df52a200ff74193ca6e32d4b48b8856fab7ebf1c595d0670a7e470";
        String expectedAuthHeader = "AWS4-HMAC-SHA256 Credential=AKIDEXAMPLE/20110909/us-east-1/host/aws4_request, SignedHeaders=date;host, Signature=" + expectedSignature;
        Assert.assertEquals((Object)expectedSignature, (Object)signature.getSignature());
        Assert.assertEquals((Object)expectedAuthHeader, (Object)signature.getAuthorizationHeader());
        Assert.assertEquals((Object)BOTOCORE_CREDENTIALS, (Object)signature.getSecurityCredentials());
        Assert.assertEquals((Object)DATE, (Object)signature.getDate());
        Assert.assertEquals((Object)"GET", (Object)signature.getHttpMethod());
        Assert.assertEquals((Object)"us-east-1", (Object)signature.getRegion());
        Assert.assertEquals((Object)URI.create(url).normalize().toString(), (Object)signature.getUrl());
    }

    @Test
    public void sign_getHostRelativePath() {
        String url = "https://host.foo.com/foo/bar/../..";
        HashMap<String, String> headers = new HashMap<String, String>();
        headers.put("date", DATE);
        AwsRequestSigner signer = AwsRequestSigner.newBuilder((AwsSecurityCredentials)BOTOCORE_CREDENTIALS, (String)"GET", (String)url, (String)"us-east-1").setAdditionalHeaders(headers).build();
        AwsRequestSignature signature = signer.sign();
        String expectedSignature = "b27ccfbfa7df52a200ff74193ca6e32d4b48b8856fab7ebf1c595d0670a7e470";
        String expectedAuthHeader = "AWS4-HMAC-SHA256 Credential=AKIDEXAMPLE/20110909/us-east-1/host/aws4_request, SignedHeaders=date;host, Signature=" + expectedSignature;
        Assert.assertEquals((Object)expectedSignature, (Object)signature.getSignature());
        Assert.assertEquals((Object)expectedAuthHeader, (Object)signature.getAuthorizationHeader());
        Assert.assertEquals((Object)BOTOCORE_CREDENTIALS, (Object)signature.getSecurityCredentials());
        Assert.assertEquals((Object)DATE, (Object)signature.getDate());
        Assert.assertEquals((Object)"GET", (Object)signature.getHttpMethod());
        Assert.assertEquals((Object)"us-east-1", (Object)signature.getRegion());
        Assert.assertEquals((Object)URI.create(url).normalize().toString(), (Object)signature.getUrl());
    }

    @Test
    public void sign_getHostInvalidPath() {
        String url = "https://host.foo.com/./";
        HashMap<String, String> headers = new HashMap<String, String>();
        headers.put("date", DATE);
        AwsRequestSigner signer = AwsRequestSigner.newBuilder((AwsSecurityCredentials)BOTOCORE_CREDENTIALS, (String)"GET", (String)url, (String)"us-east-1").setAdditionalHeaders(headers).build();
        AwsRequestSignature signature = signer.sign();
        String expectedSignature = "b27ccfbfa7df52a200ff74193ca6e32d4b48b8856fab7ebf1c595d0670a7e470";
        String expectedAuthHeader = "AWS4-HMAC-SHA256 Credential=AKIDEXAMPLE/20110909/us-east-1/host/aws4_request, SignedHeaders=date;host, Signature=" + expectedSignature;
        Assert.assertEquals((Object)expectedSignature, (Object)signature.getSignature());
        Assert.assertEquals((Object)expectedAuthHeader, (Object)signature.getAuthorizationHeader());
        Assert.assertEquals((Object)BOTOCORE_CREDENTIALS, (Object)signature.getSecurityCredentials());
        Assert.assertEquals((Object)DATE, (Object)signature.getDate());
        Assert.assertEquals((Object)"GET", (Object)signature.getHttpMethod());
        Assert.assertEquals((Object)"us-east-1", (Object)signature.getRegion());
        Assert.assertEquals((Object)URI.create(url).normalize().toString(), (Object)signature.getUrl());
    }

    @Test
    public void sign_getHostDotPath() {
        String url = "https://host.foo.com/./foo";
        HashMap<String, String> headers = new HashMap<String, String>();
        headers.put("date", DATE);
        AwsRequestSigner signer = AwsRequestSigner.newBuilder((AwsSecurityCredentials)BOTOCORE_CREDENTIALS, (String)"GET", (String)url, (String)"us-east-1").setAdditionalHeaders(headers).build();
        AwsRequestSignature signature = signer.sign();
        String expectedSignature = "910e4d6c9abafaf87898e1eb4c929135782ea25bb0279703146455745391e63a";
        String expectedAuthHeader = "AWS4-HMAC-SHA256 Credential=AKIDEXAMPLE/20110909/us-east-1/host/aws4_request, SignedHeaders=date;host, Signature=" + expectedSignature;
        Assert.assertEquals((Object)expectedSignature, (Object)signature.getSignature());
        Assert.assertEquals((Object)expectedAuthHeader, (Object)signature.getAuthorizationHeader());
        Assert.assertEquals((Object)BOTOCORE_CREDENTIALS, (Object)signature.getSecurityCredentials());
        Assert.assertEquals((Object)DATE, (Object)signature.getDate());
        Assert.assertEquals((Object)"GET", (Object)signature.getHttpMethod());
        Assert.assertEquals((Object)"us-east-1", (Object)signature.getRegion());
        Assert.assertEquals((Object)URI.create(url).normalize().toString(), (Object)signature.getUrl());
    }

    @Test
    public void sign_getHostUtf8Path() {
        String url = "https://host.foo.com/%E1%88%B4";
        HashMap<String, String> headers = new HashMap<String, String>();
        headers.put("date", DATE);
        AwsRequestSigner signer = AwsRequestSigner.newBuilder((AwsSecurityCredentials)BOTOCORE_CREDENTIALS, (String)"GET", (String)url, (String)"us-east-1").setAdditionalHeaders(headers).build();
        AwsRequestSignature signature = signer.sign();
        String expectedSignature = "8d6634c189aa8c75c2e51e106b6b5121bed103fdb351f7d7d4381c738823af74";
        String expectedAuthHeader = "AWS4-HMAC-SHA256 Credential=AKIDEXAMPLE/20110909/us-east-1/host/aws4_request, SignedHeaders=date;host, Signature=" + expectedSignature;
        Assert.assertEquals((Object)expectedSignature, (Object)signature.getSignature());
        Assert.assertEquals((Object)expectedAuthHeader, (Object)signature.getAuthorizationHeader());
        Assert.assertEquals((Object)BOTOCORE_CREDENTIALS, (Object)signature.getSecurityCredentials());
        Assert.assertEquals((Object)DATE, (Object)signature.getDate());
        Assert.assertEquals((Object)"GET", (Object)signature.getHttpMethod());
        Assert.assertEquals((Object)"us-east-1", (Object)signature.getRegion());
        Assert.assertEquals((Object)URI.create(url).normalize().toString(), (Object)signature.getUrl());
    }

    @Test
    public void sign_getHostDuplicateQueryParam() {
        String url = "https://host.foo.com/?foo=Zoo&foo=aha";
        HashMap<String, String> headers = new HashMap<String, String>();
        headers.put("date", DATE);
        AwsRequestSigner signer = AwsRequestSigner.newBuilder((AwsSecurityCredentials)BOTOCORE_CREDENTIALS, (String)"GET", (String)url, (String)"us-east-1").setAdditionalHeaders(headers).build();
        AwsRequestSignature signature = signer.sign();
        String expectedSignature = "be7148d34ebccdc6423b19085378aa0bee970bdc61d144bd1a8c48c33079ab09";
        String expectedAuthHeader = "AWS4-HMAC-SHA256 Credential=AKIDEXAMPLE/20110909/us-east-1/host/aws4_request, SignedHeaders=date;host, Signature=" + expectedSignature;
        Assert.assertEquals((Object)expectedSignature, (Object)signature.getSignature());
        Assert.assertEquals((Object)expectedAuthHeader, (Object)signature.getAuthorizationHeader());
        Assert.assertEquals((Object)BOTOCORE_CREDENTIALS, (Object)signature.getSecurityCredentials());
        Assert.assertEquals((Object)DATE, (Object)signature.getDate());
        Assert.assertEquals((Object)"GET", (Object)signature.getHttpMethod());
        Assert.assertEquals((Object)"us-east-1", (Object)signature.getRegion());
        Assert.assertEquals((Object)URI.create(url).normalize().toString(), (Object)signature.getUrl());
    }

    @Test
    public void sign_postWithUpperCaseHeaderKey() {
        String url = "https://host.foo.com/";
        String headerKey = "ZOO";
        String headerValue = "zoobar";
        HashMap<String, String> headers = new HashMap<String, String>();
        headers.put("date", DATE);
        headers.put(headerKey, headerValue);
        AwsRequestSigner signer = AwsRequestSigner.newBuilder((AwsSecurityCredentials)BOTOCORE_CREDENTIALS, (String)"POST", (String)url, (String)"us-east-1").setAdditionalHeaders(headers).build();
        AwsRequestSignature signature = signer.sign();
        String expectedSignature = "b7a95a52518abbca0964a999a880429ab734f35ebbf1235bd79a5de87756dc4a";
        String expectedAuthHeader = "AWS4-HMAC-SHA256 Credential=AKIDEXAMPLE/20110909/us-east-1/host/aws4_request, SignedHeaders=date;host;zoo, Signature=" + expectedSignature;
        Assert.assertEquals((Object)expectedSignature, (Object)signature.getSignature());
        Assert.assertEquals((Object)expectedAuthHeader, (Object)signature.getAuthorizationHeader());
        Assert.assertEquals((Object)BOTOCORE_CREDENTIALS, (Object)signature.getSecurityCredentials());
        Assert.assertEquals((Object)DATE, (Object)signature.getDate());
        Assert.assertEquals((Object)"POST", (Object)signature.getHttpMethod());
        Assert.assertEquals((Object)"us-east-1", (Object)signature.getRegion());
        Assert.assertEquals((Object)URI.create(url).normalize().toString(), (Object)signature.getUrl());
        Assert.assertEquals((Object)headerValue, signature.getCanonicalHeaders().get(headerKey.toLowerCase()));
    }

    @Test
    public void sign_postWithUpperCaseHeaderValue() {
        String url = "https://host.foo.com/";
        String headerKey = "zoo";
        String headerValue = "ZOOBAR";
        HashMap<String, String> headers = new HashMap<String, String>();
        headers.put("date", DATE);
        headers.put("zoo", "ZOOBAR");
        AwsRequestSigner signer = AwsRequestSigner.newBuilder((AwsSecurityCredentials)BOTOCORE_CREDENTIALS, (String)"POST", (String)url, (String)"us-east-1").setAdditionalHeaders(headers).build();
        AwsRequestSignature signature = signer.sign();
        String expectedSignature = "273313af9d0c265c531e11db70bbd653f3ba074c1009239e8559d3987039cad7";
        String expectedAuthHeader = "AWS4-HMAC-SHA256 Credential=AKIDEXAMPLE/20110909/us-east-1/host/aws4_request, SignedHeaders=date;host;zoo, Signature=" + expectedSignature;
        Assert.assertEquals((Object)expectedSignature, (Object)signature.getSignature());
        Assert.assertEquals((Object)expectedAuthHeader, (Object)signature.getAuthorizationHeader());
        Assert.assertEquals((Object)BOTOCORE_CREDENTIALS, (Object)signature.getSecurityCredentials());
        Assert.assertEquals((Object)DATE, (Object)signature.getDate());
        Assert.assertEquals((Object)"POST", (Object)signature.getHttpMethod());
        Assert.assertEquals((Object)"us-east-1", (Object)signature.getRegion());
        Assert.assertEquals((Object)URI.create(url).normalize().toString(), (Object)signature.getUrl());
        Assert.assertEquals((Object)headerValue, signature.getCanonicalHeaders().get(headerKey.toLowerCase()));
    }

    @Test
    public void sign_postWithHeader() {
        String url = "https://host.foo.com/";
        String headerKey = "p";
        String headerValue = "phfft";
        HashMap<String, String> headers = new HashMap<String, String>();
        headers.put("date", DATE);
        headers.put(headerKey, headerValue);
        AwsRequestSigner signer = AwsRequestSigner.newBuilder((AwsSecurityCredentials)BOTOCORE_CREDENTIALS, (String)"POST", (String)url, (String)"us-east-1").setAdditionalHeaders(headers).build();
        AwsRequestSignature signature = signer.sign();
        String expectedSignature = "debf546796015d6f6ded8626f5ce98597c33b47b9164cf6b17b4642036fcb592";
        String expectedAuthHeader = "AWS4-HMAC-SHA256 Credential=AKIDEXAMPLE/20110909/us-east-1/host/aws4_request, SignedHeaders=date;host;p, Signature=" + expectedSignature;
        Assert.assertEquals((Object)expectedSignature, (Object)signature.getSignature());
        Assert.assertEquals((Object)expectedAuthHeader, (Object)signature.getAuthorizationHeader());
        Assert.assertEquals((Object)BOTOCORE_CREDENTIALS, (Object)signature.getSecurityCredentials());
        Assert.assertEquals((Object)DATE, (Object)signature.getDate());
        Assert.assertEquals((Object)"POST", (Object)signature.getHttpMethod());
        Assert.assertEquals((Object)"us-east-1", (Object)signature.getRegion());
        Assert.assertEquals((Object)URI.create(url).normalize().toString(), (Object)signature.getUrl());
        Assert.assertEquals((Object)headerValue, signature.getCanonicalHeaders().get(headerKey.toLowerCase()));
    }

    @Test
    public void sign_postWithBodyNoCustomHeaders() {
        String url = "https://host.foo.com/";
        String headerKey = "Content-Type";
        String headerValue = "application/x-www-form-urlencoded";
        HashMap<String, String> headers = new HashMap<String, String>();
        headers.put("date", DATE);
        headers.put(headerKey, headerValue);
        AwsRequestSigner signer = AwsRequestSigner.newBuilder((AwsSecurityCredentials)BOTOCORE_CREDENTIALS, (String)"POST", (String)url, (String)"us-east-1").setAdditionalHeaders(headers).setRequestPayload("foo=bar").build();
        AwsRequestSignature signature = signer.sign();
        String expectedSignature = "5a15b22cf462f047318703b92e6f4f38884e4a7ab7b1d6426ca46a8bd1c26cbc";
        String expectedAuthHeader = "AWS4-HMAC-SHA256 Credential=AKIDEXAMPLE/20110909/us-east-1/host/aws4_request, SignedHeaders=content-type;date;host, Signature=" + expectedSignature;
        Assert.assertEquals((Object)expectedSignature, (Object)signature.getSignature());
        Assert.assertEquals((Object)expectedAuthHeader, (Object)signature.getAuthorizationHeader());
        Assert.assertEquals((Object)BOTOCORE_CREDENTIALS, (Object)signature.getSecurityCredentials());
        Assert.assertEquals((Object)DATE, (Object)signature.getDate());
        Assert.assertEquals((Object)"POST", (Object)signature.getHttpMethod());
        Assert.assertEquals((Object)"us-east-1", (Object)signature.getRegion());
        Assert.assertEquals((Object)URI.create(url).normalize().toString(), (Object)signature.getUrl());
        Assert.assertEquals((Object)headerValue, signature.getCanonicalHeaders().get(headerKey.toLowerCase()));
    }

    @Test
    public void sign_postWithQueryString() {
        String url = "https://host.foo.com/?foo=bar";
        HashMap<String, String> headers = new HashMap<String, String>();
        headers.put("date", DATE);
        AwsRequestSigner signer = AwsRequestSigner.newBuilder((AwsSecurityCredentials)BOTOCORE_CREDENTIALS, (String)"POST", (String)url, (String)"us-east-1").setAdditionalHeaders(headers).build();
        AwsRequestSignature signature = signer.sign();
        String expectedSignature = "b6e3b79003ce0743a491606ba1035a804593b0efb1e20a11cba83f8c25a57a92";
        String expectedAuthHeader = "AWS4-HMAC-SHA256 Credential=AKIDEXAMPLE/20110909/us-east-1/host/aws4_request, SignedHeaders=date;host, Signature=" + expectedSignature;
        Assert.assertEquals((Object)expectedSignature, (Object)signature.getSignature());
        Assert.assertEquals((Object)expectedAuthHeader, (Object)signature.getAuthorizationHeader());
        Assert.assertEquals((Object)BOTOCORE_CREDENTIALS, (Object)signature.getSecurityCredentials());
        Assert.assertEquals((Object)DATE, (Object)signature.getDate());
        Assert.assertEquals((Object)"POST", (Object)signature.getHttpMethod());
        Assert.assertEquals((Object)"us-east-1", (Object)signature.getRegion());
        Assert.assertEquals((Object)URI.create(url).normalize().toString(), (Object)signature.getUrl());
    }

    @Test
    public void sign_getDescribeRegions() {
        String url = "https://ec2.us-east-2.amazonaws.com?Action=DescribeRegions&Version=2013-10-15";
        HashMap<String, String> additionalHeaders = new HashMap<String, String>();
        additionalHeaders.put("x-amz-date", X_AMZ_DATE);
        AwsRequestSigner signer = AwsRequestSigner.newBuilder((AwsSecurityCredentials)this.awsSecurityCredentials, (String)"GET", (String)url, (String)"us-east-2").setAdditionalHeaders(additionalHeaders).build();
        AwsRequestSignature signature = signer.sign();
        String expectedSignature = "631ea80cddfaa545fdadb120dc92c9f18166e38a5c47b50fab9fce476e022855";
        String expectedAuthHeader = "AWS4-HMAC-SHA256 Credential=" + this.awsSecurityCredentials.getAccessKeyId() + "/20200811/us-east-2/ec2/aws4_request, SignedHeaders=host;x-amz-date;x-amz-security-token, Signature=" + expectedSignature;
        Assert.assertEquals((Object)expectedSignature, (Object)signature.getSignature());
        Assert.assertEquals((Object)expectedAuthHeader, (Object)signature.getAuthorizationHeader());
        Assert.assertEquals((Object)this.awsSecurityCredentials, (Object)signature.getSecurityCredentials());
        Assert.assertEquals((Object)X_AMZ_DATE, (Object)signature.getDate());
        Assert.assertEquals((Object)"GET", (Object)signature.getHttpMethod());
        Assert.assertEquals((Object)"us-east-2", (Object)signature.getRegion());
        Assert.assertEquals((Object)URI.create(url).normalize().toString(), (Object)signature.getUrl());
    }

    @Test
    public void sign_postGetCallerIdentity() {
        String url = "https://sts.us-east-2.amazonaws.com?Action=GetCallerIdentity&Version=2011-06-15";
        HashMap<String, String> additionalHeaders = new HashMap<String, String>();
        additionalHeaders.put("x-amz-date", X_AMZ_DATE);
        AwsRequestSigner signer = AwsRequestSigner.newBuilder((AwsSecurityCredentials)this.awsSecurityCredentials, (String)"POST", (String)url, (String)"us-east-2").setAdditionalHeaders(additionalHeaders).build();
        AwsRequestSignature signature = signer.sign();
        String expectedSignature = "73452984e4a880ffdc5c392355733ec3f5ba310d5e0609a89244440cadfe7a7a";
        String expectedAuthHeader = "AWS4-HMAC-SHA256 Credential=" + this.awsSecurityCredentials.getAccessKeyId() + "/20200811/us-east-2/sts/aws4_request, SignedHeaders=host;x-amz-date;x-amz-security-token, Signature=" + expectedSignature;
        Assert.assertEquals((Object)expectedSignature, (Object)signature.getSignature());
        Assert.assertEquals((Object)expectedAuthHeader, (Object)signature.getAuthorizationHeader());
        Assert.assertEquals((Object)this.awsSecurityCredentials, (Object)signature.getSecurityCredentials());
        Assert.assertEquals((Object)X_AMZ_DATE, (Object)signature.getDate());
        Assert.assertEquals((Object)"POST", (Object)signature.getHttpMethod());
        Assert.assertEquals((Object)"us-east-2", (Object)signature.getRegion());
        Assert.assertEquals((Object)URI.create(url).normalize().toString(), (Object)signature.getUrl());
    }

    @Test
    public void sign_postGetCallerIdentityNoToken() {
        String url = "https://sts.us-east-2.amazonaws.com?Action=GetCallerIdentity&Version=2011-06-15";
        AwsSecurityCredentials awsSecurityCredentialsWithoutToken = new AwsSecurityCredentials(this.awsSecurityCredentials.getAccessKeyId(), this.awsSecurityCredentials.getSecretAccessKey(), null);
        HashMap<String, String> additionalHeaders = new HashMap<String, String>();
        additionalHeaders.put("x-amz-date", X_AMZ_DATE);
        AwsRequestSigner signer = AwsRequestSigner.newBuilder((AwsSecurityCredentials)awsSecurityCredentialsWithoutToken, (String)"POST", (String)url, (String)"us-east-2").setAdditionalHeaders(additionalHeaders).build();
        AwsRequestSignature signature = signer.sign();
        String expectedSignature = "d095ba304919cd0d5570ba8a3787884ee78b860f268ed040ba23831d55536d56";
        String expectedAuthHeader = "AWS4-HMAC-SHA256 Credential=" + this.awsSecurityCredentials.getAccessKeyId() + "/20200811/us-east-2/sts/aws4_request, SignedHeaders=host;x-amz-date, Signature=" + expectedSignature;
        Assert.assertEquals((Object)expectedSignature, (Object)signature.getSignature());
        Assert.assertEquals((Object)expectedAuthHeader, (Object)signature.getAuthorizationHeader());
        Assert.assertEquals((Object)awsSecurityCredentialsWithoutToken, (Object)signature.getSecurityCredentials());
        Assert.assertEquals((Object)X_AMZ_DATE, (Object)signature.getDate());
        Assert.assertEquals((Object)"POST", (Object)signature.getHttpMethod());
        Assert.assertEquals((Object)"us-east-2", (Object)signature.getRegion());
        Assert.assertEquals((Object)URI.create(url).normalize().toString(), (Object)signature.getUrl());
    }

    public AwsSecurityCredentials retrieveAwsSecurityCredentials() throws IOException {
        InputStream stream = AwsRequestSignerTest.class.getClassLoader().getResourceAsStream("aws_security_credentials.json");
        JsonFactory jsonFactory = OAuth2Utils.JSON_FACTORY;
        JsonObjectParser parser = new JsonObjectParser(jsonFactory);
        GenericJson json = (GenericJson)parser.parseAndClose(stream, StandardCharsets.UTF_8, GenericJson.class);
        String accessKeyId = (String)json.get((Object)"AccessKeyId");
        String secretAccessKey = (String)json.get((Object)"SecretAccessKey");
        String awsToken = (String)json.get((Object)"Token");
        return new AwsSecurityCredentials(accessKeyId, secretAccessKey, awsToken);
    }
}

