/*
 * Decompiled with CFR 0.152.
 */
package com.google.auth.oauth2;

import com.google.api.client.util.Clock;
import com.google.auth.oauth2.BaseSerializationTest;
import com.google.auth.oauth2.CloudShellCredentials;
import com.google.auth.oauth2.GoogleCredentials;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.net.ServerSocket;
import java.net.Socket;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.JUnit4;

@RunWith(value=JUnit4.class)
public class CloudShellCredentialsTest
extends BaseSerializationTest {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void refreshAccessToken() throws IOException {
        try (final ServerSocket authSocket = new ServerSocket(0);){
            Runnable serverTask = new Runnable(){

                @Override
                public void run() {
                    try {
                        Socket clientSocket = authSocket.accept();
                        BufferedReader input = new BufferedReader(new InputStreamReader(clientSocket.getInputStream()));
                        String lines = input.readLine();
                        lines = lines + '\n' + input.readLine();
                        Assert.assertEquals((Object)lines, (Object)"2\n[]");
                        PrintWriter out = new PrintWriter(clientSocket.getOutputStream(), true);
                        out.println("32\n[\"email\", \"project-id\", \"token\"]");
                    }
                    catch (Exception reThrown) {
                        throw new RuntimeException(reThrown);
                    }
                }
            };
            Thread serverThread = new Thread(serverTask);
            serverThread.start();
            CloudShellCredentials creds = CloudShellCredentials.newBuilder().setAuthPort(authSocket.getLocalPort()).build();
            Assert.assertEquals((Object)"token", (Object)creds.refreshAccessToken().getTokenValue());
        }
    }

    @Test
    public void equals_true() throws IOException {
        CloudShellCredentials credentials = CloudShellCredentials.newBuilder().setAuthPort(42).build();
        CloudShellCredentials otherCredentials = CloudShellCredentials.newBuilder().setAuthPort(42).build();
        Assert.assertTrue((boolean)credentials.equals((Object)otherCredentials));
        Assert.assertTrue((boolean)otherCredentials.equals((Object)credentials));
    }

    @Test
    public void equals_false_authPort() throws IOException {
        CloudShellCredentials credentials = CloudShellCredentials.newBuilder().setAuthPort(42).build();
        CloudShellCredentials otherCredentials = CloudShellCredentials.newBuilder().setAuthPort(43).build();
        Assert.assertFalse((boolean)credentials.equals((Object)otherCredentials));
        Assert.assertFalse((boolean)otherCredentials.equals((Object)credentials));
    }

    @Test
    public void toString_containsFields() throws IOException {
        String expectedToString = String.format("CloudShellCredentials{authPort=%d}", 42);
        CloudShellCredentials credentials = CloudShellCredentials.newBuilder().setAuthPort(42).build();
        Assert.assertEquals((Object)expectedToString, (Object)credentials.toString());
    }

    @Test
    public void hashCode_equals() throws IOException {
        CloudShellCredentials credentials = CloudShellCredentials.newBuilder().setAuthPort(42).build();
        CloudShellCredentials otherCredentials = CloudShellCredentials.newBuilder().setAuthPort(42).build();
        Assert.assertEquals((long)credentials.hashCode(), (long)otherCredentials.hashCode());
    }

    @Test
    public void serialize() throws IOException, ClassNotFoundException {
        CloudShellCredentials credentials = CloudShellCredentials.newBuilder().setAuthPort(42).build();
        GoogleCredentials deserializedCredentials = (GoogleCredentials)this.serializeAndDeserialize(credentials);
        Assert.assertEquals((Object)credentials, (Object)deserializedCredentials);
        Assert.assertEquals((long)credentials.hashCode(), (long)deserializedCredentials.hashCode());
        Assert.assertEquals((Object)credentials.toString(), (Object)deserializedCredentials.toString());
        Assert.assertSame((Object)deserializedCredentials.clock, (Object)Clock.SYSTEM);
    }
}

