/*
 * Decompiled with CFR 0.152.
 */
package com.google.auth.oauth2;

import com.google.api.client.http.HttpTransport;
import com.google.api.client.http.LowLevelHttpRequest;
import com.google.api.client.http.LowLevelHttpResponse;
import com.google.api.client.json.webtoken.JsonWebToken;
import com.google.api.client.testing.http.MockLowLevelHttpRequest;
import com.google.api.client.testing.http.MockLowLevelHttpResponse;
import com.google.api.client.util.ArrayMap;
import com.google.api.client.util.Clock;
import com.google.auth.ServiceAccountSigner;
import com.google.auth.TestUtils;
import com.google.auth.http.HttpTransportFactory;
import com.google.auth.oauth2.BaseSerializationTest;
import com.google.auth.oauth2.ComputeEngineCredentials;
import com.google.auth.oauth2.GoogleCredentials;
import com.google.auth.oauth2.GoogleCredentialsTest;
import com.google.auth.oauth2.IdTokenCredentials;
import com.google.auth.oauth2.IdTokenProvider;
import com.google.auth.oauth2.MockMetadataServerTransport;
import java.io.IOException;
import java.net.URI;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.JUnit4;

@RunWith(value=JUnit4.class)
public class ComputeEngineCredentialsTest
extends BaseSerializationTest {
    private static final URI CALL_URI = URI.create("http://googleapis.com/testapi/v1/foo");
    private static final String TOKEN_URL = "http://metadata.google.internal/computeMetadata/v1/instance/service-accounts/default/token";
    public static final String STANDARD_ID_TOKEN = "eyJhbGciOiJSUzI1NiIsImtpZCI6ImRmMzc1ODkwOGI3OTIyOTNhZDk3N2EwYjk5MWQ5OGE3N2Y0ZWVlY2QiLCJ0eXAiOiJKV1QifQ.eyJhdWQiOiJodHRwczovL2Zvby5iYXIiLCJhenAiOiIxMDIxMDE1NTA4MzQyMDA3MDg1NjgiLCJleHAiOjE1NjQ0NzUwNTEsImlhdCI6MTU2NDQ3MTQ1MSwiaXNzIjoiaHR0cHM6Ly9hY2NvdW50cy5nb29nbGUuY29tIiwic3ViIjoiMTAyMTAxNTUwODM0MjAwNzA4NTY4In0.redacted";
    public static final String FULL_ID_TOKEN = "eyJhbGciOiJSUzI1NiIsImtpZCI6ImRmMzc1ODkwOGI3OTIyOTNhZDk3N2EwYjk5MWQ5OGE3N2Y0ZWVlY2QiLCJ0eXAiOiJKV1QifQ.eyJhdWQiOiJodHRwczovL2Zvby5iYXIiLCJhenAiOiIxMTIxNzkwNjI3MjAzOTEzMDU4ODUiLCJlbWFpbCI6IjEwNzEyODQxODQ0MzYtY29tcHV0ZUBkZXZlbG9wZXIuZ3NlcnZpY2VhY2NvdW50LmNvbSIsImVtYWlsX3ZlcmlmaWVkIjp0cnVlLCJleHAiOjE1NjQ1MTk0OTYsImdvb2dsZSI6eyJjb21wdXRlX2VuZ2luZSI6eyJpbnN0YW5jZV9jcmVhdGlvbl90aW1lc3RhbXAiOjE1NjMyMzA5MDcsImluc3RhbmNlX2lkIjoiMzQ5Nzk3NDM5MzQ0MTE3OTI0MyIsImluc3RhbmNlX25hbWUiOiJpYW0iLCJwcm9qZWN0X2lkIjoibWluZXJhbC1taW51dGlhLTgyMCIsInByb2plY3RfbnVtYmVyIjoxMDcxMjg0MTg0NDM2LCJ6b25lIjoidXMtY2VudHJhbDEtYSJ9fSwiaWF0IjoxNTY0NTE1ODk2LCJpc3MiOiJodHRwczovL2FjY291bnRzLmdvb2dsZS5jb20iLCJzdWIiOiIxMTIxNzkwNjI3MjAzOTEzMDU4ODUifQ.redacted";
    public static final String FULL_ID_TOKEN_WITH_LICENSE = "eyJhbGciOiJSUzI1NiIsImtpZCI6ImRmMzc1ODkwOGI3OTIyOTNhZDk3N2EwYjk5MWQ5OGE3N2Y0ZWVlY2QiLCJ0eXAiOiJKV1QifQ.ew0KICAiYXVkIjogImh0dHBzOi8vZm9vLmJhciIsDQogICJhenAiOiAiMTEyMTc5MDYyNzIwMzkxMzA1ODg1IiwNCiAgImVtYWlsIjogIjEyMzQ1Ni1jb21wdXRlQGRldmVsb3Blci5nc2VydmljZWFjY291bnQuY29tIiwNCiAgImVtYWlsX3ZlcmlmaWVkIjogdHJ1ZSwNCiAgImV4cCI6IDE1NjQ1MTk0OTYsDQogICJnb29nbGUiOiB7DQogICAgImNvbXB1dGVfZW5naW5lIjogew0KICAgICAgImluc3RhbmNlX2NyZWF0aW9uX3RpbWVzdGFtcCI6IDE1NjMyMzA5MDcsDQogICAgICAiaW5zdGFuY2VfaWQiOiAiMzQ5Nzk3NDM5MzQ0MTE3OTI0MyIsDQogICAgICAiaW5zdGFuY2VfbmFtZSI6ICJpYW0iLA0KICAgICAgInByb2plY3RfaWQiOiAiZm9vLWJhci04MjAiLA0KICAgICAgInByb2plY3RfbnVtYmVyIjogMTA3MTI4NDE4NDQzNiwNCiAgICAgICJ6b25lIjogInVzLWNlbnRyYWwxLWEiDQogICAgfSwNCiAgICAibGljZW5zZSI6IFsNCiAgICAgICAiTElDRU5TRV8xIiwNCiAgICAgICAiTElDRU5TRV8yIg0KICAgIF0NCiAgfSwNCiAgImlhdCI6IDE1NjQ1MTU4OTYsDQogICJpc3MiOiAiaHR0cHM6Ly9hY2NvdW50cy5nb29nbGUuY29tIiwNCiAgInN1YiI6ICIxMTIxNzkwNjI3MjAzOTEzMDU4ODUiDQp9.redacted";

    @Test
    public void createTokenUrlWithScopes_null_scopes() {
        ComputeEngineCredentials credentials = ComputeEngineCredentials.newBuilder().setScopes(null).build();
        Collection scopes = credentials.getScopes();
        String tokenUrlWithScopes = credentials.createTokenUrlWithScopes();
        Assert.assertEquals((Object)TOKEN_URL, (Object)tokenUrlWithScopes);
        Assert.assertTrue((boolean)scopes.isEmpty());
    }

    @Test
    public void createTokenUrlWithScopes_empty_scopes() {
        ComputeEngineCredentials.Builder builder = ComputeEngineCredentials.newBuilder().setScopes(Collections.emptyList());
        ComputeEngineCredentials credentials = builder.build();
        Collection scopes = credentials.getScopes();
        String tokenUrlWithScopes = credentials.createTokenUrlWithScopes();
        Assert.assertEquals((Object)TOKEN_URL, (Object)tokenUrlWithScopes);
        Assert.assertTrue((boolean)scopes.isEmpty());
        Assert.assertTrue((boolean)builder.getScopes().isEmpty());
    }

    @Test
    public void createTokenUrlWithScopes_single_scope() {
        ComputeEngineCredentials credentials = ComputeEngineCredentials.newBuilder().setScopes(Arrays.asList("foo")).build();
        String tokenUrlWithScopes = credentials.createTokenUrlWithScopes();
        Collection scopes = credentials.getScopes();
        Assert.assertEquals((Object)"http://metadata.google.internal/computeMetadata/v1/instance/service-accounts/default/token?scopes=foo", (Object)tokenUrlWithScopes);
        Assert.assertEquals((long)1L, (long)scopes.size());
        Assert.assertEquals((Object)"foo", (Object)scopes.toArray()[0]);
    }

    @Test
    public void createTokenUrlWithScopes_multiple_scopes() {
        ComputeEngineCredentials credentials = ComputeEngineCredentials.newBuilder().setScopes(Arrays.asList(null, "foo", "", "bar")).build();
        Collection scopes = credentials.getScopes();
        String tokenUrlWithScopes = credentials.createTokenUrlWithScopes();
        Assert.assertEquals((Object)"http://metadata.google.internal/computeMetadata/v1/instance/service-accounts/default/token?scopes=foo,bar", (Object)tokenUrlWithScopes);
        Assert.assertEquals((long)2L, (long)scopes.size());
        Assert.assertEquals((Object)"foo", (Object)scopes.toArray()[0]);
        Assert.assertEquals((Object)"bar", (Object)scopes.toArray()[1]);
    }

    @Test
    public void createTokenUrlWithScopes_defaultScopes() {
        ComputeEngineCredentials credentials = ComputeEngineCredentials.newBuilder().build();
        credentials = (ComputeEngineCredentials)credentials.createScoped(null, Arrays.asList(null, "foo", "", "bar"));
        Collection scopes = credentials.getScopes();
        String tokenUrlWithScopes = credentials.createTokenUrlWithScopes();
        Assert.assertEquals((Object)"http://metadata.google.internal/computeMetadata/v1/instance/service-accounts/default/token?scopes=foo,bar", (Object)tokenUrlWithScopes);
        Assert.assertEquals((long)2L, (long)scopes.size());
        Assert.assertEquals((Object)"foo", (Object)scopes.toArray()[0]);
        Assert.assertEquals((Object)"bar", (Object)scopes.toArray()[1]);
    }

    @Test
    public void createScoped() {
        ComputeEngineCredentials credentials = ComputeEngineCredentials.newBuilder().setScopes(null).build();
        ComputeEngineCredentials credentialsWithScopes = (ComputeEngineCredentials)credentials.createScoped(Arrays.asList("foo"));
        Collection scopes = credentialsWithScopes.getScopes();
        Assert.assertEquals((long)1L, (long)scopes.size());
        Assert.assertEquals((Object)"foo", (Object)scopes.toArray()[0]);
    }

    @Test
    public void createScoped_defaultScopes() {
        GoogleCredentials credentials = ComputeEngineCredentials.create().createScoped(null, Arrays.asList("foo"));
        Collection scopes = ((ComputeEngineCredentials)credentials).getScopes();
        Assert.assertEquals((long)1L, (long)scopes.size());
        Assert.assertEquals((Object)"foo", (Object)scopes.toArray()[0]);
    }

    @Test
    public void getRequestMetadata_hasAccessToken() throws IOException {
        String accessToken = "1/MkSJoj1xsli0AccessToken_NKPY2";
        MockMetadataServerTransportFactory transportFactory = new MockMetadataServerTransportFactory();
        transportFactory.transport.setAccessToken(accessToken);
        ComputeEngineCredentials credentials = ComputeEngineCredentials.newBuilder().setHttpTransportFactory((HttpTransportFactory)transportFactory).build();
        Map metadata = credentials.getRequestMetadata(CALL_URI);
        TestUtils.assertContainsBearerToken(metadata, accessToken);
    }

    @Test
    public void getRequestMetadata_missingServiceAccount_throws() {
        String accessToken = "1/MkSJoj1xsli0AccessToken_NKPY2";
        MockMetadataServerTransportFactory transportFactory = new MockMetadataServerTransportFactory();
        transportFactory.transport.setAccessToken(accessToken);
        transportFactory.transport.setTokenRequestStatusCode(404);
        ComputeEngineCredentials credentials = ComputeEngineCredentials.newBuilder().setHttpTransportFactory((HttpTransportFactory)transportFactory).build();
        try {
            credentials.getRequestMetadata(CALL_URI);
            Assert.fail((String)"Expected error refreshing token.");
        }
        catch (IOException expected) {
            String message = expected.getMessage();
            Assert.assertTrue((boolean)message.contains(Integer.toString(404)));
            Assert.assertTrue((boolean)message.contains("scope"));
        }
    }

    @Test
    public void getRequestMetadata_serverError_throws() {
        String accessToken = "1/MkSJoj1xsli0AccessToken_NKPY2";
        MockMetadataServerTransportFactory transportFactory = new MockMetadataServerTransportFactory();
        transportFactory.transport.setAccessToken(accessToken);
        transportFactory.transport.setTokenRequestStatusCode(500);
        ComputeEngineCredentials credentials = ComputeEngineCredentials.newBuilder().setHttpTransportFactory((HttpTransportFactory)transportFactory).build();
        try {
            credentials.getRequestMetadata(CALL_URI);
            Assert.fail((String)"Expected error refreshing token.");
        }
        catch (IOException expected) {
            String message = expected.getMessage();
            Assert.assertTrue((boolean)message.contains(Integer.toString(500)));
            Assert.assertTrue((boolean)message.contains("Unexpected"));
        }
    }

    @Test
    public void equals_true() throws IOException {
        MockMetadataServerTransportFactory transportFactory = new MockMetadataServerTransportFactory();
        ComputeEngineCredentials credentials = ComputeEngineCredentials.newBuilder().setHttpTransportFactory((HttpTransportFactory)transportFactory).build();
        ComputeEngineCredentials otherCredentials = ComputeEngineCredentials.newBuilder().setHttpTransportFactory((HttpTransportFactory)transportFactory).build();
        Assert.assertTrue((boolean)credentials.equals((Object)otherCredentials));
        Assert.assertTrue((boolean)otherCredentials.equals((Object)credentials));
    }

    @Test
    public void equals_false_transportFactory() throws IOException {
        GoogleCredentialsTest.MockHttpTransportFactory httpTransportFactory = new GoogleCredentialsTest.MockHttpTransportFactory();
        MockMetadataServerTransportFactory serverTransportFactory = new MockMetadataServerTransportFactory();
        ComputeEngineCredentials credentials = ComputeEngineCredentials.newBuilder().setHttpTransportFactory((HttpTransportFactory)serverTransportFactory).build();
        ComputeEngineCredentials otherCredentials = ComputeEngineCredentials.newBuilder().setHttpTransportFactory((HttpTransportFactory)httpTransportFactory).build();
        Assert.assertFalse((boolean)credentials.equals((Object)otherCredentials));
        Assert.assertFalse((boolean)otherCredentials.equals((Object)credentials));
    }

    @Test
    public void toString_containsFields() throws IOException {
        MockMetadataServerTransportFactory serverTransportFactory = new MockMetadataServerTransportFactory();
        String expectedToString = String.format("ComputeEngineCredentials{transportFactoryClassName=%s}", MockMetadataServerTransportFactory.class.getName());
        ComputeEngineCredentials credentials = ComputeEngineCredentials.newBuilder().setHttpTransportFactory((HttpTransportFactory)serverTransportFactory).build();
        Assert.assertEquals((Object)expectedToString, (Object)credentials.toString());
    }

    @Test
    public void hashCode_equals() throws IOException {
        MockMetadataServerTransportFactory serverTransportFactory = new MockMetadataServerTransportFactory();
        ComputeEngineCredentials credentials = ComputeEngineCredentials.newBuilder().setHttpTransportFactory((HttpTransportFactory)serverTransportFactory).build();
        ComputeEngineCredentials otherCredentials = ComputeEngineCredentials.newBuilder().setHttpTransportFactory((HttpTransportFactory)serverTransportFactory).build();
        Assert.assertEquals((long)credentials.hashCode(), (long)otherCredentials.hashCode());
    }

    @Test
    public void serialize() throws IOException, ClassNotFoundException {
        MockMetadataServerTransportFactory serverTransportFactory = new MockMetadataServerTransportFactory();
        ComputeEngineCredentials credentials = ComputeEngineCredentials.newBuilder().setHttpTransportFactory((HttpTransportFactory)serverTransportFactory).build();
        GoogleCredentials deserializedCredentials = (GoogleCredentials)this.serializeAndDeserialize(credentials);
        Assert.assertEquals((Object)credentials, (Object)deserializedCredentials);
        Assert.assertEquals((long)credentials.hashCode(), (long)deserializedCredentials.hashCode());
        Assert.assertEquals((Object)credentials.toString(), (Object)deserializedCredentials.toString());
        Assert.assertSame((Object)deserializedCredentials.clock, (Object)Clock.SYSTEM);
        credentials = ComputeEngineCredentials.newBuilder().build();
        deserializedCredentials = (GoogleCredentials)this.serializeAndDeserialize(credentials);
        Assert.assertEquals((Object)credentials, (Object)deserializedCredentials);
        Assert.assertEquals((long)credentials.hashCode(), (long)deserializedCredentials.hashCode());
        Assert.assertEquals((Object)credentials.toString(), (Object)deserializedCredentials.toString());
        Assert.assertSame((Object)deserializedCredentials.clock, (Object)Clock.SYSTEM);
    }

    @Test
    public void getAccount_sameAs() throws IOException {
        MockMetadataServerTransportFactory transportFactory = new MockMetadataServerTransportFactory();
        String defaultAccountEmail = "mail@mail.com";
        transportFactory.transport.setServiceAccountEmail(defaultAccountEmail);
        ComputeEngineCredentials credentials = ComputeEngineCredentials.newBuilder().setHttpTransportFactory((HttpTransportFactory)transportFactory).build();
        Assert.assertEquals((Object)defaultAccountEmail, (Object)credentials.getAccount());
    }

    @Test
    public void getAccount_missing_throws() {
        MockMetadataServerTransportFactory transportFactory = new MockMetadataServerTransportFactory();
        String defaultAccountEmail = "mail@mail.com";
        transportFactory.transport = new MockMetadataServerTransport(){

            @Override
            public LowLevelHttpRequest buildRequest(String method, String url) throws IOException {
                if (this.isGetServiceAccountsUrl(url)) {
                    return new MockLowLevelHttpRequest(url){

                        public LowLevelHttpResponse execute() throws IOException {
                            return new MockLowLevelHttpResponse().setStatusCode(404).setContent("");
                        }
                    };
                }
                return super.buildRequest(method, url);
            }
        };
        transportFactory.transport.setServiceAccountEmail(defaultAccountEmail);
        ComputeEngineCredentials credentials = ComputeEngineCredentials.newBuilder().setHttpTransportFactory((HttpTransportFactory)transportFactory).build();
        try {
            credentials.getAccount();
            Assert.fail((String)"Fetching default service account should have failed");
        }
        catch (RuntimeException e) {
            Assert.assertEquals((Object)"Failed to get service account", (Object)e.getMessage());
            Assert.assertNotNull((Object)e.getCause());
            Assert.assertTrue((boolean)e.getCause().getMessage().contains("404"));
        }
    }

    @Test
    public void getAccount_emptyContent_throws() {
        MockMetadataServerTransportFactory transportFactory = new MockMetadataServerTransportFactory();
        String defaultAccountEmail = "mail@mail.com";
        transportFactory.transport = new MockMetadataServerTransport(){

            @Override
            public LowLevelHttpRequest buildRequest(String method, String url) throws IOException {
                if (this.isGetServiceAccountsUrl(url)) {
                    return new MockLowLevelHttpRequest(url){

                        public LowLevelHttpResponse execute() throws IOException {
                            return new MockLowLevelHttpResponse().setStatusCode(200);
                        }
                    };
                }
                return super.buildRequest(method, url);
            }
        };
        transportFactory.transport.setServiceAccountEmail(defaultAccountEmail);
        ComputeEngineCredentials credentials = ComputeEngineCredentials.newBuilder().setHttpTransportFactory((HttpTransportFactory)transportFactory).build();
        try {
            credentials.getAccount();
            Assert.fail((String)"Fetching default service account should have failed");
        }
        catch (RuntimeException e) {
            Assert.assertEquals((Object)"Failed to get service account", (Object)e.getMessage());
            Assert.assertNotNull((Object)e.getCause());
            Assert.assertTrue((boolean)e.getCause().getMessage().contains("Empty content"));
        }
    }

    @Test
    public void sign_sameAs() throws IOException {
        MockMetadataServerTransportFactory transportFactory = new MockMetadataServerTransportFactory();
        String accessToken = "1/MkSJoj1xsli0AccessToken_NKPY2";
        String defaultAccountEmail = "mail@mail.com";
        byte[] expectedSignature = new byte[]{13, 14, 10, 13};
        transportFactory.transport.setAccessToken("1/MkSJoj1xsli0AccessToken_NKPY2");
        transportFactory.transport.setServiceAccountEmail(defaultAccountEmail);
        transportFactory.transport.setSignature(expectedSignature);
        ComputeEngineCredentials credentials = ComputeEngineCredentials.newBuilder().setHttpTransportFactory((HttpTransportFactory)transportFactory).build();
        Assert.assertArrayEquals((byte[])expectedSignature, (byte[])credentials.sign(expectedSignature));
    }

    @Test
    public void sign_getAccountFails() throws IOException {
        MockMetadataServerTransportFactory transportFactory = new MockMetadataServerTransportFactory();
        String accessToken = "1/MkSJoj1xsli0AccessToken_NKPY2";
        byte[] expectedSignature = new byte[]{13, 14, 10, 13};
        transportFactory.transport.setAccessToken("1/MkSJoj1xsli0AccessToken_NKPY2");
        transportFactory.transport.setSignature(expectedSignature);
        ComputeEngineCredentials credentials = ComputeEngineCredentials.newBuilder().setHttpTransportFactory((HttpTransportFactory)transportFactory).build();
        try {
            credentials.sign(expectedSignature);
            Assert.fail((String)"Should not be able to use credential without exception.");
        }
        catch (ServiceAccountSigner.SigningException ex) {
            Assert.assertNotNull((Object)ex.getMessage());
            Assert.assertNotNull((Object)ex.getCause());
        }
    }

    @Test
    public void sign_accessDenied_throws() {
        MockMetadataServerTransportFactory transportFactory = new MockMetadataServerTransportFactory();
        String accessToken = "1/MkSJoj1xsli0AccessToken_NKPY2";
        String defaultAccountEmail = "mail@mail.com";
        transportFactory.transport = new MockMetadataServerTransport(){

            @Override
            public LowLevelHttpRequest buildRequest(String method, String url) throws IOException {
                if (this.isSignRequestUrl(url)) {
                    return new MockLowLevelHttpRequest(url){

                        public LowLevelHttpResponse execute() throws IOException {
                            return new MockLowLevelHttpResponse().setStatusCode(403).setContent(TestUtils.errorJson("Sign Error"));
                        }
                    };
                }
                return super.buildRequest(method, url);
            }
        };
        transportFactory.transport.setAccessToken("1/MkSJoj1xsli0AccessToken_NKPY2");
        transportFactory.transport.setServiceAccountEmail(defaultAccountEmail);
        ComputeEngineCredentials credentials = ComputeEngineCredentials.newBuilder().setHttpTransportFactory((HttpTransportFactory)transportFactory).build();
        try {
            byte[] bytes = new byte[]{13, 14, 10, 13};
            credentials.sign(bytes);
            Assert.fail((String)"Signing should have failed");
        }
        catch (ServiceAccountSigner.SigningException e) {
            Assert.assertEquals((Object)"Failed to sign the provided bytes", (Object)e.getMessage());
            Assert.assertNotNull((Object)e.getCause());
            Assert.assertTrue((boolean)e.getCause().getMessage().contains("403"));
        }
    }

    @Test
    public void sign_serverError_throws() {
        MockMetadataServerTransportFactory transportFactory = new MockMetadataServerTransportFactory();
        String accessToken = "1/MkSJoj1xsli0AccessToken_NKPY2";
        String defaultAccountEmail = "mail@mail.com";
        transportFactory.transport = new MockMetadataServerTransport(){

            @Override
            public LowLevelHttpRequest buildRequest(String method, String url) throws IOException {
                if (this.isSignRequestUrl(url)) {
                    return new MockLowLevelHttpRequest(url){

                        public LowLevelHttpResponse execute() throws IOException {
                            return new MockLowLevelHttpResponse().setStatusCode(500).setContent(TestUtils.errorJson("Sign Error"));
                        }
                    };
                }
                return super.buildRequest(method, url);
            }
        };
        transportFactory.transport.setAccessToken("1/MkSJoj1xsli0AccessToken_NKPY2");
        transportFactory.transport.setServiceAccountEmail(defaultAccountEmail);
        ComputeEngineCredentials credentials = ComputeEngineCredentials.newBuilder().setHttpTransportFactory((HttpTransportFactory)transportFactory).build();
        try {
            byte[] bytes = new byte[]{13, 14, 10, 13};
            credentials.sign(bytes);
            Assert.fail((String)"Signing should have failed");
        }
        catch (ServiceAccountSigner.SigningException e) {
            Assert.assertEquals((Object)"Failed to sign the provided bytes", (Object)e.getMessage());
            Assert.assertNotNull((Object)e.getCause());
            Assert.assertTrue((boolean)e.getCause().getMessage().contains("500"));
        }
    }

    @Test
    public void sign_emptyContent_throws() {
        MockMetadataServerTransportFactory transportFactory = new MockMetadataServerTransportFactory();
        String accessToken = "1/MkSJoj1xsli0AccessToken_NKPY2";
        String defaultAccountEmail = "mail@mail.com";
        transportFactory.transport = new MockMetadataServerTransport(){

            @Override
            public LowLevelHttpRequest buildRequest(String method, String url) throws IOException {
                if (this.isSignRequestUrl(url)) {
                    return new MockLowLevelHttpRequest(url){

                        public LowLevelHttpResponse execute() throws IOException {
                            return new MockLowLevelHttpResponse().setStatusCode(200);
                        }
                    };
                }
                return super.buildRequest(method, url);
            }
        };
        transportFactory.transport.setAccessToken(accessToken);
        transportFactory.transport.setServiceAccountEmail(defaultAccountEmail);
        ComputeEngineCredentials credentials = ComputeEngineCredentials.newBuilder().setHttpTransportFactory((HttpTransportFactory)transportFactory).build();
        try {
            byte[] bytes = new byte[]{13, 14, 10, 13};
            credentials.sign(bytes);
            Assert.fail((String)"Signing should have failed");
        }
        catch (ServiceAccountSigner.SigningException e) {
            Assert.assertEquals((Object)"Failed to sign the provided bytes", (Object)e.getMessage());
            Assert.assertNotNull((Object)e.getCause());
            Assert.assertTrue((boolean)e.getCause().getMessage().contains("Empty content"));
        }
    }

    @Test
    public void idTokenWithAudience_sameAs() throws IOException {
        MockMetadataServerTransportFactory transportFactory = new MockMetadataServerTransportFactory();
        transportFactory.transport.setIdToken(STANDARD_ID_TOKEN);
        ComputeEngineCredentials credentials = ComputeEngineCredentials.newBuilder().setHttpTransportFactory((HttpTransportFactory)transportFactory).build();
        String targetAudience = "https://foo.bar";
        IdTokenCredentials tokenCredential = IdTokenCredentials.newBuilder().setIdTokenProvider((IdTokenProvider)credentials).setTargetAudience(targetAudience).build();
        tokenCredential.refresh();
        Assert.assertEquals((Object)STANDARD_ID_TOKEN, (Object)tokenCredential.getAccessToken().getTokenValue());
        Assert.assertEquals((Object)STANDARD_ID_TOKEN, (Object)tokenCredential.getIdToken().getTokenValue());
        Assert.assertEquals((Object)targetAudience, (Object)((String)tokenCredential.getIdToken().getJsonWebSignature().getPayload().getAudience()));
    }

    @Test
    public void idTokenWithAudience_standard() throws IOException {
        MockMetadataServerTransportFactory transportFactory = new MockMetadataServerTransportFactory();
        ComputeEngineCredentials credentials = ComputeEngineCredentials.newBuilder().setHttpTransportFactory((HttpTransportFactory)transportFactory).build();
        String targetAudience = "https://foo.bar";
        IdTokenCredentials tokenCredential = IdTokenCredentials.newBuilder().setIdTokenProvider((IdTokenProvider)credentials).setTargetAudience(targetAudience).build();
        tokenCredential.refresh();
        Assert.assertEquals((Object)STANDARD_ID_TOKEN, (Object)tokenCredential.getAccessToken().getTokenValue());
        Assert.assertEquals((Object)STANDARD_ID_TOKEN, (Object)tokenCredential.getIdToken().getTokenValue());
        Assert.assertNull((Object)tokenCredential.getIdToken().getJsonWebSignature().getPayload().get((Object)"google"));
    }

    @Test
    public void idTokenWithAudience_full() throws IOException {
        MockMetadataServerTransportFactory transportFactory = new MockMetadataServerTransportFactory();
        ComputeEngineCredentials credentials = ComputeEngineCredentials.newBuilder().setHttpTransportFactory((HttpTransportFactory)transportFactory).build();
        String targetAudience = "https://foo.bar";
        IdTokenCredentials tokenCredential = IdTokenCredentials.newBuilder().setIdTokenProvider((IdTokenProvider)credentials).setTargetAudience(targetAudience).setOptions(Arrays.asList(IdTokenProvider.Option.FORMAT_FULL)).build();
        tokenCredential.refresh();
        JsonWebToken.Payload p = tokenCredential.getIdToken().getJsonWebSignature().getPayload();
        Assert.assertTrue((String)"Full ID Token format not provided", (boolean)p.containsKey((Object)"google"));
        ArrayMap googleClaim = (ArrayMap)p.get((Object)"google");
        Assert.assertTrue((boolean)googleClaim.containsKey((Object)"compute_engine"));
    }

    @Test
    public void idTokenWithAudience_license() throws IOException {
        MockMetadataServerTransportFactory transportFactory = new MockMetadataServerTransportFactory();
        ComputeEngineCredentials credentials = ComputeEngineCredentials.newBuilder().setHttpTransportFactory((HttpTransportFactory)transportFactory).build();
        String targetAudience = "https://foo.bar";
        IdTokenCredentials tokenCredential = IdTokenCredentials.newBuilder().setIdTokenProvider((IdTokenProvider)credentials).setTargetAudience(targetAudience).setOptions(Arrays.asList(IdTokenProvider.Option.FORMAT_FULL, IdTokenProvider.Option.LICENSES_TRUE)).build();
        tokenCredential.refresh();
        JsonWebToken.Payload p = tokenCredential.getIdToken().getJsonWebSignature().getPayload();
        Assert.assertTrue((String)"Full ID Token format not provided", (boolean)p.containsKey((Object)"google"));
        ArrayMap googleClaim = (ArrayMap)p.get((Object)"google");
        Assert.assertTrue((boolean)googleClaim.containsKey((Object)"license"));
    }

    static class MockMetadataServerTransportFactory
    implements HttpTransportFactory {
        MockMetadataServerTransport transport = new MockMetadataServerTransport();

        MockMetadataServerTransportFactory() {
        }

        public HttpTransport create() {
            return this.transport;
        }
    }
}

