/*
 * Decompiled with CFR 0.152.
 */
package com.google.auth.oauth2;

import com.google.auth.oauth2.CredentialAccessBoundary;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.JUnit4;

@RunWith(value=JUnit4.class)
public class CredentialAccessBoundaryTest {
    @Test
    public void credentialAccessBoundary() {
        CredentialAccessBoundary.AccessBoundaryRule.AvailabilityCondition availabilityCondition = CredentialAccessBoundary.AccessBoundaryRule.AvailabilityCondition.newBuilder().setExpression("expression").build();
        CredentialAccessBoundary.AccessBoundaryRule firstRule = CredentialAccessBoundary.AccessBoundaryRule.newBuilder().setAvailableResource("firstResource").addAvailablePermission("firstPermission").setAvailabilityCondition(availabilityCondition).build();
        CredentialAccessBoundary.AccessBoundaryRule secondRule = CredentialAccessBoundary.AccessBoundaryRule.newBuilder().setAvailableResource("secondResource").addAvailablePermission("secondPermission").build();
        CredentialAccessBoundary credentialAccessBoundary = CredentialAccessBoundary.newBuilder().setRules(Arrays.asList(firstRule, secondRule)).build();
        Assert.assertEquals((long)2L, (long)credentialAccessBoundary.getAccessBoundaryRules().size());
        CredentialAccessBoundary.AccessBoundaryRule first = (CredentialAccessBoundary.AccessBoundaryRule)credentialAccessBoundary.getAccessBoundaryRules().get(0);
        Assert.assertEquals((Object)firstRule, (Object)first);
        Assert.assertEquals((Object)"firstResource", (Object)first.getAvailableResource());
        Assert.assertEquals((long)1L, (long)first.getAvailablePermissions().size());
        Assert.assertEquals((Object)"firstPermission", first.getAvailablePermissions().get(0));
        Assert.assertEquals((Object)availabilityCondition, (Object)first.getAvailabilityCondition());
        Assert.assertEquals((Object)"expression", (Object)first.getAvailabilityCondition().getExpression());
        Assert.assertNull((Object)first.getAvailabilityCondition().getTitle());
        Assert.assertNull((Object)first.getAvailabilityCondition().getDescription());
        CredentialAccessBoundary.AccessBoundaryRule second = (CredentialAccessBoundary.AccessBoundaryRule)credentialAccessBoundary.getAccessBoundaryRules().get(1);
        Assert.assertEquals((Object)secondRule, (Object)second);
        Assert.assertEquals((Object)"secondResource", (Object)second.getAvailableResource());
        Assert.assertEquals((long)1L, (long)second.getAvailablePermissions().size());
        Assert.assertEquals((Object)"secondPermission", second.getAvailablePermissions().get(0));
        Assert.assertNull((Object)second.getAvailabilityCondition());
    }

    @Test
    public void credentialAccessBoundary_nullRules_throws() {
        try {
            CredentialAccessBoundary.newBuilder().build();
            Assert.fail((String)"Should fail.");
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
    }

    @Test
    public void credentialAccessBoundary_withoutRules_throws() {
        try {
            CredentialAccessBoundary.newBuilder().setRules(new ArrayList()).build();
            Assert.fail((String)"Should fail.");
        }
        catch (IllegalArgumentException e) {
            Assert.assertEquals((Object)"At least one access boundary rule must be provided.", (Object)e.getMessage());
        }
    }

    @Test
    public void credentialAccessBoundary_ruleCountExceeded_throws() {
        CredentialAccessBoundary.AccessBoundaryRule rule = CredentialAccessBoundary.AccessBoundaryRule.newBuilder().setAvailableResource("resource").addAvailablePermission("permission").build();
        CredentialAccessBoundary.Builder builder = CredentialAccessBoundary.newBuilder();
        for (int i = 0; i <= 10; ++i) {
            builder.addRule(rule);
        }
        try {
            builder.build();
            Assert.fail((String)"Should fail.");
        }
        catch (IllegalArgumentException e) {
            Assert.assertEquals((Object)"The provided list has more than 10 access boundary rules.", (Object)e.getMessage());
        }
    }

    @Test
    public void credentialAccessBoundary_toJson() {
        CredentialAccessBoundary.AccessBoundaryRule.AvailabilityCondition availabilityCondition = CredentialAccessBoundary.AccessBoundaryRule.AvailabilityCondition.newBuilder().setExpression("expression").setTitle("title").setDescription("description").build();
        CredentialAccessBoundary.AccessBoundaryRule firstRule = CredentialAccessBoundary.AccessBoundaryRule.newBuilder().setAvailableResource("firstResource").addAvailablePermission("firstPermission").setAvailabilityCondition(availabilityCondition).build();
        CredentialAccessBoundary.AccessBoundaryRule secondRule = CredentialAccessBoundary.AccessBoundaryRule.newBuilder().setAvailableResource("secondResource").setAvailablePermissions(Arrays.asList("firstPermission", "secondPermission")).build();
        CredentialAccessBoundary credentialAccessBoundary = CredentialAccessBoundary.newBuilder().setRules(Arrays.asList(firstRule, secondRule)).build();
        String expectedJson = "{\"accessBoundary\":{\"accessBoundaryRules\":[{\"availableResource\":\"firstResource\",\"availablePermissions\":[\"firstPermission\"],\"availabilityCondition\":{\"expression\":\"expression\",\"title\":\"title\",\"description\":\"description\"}},{\"availableResource\":\"secondResource\",\"availablePermissions\":[\"firstPermission\",\"secondPermission\"]}]}}";
        Assert.assertEquals((Object)expectedJson, (Object)credentialAccessBoundary.toJson());
    }

    @Test
    public void accessBoundaryRule_allFields() {
        CredentialAccessBoundary.AccessBoundaryRule.AvailabilityCondition availabilityCondition = CredentialAccessBoundary.AccessBoundaryRule.AvailabilityCondition.newBuilder().setExpression("expression").build();
        CredentialAccessBoundary.AccessBoundaryRule rule = CredentialAccessBoundary.AccessBoundaryRule.newBuilder().setAvailableResource("resource").addAvailablePermission("firstPermission").addAvailablePermission("secondPermission").setAvailabilityCondition(availabilityCondition).build();
        Assert.assertEquals((Object)"resource", (Object)rule.getAvailableResource());
        Assert.assertEquals((long)2L, (long)rule.getAvailablePermissions().size());
        Assert.assertEquals((Object)"firstPermission", rule.getAvailablePermissions().get(0));
        Assert.assertEquals((Object)"secondPermission", rule.getAvailablePermissions().get(1));
        Assert.assertEquals((Object)availabilityCondition, (Object)rule.getAvailabilityCondition());
    }

    @Test
    public void accessBoundaryRule_requiredFields() {
        CredentialAccessBoundary.AccessBoundaryRule rule = CredentialAccessBoundary.AccessBoundaryRule.newBuilder().setAvailableResource("resource").setAvailablePermissions(Collections.singletonList("firstPermission")).build();
        Assert.assertEquals((Object)"resource", (Object)rule.getAvailableResource());
        Assert.assertEquals((long)1L, (long)rule.getAvailablePermissions().size());
        Assert.assertEquals((Object)"firstPermission", rule.getAvailablePermissions().get(0));
        Assert.assertNull((Object)rule.getAvailabilityCondition());
    }

    @Test
    public void accessBoundaryRule_withEmptyAvailableResource_throws() {
        try {
            CredentialAccessBoundary.AccessBoundaryRule.newBuilder().setAvailableResource("").addAvailablePermission("permission").build();
            Assert.fail((String)"Should fail.");
        }
        catch (IllegalArgumentException e) {
            Assert.assertEquals((Object)"The provided availableResource is empty.", (Object)e.getMessage());
        }
    }

    @Test
    public void accessBoundaryRule_withoutAvailableResource_throws() {
        try {
            CredentialAccessBoundary.AccessBoundaryRule.newBuilder().addAvailablePermission("permission").build();
            Assert.fail((String)"Should fail.");
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
    }

    @Test
    public void accessBoundaryRule_withoutAvailablePermissions_throws() {
        try {
            CredentialAccessBoundary.AccessBoundaryRule.newBuilder().setAvailableResource("resource").build();
            Assert.fail((String)"Should fail.");
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
    }

    @Test
    public void accessBoundaryRule_withEmptyAvailablePermissions_throws() {
        try {
            CredentialAccessBoundary.AccessBoundaryRule.newBuilder().setAvailableResource("resource").setAvailablePermissions(new ArrayList()).build();
            Assert.fail((String)"Should fail.");
        }
        catch (IllegalArgumentException e) {
            Assert.assertEquals((Object)"The list of provided availablePermissions is empty.", (Object)e.getMessage());
        }
    }

    @Test
    public void accessBoundaryRule_withNullAvailablePermissions_throws() {
        try {
            CredentialAccessBoundary.AccessBoundaryRule.newBuilder().setAvailableResource("resource").addAvailablePermission(null).build();
            Assert.fail((String)"Should fail.");
        }
        catch (IllegalArgumentException e) {
            Assert.assertEquals((Object)"One of the provided available permissions is null.", (Object)e.getMessage());
        }
    }

    @Test
    public void accessBoundaryRule_withEmptyAvailablePermission_throws() {
        try {
            CredentialAccessBoundary.AccessBoundaryRule.newBuilder().setAvailableResource("resource").addAvailablePermission("").build();
            Assert.fail((String)"Should fail.");
        }
        catch (IllegalArgumentException e) {
            Assert.assertEquals((Object)"One of the provided available permissions is empty.", (Object)e.getMessage());
        }
    }

    @Test
    public void availabilityCondition_allFields() {
        CredentialAccessBoundary.AccessBoundaryRule.AvailabilityCondition availabilityCondition = CredentialAccessBoundary.AccessBoundaryRule.AvailabilityCondition.newBuilder().setExpression("expression").setTitle("title").setDescription("description").build();
        Assert.assertEquals((Object)"expression", (Object)availabilityCondition.getExpression());
        Assert.assertEquals((Object)"title", (Object)availabilityCondition.getTitle());
        Assert.assertEquals((Object)"description", (Object)availabilityCondition.getDescription());
    }

    @Test
    public void availabilityCondition_expressionOnly() {
        CredentialAccessBoundary.AccessBoundaryRule.AvailabilityCondition availabilityCondition = CredentialAccessBoundary.AccessBoundaryRule.AvailabilityCondition.newBuilder().setExpression("expression").build();
        Assert.assertEquals((Object)"expression", (Object)availabilityCondition.getExpression());
        Assert.assertNull((Object)availabilityCondition.getTitle());
        Assert.assertNull((Object)availabilityCondition.getDescription());
    }

    @Test
    public void availabilityCondition_nullExpression_throws() {
        try {
            CredentialAccessBoundary.AccessBoundaryRule.AvailabilityCondition.newBuilder().setExpression(null).build();
            Assert.fail((String)"Should fail.");
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
    }

    @Test
    public void availabilityCondition_emptyExpression_throws() {
        try {
            CredentialAccessBoundary.AccessBoundaryRule.AvailabilityCondition.newBuilder().setExpression("").build();
            Assert.fail((String)"Should fail.");
        }
        catch (IllegalArgumentException e) {
            Assert.assertEquals((Object)"The provided expression is empty.", (Object)e.getMessage());
        }
    }
}

